/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingOrganizationSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, the _Default sink in newly created projects and folders will created in a disabled state. This can be used to automatically disable log storage if there is already an aggregated sink configured in the hierarchy. The _Default sink can be re-enabled manually if needed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#disable_default_sink GoogleLoggingOrganizationSettings#disable_default_sink}
    */
    readonly disableDefaultSink?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#id GoogleLoggingOrganizationSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name for the configured Cloud KMS key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#kms_key_name GoogleLoggingOrganizationSettings#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * The organization for which to retrieve or configure settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#organization GoogleLoggingOrganizationSettings#organization}
    */
    readonly organization: string;
    /**
    * The storage location that Cloud Logging will use to create new resources when a location is needed but not explicitly provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#storage_location GoogleLoggingOrganizationSettings#storage_location}
    */
    readonly storageLocation?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#timeouts GoogleLoggingOrganizationSettings#timeouts}
    */
    readonly timeouts?: GoogleLoggingOrganizationSettingsTimeouts;
}
export interface GoogleLoggingOrganizationSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#create GoogleLoggingOrganizationSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#delete GoogleLoggingOrganizationSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#update GoogleLoggingOrganizationSettings#update}
    */
    readonly update?: string;
}
export declare function googleLoggingOrganizationSettingsTimeoutsToTerraform(struct?: GoogleLoggingOrganizationSettingsTimeouts | cdktf.IResolvable): any;
export declare function googleLoggingOrganizationSettingsTimeoutsToHclTerraform(struct?: GoogleLoggingOrganizationSettingsTimeouts | cdktf.IResolvable): any;
export declare class GoogleLoggingOrganizationSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingOrganizationSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingOrganizationSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings google_logging_organization_settings}
*/
export declare class GoogleLoggingOrganizationSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_organization_settings";
    /**
    * Generates CDKTF code for importing a GoogleLoggingOrganizationSettings resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleLoggingOrganizationSettings to import
    * @param importFromId The id of the existing GoogleLoggingOrganizationSettings that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleLoggingOrganizationSettings to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_settings google_logging_organization_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingOrganizationSettingsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingOrganizationSettingsConfig);
    private _disableDefaultSink?;
    get disableDefaultSink(): boolean | cdktf.IResolvable;
    set disableDefaultSink(value: boolean | cdktf.IResolvable);
    resetDisableDefaultSink(): void;
    get disableDefaultSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    get kmsServiceAccountId(): string;
    get loggingServiceAccountId(): string;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _storageLocation?;
    get storageLocation(): string;
    set storageLocation(value: string);
    resetStorageLocation(): void;
    get storageLocationInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleLoggingOrganizationSettingsTimeoutsOutputReference;
    putTimeouts(value: GoogleLoggingOrganizationSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleLoggingOrganizationSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
