/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingProjectBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#bucket_id GoogleLoggingProjectBucketConfig#bucket_id}
    */
    readonly bucketId: string;
    /**
    * An optional description for this bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#description GoogleLoggingProjectBucketConfig#description}
    */
    readonly description?: string;
    /**
    * Enable log analytics for the bucket. Cannot be disabled once enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#enable_analytics GoogleLoggingProjectBucketConfig#enable_analytics}
    */
    readonly enableAnalytics?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#id GoogleLoggingProjectBucketConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#location GoogleLoggingProjectBucketConfig#location}
    */
    readonly location: string;
    /**
    * Whether the bucket is locked. The retention period on a locked bucket cannot be changed. Locked buckets may only be deleted if they are empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#locked GoogleLoggingProjectBucketConfig#locked}
    */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
    * The parent project that contains the logging bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#project GoogleLoggingProjectBucketConfig#project}
    */
    readonly project: string;
    /**
    * Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#retention_days GoogleLoggingProjectBucketConfig#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * cmek_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#cmek_settings GoogleLoggingProjectBucketConfig#cmek_settings}
    */
    readonly cmekSettings?: GoogleLoggingProjectBucketConfigCmekSettings;
    /**
    * index_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#index_configs GoogleLoggingProjectBucketConfig#index_configs}
    */
    readonly indexConfigs?: GoogleLoggingProjectBucketConfigIndexConfigs[] | cdktf.IResolvable;
}
export interface GoogleLoggingProjectBucketConfigCmekSettings {
    /**
    * The resource name for the configured Cloud KMS key.
    * KMS key name format:
    * "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
    * To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
    * The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
    * See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#kms_key_name GoogleLoggingProjectBucketConfig#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleLoggingProjectBucketConfigCmekSettingsToTerraform(struct?: GoogleLoggingProjectBucketConfigCmekSettingsOutputReference | GoogleLoggingProjectBucketConfigCmekSettings): any;
export declare function googleLoggingProjectBucketConfigCmekSettingsToHclTerraform(struct?: GoogleLoggingProjectBucketConfigCmekSettingsOutputReference | GoogleLoggingProjectBucketConfigCmekSettings): any;
export declare class GoogleLoggingProjectBucketConfigCmekSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingProjectBucketConfigCmekSettings | undefined;
    set internalValue(value: GoogleLoggingProjectBucketConfigCmekSettings | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyVersionName(): string;
    get name(): string;
    get serviceAccountId(): string;
}
export interface GoogleLoggingProjectBucketConfigIndexConfigs {
    /**
    * The LogEntry field path to index.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#field_path GoogleLoggingProjectBucketConfig#field_path}
    */
    readonly fieldPath: string;
    /**
    * The type of data in this index
    * Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation]( https://cloud.google.com/logging/docs/view/advanced-queries#indexed-fields) for details.
    * For example: jsonPayload.request.status
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#type GoogleLoggingProjectBucketConfig#type}
    */
    readonly type: string;
}
export declare function googleLoggingProjectBucketConfigIndexConfigsToTerraform(struct?: GoogleLoggingProjectBucketConfigIndexConfigs | cdktf.IResolvable): any;
export declare function googleLoggingProjectBucketConfigIndexConfigsToHclTerraform(struct?: GoogleLoggingProjectBucketConfigIndexConfigs | cdktf.IResolvable): any;
export declare class GoogleLoggingProjectBucketConfigIndexConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleLoggingProjectBucketConfigIndexConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingProjectBucketConfigIndexConfigs | cdktf.IResolvable | undefined);
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    get fieldPathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleLoggingProjectBucketConfigIndexConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleLoggingProjectBucketConfigIndexConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleLoggingProjectBucketConfigIndexConfigsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config google_logging_project_bucket_config}
*/
export declare class GoogleLoggingProjectBucketConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_project_bucket_config";
    /**
    * Generates CDKTF code for importing a GoogleLoggingProjectBucketConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleLoggingProjectBucketConfig to import
    * @param importFromId The id of the existing GoogleLoggingProjectBucketConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleLoggingProjectBucketConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_project_bucket_config google_logging_project_bucket_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingProjectBucketConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingProjectBucketConfigConfig);
    private _bucketId?;
    get bucketId(): string;
    set bucketId(value: string);
    get bucketIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableAnalytics?;
    get enableAnalytics(): boolean | cdktf.IResolvable;
    set enableAnalytics(value: boolean | cdktf.IResolvable);
    resetEnableAnalytics(): void;
    get enableAnalyticsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    resetLocked(): void;
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _cmekSettings;
    get cmekSettings(): GoogleLoggingProjectBucketConfigCmekSettingsOutputReference;
    putCmekSettings(value: GoogleLoggingProjectBucketConfigCmekSettings): void;
    resetCmekSettings(): void;
    get cmekSettingsInput(): GoogleLoggingProjectBucketConfigCmekSettings | undefined;
    private _indexConfigs;
    get indexConfigs(): GoogleLoggingProjectBucketConfigIndexConfigsList;
    putIndexConfigs(value: GoogleLoggingProjectBucketConfigIndexConfigs[] | cdktf.IResolvable): void;
    resetIndexConfigs(): void;
    get indexConfigsInput(): cdktf.IResolvable | GoogleLoggingProjectBucketConfigIndexConfigs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
