/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLookerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Network name in the consumer project in the format of: projects/{project}/global/networks/{network}
    * Note that the consumer network may be in a different GCP project than the consumer
    * project that is hosting the Looker Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#consumer_network GoogleLookerInstance#consumer_network}
    */
    readonly consumerNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#id GoogleLookerInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#name GoogleLookerInstance#name}
    */
    readonly name: string;
    /**
    * Platform editions for a Looker instance. Each edition maps to a set of instance features, like its size. Must be one of these values:
    * - LOOKER_CORE_TRIAL: trial instance
    * - LOOKER_CORE_STANDARD: pay as you go standard instance
    * - LOOKER_CORE_STANDARD_ANNUAL: subscription standard instance
    * - LOOKER_CORE_ENTERPRISE_ANNUAL: subscription enterprise instance
    * - LOOKER_CORE_EMBED_ANNUAL: subscription embed instance Default value: "LOOKER_CORE_TRIAL" Possible values: ["LOOKER_CORE_TRIAL", "LOOKER_CORE_STANDARD", "LOOKER_CORE_STANDARD_ANNUAL", "LOOKER_CORE_ENTERPRISE_ANNUAL", "LOOKER_CORE_EMBED_ANNUAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#platform_edition GoogleLookerInstance#platform_edition}
    */
    readonly platformEdition?: string;
    /**
    * Whether private IP is enabled on the Looker instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#private_ip_enabled GoogleLookerInstance#private_ip_enabled}
    */
    readonly privateIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#project GoogleLookerInstance#project}
    */
    readonly project?: string;
    /**
    * Whether public IP is enabled on the Looker instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#public_ip_enabled GoogleLookerInstance#public_ip_enabled}
    */
    readonly publicIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * The name of the Looker region of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#region GoogleLookerInstance#region}
    */
    readonly region?: string;
    /**
    * Name of a reserved IP address range within the consumer network, to be used for
    * private service access connection. User may or may not specify this in a request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#reserved_range GoogleLookerInstance#reserved_range}
    */
    readonly reservedRange?: string;
    /**
    * admin_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#admin_settings GoogleLookerInstance#admin_settings}
    */
    readonly adminSettings?: GoogleLookerInstanceAdminSettings;
    /**
    * custom_domain block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#custom_domain GoogleLookerInstance#custom_domain}
    */
    readonly customDomain?: GoogleLookerInstanceCustomDomain;
    /**
    * deny_maintenance_period block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#deny_maintenance_period GoogleLookerInstance#deny_maintenance_period}
    */
    readonly denyMaintenancePeriod?: GoogleLookerInstanceDenyMaintenancePeriod;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#encryption_config GoogleLookerInstance#encryption_config}
    */
    readonly encryptionConfig?: GoogleLookerInstanceEncryptionConfig;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#maintenance_window GoogleLookerInstance#maintenance_window}
    */
    readonly maintenanceWindow?: GoogleLookerInstanceMaintenanceWindow;
    /**
    * oauth_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#oauth_config GoogleLookerInstance#oauth_config}
    */
    readonly oauthConfig?: GoogleLookerInstanceOauthConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#timeouts GoogleLookerInstance#timeouts}
    */
    readonly timeouts?: GoogleLookerInstanceTimeouts;
    /**
    * user_metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#user_metadata GoogleLookerInstance#user_metadata}
    */
    readonly userMetadata?: GoogleLookerInstanceUserMetadata;
}
export interface GoogleLookerInstanceAdminSettings {
    /**
    * Email domain allowlist for the instance.
    *
    * Define the email domains to which your users can deliver Looker (Google Cloud core) content.
    * Updating this list will restart the instance. Updating the allowed email domains from terraform
    * means the value provided will be considered as the entire list and not an amendment to the
    * existing list of allowed email domains.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#allowed_email_domains GoogleLookerInstance#allowed_email_domains}
    */
    readonly allowedEmailDomains?: string[];
}
export declare function googleLookerInstanceAdminSettingsToTerraform(struct?: GoogleLookerInstanceAdminSettingsOutputReference | GoogleLookerInstanceAdminSettings): any;
export declare function googleLookerInstanceAdminSettingsToHclTerraform(struct?: GoogleLookerInstanceAdminSettingsOutputReference | GoogleLookerInstanceAdminSettings): any;
export declare class GoogleLookerInstanceAdminSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceAdminSettings | undefined;
    set internalValue(value: GoogleLookerInstanceAdminSettings | undefined);
    private _allowedEmailDomains?;
    get allowedEmailDomains(): string[];
    set allowedEmailDomains(value: string[]);
    resetAllowedEmailDomains(): void;
    get allowedEmailDomainsInput(): string[] | undefined;
}
export interface GoogleLookerInstanceCustomDomain {
    /**
    * Domain name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#domain GoogleLookerInstance#domain}
    */
    readonly domain?: string;
}
export declare function googleLookerInstanceCustomDomainToTerraform(struct?: GoogleLookerInstanceCustomDomainOutputReference | GoogleLookerInstanceCustomDomain): any;
export declare function googleLookerInstanceCustomDomainToHclTerraform(struct?: GoogleLookerInstanceCustomDomainOutputReference | GoogleLookerInstanceCustomDomain): any;
export declare class GoogleLookerInstanceCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceCustomDomain | undefined;
    set internalValue(value: GoogleLookerInstanceCustomDomain | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    get state(): string;
}
export interface GoogleLookerInstanceDenyMaintenancePeriodEndDate {
    /**
    * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
    * to specify a year by itself or a year and month where the day isn't significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#day GoogleLookerInstance#day}
    */
    readonly day?: number;
    /**
    * Month of a year. Must be from 1 to 12, or 0 to specify a year without a
    * month and day.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#month GoogleLookerInstance#month}
    */
    readonly month?: number;
    /**
    * Year of the date. Must be from 1 to 9999, or 0 to specify a date without
    * a year.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#year GoogleLookerInstance#year}
    */
    readonly year?: number;
}
export declare function googleLookerInstanceDenyMaintenancePeriodEndDateToTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodEndDateOutputReference | GoogleLookerInstanceDenyMaintenancePeriodEndDate): any;
export declare function googleLookerInstanceDenyMaintenancePeriodEndDateToHclTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodEndDateOutputReference | GoogleLookerInstanceDenyMaintenancePeriodEndDate): any;
export declare class GoogleLookerInstanceDenyMaintenancePeriodEndDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceDenyMaintenancePeriodEndDate | undefined;
    set internalValue(value: GoogleLookerInstanceDenyMaintenancePeriodEndDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    resetDay(): void;
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    resetMonth(): void;
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    resetYear(): void;
    get yearInput(): number | undefined;
}
export interface GoogleLookerInstanceDenyMaintenancePeriodStartDate {
    /**
    * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
    * to specify a year by itself or a year and month where the day isn't significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#day GoogleLookerInstance#day}
    */
    readonly day?: number;
    /**
    * Month of a year. Must be from 1 to 12, or 0 to specify a year without a
    * month and day.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#month GoogleLookerInstance#month}
    */
    readonly month?: number;
    /**
    * Year of the date. Must be from 1 to 9999, or 0 to specify a date without
    * a year.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#year GoogleLookerInstance#year}
    */
    readonly year?: number;
}
export declare function googleLookerInstanceDenyMaintenancePeriodStartDateToTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodStartDateOutputReference | GoogleLookerInstanceDenyMaintenancePeriodStartDate): any;
export declare function googleLookerInstanceDenyMaintenancePeriodStartDateToHclTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodStartDateOutputReference | GoogleLookerInstanceDenyMaintenancePeriodStartDate): any;
export declare class GoogleLookerInstanceDenyMaintenancePeriodStartDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceDenyMaintenancePeriodStartDate | undefined;
    set internalValue(value: GoogleLookerInstanceDenyMaintenancePeriodStartDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    resetDay(): void;
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    resetMonth(): void;
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    resetYear(): void;
    get yearInput(): number | undefined;
}
export interface GoogleLookerInstanceDenyMaintenancePeriodTime {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#hours GoogleLookerInstance#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#minutes GoogleLookerInstance#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#nanos GoogleLookerInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#seconds GoogleLookerInstance#seconds}
    */
    readonly seconds?: number;
}
export declare function googleLookerInstanceDenyMaintenancePeriodTimeToTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodTimeOutputReference | GoogleLookerInstanceDenyMaintenancePeriodTime): any;
export declare function googleLookerInstanceDenyMaintenancePeriodTimeToHclTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodTimeOutputReference | GoogleLookerInstanceDenyMaintenancePeriodTime): any;
export declare class GoogleLookerInstanceDenyMaintenancePeriodTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceDenyMaintenancePeriodTime | undefined;
    set internalValue(value: GoogleLookerInstanceDenyMaintenancePeriodTime | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface GoogleLookerInstanceDenyMaintenancePeriod {
    /**
    * end_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#end_date GoogleLookerInstance#end_date}
    */
    readonly endDate: GoogleLookerInstanceDenyMaintenancePeriodEndDate;
    /**
    * start_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#start_date GoogleLookerInstance#start_date}
    */
    readonly startDate: GoogleLookerInstanceDenyMaintenancePeriodStartDate;
    /**
    * time block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#time GoogleLookerInstance#time}
    */
    readonly time: GoogleLookerInstanceDenyMaintenancePeriodTime;
}
export declare function googleLookerInstanceDenyMaintenancePeriodToTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodOutputReference | GoogleLookerInstanceDenyMaintenancePeriod): any;
export declare function googleLookerInstanceDenyMaintenancePeriodToHclTerraform(struct?: GoogleLookerInstanceDenyMaintenancePeriodOutputReference | GoogleLookerInstanceDenyMaintenancePeriod): any;
export declare class GoogleLookerInstanceDenyMaintenancePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceDenyMaintenancePeriod | undefined;
    set internalValue(value: GoogleLookerInstanceDenyMaintenancePeriod | undefined);
    private _endDate;
    get endDate(): GoogleLookerInstanceDenyMaintenancePeriodEndDateOutputReference;
    putEndDate(value: GoogleLookerInstanceDenyMaintenancePeriodEndDate): void;
    get endDateInput(): GoogleLookerInstanceDenyMaintenancePeriodEndDate | undefined;
    private _startDate;
    get startDate(): GoogleLookerInstanceDenyMaintenancePeriodStartDateOutputReference;
    putStartDate(value: GoogleLookerInstanceDenyMaintenancePeriodStartDate): void;
    get startDateInput(): GoogleLookerInstanceDenyMaintenancePeriodStartDate | undefined;
    private _time;
    get time(): GoogleLookerInstanceDenyMaintenancePeriodTimeOutputReference;
    putTime(value: GoogleLookerInstanceDenyMaintenancePeriodTime): void;
    get timeInput(): GoogleLookerInstanceDenyMaintenancePeriodTime | undefined;
}
export interface GoogleLookerInstanceEncryptionConfig {
    /**
    * Name of the customer managed encryption key (CMEK) in KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#kms_key_name GoogleLookerInstance#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleLookerInstanceEncryptionConfigToTerraform(struct?: GoogleLookerInstanceEncryptionConfigOutputReference | GoogleLookerInstanceEncryptionConfig): any;
export declare function googleLookerInstanceEncryptionConfigToHclTerraform(struct?: GoogleLookerInstanceEncryptionConfigOutputReference | GoogleLookerInstanceEncryptionConfig): any;
export declare class GoogleLookerInstanceEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceEncryptionConfig | undefined;
    set internalValue(value: GoogleLookerInstanceEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyNameVersion(): string;
    get kmsKeyState(): string;
}
export interface GoogleLookerInstanceMaintenanceWindowStartTime {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#hours GoogleLookerInstance#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#minutes GoogleLookerInstance#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#nanos GoogleLookerInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#seconds GoogleLookerInstance#seconds}
    */
    readonly seconds?: number;
}
export declare function googleLookerInstanceMaintenanceWindowStartTimeToTerraform(struct?: GoogleLookerInstanceMaintenanceWindowStartTimeOutputReference | GoogleLookerInstanceMaintenanceWindowStartTime): any;
export declare function googleLookerInstanceMaintenanceWindowStartTimeToHclTerraform(struct?: GoogleLookerInstanceMaintenanceWindowStartTimeOutputReference | GoogleLookerInstanceMaintenanceWindowStartTime): any;
export declare class GoogleLookerInstanceMaintenanceWindowStartTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceMaintenanceWindowStartTime | undefined;
    set internalValue(value: GoogleLookerInstanceMaintenanceWindowStartTime | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface GoogleLookerInstanceMaintenanceWindow {
    /**
    * Required. Day of the week for this MaintenanceWindow (in UTC).
    *
    * - MONDAY: Monday
    * - TUESDAY: Tuesday
    * - WEDNESDAY: Wednesday
    * - THURSDAY: Thursday
    * - FRIDAY: Friday
    * - SATURDAY: Saturday
    * - SUNDAY: Sunday Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#day_of_week GoogleLookerInstance#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * start_time block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#start_time GoogleLookerInstance#start_time}
    */
    readonly startTime: GoogleLookerInstanceMaintenanceWindowStartTime;
}
export declare function googleLookerInstanceMaintenanceWindowToTerraform(struct?: GoogleLookerInstanceMaintenanceWindowOutputReference | GoogleLookerInstanceMaintenanceWindow): any;
export declare function googleLookerInstanceMaintenanceWindowToHclTerraform(struct?: GoogleLookerInstanceMaintenanceWindowOutputReference | GoogleLookerInstanceMaintenanceWindow): any;
export declare class GoogleLookerInstanceMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceMaintenanceWindow | undefined;
    set internalValue(value: GoogleLookerInstanceMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _startTime;
    get startTime(): GoogleLookerInstanceMaintenanceWindowStartTimeOutputReference;
    putStartTime(value: GoogleLookerInstanceMaintenanceWindowStartTime): void;
    get startTimeInput(): GoogleLookerInstanceMaintenanceWindowStartTime | undefined;
}
export interface GoogleLookerInstanceOauthConfig {
    /**
    * The client ID for the Oauth config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#client_id GoogleLookerInstance#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret for the Oauth config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#client_secret GoogleLookerInstance#client_secret}
    */
    readonly clientSecret: string;
}
export declare function googleLookerInstanceOauthConfigToTerraform(struct?: GoogleLookerInstanceOauthConfigOutputReference | GoogleLookerInstanceOauthConfig): any;
export declare function googleLookerInstanceOauthConfigToHclTerraform(struct?: GoogleLookerInstanceOauthConfigOutputReference | GoogleLookerInstanceOauthConfig): any;
export declare class GoogleLookerInstanceOauthConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceOauthConfig | undefined;
    set internalValue(value: GoogleLookerInstanceOauthConfig | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
}
export interface GoogleLookerInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#create GoogleLookerInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#delete GoogleLookerInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#update GoogleLookerInstance#update}
    */
    readonly update?: string;
}
export declare function googleLookerInstanceTimeoutsToTerraform(struct?: GoogleLookerInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleLookerInstanceTimeoutsToHclTerraform(struct?: GoogleLookerInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleLookerInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLookerInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleLookerInstanceUserMetadata {
    /**
    * Number of additional Developer Users to allocate to the Looker Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#additional_developer_user_count GoogleLookerInstance#additional_developer_user_count}
    */
    readonly additionalDeveloperUserCount?: number;
    /**
    * Number of additional Standard Users to allocate to the Looker Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#additional_standard_user_count GoogleLookerInstance#additional_standard_user_count}
    */
    readonly additionalStandardUserCount?: number;
    /**
    * Number of additional Viewer Users to allocate to the Looker Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#additional_viewer_user_count GoogleLookerInstance#additional_viewer_user_count}
    */
    readonly additionalViewerUserCount?: number;
}
export declare function googleLookerInstanceUserMetadataToTerraform(struct?: GoogleLookerInstanceUserMetadataOutputReference | GoogleLookerInstanceUserMetadata): any;
export declare function googleLookerInstanceUserMetadataToHclTerraform(struct?: GoogleLookerInstanceUserMetadataOutputReference | GoogleLookerInstanceUserMetadata): any;
export declare class GoogleLookerInstanceUserMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLookerInstanceUserMetadata | undefined;
    set internalValue(value: GoogleLookerInstanceUserMetadata | undefined);
    private _additionalDeveloperUserCount?;
    get additionalDeveloperUserCount(): number;
    set additionalDeveloperUserCount(value: number);
    resetAdditionalDeveloperUserCount(): void;
    get additionalDeveloperUserCountInput(): number | undefined;
    private _additionalStandardUserCount?;
    get additionalStandardUserCount(): number;
    set additionalStandardUserCount(value: number);
    resetAdditionalStandardUserCount(): void;
    get additionalStandardUserCountInput(): number | undefined;
    private _additionalViewerUserCount?;
    get additionalViewerUserCount(): number;
    set additionalViewerUserCount(value: number);
    resetAdditionalViewerUserCount(): void;
    get additionalViewerUserCountInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance google_looker_instance}
*/
export declare class GoogleLookerInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_looker_instance";
    /**
    * Generates CDKTF code for importing a GoogleLookerInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleLookerInstance to import
    * @param importFromId The id of the existing GoogleLookerInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleLookerInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_looker_instance google_looker_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLookerInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLookerInstanceConfig);
    private _consumerNetwork?;
    get consumerNetwork(): string;
    set consumerNetwork(value: string);
    resetConsumerNetwork(): void;
    get consumerNetworkInput(): string | undefined;
    get createTime(): string;
    get egressPublicIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ingressPrivateIp(): string;
    get ingressPublicIp(): string;
    get lookerUri(): string;
    get lookerVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _platformEdition?;
    get platformEdition(): string;
    set platformEdition(value: string);
    resetPlatformEdition(): void;
    get platformEditionInput(): string | undefined;
    private _privateIpEnabled?;
    get privateIpEnabled(): boolean | cdktf.IResolvable;
    set privateIpEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateIpEnabled(): void;
    get privateIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _publicIpEnabled?;
    get publicIpEnabled(): boolean | cdktf.IResolvable;
    set publicIpEnabled(value: boolean | cdktf.IResolvable);
    resetPublicIpEnabled(): void;
    get publicIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _reservedRange?;
    get reservedRange(): string;
    set reservedRange(value: string);
    resetReservedRange(): void;
    get reservedRangeInput(): string | undefined;
    get updateTime(): string;
    private _adminSettings;
    get adminSettings(): GoogleLookerInstanceAdminSettingsOutputReference;
    putAdminSettings(value: GoogleLookerInstanceAdminSettings): void;
    resetAdminSettings(): void;
    get adminSettingsInput(): GoogleLookerInstanceAdminSettings | undefined;
    private _customDomain;
    get customDomain(): GoogleLookerInstanceCustomDomainOutputReference;
    putCustomDomain(value: GoogleLookerInstanceCustomDomain): void;
    resetCustomDomain(): void;
    get customDomainInput(): GoogleLookerInstanceCustomDomain | undefined;
    private _denyMaintenancePeriod;
    get denyMaintenancePeriod(): GoogleLookerInstanceDenyMaintenancePeriodOutputReference;
    putDenyMaintenancePeriod(value: GoogleLookerInstanceDenyMaintenancePeriod): void;
    resetDenyMaintenancePeriod(): void;
    get denyMaintenancePeriodInput(): GoogleLookerInstanceDenyMaintenancePeriod | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleLookerInstanceEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleLookerInstanceEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleLookerInstanceEncryptionConfig | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): GoogleLookerInstanceMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: GoogleLookerInstanceMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): GoogleLookerInstanceMaintenanceWindow | undefined;
    private _oauthConfig;
    get oauthConfig(): GoogleLookerInstanceOauthConfigOutputReference;
    putOauthConfig(value: GoogleLookerInstanceOauthConfig): void;
    resetOauthConfig(): void;
    get oauthConfigInput(): GoogleLookerInstanceOauthConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleLookerInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleLookerInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleLookerInstanceTimeouts | undefined;
    private _userMetadata;
    get userMetadata(): GoogleLookerInstanceUserMetadataOutputReference;
    putUserMetadata(value: GoogleLookerInstanceUserMetadata): void;
    resetUserMetadata(): void;
    get userMetadataInput(): GoogleLookerInstanceUserMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
