/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMigrationCenterPreferenceSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the preference set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#description GoogleMigrationCenterPreferenceSet#description}
    */
    readonly description?: string;
    /**
    * User-friendly display name. Maximum length is 63 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#display_name GoogleMigrationCenterPreferenceSet#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#id GoogleMigrationCenterPreferenceSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Part of 'parent'. See documentation of 'projectsId'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#location GoogleMigrationCenterPreferenceSet#location}
    */
    readonly location: string;
    /**
    * Required. User specified ID for the preference set. It will become the last component of the preference set name. The ID must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. The ID must match the regular expression '[a-z]([a-z0-9-]{0,61}[a-z0-9])?'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#preference_set_id GoogleMigrationCenterPreferenceSet#preference_set_id}
    */
    readonly preferenceSetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#project GoogleMigrationCenterPreferenceSet#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#timeouts GoogleMigrationCenterPreferenceSet#timeouts}
    */
    readonly timeouts?: GoogleMigrationCenterPreferenceSetTimeouts;
    /**
    * virtual_machine_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#virtual_machine_preferences GoogleMigrationCenterPreferenceSet#virtual_machine_preferences}
    */
    readonly virtualMachinePreferences?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferences;
}
export interface GoogleMigrationCenterPreferenceSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#create GoogleMigrationCenterPreferenceSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#delete GoogleMigrationCenterPreferenceSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#update GoogleMigrationCenterPreferenceSet#update}
    */
    readonly update?: string;
}
export declare function googleMigrationCenterPreferenceSetTimeoutsToTerraform(struct?: GoogleMigrationCenterPreferenceSetTimeouts | cdktf.IResolvable): any;
export declare function googleMigrationCenterPreferenceSetTimeoutsToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetTimeouts | cdktf.IResolvable): any;
export declare class GoogleMigrationCenterPreferenceSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries {
    /**
    * Code to identify a Compute Engine machine series. Consult https://cloud.google.com/compute/docs/machine-resource#machine_type_comparison for more details on the available series.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#code GoogleMigrationCenterPreferenceSet#code}
    */
    readonly code?: string;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeriesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries | cdktf.IResolvable): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeriesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries | cdktf.IResolvable): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries | cdktf.IResolvable | undefined);
    private _code?;
    get code(): string;
    set code(value: string);
    resetCode(): void;
    get codeInput(): string | undefined;
}
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeriesOutputReference;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences {
    /**
    * allowed_machine_series block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#allowed_machine_series GoogleMigrationCenterPreferenceSet#allowed_machine_series}
    */
    readonly allowedMachineSeries?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries[] | cdktf.IResolvable;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences | undefined);
    private _allowedMachineSeries;
    get allowedMachineSeries(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeriesList;
    putAllowedMachineSeries(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries[] | cdktf.IResolvable): void;
    resetAllowedMachineSeries(): void;
    get allowedMachineSeriesInput(): cdktf.IResolvable | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesAllowedMachineSeries[] | undefined;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences {
    /**
    * License type to consider when calculating costs for virtual machine insights and recommendations. If unspecified, costs are calculated based on the default licensing plan.
    *  Possible values:
    *  LICENSE_TYPE_UNSPECIFIED
    * LICENSE_TYPE_DEFAULT
    * LICENSE_TYPE_BRING_YOUR_OWN_LICENSE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#license_type GoogleMigrationCenterPreferenceSet#license_type}
    */
    readonly licenseType?: string;
    /**
    * machine_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#machine_preferences GoogleMigrationCenterPreferenceSet#machine_preferences}
    */
    readonly machinePreferences?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences | undefined);
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _machinePreferences;
    get machinePreferences(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferencesOutputReference;
    putMachinePreferences(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences): void;
    resetMachinePreferences(): void;
    get machinePreferencesInput(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesMachinePreferences | undefined;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences {
    /**
    * A list of preferred regions, ordered by the most preferred region first. Set only valid Google Cloud region names. See https://cloud.google.com/compute/docs/regions-zones for available regions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#preferred_regions GoogleMigrationCenterPreferenceSet#preferred_regions}
    */
    readonly preferredRegions?: string[];
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferencesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferencesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences | undefined);
    private _preferredRegions?;
    get preferredRegions(): string[];
    set preferredRegions(value: string[]);
    resetPreferredRegions(): void;
    get preferredRegionsInput(): string[] | undefined;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes {
    /**
    * Name of the Sole Tenant node. Consult https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#node_name GoogleMigrationCenterPreferenceSet#node_name}
    */
    readonly nodeName?: string;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes | cdktf.IResolvable): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes | cdktf.IResolvable): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes | cdktf.IResolvable | undefined);
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    resetNodeName(): void;
    get nodeNameInput(): string | undefined;
}
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypesOutputReference;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences {
    /**
    * Commitment plan to consider when calculating costs for virtual machine insights and recommendations. If you are unsure which value to set, a 3 year commitment plan is often a good value to start with.
    *  Possible values:
    *  COMMITMENT_PLAN_UNSPECIFIED
    * ON_DEMAND
    * COMMITMENT_1_YEAR
    * COMMITMENT_3_YEAR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#commitment_plan GoogleMigrationCenterPreferenceSet#commitment_plan}
    */
    readonly commitmentPlan?: string;
    /**
    * CPU overcommit ratio. Acceptable values are between 1.0 and 2.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#cpu_overcommit_ratio GoogleMigrationCenterPreferenceSet#cpu_overcommit_ratio}
    */
    readonly cpuOvercommitRatio?: number;
    /**
    * Sole Tenancy nodes maintenance policy.
    *  Possible values:
    *  HOST_MAINTENANCE_POLICY_UNSPECIFIED
    * HOST_MAINTENANCE_POLICY_DEFAULT
    * HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE
    * HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#host_maintenance_policy GoogleMigrationCenterPreferenceSet#host_maintenance_policy}
    */
    readonly hostMaintenancePolicy?: string;
    /**
    * node_types block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#node_types GoogleMigrationCenterPreferenceSet#node_types}
    */
    readonly nodeTypes?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes[] | cdktf.IResolvable;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences | undefined);
    private _commitmentPlan?;
    get commitmentPlan(): string;
    set commitmentPlan(value: string);
    resetCommitmentPlan(): void;
    get commitmentPlanInput(): string | undefined;
    private _cpuOvercommitRatio?;
    get cpuOvercommitRatio(): number;
    set cpuOvercommitRatio(value: number);
    resetCpuOvercommitRatio(): void;
    get cpuOvercommitRatioInput(): number | undefined;
    private _hostMaintenancePolicy?;
    get hostMaintenancePolicy(): string;
    set hostMaintenancePolicy(value: string);
    resetHostMaintenancePolicy(): void;
    get hostMaintenancePolicyInput(): string | undefined;
    private _nodeTypes;
    get nodeTypes(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypesList;
    putNodeTypes(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes[] | cdktf.IResolvable): void;
    resetNodeTypes(): void;
    get nodeTypesInput(): cdktf.IResolvable | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesNodeTypes[] | undefined;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences {
    /**
    * Commitment plan to consider when calculating costs for virtual machine insights and recommendations. If you are unsure which value to set, a 3 year commitment plan is often a good value to start with.
    *  Possible values:
    *  COMMITMENT_PLAN_UNSPECIFIED
    * ON_DEMAND
    * COMMITMENT_1_YEAR_MONTHLY_PAYMENTS
    * COMMITMENT_3_YEAR_MONTHLY_PAYMENTS
    * COMMITMENT_1_YEAR_UPFRONT_PAYMENT
    * COMMITMENT_3_YEAR_UPFRONT_PAYMENT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#commitment_plan GoogleMigrationCenterPreferenceSet#commitment_plan}
    */
    readonly commitmentPlan?: string;
    /**
    * CPU overcommit ratio. Acceptable values are between 1.0 and 8.0, with 0.1 increment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#cpu_overcommit_ratio GoogleMigrationCenterPreferenceSet#cpu_overcommit_ratio}
    */
    readonly cpuOvercommitRatio?: number;
    /**
    * Memory overcommit ratio. Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#memory_overcommit_ratio GoogleMigrationCenterPreferenceSet#memory_overcommit_ratio}
    */
    readonly memoryOvercommitRatio?: number;
    /**
    * The Deduplication and Compression ratio is based on the logical (Used Before) space required to store data before applying deduplication and compression, in relation to the physical (Used After) space required after applying deduplication and compression. Specifically, the ratio is the Used Before space divided by the Used After space. For example, if the Used Before space is 3 GB, but the physical Used After space is 1 GB, the deduplication and compression ratio is 3x. Acceptable values are between 1.0 and 4.0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#storage_deduplication_compression_ratio GoogleMigrationCenterPreferenceSet#storage_deduplication_compression_ratio}
    */
    readonly storageDeduplicationCompressionRatio?: number;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferencesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferencesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences | undefined);
    private _commitmentPlan?;
    get commitmentPlan(): string;
    set commitmentPlan(value: string);
    resetCommitmentPlan(): void;
    get commitmentPlanInput(): string | undefined;
    private _cpuOvercommitRatio?;
    get cpuOvercommitRatio(): number;
    set cpuOvercommitRatio(value: number);
    resetCpuOvercommitRatio(): void;
    get cpuOvercommitRatioInput(): number | undefined;
    private _memoryOvercommitRatio?;
    get memoryOvercommitRatio(): number;
    set memoryOvercommitRatio(value: number);
    resetMemoryOvercommitRatio(): void;
    get memoryOvercommitRatioInput(): number | undefined;
    private _storageDeduplicationCompressionRatio?;
    get storageDeduplicationCompressionRatio(): number;
    set storageDeduplicationCompressionRatio(value: number);
    resetStorageDeduplicationCompressionRatio(): void;
    get storageDeduplicationCompressionRatioInput(): number | undefined;
}
export interface GoogleMigrationCenterPreferenceSetVirtualMachinePreferences {
    /**
    * Commitment plan to consider when calculating costs for virtual machine insights and recommendations. If you are unsure which value to set, a 3 year commitment plan is often a good value to start with.
    *  Possible values:
    *  COMMITMENT_PLAN_UNSPECIFIED
    * COMMITMENT_PLAN_NONE
    * COMMITMENT_PLAN_ONE_YEAR
    * COMMITMENT_PLAN_THREE_YEARS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#commitment_plan GoogleMigrationCenterPreferenceSet#commitment_plan}
    */
    readonly commitmentPlan?: string;
    /**
    * Sizing optimization strategy specifies the preferred strategy used when extrapolating usage data to calculate insights and recommendations for a virtual machine. If you are unsure which value to set, a moderate sizing optimization strategy is often a good value to start with.
    *  Possible values:
    *  SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED
    * SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE
    * SIZING_OPTIMIZATION_STRATEGY_MODERATE
    * SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#sizing_optimization_strategy GoogleMigrationCenterPreferenceSet#sizing_optimization_strategy}
    */
    readonly sizingOptimizationStrategy?: string;
    /**
    * Target product for assets using this preference set. Specify either target product or business goal, but not both.
    *  Possible values:
    *  COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED
    * COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE
    * COMPUTE_MIGRATION_TARGET_PRODUCT_VMWARE_ENGINE
    * COMPUTE_MIGRATION_TARGET_PRODUCT_SOLE_TENANCY
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#target_product GoogleMigrationCenterPreferenceSet#target_product}
    */
    readonly targetProduct?: string;
    /**
    * compute_engine_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#compute_engine_preferences GoogleMigrationCenterPreferenceSet#compute_engine_preferences}
    */
    readonly computeEnginePreferences?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences;
    /**
    * region_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#region_preferences GoogleMigrationCenterPreferenceSet#region_preferences}
    */
    readonly regionPreferences?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences;
    /**
    * sole_tenancy_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#sole_tenancy_preferences GoogleMigrationCenterPreferenceSet#sole_tenancy_preferences}
    */
    readonly soleTenancyPreferences?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences;
    /**
    * vmware_engine_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#vmware_engine_preferences GoogleMigrationCenterPreferenceSet#vmware_engine_preferences}
    */
    readonly vmwareEnginePreferences?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences;
}
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesToTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferences): any;
export declare function googleMigrationCenterPreferenceSetVirtualMachinePreferencesToHclTerraform(struct?: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesOutputReference | GoogleMigrationCenterPreferenceSetVirtualMachinePreferences): any;
export declare class GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferences | undefined;
    set internalValue(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferences | undefined);
    private _commitmentPlan?;
    get commitmentPlan(): string;
    set commitmentPlan(value: string);
    resetCommitmentPlan(): void;
    get commitmentPlanInput(): string | undefined;
    private _sizingOptimizationStrategy?;
    get sizingOptimizationStrategy(): string;
    set sizingOptimizationStrategy(value: string);
    resetSizingOptimizationStrategy(): void;
    get sizingOptimizationStrategyInput(): string | undefined;
    private _targetProduct?;
    get targetProduct(): string;
    set targetProduct(value: string);
    resetTargetProduct(): void;
    get targetProductInput(): string | undefined;
    private _computeEnginePreferences;
    get computeEnginePreferences(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferencesOutputReference;
    putComputeEnginePreferences(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences): void;
    resetComputeEnginePreferences(): void;
    get computeEnginePreferencesInput(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesComputeEnginePreferences | undefined;
    private _regionPreferences;
    get regionPreferences(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferencesOutputReference;
    putRegionPreferences(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences): void;
    resetRegionPreferences(): void;
    get regionPreferencesInput(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesRegionPreferences | undefined;
    private _soleTenancyPreferences;
    get soleTenancyPreferences(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferencesOutputReference;
    putSoleTenancyPreferences(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences): void;
    resetSoleTenancyPreferences(): void;
    get soleTenancyPreferencesInput(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesSoleTenancyPreferences | undefined;
    private _vmwareEnginePreferences;
    get vmwareEnginePreferences(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferencesOutputReference;
    putVmwareEnginePreferences(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences): void;
    resetVmwareEnginePreferences(): void;
    get vmwareEnginePreferencesInput(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesVmwareEnginePreferences | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set google_migration_center_preference_set}
*/
export declare class GoogleMigrationCenterPreferenceSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_migration_center_preference_set";
    /**
    * Generates CDKTF code for importing a GoogleMigrationCenterPreferenceSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleMigrationCenterPreferenceSet to import
    * @param importFromId The id of the existing GoogleMigrationCenterPreferenceSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleMigrationCenterPreferenceSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_migration_center_preference_set google_migration_center_preference_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMigrationCenterPreferenceSetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMigrationCenterPreferenceSetConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _preferenceSetId?;
    get preferenceSetId(): string;
    set preferenceSetId(value: string);
    get preferenceSetIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleMigrationCenterPreferenceSetTimeoutsOutputReference;
    putTimeouts(value: GoogleMigrationCenterPreferenceSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMigrationCenterPreferenceSetTimeouts | undefined;
    private _virtualMachinePreferences;
    get virtualMachinePreferences(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferencesOutputReference;
    putVirtualMachinePreferences(value: GoogleMigrationCenterPreferenceSetVirtualMachinePreferences): void;
    resetVirtualMachinePreferences(): void;
    get virtualMachinePreferencesInput(): GoogleMigrationCenterPreferenceSetVirtualMachinePreferences | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
