/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMlEngineModelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description specified for the model when it was created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#description GoogleMlEngineModel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#id GoogleMlEngineModel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * One or more labels that you can add, to organize your models.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#labels GoogleMlEngineModel#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name specified for the model.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#name GoogleMlEngineModel#name}
    */
    readonly name: string;
    /**
    * If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#online_prediction_console_logging GoogleMlEngineModel#online_prediction_console_logging}
    */
    readonly onlinePredictionConsoleLogging?: boolean | cdktf.IResolvable;
    /**
    * If true, online prediction access logs are sent to StackDriver Logging.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#online_prediction_logging GoogleMlEngineModel#online_prediction_logging}
    */
    readonly onlinePredictionLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#project GoogleMlEngineModel#project}
    */
    readonly project?: string;
    /**
    * The list of regions where the model is going to be deployed.
    * Currently only one region per model is supported
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#regions GoogleMlEngineModel#regions}
    */
    readonly regions?: string[];
    /**
    * default_version block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#default_version GoogleMlEngineModel#default_version}
    */
    readonly defaultVersion?: GoogleMlEngineModelDefaultVersion;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#timeouts GoogleMlEngineModel#timeouts}
    */
    readonly timeouts?: GoogleMlEngineModelTimeouts;
}
export interface GoogleMlEngineModelDefaultVersion {
    /**
    * The name specified for the version when it was created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#name GoogleMlEngineModel#name}
    */
    readonly name: string;
}
export declare function googleMlEngineModelDefaultVersionToTerraform(struct?: GoogleMlEngineModelDefaultVersionOutputReference | GoogleMlEngineModelDefaultVersion): any;
export declare function googleMlEngineModelDefaultVersionToHclTerraform(struct?: GoogleMlEngineModelDefaultVersionOutputReference | GoogleMlEngineModelDefaultVersion): any;
export declare class GoogleMlEngineModelDefaultVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMlEngineModelDefaultVersion | undefined;
    set internalValue(value: GoogleMlEngineModelDefaultVersion | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleMlEngineModelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#create GoogleMlEngineModel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#delete GoogleMlEngineModel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#update GoogleMlEngineModel#update}
    */
    readonly update?: string;
}
export declare function googleMlEngineModelTimeoutsToTerraform(struct?: GoogleMlEngineModelTimeouts | cdktf.IResolvable): any;
export declare function googleMlEngineModelTimeoutsToHclTerraform(struct?: GoogleMlEngineModelTimeouts | cdktf.IResolvable): any;
export declare class GoogleMlEngineModelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMlEngineModelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMlEngineModelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model google_ml_engine_model}
*/
export declare class GoogleMlEngineModel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_ml_engine_model";
    /**
    * Generates CDKTF code for importing a GoogleMlEngineModel resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleMlEngineModel to import
    * @param importFromId The id of the existing GoogleMlEngineModel that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleMlEngineModel to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_ml_engine_model google_ml_engine_model} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMlEngineModelConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMlEngineModelConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onlinePredictionConsoleLogging?;
    get onlinePredictionConsoleLogging(): boolean | cdktf.IResolvable;
    set onlinePredictionConsoleLogging(value: boolean | cdktf.IResolvable);
    resetOnlinePredictionConsoleLogging(): void;
    get onlinePredictionConsoleLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _onlinePredictionLogging?;
    get onlinePredictionLogging(): boolean | cdktf.IResolvable;
    set onlinePredictionLogging(value: boolean | cdktf.IResolvable);
    resetOnlinePredictionLogging(): void;
    get onlinePredictionLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _regions?;
    get regions(): string[];
    set regions(value: string[]);
    resetRegions(): void;
    get regionsInput(): string[] | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _defaultVersion;
    get defaultVersion(): GoogleMlEngineModelDefaultVersionOutputReference;
    putDefaultVersion(value: GoogleMlEngineModelDefaultVersion): void;
    resetDefaultVersion(): void;
    get defaultVersionInput(): GoogleMlEngineModelDefaultVersion | undefined;
    private _timeouts;
    get timeouts(): GoogleMlEngineModelTimeoutsOutputReference;
    putTimeouts(value: GoogleMlEngineModelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMlEngineModelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
