/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * How to combine the results of multiple conditions to
    * determine if an incident should be opened. Possible values: ["AND", "OR", "AND_WITH_MATCHING_RESOURCE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#combiner GoogleMonitoringAlertPolicy#combiner}
    */
    readonly combiner: string;
    /**
    * A short name or phrase used to identify the policy in
    * dashboards, notifications, and incidents. To avoid confusion, don't use
    * the same display name for multiple policies in the same project. The
    * name is limited to 512 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#display_name GoogleMonitoringAlertPolicy#display_name}
    */
    readonly displayName: string;
    /**
    * Whether or not the policy is enabled. The default is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#enabled GoogleMonitoringAlertPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#id GoogleMonitoringAlertPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifies the notification channels to which notifications should be
    * sent when incidents are opened or closed or when new violations occur
    * on an already opened incident. Each element of this array corresponds
    * to the name field in each of the NotificationChannel objects that are
    * returned from the notificationChannels.list method. The syntax of the
    * entries in this field is
    * 'projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#notification_channels GoogleMonitoringAlertPolicy#notification_channels}
    */
    readonly notificationChannels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#project GoogleMonitoringAlertPolicy#project}
    */
    readonly project?: string;
    /**
    * The severity of an alert policy indicates how important incidents generated
    * by that policy are. The severity level will be displayed on the Incident
    * detail page and in notifications. Possible values: ["CRITICAL", "ERROR", "WARNING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#severity GoogleMonitoringAlertPolicy#severity}
    */
    readonly severity?: string;
    /**
    * This field is intended to be used for organizing and identifying the AlertPolicy
    * objects.The field can contain up to 64 entries. Each key and value is limited
    * to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
    * can contain only lowercase letters, numerals, underscores, and dashes. Keys
    * must begin with a letter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#user_labels GoogleMonitoringAlertPolicy#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * alert_strategy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#alert_strategy GoogleMonitoringAlertPolicy#alert_strategy}
    */
    readonly alertStrategy?: GoogleMonitoringAlertPolicyAlertStrategy;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#conditions GoogleMonitoringAlertPolicy#conditions}
    */
    readonly conditions: GoogleMonitoringAlertPolicyConditions[] | cdktf.IResolvable;
    /**
    * documentation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#documentation GoogleMonitoringAlertPolicy#documentation}
    */
    readonly documentation?: GoogleMonitoringAlertPolicyDocumentation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#timeouts GoogleMonitoringAlertPolicy#timeouts}
    */
    readonly timeouts?: GoogleMonitoringAlertPolicyTimeouts;
}
export interface GoogleMonitoringAlertPolicyCreationRecord {
}
export declare function googleMonitoringAlertPolicyCreationRecordToTerraform(struct?: GoogleMonitoringAlertPolicyCreationRecord): any;
export declare function googleMonitoringAlertPolicyCreationRecordToHclTerraform(struct?: GoogleMonitoringAlertPolicyCreationRecord): any;
export declare class GoogleMonitoringAlertPolicyCreationRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringAlertPolicyCreationRecord | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyCreationRecord | undefined);
    get mutateTime(): string;
    get mutatedBy(): string;
}
export declare class GoogleMonitoringAlertPolicyCreationRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringAlertPolicyCreationRecordOutputReference;
}
export interface GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy {
    /**
    * The notification channels that these settings apply to. Each of these
    * correspond to the name field in one of the NotificationChannel objects
    * referenced in the notification_channels field of this AlertPolicy. The format is
    * 'projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#notification_channel_names GoogleMonitoringAlertPolicy#notification_channel_names}
    */
    readonly notificationChannelNames?: string[];
    /**
    * The frequency at which to send reminder notifications for open incidents.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#renotify_interval GoogleMonitoringAlertPolicy#renotify_interval}
    */
    readonly renotifyInterval?: string;
}
export declare function googleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategyToTerraform(struct?: GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy | cdktf.IResolvable): any;
export declare function googleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategyToHclTerraform(struct?: GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy | cdktf.IResolvable): any;
export declare class GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy | cdktf.IResolvable | undefined);
    private _notificationChannelNames?;
    get notificationChannelNames(): string[];
    set notificationChannelNames(value: string[]);
    resetNotificationChannelNames(): void;
    get notificationChannelNamesInput(): string[] | undefined;
    private _renotifyInterval?;
    get renotifyInterval(): string;
    set renotifyInterval(value: string);
    resetRenotifyInterval(): void;
    get renotifyIntervalInput(): string | undefined;
}
export declare class GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategyOutputReference;
}
export interface GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit {
    /**
    * Not more than one notification per period.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#period GoogleMonitoringAlertPolicy#period}
    */
    readonly period?: string;
}
export declare function googleMonitoringAlertPolicyAlertStrategyNotificationRateLimitToTerraform(struct?: GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimitOutputReference | GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit): any;
export declare function googleMonitoringAlertPolicyAlertStrategyNotificationRateLimitToHclTerraform(struct?: GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimitOutputReference | GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit): any;
export declare class GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit | undefined);
    private _period?;
    get period(): string;
    set period(value: string);
    resetPeriod(): void;
    get periodInput(): string | undefined;
}
export interface GoogleMonitoringAlertPolicyAlertStrategy {
    /**
    * If an alert policy that was active has no data for this long, any open incidents will close.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#auto_close GoogleMonitoringAlertPolicy#auto_close}
    */
    readonly autoClose?: string;
    /**
    * notification_channel_strategy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#notification_channel_strategy GoogleMonitoringAlertPolicy#notification_channel_strategy}
    */
    readonly notificationChannelStrategy?: GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy[] | cdktf.IResolvable;
    /**
    * notification_rate_limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#notification_rate_limit GoogleMonitoringAlertPolicy#notification_rate_limit}
    */
    readonly notificationRateLimit?: GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit;
}
export declare function googleMonitoringAlertPolicyAlertStrategyToTerraform(struct?: GoogleMonitoringAlertPolicyAlertStrategyOutputReference | GoogleMonitoringAlertPolicyAlertStrategy): any;
export declare function googleMonitoringAlertPolicyAlertStrategyToHclTerraform(struct?: GoogleMonitoringAlertPolicyAlertStrategyOutputReference | GoogleMonitoringAlertPolicyAlertStrategy): any;
export declare class GoogleMonitoringAlertPolicyAlertStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyAlertStrategy | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyAlertStrategy | undefined);
    private _autoClose?;
    get autoClose(): string;
    set autoClose(value: string);
    resetAutoClose(): void;
    get autoCloseInput(): string | undefined;
    private _notificationChannelStrategy;
    get notificationChannelStrategy(): GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategyList;
    putNotificationChannelStrategy(value: GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy[] | cdktf.IResolvable): void;
    resetNotificationChannelStrategy(): void;
    get notificationChannelStrategyInput(): cdktf.IResolvable | GoogleMonitoringAlertPolicyAlertStrategyNotificationChannelStrategy[] | undefined;
    private _notificationRateLimit;
    get notificationRateLimit(): GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimitOutputReference;
    putNotificationRateLimit(value: GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit): void;
    resetNotificationRateLimit(): void;
    get notificationRateLimitInput(): GoogleMonitoringAlertPolicyAlertStrategyNotificationRateLimit | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations {
    /**
    * The alignment period for per-time
    * series alignment. If present,
    * alignmentPeriod must be at least
    * 60 seconds. After per-time series
    * alignment, each time series will
    * contain data points only on the
    * period boundaries. If
    * perSeriesAligner is not specified
    * or equals ALIGN_NONE, then this
    * field is ignored. If
    * perSeriesAligner is specified and
    * does not equal ALIGN_NONE, then
    * this field must be defined;
    * otherwise an error is returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#alignment_period GoogleMonitoringAlertPolicy#alignment_period}
    */
    readonly alignmentPeriod?: string;
    /**
    * The approach to be used to combine
    * time series. Not all reducer
    * functions may be applied to all
    * time series, depending on the
    * metric type and the value type of
    * the original time series.
    * Reduction may change the metric
    * type of value type of the time
    * series.Time series data must be
    * aligned in order to perform cross-
    * time series reduction. If
    * crossSeriesReducer is specified,
    * then perSeriesAligner must be
    * specified and not equal ALIGN_NONE
    * and alignmentPeriod must be
    * specified; otherwise, an error is
    * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#cross_series_reducer GoogleMonitoringAlertPolicy#cross_series_reducer}
    */
    readonly crossSeriesReducer?: string;
    /**
    * The set of fields to preserve when
    * crossSeriesReducer is specified.
    * The groupByFields determine how
    * the time series are partitioned
    * into subsets prior to applying the
    * aggregation function. Each subset
    * contains time series that have the
    * same value for each of the
    * grouping fields. Each individual
    * time series is a member of exactly
    * one subset. The crossSeriesReducer
    * is applied to each subset of time
    * series. It is not possible to
    * reduce across different resource
    * types, so this field implicitly
    * contains resource.type. Fields not
    * specified in groupByFields are
    * aggregated away. If groupByFields
    * is not specified and all the time
    * series have the same resource
    * type, then the time series are
    * aggregated into a single output
    * time series. If crossSeriesReducer
    * is not defined, this field is
    * ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#group_by_fields GoogleMonitoringAlertPolicy#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The approach to be used to align
    * individual time series. Not all
    * alignment functions may be applied
    * to all time series, depending on
    * the metric type and value type of
    * the original time series.
    * Alignment may change the metric
    * type or the value type of the time
    * series.Time series data must be
    * aligned in order to perform cross-
    * time series reduction. If
    * crossSeriesReducer is specified,
    * then perSeriesAligner must be
    * specified and not equal ALIGN_NONE
    * and alignmentPeriod must be
    * specified; otherwise, an error is
    * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#per_series_aligner GoogleMonitoringAlertPolicy#per_series_aligner}
    */
    readonly perSeriesAligner?: string;
}
export declare function googleMonitoringAlertPolicyConditionsConditionAbsentAggregationsToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations | cdktf.IResolvable): any;
export declare function googleMonitoringAlertPolicyConditionsConditionAbsentAggregationsToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations | cdktf.IResolvable): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations | cdktf.IResolvable | undefined);
    private _alignmentPeriod?;
    get alignmentPeriod(): string;
    set alignmentPeriod(value: string);
    resetAlignmentPeriod(): void;
    get alignmentPeriodInput(): string | undefined;
    private _crossSeriesReducer?;
    get crossSeriesReducer(): string;
    set crossSeriesReducer(value: string);
    resetCrossSeriesReducer(): void;
    get crossSeriesReducerInput(): string | undefined;
    private _groupByFields?;
    get groupByFields(): string[];
    set groupByFields(value: string[]);
    resetGroupByFields(): void;
    get groupByFieldsInput(): string[] | undefined;
    private _perSeriesAligner?;
    get perSeriesAligner(): string;
    set perSeriesAligner(value: string);
    resetPerSeriesAligner(): void;
    get perSeriesAlignerInput(): string | undefined;
}
export declare class GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregationsOutputReference;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger {
    /**
    * The absolute number of time series
    * that must fail the predicate for the
    * condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#count GoogleMonitoringAlertPolicy#count}
    */
    readonly count?: number;
    /**
    * The percentage of time series that
    * must fail the predicate for the
    * condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#percent GoogleMonitoringAlertPolicy#percent}
    */
    readonly percent?: number;
}
export declare function googleMonitoringAlertPolicyConditionsConditionAbsentTriggerToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference | GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger): any;
export declare function googleMonitoringAlertPolicyConditionsConditionAbsentTriggerToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference | GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionAbsent {
    /**
    * The amount of time that a time series must
    * fail to report new data to be considered
    * failing. Currently, only values that are a
    * multiple of a minute--e.g. 60s, 120s, or 300s
    * --are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#duration GoogleMonitoringAlertPolicy#duration}
    */
    readonly duration: string;
    /**
    * A filter that identifies which time series
    * should be compared with the threshold.The
    * filter is similar to the one that is
    * specified in the
    * MetricService.ListTimeSeries request (that
    * call is useful to verify the time series
    * that will be retrieved / processed) and must
    * specify the metric type and optionally may
    * contain restrictions on resource type,
    * resource labels, and metric labels. This
    * field may not exceed 2048 Unicode characters
    * in length.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#filter GoogleMonitoringAlertPolicy#filter}
    */
    readonly filter?: string;
    /**
    * aggregations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#aggregations GoogleMonitoringAlertPolicy#aggregations}
    */
    readonly aggregations?: GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#trigger GoogleMonitoringAlertPolicy#trigger}
    */
    readonly trigger?: GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger;
}
export declare function googleMonitoringAlertPolicyConditionsConditionAbsentToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionAbsentOutputReference | GoogleMonitoringAlertPolicyConditionsConditionAbsent): any;
export declare function googleMonitoringAlertPolicyConditionsConditionAbsentToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionAbsentOutputReference | GoogleMonitoringAlertPolicyConditionsConditionAbsent): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionAbsentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionAbsent | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionAbsent | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _aggregations;
    get aggregations(): GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregationsList;
    putAggregations(value: GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable): void;
    resetAggregations(): void;
    get aggregationsInput(): cdktf.IResolvable | GoogleMonitoringAlertPolicyConditionsConditionAbsentAggregations[] | undefined;
    private _trigger;
    get trigger(): GoogleMonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference;
    putTrigger(value: GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger): void;
    resetTrigger(): void;
    get triggerInput(): GoogleMonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionMatchedLog {
    /**
    * A logs-based filter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#filter GoogleMonitoringAlertPolicy#filter}
    */
    readonly filter: string;
    /**
    * A map from a label key to an extractor expression, which is used to
    * extract the value for this label key. Each entry in this map is
    * a specification for how data should be extracted from log entries that
    * match filter. Each combination of extracted values is treated as
    * a separate rule for the purposes of triggering notifications.
    * Label keys and corresponding values can be used in notifications
    * generated by this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#label_extractors GoogleMonitoringAlertPolicy#label_extractors}
    */
    readonly labelExtractors?: {
        [key: string]: string;
    };
}
export declare function googleMonitoringAlertPolicyConditionsConditionMatchedLogToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionMatchedLogOutputReference | GoogleMonitoringAlertPolicyConditionsConditionMatchedLog): any;
export declare function googleMonitoringAlertPolicyConditionsConditionMatchedLogToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionMatchedLogOutputReference | GoogleMonitoringAlertPolicyConditionsConditionMatchedLog): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionMatchedLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionMatchedLog | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionMatchedLog | undefined);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _labelExtractors?;
    get labelExtractors(): {
        [key: string]: string;
    };
    set labelExtractors(value: {
        [key: string]: string;
    });
    resetLabelExtractors(): void;
    get labelExtractorsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger {
    /**
    * The absolute number of time series
    * that must fail the predicate for the
    * condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#count GoogleMonitoringAlertPolicy#count}
    */
    readonly count?: number;
    /**
    * The percentage of time series that
    * must fail the predicate for the
    * condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#percent GoogleMonitoringAlertPolicy#percent}
    */
    readonly percent?: number;
}
export declare function googleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference | GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): any;
export declare function googleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference | GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage {
    /**
    * The amount of time that a time series must
    * violate the threshold to be considered
    * failing. Currently, only values that are a
    * multiple of a minute--e.g., 0, 60, 120, or
    * 300 seconds--are supported. If an invalid
    * value is given, an error will be returned.
    * When choosing a duration, it is useful to
    * keep in mind the frequency of the underlying
    * time series data (which may also be affected
    * by any alignments specified in the
    * aggregations field); a good duration is long
    * enough so that a single outlier does not
    * generate spurious alerts, but short enough
    * that unhealthy states are detected and
    * alerted on quickly.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#duration GoogleMonitoringAlertPolicy#duration}
    */
    readonly duration: string;
    /**
    * A condition control that determines how
    * metric-threshold conditions are evaluated when
    * data stops arriving. Possible values: ["EVALUATION_MISSING_DATA_INACTIVE", "EVALUATION_MISSING_DATA_ACTIVE", "EVALUATION_MISSING_DATA_NO_OP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#evaluation_missing_data GoogleMonitoringAlertPolicy#evaluation_missing_data}
    */
    readonly evaluationMissingData?: string;
    /**
    * Monitoring Query Language query that outputs a boolean stream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#query GoogleMonitoringAlertPolicy#query}
    */
    readonly query: string;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#trigger GoogleMonitoringAlertPolicy#trigger}
    */
    readonly trigger?: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger;
}
export declare function googleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference | GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage): any;
export declare function googleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference | GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _evaluationMissingData?;
    get evaluationMissingData(): string;
    set evaluationMissingData(value: string);
    resetEvaluationMissingData(): void;
    get evaluationMissingDataInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _trigger;
    get trigger(): GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference;
    putTrigger(value: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): void;
    resetTrigger(): void;
    get triggerInput(): GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage {
    /**
    * The alerting rule name of this alert in the corresponding Prometheus
    * configuration file.
    *
    * Some external tools may require this field to be populated correctly
    * in order to refer to the original Prometheus configuration file.
    * The rule group name and the alert name are necessary to update the
    * relevant AlertPolicies in case the definition of the rule group changes
    * in the future.
    *
    * This field is optional. If this field is not empty, then it must be a
    * valid Prometheus label name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#alert_rule GoogleMonitoringAlertPolicy#alert_rule}
    */
    readonly alertRule?: string;
    /**
    * Alerts are considered firing once their PromQL expression evaluated
    * to be "true" for this long. Alerts whose PromQL expression was not
    * evaluated to be "true" for long enough are considered pending. The
    * default value is zero. Must be zero or positive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#duration GoogleMonitoringAlertPolicy#duration}
    */
    readonly duration?: string;
    /**
    * How often this rule should be evaluated. Must be a positive multiple
    * of 30 seconds or missing. The default value is 30 seconds. If this
    * PrometheusQueryLanguageCondition was generated from a Prometheus
    * alerting rule, then this value should be taken from the enclosing
    * rule group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#evaluation_interval GoogleMonitoringAlertPolicy#evaluation_interval}
    */
    readonly evaluationInterval?: string;
    /**
    * Labels to add to or overwrite in the PromQL query result. Label names
    * must be valid.
    *
    * Label values can be templatized by using variables. The only available
    * variable names are the names of the labels in the PromQL result, including
    * "__name__" and "value". "labels" may be empty. This field is intended to be
    * used for organizing and identifying the AlertPolicy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#labels GoogleMonitoringAlertPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The PromQL expression to evaluate. Every evaluation cycle this
    * expression is evaluated at the current time, and all resultant time
    * series become pending/firing alerts. This field must not be empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#query GoogleMonitoringAlertPolicy#query}
    */
    readonly query: string;
    /**
    * The rule group name of this alert in the corresponding Prometheus
    * configuration file.
    *
    * Some external tools may require this field to be populated correctly
    * in order to refer to the original Prometheus configuration file.
    * The rule group name and the alert name are necessary to update the
    * relevant AlertPolicies in case the definition of the rule group changes
    * in the future. This field is optional.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#rule_group GoogleMonitoringAlertPolicy#rule_group}
    */
    readonly ruleGroup?: string;
}
export declare function googleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguageToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguageOutputReference | GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage): any;
export declare function googleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguageToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguageOutputReference | GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage | undefined);
    private _alertRule?;
    get alertRule(): string;
    set alertRule(value: string);
    resetAlertRule(): void;
    get alertRuleInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    private _evaluationInterval?;
    get evaluationInterval(): string;
    set evaluationInterval(value: string);
    resetEvaluationInterval(): void;
    get evaluationIntervalInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _ruleGroup?;
    get ruleGroup(): string;
    set ruleGroup(value: string);
    resetRuleGroup(): void;
    get ruleGroupInput(): string | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations {
    /**
    * The alignment period for per-time
    * series alignment. If present,
    * alignmentPeriod must be at least
    * 60 seconds. After per-time series
    * alignment, each time series will
    * contain data points only on the
    * period boundaries. If
    * perSeriesAligner is not specified
    * or equals ALIGN_NONE, then this
    * field is ignored. If
    * perSeriesAligner is specified and
    * does not equal ALIGN_NONE, then
    * this field must be defined;
    * otherwise an error is returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#alignment_period GoogleMonitoringAlertPolicy#alignment_period}
    */
    readonly alignmentPeriod?: string;
    /**
    * The approach to be used to combine
    * time series. Not all reducer
    * functions may be applied to all
    * time series, depending on the
    * metric type and the value type of
    * the original time series.
    * Reduction may change the metric
    * type of value type of the time
    * series.Time series data must be
    * aligned in order to perform cross-
    * time series reduction. If
    * crossSeriesReducer is specified,
    * then perSeriesAligner must be
    * specified and not equal ALIGN_NONE
    * and alignmentPeriod must be
    * specified; otherwise, an error is
    * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#cross_series_reducer GoogleMonitoringAlertPolicy#cross_series_reducer}
    */
    readonly crossSeriesReducer?: string;
    /**
    * The set of fields to preserve when
    * crossSeriesReducer is specified.
    * The groupByFields determine how
    * the time series are partitioned
    * into subsets prior to applying the
    * aggregation function. Each subset
    * contains time series that have the
    * same value for each of the
    * grouping fields. Each individual
    * time series is a member of exactly
    * one subset. The crossSeriesReducer
    * is applied to each subset of time
    * series. It is not possible to
    * reduce across different resource
    * types, so this field implicitly
    * contains resource.type. Fields not
    * specified in groupByFields are
    * aggregated away. If groupByFields
    * is not specified and all the time
    * series have the same resource
    * type, then the time series are
    * aggregated into a single output
    * time series. If crossSeriesReducer
    * is not defined, this field is
    * ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#group_by_fields GoogleMonitoringAlertPolicy#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The approach to be used to align
    * individual time series. Not all
    * alignment functions may be applied
    * to all time series, depending on
    * the metric type and value type of
    * the original time series.
    * Alignment may change the metric
    * type or the value type of the time
    * series.Time series data must be
    * aligned in order to perform cross-
    * time series reduction. If
    * crossSeriesReducer is specified,
    * then perSeriesAligner must be
    * specified and not equal ALIGN_NONE
    * and alignmentPeriod must be
    * specified; otherwise, an error is
    * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#per_series_aligner GoogleMonitoringAlertPolicy#per_series_aligner}
    */
    readonly perSeriesAligner?: string;
}
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdAggregationsToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations | cdktf.IResolvable): any;
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdAggregationsToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations | cdktf.IResolvable): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations | cdktf.IResolvable | undefined);
    private _alignmentPeriod?;
    get alignmentPeriod(): string;
    set alignmentPeriod(value: string);
    resetAlignmentPeriod(): void;
    get alignmentPeriodInput(): string | undefined;
    private _crossSeriesReducer?;
    get crossSeriesReducer(): string;
    set crossSeriesReducer(value: string);
    resetCrossSeriesReducer(): void;
    get crossSeriesReducerInput(): string | undefined;
    private _groupByFields?;
    get groupByFields(): string[];
    set groupByFields(value: string[]);
    resetGroupByFields(): void;
    get groupByFieldsInput(): string[] | undefined;
    private _perSeriesAligner?;
    get perSeriesAligner(): string;
    set perSeriesAligner(value: string);
    resetPerSeriesAligner(): void;
    get perSeriesAlignerInput(): string | undefined;
}
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregationsOutputReference;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations {
    /**
    * The alignment period for per-time
    * series alignment. If present,
    * alignmentPeriod must be at least
    * 60 seconds. After per-time series
    * alignment, each time series will
    * contain data points only on the
    * period boundaries. If
    * perSeriesAligner is not specified
    * or equals ALIGN_NONE, then this
    * field is ignored. If
    * perSeriesAligner is specified and
    * does not equal ALIGN_NONE, then
    * this field must be defined;
    * otherwise an error is returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#alignment_period GoogleMonitoringAlertPolicy#alignment_period}
    */
    readonly alignmentPeriod?: string;
    /**
    * The approach to be used to combine
    * time series. Not all reducer
    * functions may be applied to all
    * time series, depending on the
    * metric type and the value type of
    * the original time series.
    * Reduction may change the metric
    * type of value type of the time
    * series.Time series data must be
    * aligned in order to perform cross-
    * time series reduction. If
    * crossSeriesReducer is specified,
    * then perSeriesAligner must be
    * specified and not equal ALIGN_NONE
    * and alignmentPeriod must be
    * specified; otherwise, an error is
    * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#cross_series_reducer GoogleMonitoringAlertPolicy#cross_series_reducer}
    */
    readonly crossSeriesReducer?: string;
    /**
    * The set of fields to preserve when
    * crossSeriesReducer is specified.
    * The groupByFields determine how
    * the time series are partitioned
    * into subsets prior to applying the
    * aggregation function. Each subset
    * contains time series that have the
    * same value for each of the
    * grouping fields. Each individual
    * time series is a member of exactly
    * one subset. The crossSeriesReducer
    * is applied to each subset of time
    * series. It is not possible to
    * reduce across different resource
    * types, so this field implicitly
    * contains resource.type. Fields not
    * specified in groupByFields are
    * aggregated away. If groupByFields
    * is not specified and all the time
    * series have the same resource
    * type, then the time series are
    * aggregated into a single output
    * time series. If crossSeriesReducer
    * is not defined, this field is
    * ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#group_by_fields GoogleMonitoringAlertPolicy#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The approach to be used to align
    * individual time series. Not all
    * alignment functions may be applied
    * to all time series, depending on
    * the metric type and value type of
    * the original time series.
    * Alignment may change the metric
    * type or the value type of the time
    * series.Time series data must be
    * aligned in order to perform cross-
    * time series reduction. If
    * crossSeriesReducer is specified,
    * then perSeriesAligner must be
    * specified and not equal ALIGN_NONE
    * and alignmentPeriod must be
    * specified; otherwise, an error is
    * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#per_series_aligner GoogleMonitoringAlertPolicy#per_series_aligner}
    */
    readonly perSeriesAligner?: string;
}
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations | cdktf.IResolvable): any;
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations | cdktf.IResolvable): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations | cdktf.IResolvable | undefined);
    private _alignmentPeriod?;
    get alignmentPeriod(): string;
    set alignmentPeriod(value: string);
    resetAlignmentPeriod(): void;
    get alignmentPeriodInput(): string | undefined;
    private _crossSeriesReducer?;
    get crossSeriesReducer(): string;
    set crossSeriesReducer(value: string);
    resetCrossSeriesReducer(): void;
    get crossSeriesReducerInput(): string | undefined;
    private _groupByFields?;
    get groupByFields(): string[];
    set groupByFields(value: string[]);
    resetGroupByFields(): void;
    get groupByFieldsInput(): string[] | undefined;
    private _perSeriesAligner?;
    get perSeriesAligner(): string;
    set perSeriesAligner(value: string);
    resetPerSeriesAligner(): void;
    get perSeriesAlignerInput(): string | undefined;
}
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsOutputReference;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions {
    /**
    * The length of time into the future to forecast
    * whether a timeseries will violate the threshold.
    * If the predicted value is found to violate the
    * threshold, and the violation is observed in all
    * forecasts made for the Configured 'duration',
    * then the timeseries is considered to be failing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#forecast_horizon GoogleMonitoringAlertPolicy#forecast_horizon}
    */
    readonly forecastHorizon: string;
}
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdForecastOptionsToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptionsOutputReference | GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions): any;
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdForecastOptionsToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptionsOutputReference | GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions | undefined);
    private _forecastHorizon?;
    get forecastHorizon(): string;
    set forecastHorizon(value: string);
    get forecastHorizonInput(): string | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger {
    /**
    * The absolute number of time series
    * that must fail the predicate for the
    * condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#count GoogleMonitoringAlertPolicy#count}
    */
    readonly count?: number;
    /**
    * The percentage of time series that
    * must fail the predicate for the
    * condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#percent GoogleMonitoringAlertPolicy#percent}
    */
    readonly percent?: number;
}
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdTriggerToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference | GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger): any;
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdTriggerToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference | GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleMonitoringAlertPolicyConditionsConditionThreshold {
    /**
    * The comparison to apply between the time
    * series (indicated by filter and aggregation)
    * and the threshold (indicated by
    * threshold_value). The comparison is applied
    * on each time series, with the time series on
    * the left-hand side and the threshold on the
    * right-hand side. Only COMPARISON_LT and
    * COMPARISON_GT are supported currently. Possible values: ["COMPARISON_GT", "COMPARISON_GE", "COMPARISON_LT", "COMPARISON_LE", "COMPARISON_EQ", "COMPARISON_NE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#comparison GoogleMonitoringAlertPolicy#comparison}
    */
    readonly comparison: string;
    /**
    * A filter that identifies a time series that
    * should be used as the denominator of a ratio
    * that will be compared with the threshold. If
    * a denominator_filter is specified, the time
    * series specified by the filter field will be
    * used as the numerator.The filter is similar
    * to the one that is specified in the
    * MetricService.ListTimeSeries request (that
    * call is useful to verify the time series
    * that will be retrieved / processed) and must
    * specify the metric type and optionally may
    * contain restrictions on resource type,
    * resource labels, and metric labels. This
    * field may not exceed 2048 Unicode characters
    * in length.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#denominator_filter GoogleMonitoringAlertPolicy#denominator_filter}
    */
    readonly denominatorFilter?: string;
    /**
    * The amount of time that a time series must
    * violate the threshold to be considered
    * failing. Currently, only values that are a
    * multiple of a minute--e.g., 0, 60, 120, or
    * 300 seconds--are supported. If an invalid
    * value is given, an error will be returned.
    * When choosing a duration, it is useful to
    * keep in mind the frequency of the underlying
    * time series data (which may also be affected
    * by any alignments specified in the
    * aggregations field); a good duration is long
    * enough so that a single outlier does not
    * generate spurious alerts, but short enough
    * that unhealthy states are detected and
    * alerted on quickly.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#duration GoogleMonitoringAlertPolicy#duration}
    */
    readonly duration: string;
    /**
    * A condition control that determines how
    * metric-threshold conditions are evaluated when
    * data stops arriving. Possible values: ["EVALUATION_MISSING_DATA_INACTIVE", "EVALUATION_MISSING_DATA_ACTIVE", "EVALUATION_MISSING_DATA_NO_OP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#evaluation_missing_data GoogleMonitoringAlertPolicy#evaluation_missing_data}
    */
    readonly evaluationMissingData?: string;
    /**
    * A filter that identifies which time series
    * should be compared with the threshold.The
    * filter is similar to the one that is
    * specified in the
    * MetricService.ListTimeSeries request (that
    * call is useful to verify the time series
    * that will be retrieved / processed) and must
    * specify the metric type and optionally may
    * contain restrictions on resource type,
    * resource labels, and metric labels. This
    * field may not exceed 2048 Unicode characters
    * in length.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#filter GoogleMonitoringAlertPolicy#filter}
    */
    readonly filter?: string;
    /**
    * A value against which to compare the time
    * series.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#threshold_value GoogleMonitoringAlertPolicy#threshold_value}
    */
    readonly thresholdValue?: number;
    /**
    * aggregations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#aggregations GoogleMonitoringAlertPolicy#aggregations}
    */
    readonly aggregations?: GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable;
    /**
    * denominator_aggregations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#denominator_aggregations GoogleMonitoringAlertPolicy#denominator_aggregations}
    */
    readonly denominatorAggregations?: GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable;
    /**
    * forecast_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#forecast_options GoogleMonitoringAlertPolicy#forecast_options}
    */
    readonly forecastOptions?: GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#trigger GoogleMonitoringAlertPolicy#trigger}
    */
    readonly trigger?: GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger;
}
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdToTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdOutputReference | GoogleMonitoringAlertPolicyConditionsConditionThreshold): any;
export declare function googleMonitoringAlertPolicyConditionsConditionThresholdToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditionsConditionThresholdOutputReference | GoogleMonitoringAlertPolicyConditionsConditionThreshold): any;
export declare class GoogleMonitoringAlertPolicyConditionsConditionThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyConditionsConditionThreshold | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditionsConditionThreshold | undefined);
    private _comparison?;
    get comparison(): string;
    set comparison(value: string);
    get comparisonInput(): string | undefined;
    private _denominatorFilter?;
    get denominatorFilter(): string;
    set denominatorFilter(value: string);
    resetDenominatorFilter(): void;
    get denominatorFilterInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _evaluationMissingData?;
    get evaluationMissingData(): string;
    set evaluationMissingData(value: string);
    resetEvaluationMissingData(): void;
    get evaluationMissingDataInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _thresholdValue?;
    get thresholdValue(): number;
    set thresholdValue(value: number);
    resetThresholdValue(): void;
    get thresholdValueInput(): number | undefined;
    private _aggregations;
    get aggregations(): GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregationsList;
    putAggregations(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable): void;
    resetAggregations(): void;
    get aggregationsInput(): cdktf.IResolvable | GoogleMonitoringAlertPolicyConditionsConditionThresholdAggregations[] | undefined;
    private _denominatorAggregations;
    get denominatorAggregations(): GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsList;
    putDenominatorAggregations(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable): void;
    resetDenominatorAggregations(): void;
    get denominatorAggregationsInput(): cdktf.IResolvable | GoogleMonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | undefined;
    private _forecastOptions;
    get forecastOptions(): GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptionsOutputReference;
    putForecastOptions(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions): void;
    resetForecastOptions(): void;
    get forecastOptionsInput(): GoogleMonitoringAlertPolicyConditionsConditionThresholdForecastOptions | undefined;
    private _trigger;
    get trigger(): GoogleMonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference;
    putTrigger(value: GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger): void;
    resetTrigger(): void;
    get triggerInput(): GoogleMonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined;
}
export interface GoogleMonitoringAlertPolicyConditions {
    /**
    * A short name or phrase used to identify the
    * condition in dashboards, notifications, and
    * incidents. To avoid confusion, don't use the same
    * display name for multiple conditions in the same
    * policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#display_name GoogleMonitoringAlertPolicy#display_name}
    */
    readonly displayName: string;
    /**
    * condition_absent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#condition_absent GoogleMonitoringAlertPolicy#condition_absent}
    */
    readonly conditionAbsent?: GoogleMonitoringAlertPolicyConditionsConditionAbsent;
    /**
    * condition_matched_log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#condition_matched_log GoogleMonitoringAlertPolicy#condition_matched_log}
    */
    readonly conditionMatchedLog?: GoogleMonitoringAlertPolicyConditionsConditionMatchedLog;
    /**
    * condition_monitoring_query_language block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#condition_monitoring_query_language GoogleMonitoringAlertPolicy#condition_monitoring_query_language}
    */
    readonly conditionMonitoringQueryLanguage?: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage;
    /**
    * condition_prometheus_query_language block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#condition_prometheus_query_language GoogleMonitoringAlertPolicy#condition_prometheus_query_language}
    */
    readonly conditionPrometheusQueryLanguage?: GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage;
    /**
    * condition_threshold block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#condition_threshold GoogleMonitoringAlertPolicy#condition_threshold}
    */
    readonly conditionThreshold?: GoogleMonitoringAlertPolicyConditionsConditionThreshold;
}
export declare function googleMonitoringAlertPolicyConditionsToTerraform(struct?: GoogleMonitoringAlertPolicyConditions | cdktf.IResolvable): any;
export declare function googleMonitoringAlertPolicyConditionsToHclTerraform(struct?: GoogleMonitoringAlertPolicyConditions | cdktf.IResolvable): any;
export declare class GoogleMonitoringAlertPolicyConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringAlertPolicyConditions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyConditions | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get name(): string;
    private _conditionAbsent;
    get conditionAbsent(): GoogleMonitoringAlertPolicyConditionsConditionAbsentOutputReference;
    putConditionAbsent(value: GoogleMonitoringAlertPolicyConditionsConditionAbsent): void;
    resetConditionAbsent(): void;
    get conditionAbsentInput(): GoogleMonitoringAlertPolicyConditionsConditionAbsent | undefined;
    private _conditionMatchedLog;
    get conditionMatchedLog(): GoogleMonitoringAlertPolicyConditionsConditionMatchedLogOutputReference;
    putConditionMatchedLog(value: GoogleMonitoringAlertPolicyConditionsConditionMatchedLog): void;
    resetConditionMatchedLog(): void;
    get conditionMatchedLogInput(): GoogleMonitoringAlertPolicyConditionsConditionMatchedLog | undefined;
    private _conditionMonitoringQueryLanguage;
    get conditionMonitoringQueryLanguage(): GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference;
    putConditionMonitoringQueryLanguage(value: GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage): void;
    resetConditionMonitoringQueryLanguage(): void;
    get conditionMonitoringQueryLanguageInput(): GoogleMonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined;
    private _conditionPrometheusQueryLanguage;
    get conditionPrometheusQueryLanguage(): GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguageOutputReference;
    putConditionPrometheusQueryLanguage(value: GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage): void;
    resetConditionPrometheusQueryLanguage(): void;
    get conditionPrometheusQueryLanguageInput(): GoogleMonitoringAlertPolicyConditionsConditionPrometheusQueryLanguage | undefined;
    private _conditionThreshold;
    get conditionThreshold(): GoogleMonitoringAlertPolicyConditionsConditionThresholdOutputReference;
    putConditionThreshold(value: GoogleMonitoringAlertPolicyConditionsConditionThreshold): void;
    resetConditionThreshold(): void;
    get conditionThresholdInput(): GoogleMonitoringAlertPolicyConditionsConditionThreshold | undefined;
}
export declare class GoogleMonitoringAlertPolicyConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringAlertPolicyConditions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringAlertPolicyConditionsOutputReference;
}
export interface GoogleMonitoringAlertPolicyDocumentation {
    /**
    * The text of the documentation, interpreted according to mimeType.
    * The content may not exceed 8,192 Unicode characters and may not
    * exceed more than 10,240 bytes when encoded in UTF-8 format,
    * whichever is smaller.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#content GoogleMonitoringAlertPolicy#content}
    */
    readonly content?: string;
    /**
    * The format of the content field. Presently, only the value
    * "text/markdown" is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#mime_type GoogleMonitoringAlertPolicy#mime_type}
    */
    readonly mimeType?: string;
    /**
    * The subject line of the notification. The subject line may not
    * exceed 10,240 bytes. In notifications generated by this policy the contents
    * of the subject line after variable expansion will be truncated to 255 bytes
    * or shorter at the latest UTF-8 character boundary.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#subject GoogleMonitoringAlertPolicy#subject}
    */
    readonly subject?: string;
}
export declare function googleMonitoringAlertPolicyDocumentationToTerraform(struct?: GoogleMonitoringAlertPolicyDocumentationOutputReference | GoogleMonitoringAlertPolicyDocumentation): any;
export declare function googleMonitoringAlertPolicyDocumentationToHclTerraform(struct?: GoogleMonitoringAlertPolicyDocumentationOutputReference | GoogleMonitoringAlertPolicyDocumentation): any;
export declare class GoogleMonitoringAlertPolicyDocumentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyDocumentation | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyDocumentation | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _mimeType?;
    get mimeType(): string;
    set mimeType(value: string);
    resetMimeType(): void;
    get mimeTypeInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
}
export interface GoogleMonitoringAlertPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#create GoogleMonitoringAlertPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#delete GoogleMonitoringAlertPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#update GoogleMonitoringAlertPolicy#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringAlertPolicyTimeoutsToTerraform(struct?: GoogleMonitoringAlertPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleMonitoringAlertPolicyTimeoutsToHclTerraform(struct?: GoogleMonitoringAlertPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringAlertPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringAlertPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringAlertPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy google_monitoring_alert_policy}
*/
export declare class GoogleMonitoringAlertPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_alert_policy";
    /**
    * Generates CDKTF code for importing a GoogleMonitoringAlertPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleMonitoringAlertPolicy to import
    * @param importFromId The id of the existing GoogleMonitoringAlertPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleMonitoringAlertPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_alert_policy google_monitoring_alert_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringAlertPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringAlertPolicyConfig);
    private _combiner?;
    get combiner(): string;
    set combiner(value: string);
    get combinerInput(): string | undefined;
    private _creationRecord;
    get creationRecord(): GoogleMonitoringAlertPolicyCreationRecordList;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _notificationChannels?;
    get notificationChannels(): string[];
    set notificationChannels(value: string[]);
    resetNotificationChannels(): void;
    get notificationChannelsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    resetSeverity(): void;
    get severityInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _alertStrategy;
    get alertStrategy(): GoogleMonitoringAlertPolicyAlertStrategyOutputReference;
    putAlertStrategy(value: GoogleMonitoringAlertPolicyAlertStrategy): void;
    resetAlertStrategy(): void;
    get alertStrategyInput(): GoogleMonitoringAlertPolicyAlertStrategy | undefined;
    private _conditions;
    get conditions(): GoogleMonitoringAlertPolicyConditionsList;
    putConditions(value: GoogleMonitoringAlertPolicyConditions[] | cdktf.IResolvable): void;
    get conditionsInput(): cdktf.IResolvable | GoogleMonitoringAlertPolicyConditions[] | undefined;
    private _documentation;
    get documentation(): GoogleMonitoringAlertPolicyDocumentationOutputReference;
    putDocumentation(value: GoogleMonitoringAlertPolicyDocumentation): void;
    resetDocumentation(): void;
    get documentationInput(): GoogleMonitoringAlertPolicyDocumentation | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringAlertPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringAlertPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringAlertPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
