/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringCustomServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name used for UI elements listing this Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#display_name GoogleMonitoringCustomService#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#id GoogleMonitoringCustomService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#project GoogleMonitoringCustomService#project}
    */
    readonly project?: string;
    /**
    * An optional service ID to use. If not given, the server will generate a
    * service ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#service_id GoogleMonitoringCustomService#service_id}
    */
    readonly serviceId?: string;
    /**
    * Labels which have been used to annotate the service. Label keys must start
    * with a letter. Label keys and values may contain lowercase letters,
    * numbers, underscores, and dashes. Label keys and values have a maximum
    * length of 63 characters, and must be less than 128 bytes in size. Up to 64
    * label entries may be stored. For labels which do not have a semantic value,
    * the empty string may be supplied for the label value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#user_labels GoogleMonitoringCustomService#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * telemetry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#telemetry GoogleMonitoringCustomService#telemetry}
    */
    readonly telemetry?: GoogleMonitoringCustomServiceTelemetry;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#timeouts GoogleMonitoringCustomService#timeouts}
    */
    readonly timeouts?: GoogleMonitoringCustomServiceTimeouts;
}
export interface GoogleMonitoringCustomServiceTelemetry {
    /**
    * The full name of the resource that defines this service.
    * Formatted as described in
    * https://cloud.google.com/apis/design/resource_names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#resource_name GoogleMonitoringCustomService#resource_name}
    */
    readonly resourceName?: string;
}
export declare function googleMonitoringCustomServiceTelemetryToTerraform(struct?: GoogleMonitoringCustomServiceTelemetryOutputReference | GoogleMonitoringCustomServiceTelemetry): any;
export declare function googleMonitoringCustomServiceTelemetryToHclTerraform(struct?: GoogleMonitoringCustomServiceTelemetryOutputReference | GoogleMonitoringCustomServiceTelemetry): any;
export declare class GoogleMonitoringCustomServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringCustomServiceTelemetry | undefined;
    set internalValue(value: GoogleMonitoringCustomServiceTelemetry | undefined);
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
}
export interface GoogleMonitoringCustomServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#create GoogleMonitoringCustomService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#delete GoogleMonitoringCustomService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#update GoogleMonitoringCustomService#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringCustomServiceTimeoutsToTerraform(struct?: GoogleMonitoringCustomServiceTimeouts | cdktf.IResolvable): any;
export declare function googleMonitoringCustomServiceTimeoutsToHclTerraform(struct?: GoogleMonitoringCustomServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringCustomServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringCustomServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringCustomServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service google_monitoring_custom_service}
*/
export declare class GoogleMonitoringCustomService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_custom_service";
    /**
    * Generates CDKTF code for importing a GoogleMonitoringCustomService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleMonitoringCustomService to import
    * @param importFromId The id of the existing GoogleMonitoringCustomService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleMonitoringCustomService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_custom_service google_monitoring_custom_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringCustomServiceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleMonitoringCustomServiceConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    resetServiceId(): void;
    get serviceIdInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _telemetry;
    get telemetry(): GoogleMonitoringCustomServiceTelemetryOutputReference;
    putTelemetry(value: GoogleMonitoringCustomServiceTelemetry): void;
    resetTelemetry(): void;
    get telemetryInput(): GoogleMonitoringCustomServiceTelemetry | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringCustomServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringCustomServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringCustomServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
