/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * A user-assigned name for this group, used only for display
    * purposes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#display_name GoogleMonitoringGroup#display_name}
    */
    readonly displayName: string;
    /**
    * The filter used to determine which monitored resources
    * belong to this group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#filter GoogleMonitoringGroup#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#id GoogleMonitoringGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If true, the members of this group are considered to be a
    * cluster. The system can perform additional analysis on
    * groups that are clusters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#is_cluster GoogleMonitoringGroup#is_cluster}
    */
    readonly isCluster?: boolean | cdktf.IResolvable;
    /**
    * The name of the group's parent, if it has one. The format is
    * "projects/{project_id_or_number}/groups/{group_id}". For
    * groups with no parent, parentName is the empty string, "".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#parent_name GoogleMonitoringGroup#parent_name}
    */
    readonly parentName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#project GoogleMonitoringGroup#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#timeouts GoogleMonitoringGroup#timeouts}
    */
    readonly timeouts?: GoogleMonitoringGroupTimeouts;
}
export interface GoogleMonitoringGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#create GoogleMonitoringGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#delete GoogleMonitoringGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#update GoogleMonitoringGroup#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringGroupTimeoutsToTerraform(struct?: GoogleMonitoringGroupTimeouts | cdktf.IResolvable): any;
export declare function googleMonitoringGroupTimeoutsToHclTerraform(struct?: GoogleMonitoringGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group google_monitoring_group}
*/
export declare class GoogleMonitoringGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_group";
    /**
    * Generates CDKTF code for importing a GoogleMonitoringGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleMonitoringGroup to import
    * @param importFromId The id of the existing GoogleMonitoringGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleMonitoringGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_group google_monitoring_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringGroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringGroupConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isCluster?;
    get isCluster(): boolean | cdktf.IResolvable;
    set isCluster(value: boolean | cdktf.IResolvable);
    resetIsCluster(): void;
    get isClusterInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _parentName?;
    get parentName(): string;
    set parentName(value: string);
    resetParentName(): void;
    get parentNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
