/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringMetricDescriptorConfig extends cdktf.TerraformMetaArguments {
    /**
    * A detailed description of the metric, which can be used in documentation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#description GoogleMonitoringMetricDescriptor#description}
    */
    readonly description: string;
    /**
    * A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#display_name GoogleMonitoringMetricDescriptor#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#id GoogleMonitoringMetricDescriptor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The launch stage of the metric definition. Possible values: ["LAUNCH_STAGE_UNSPECIFIED", "UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#launch_stage GoogleMonitoringMetricDescriptor#launch_stage}
    */
    readonly launchStage?: string;
    /**
    * Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported. Possible values: ["METRIC_KIND_UNSPECIFIED", "GAUGE", "DELTA", "CUMULATIVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#metric_kind GoogleMonitoringMetricDescriptor#metric_kind}
    */
    readonly metricKind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#project GoogleMonitoringMetricDescriptor#project}
    */
    readonly project?: string;
    /**
    * The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#type GoogleMonitoringMetricDescriptor#type}
    */
    readonly type: string;
    /**
    * The units in which the metric value is reported. It is only applicable if the
    * valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
    * the stored metric values.
    *
    * Different systems may scale the values to be more easily displayed (so a value of
    * 0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
    * 3.5MBy). However, if the unit is KBy, then the value of the metric is always in
    * thousands of bytes, no matter how it may be displayed.
    *
    * If you want a custom metric to record the exact number of CPU-seconds used by a job,
    * you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
    * 1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
    * 12005.
    *
    * Alternatively, if you want a custom metric to record data in a more granular way, you
    * can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
    * 12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
    * The supported units are a subset of The Unified Code for Units of Measure standard.
    * More info can be found in the API documentation
    * (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#unit GoogleMonitoringMetricDescriptor#unit}
    */
    readonly unit?: string;
    /**
    * Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#value_type GoogleMonitoringMetricDescriptor#value_type}
    */
    readonly valueType: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#labels GoogleMonitoringMetricDescriptor#labels}
    */
    readonly labels?: GoogleMonitoringMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#metadata GoogleMonitoringMetricDescriptor#metadata}
    */
    readonly metadata?: GoogleMonitoringMetricDescriptorMetadata;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#timeouts GoogleMonitoringMetricDescriptor#timeouts}
    */
    readonly timeouts?: GoogleMonitoringMetricDescriptorTimeouts;
}
export interface GoogleMonitoringMetricDescriptorLabels {
    /**
    * A human-readable description for the label.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#description GoogleMonitoringMetricDescriptor#description}
    */
    readonly description?: string;
    /**
    * The key for this label. The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#key GoogleMonitoringMetricDescriptor#key}
    */
    readonly key: string;
    /**
    * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["STRING", "BOOL", "INT64"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#value_type GoogleMonitoringMetricDescriptor#value_type}
    */
    readonly valueType?: string;
}
export declare function googleMonitoringMetricDescriptorLabelsToTerraform(struct?: GoogleMonitoringMetricDescriptorLabels | cdktf.IResolvable): any;
export declare function googleMonitoringMetricDescriptorLabelsToHclTerraform(struct?: GoogleMonitoringMetricDescriptorLabels | cdktf.IResolvable): any;
export declare class GoogleMonitoringMetricDescriptorLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringMetricDescriptorLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringMetricDescriptorLabels | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
}
export declare class GoogleMonitoringMetricDescriptorLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringMetricDescriptorLabelsOutputReference;
}
export interface GoogleMonitoringMetricDescriptorMetadata {
    /**
    * The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In '[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#ingest_delay GoogleMonitoringMetricDescriptor#ingest_delay}
    */
    readonly ingestDelay?: string;
    /**
    * The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In '[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#sample_period GoogleMonitoringMetricDescriptor#sample_period}
    */
    readonly samplePeriod?: string;
}
export declare function googleMonitoringMetricDescriptorMetadataToTerraform(struct?: GoogleMonitoringMetricDescriptorMetadataOutputReference | GoogleMonitoringMetricDescriptorMetadata): any;
export declare function googleMonitoringMetricDescriptorMetadataToHclTerraform(struct?: GoogleMonitoringMetricDescriptorMetadataOutputReference | GoogleMonitoringMetricDescriptorMetadata): any;
export declare class GoogleMonitoringMetricDescriptorMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringMetricDescriptorMetadata | undefined;
    set internalValue(value: GoogleMonitoringMetricDescriptorMetadata | undefined);
    private _ingestDelay?;
    get ingestDelay(): string;
    set ingestDelay(value: string);
    resetIngestDelay(): void;
    get ingestDelayInput(): string | undefined;
    private _samplePeriod?;
    get samplePeriod(): string;
    set samplePeriod(value: string);
    resetSamplePeriod(): void;
    get samplePeriodInput(): string | undefined;
}
export interface GoogleMonitoringMetricDescriptorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#create GoogleMonitoringMetricDescriptor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#delete GoogleMonitoringMetricDescriptor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#update GoogleMonitoringMetricDescriptor#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringMetricDescriptorTimeoutsToTerraform(struct?: GoogleMonitoringMetricDescriptorTimeouts | cdktf.IResolvable): any;
export declare function googleMonitoringMetricDescriptorTimeoutsToHclTerraform(struct?: GoogleMonitoringMetricDescriptorTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringMetricDescriptorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringMetricDescriptorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringMetricDescriptorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor google_monitoring_metric_descriptor}
*/
export declare class GoogleMonitoringMetricDescriptor extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_metric_descriptor";
    /**
    * Generates CDKTF code for importing a GoogleMonitoringMetricDescriptor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleMonitoringMetricDescriptor to import
    * @param importFromId The id of the existing GoogleMonitoringMetricDescriptor that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleMonitoringMetricDescriptor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_monitoring_metric_descriptor google_monitoring_metric_descriptor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringMetricDescriptorConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringMetricDescriptorConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _launchStage?;
    get launchStage(): string;
    set launchStage(value: string);
    resetLaunchStage(): void;
    get launchStageInput(): string | undefined;
    private _metricKind?;
    get metricKind(): string;
    set metricKind(value: string);
    get metricKindInput(): string | undefined;
    get monitoredResourceTypes(): string[];
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    get valueTypeInput(): string | undefined;
    private _labels;
    get labels(): GoogleMonitoringMetricDescriptorLabelsList;
    putLabels(value: GoogleMonitoringMetricDescriptorLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | GoogleMonitoringMetricDescriptorLabels[] | undefined;
    private _metadata;
    get metadata(): GoogleMonitoringMetricDescriptorMetadataOutputReference;
    putMetadata(value: GoogleMonitoringMetricDescriptorMetadata): void;
    resetMetadata(): void;
    get metadataInput(): GoogleMonitoringMetricDescriptorMetadata | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringMetricDescriptorTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringMetricDescriptorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringMetricDescriptorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
