/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetappActiveDirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enables AES-128 and AES-256 encryption for Kerberos-based communication with Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#aes_encryption GoogleNetappActiveDirectory#aes_encryption}
    */
    readonly aesEncryption?: boolean | cdktf.IResolvable;
    /**
    * Domain user/group accounts to be added to the Backup Operators group of the SMB service. The Backup Operators group allows members to backup and restore files regardless of whether they have read or write access to the files. Comma-separated list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#backup_operators GoogleNetappActiveDirectory#backup_operators}
    */
    readonly backupOperators?: string[];
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#description GoogleNetappActiveDirectory#description}
    */
    readonly description?: string;
    /**
    * Comma separated list of DNS server IP addresses for the Active Directory domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#dns GoogleNetappActiveDirectory#dns}
    */
    readonly dns: string;
    /**
    * Fully qualified domain name for the Active Directory domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#domain GoogleNetappActiveDirectory#domain}
    */
    readonly domain: string;
    /**
    * If enabled, traffic between the SMB server to Domain Controller (DC) will be encrypted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#encrypt_dc_connections GoogleNetappActiveDirectory#encrypt_dc_connections}
    */
    readonly encryptDcConnections?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#id GoogleNetappActiveDirectory#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Hostname of the Active Directory server used as Kerberos Key Distribution Center. Only requried for volumes using kerberized NFSv4.1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#kdc_hostname GoogleNetappActiveDirectory#kdc_hostname}
    */
    readonly kdcHostname?: string;
    /**
    * IP address of the Active Directory server used as Kerberos Key Distribution Center.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#kdc_ip GoogleNetappActiveDirectory#kdc_ip}
    */
    readonly kdcIp?: string;
    /**
    * Labels as key value pairs. Example: '{ "owner": "Bob", "department": "finance", "purpose": "testing" }'.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#labels GoogleNetappActiveDirectory#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies whether or not the LDAP traffic needs to be signed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#ldap_signing GoogleNetappActiveDirectory#ldap_signing}
    */
    readonly ldapSigning?: boolean | cdktf.IResolvable;
    /**
    * Name of the region for the policy to apply to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#location GoogleNetappActiveDirectory#location}
    */
    readonly location: string;
    /**
    * The resource name of the Active Directory pool. Needs to be unique per location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#name GoogleNetappActiveDirectory#name}
    */
    readonly name: string;
    /**
    * NetBIOS name prefix of the server to be created.
    * A five-character random ID is generated automatically, for example, -6f9a, and appended to the prefix. The full UNC share path will have the following format:
    * '\\NetBIOS_PREFIX-ABCD.DOMAIN_NAME\SHARE_NAME'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#net_bios_prefix GoogleNetappActiveDirectory#net_bios_prefix}
    */
    readonly netBiosPrefix: string;
    /**
    * Local UNIX users on clients without valid user information in Active Directory are blocked from access to LDAP enabled volumes.
    * This option can be used to temporarily switch such volumes to AUTH_SYS authentication (user ID + 1-16 groups).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#nfs_users_with_ldap GoogleNetappActiveDirectory#nfs_users_with_ldap}
    */
    readonly nfsUsersWithLdap?: boolean | cdktf.IResolvable;
    /**
    * Name of the Organizational Unit where you intend to create the computer account for NetApp Volumes.
    * Defaults to 'CN=Computers' if left empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#organizational_unit GoogleNetappActiveDirectory#organizational_unit}
    */
    readonly organizationalUnit?: string;
    /**
    * Password for specified username. Note - Manual changes done to the password will not be detected. Terraform will not re-apply the password, unless you use a new password in Terraform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#password GoogleNetappActiveDirectory#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#project GoogleNetappActiveDirectory#project}
    */
    readonly project?: string;
    /**
    * Domain accounts that require elevated privileges such as 'SeSecurityPrivilege' to manage security logs. Comma-separated list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#security_operators GoogleNetappActiveDirectory#security_operators}
    */
    readonly securityOperators?: string[];
    /**
    * Specifies an Active Directory site to manage domain controller selection.
    * Use when Active Directory domain controllers in multiple regions are configured. Defaults to 'Default-First-Site-Name' if left empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#site GoogleNetappActiveDirectory#site}
    */
    readonly site?: string;
    /**
    * Username for the Active Directory account with permissions to create the compute account within the specified organizational unit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#username GoogleNetappActiveDirectory#username}
    */
    readonly username: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#timeouts GoogleNetappActiveDirectory#timeouts}
    */
    readonly timeouts?: GoogleNetappActiveDirectoryTimeouts;
}
export interface GoogleNetappActiveDirectoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#create GoogleNetappActiveDirectory#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#delete GoogleNetappActiveDirectory#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#update GoogleNetappActiveDirectory#update}
    */
    readonly update?: string;
}
export declare function googleNetappActiveDirectoryTimeoutsToTerraform(struct?: GoogleNetappActiveDirectoryTimeouts | cdktf.IResolvable): any;
export declare function googleNetappActiveDirectoryTimeoutsToHclTerraform(struct?: GoogleNetappActiveDirectoryTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetappActiveDirectoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappActiveDirectoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetappActiveDirectoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory google_netapp_active_directory}
*/
export declare class GoogleNetappActiveDirectory extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_netapp_active_directory";
    /**
    * Generates CDKTF code for importing a GoogleNetappActiveDirectory resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetappActiveDirectory to import
    * @param importFromId The id of the existing GoogleNetappActiveDirectory that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetappActiveDirectory to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_active_directory google_netapp_active_directory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetappActiveDirectoryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetappActiveDirectoryConfig);
    private _aesEncryption?;
    get aesEncryption(): boolean | cdktf.IResolvable;
    set aesEncryption(value: boolean | cdktf.IResolvable);
    resetAesEncryption(): void;
    get aesEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _backupOperators?;
    get backupOperators(): string[];
    set backupOperators(value: string[]);
    resetBackupOperators(): void;
    get backupOperatorsInput(): string[] | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dns?;
    get dns(): string;
    set dns(value: string);
    get dnsInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _encryptDcConnections?;
    get encryptDcConnections(): boolean | cdktf.IResolvable;
    set encryptDcConnections(value: boolean | cdktf.IResolvable);
    resetEncryptDcConnections(): void;
    get encryptDcConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kdcHostname?;
    get kdcHostname(): string;
    set kdcHostname(value: string);
    resetKdcHostname(): void;
    get kdcHostnameInput(): string | undefined;
    private _kdcIp?;
    get kdcIp(): string;
    set kdcIp(value: string);
    resetKdcIp(): void;
    get kdcIpInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _ldapSigning?;
    get ldapSigning(): boolean | cdktf.IResolvable;
    set ldapSigning(value: boolean | cdktf.IResolvable);
    resetLdapSigning(): void;
    get ldapSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _netBiosPrefix?;
    get netBiosPrefix(): string;
    set netBiosPrefix(value: string);
    get netBiosPrefixInput(): string | undefined;
    private _nfsUsersWithLdap?;
    get nfsUsersWithLdap(): boolean | cdktf.IResolvable;
    set nfsUsersWithLdap(value: boolean | cdktf.IResolvable);
    resetNfsUsersWithLdap(): void;
    get nfsUsersWithLdapInput(): boolean | cdktf.IResolvable | undefined;
    private _organizationalUnit?;
    get organizationalUnit(): string;
    set organizationalUnit(value: string);
    resetOrganizationalUnit(): void;
    get organizationalUnitInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _securityOperators?;
    get securityOperators(): string[];
    set securityOperators(value: string[]);
    resetSecurityOperators(): void;
    get securityOperatorsInput(): string[] | undefined;
    private _site?;
    get site(): string;
    set site(value: string);
    resetSite(): void;
    get siteInput(): string | undefined;
    get state(): string;
    get stateDetails(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleNetappActiveDirectoryTimeoutsOutputReference;
    putTimeouts(value: GoogleNetappActiveDirectoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetappActiveDirectoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
