/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetappBackupPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Number of daily backups to keep. Note that the minimum daily backup limit is 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#daily_backup_limit GoogleNetappBackupPolicy#daily_backup_limit}
    */
    readonly dailyBackupLimit: number;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#description GoogleNetappBackupPolicy#description}
    */
    readonly description?: string;
    /**
    * If enabled, make backups automatically according to the schedules.
    * This will be applied to all volumes that have this policy attached and enforced on volume level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#enabled GoogleNetappBackupPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#id GoogleNetappBackupPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels as key value pairs. Example: '{ "owner": "Bob", "department": "finance", "purpose": "testing" }'.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#labels GoogleNetappBackupPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the region for the policy to apply to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#location GoogleNetappBackupPolicy#location}
    */
    readonly location: string;
    /**
    * Number of monthly backups to keep. Note that the sum of daily, weekly and monthly backups should be greater than 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#monthly_backup_limit GoogleNetappBackupPolicy#monthly_backup_limit}
    */
    readonly monthlyBackupLimit: number;
    /**
    * The name of the backup policy. Needs to be unique per location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#name GoogleNetappBackupPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#project GoogleNetappBackupPolicy#project}
    */
    readonly project?: string;
    /**
    * Number of weekly backups to keep. Note that the sum of daily, weekly and monthly backups should be greater than 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#weekly_backup_limit GoogleNetappBackupPolicy#weekly_backup_limit}
    */
    readonly weeklyBackupLimit: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#timeouts GoogleNetappBackupPolicy#timeouts}
    */
    readonly timeouts?: GoogleNetappBackupPolicyTimeouts;
}
export interface GoogleNetappBackupPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#create GoogleNetappBackupPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#delete GoogleNetappBackupPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#update GoogleNetappBackupPolicy#update}
    */
    readonly update?: string;
}
export declare function googleNetappBackupPolicyTimeoutsToTerraform(struct?: GoogleNetappBackupPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleNetappBackupPolicyTimeoutsToHclTerraform(struct?: GoogleNetappBackupPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetappBackupPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappBackupPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetappBackupPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy google_netapp_backup_policy}
*/
export declare class GoogleNetappBackupPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_netapp_backup_policy";
    /**
    * Generates CDKTF code for importing a GoogleNetappBackupPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetappBackupPolicy to import
    * @param importFromId The id of the existing GoogleNetappBackupPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetappBackupPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_backup_policy google_netapp_backup_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetappBackupPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetappBackupPolicyConfig);
    get assignedVolumeCount(): number;
    get createTime(): string;
    private _dailyBackupLimit?;
    get dailyBackupLimit(): number;
    set dailyBackupLimit(value: number);
    get dailyBackupLimitInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _monthlyBackupLimit?;
    get monthlyBackupLimit(): number;
    set monthlyBackupLimit(value: number);
    get monthlyBackupLimitInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _weeklyBackupLimit?;
    get weeklyBackupLimit(): number;
    set weeklyBackupLimit(value: number);
    get weeklyBackupLimitInput(): number | undefined;
    private _timeouts;
    get timeouts(): GoogleNetappBackupPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleNetappBackupPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetappBackupPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
