/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetappStoragePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the Active Directory policy to be used. Format: 'projects/{{project}}/locations/{{location}}/activeDirectories/{{name}}'.
    * The policy needs to be in the same location as the storage pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#active_directory GoogleNetappStoragePool#active_directory}
    */
    readonly activeDirectory?: string;
    /**
    * Capacity of the storage pool (in GiB).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#capacity_gib GoogleNetappStoragePool#capacity_gib}
    */
    readonly capacityGib: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#description GoogleNetappStoragePool#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#id GoogleNetappStoragePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the CMEK policy to be used for volume encryption. Format: 'projects/{{project}}/locations/{{location}}/kmsConfigs/{{name}}'.
    * The policy needs to be in the same location as the storage pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#kms_config GoogleNetappStoragePool#kms_config}
    */
    readonly kmsConfig?: string;
    /**
    * Labels as key value pairs. Example: '{ "owner": "Bob", "department": "finance", "purpose": "testing" }'.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#labels GoogleNetappStoragePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * When enabled, the volumes uses Active Directory as LDAP name service for UID/GID lookups. Required to enable extended group support for NFSv3,
    * using security identifiers for NFSv4.1 or principal names for kerberized NFSv4.1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#ldap_enabled GoogleNetappStoragePool#ldap_enabled}
    */
    readonly ldapEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#location GoogleNetappStoragePool#location}
    */
    readonly location: string;
    /**
    * The resource name of the storage pool. Needs to be unique per location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#name GoogleNetappStoragePool#name}
    */
    readonly name: string;
    /**
    * VPC network name with format: 'projects/{{project}}/global/networks/{{network}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#network GoogleNetappStoragePool#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#project GoogleNetappStoragePool#project}
    */
    readonly project?: string;
    /**
    * Service level of the storage pool. Possible values: ["PREMIUM", "EXTREME", "STANDARD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#service_level GoogleNetappStoragePool#service_level}
    */
    readonly serviceLevel: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#timeouts GoogleNetappStoragePool#timeouts}
    */
    readonly timeouts?: GoogleNetappStoragePoolTimeouts;
}
export interface GoogleNetappStoragePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#create GoogleNetappStoragePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#delete GoogleNetappStoragePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#update GoogleNetappStoragePool#update}
    */
    readonly update?: string;
}
export declare function googleNetappStoragePoolTimeoutsToTerraform(struct?: GoogleNetappStoragePoolTimeouts | cdktf.IResolvable): any;
export declare function googleNetappStoragePoolTimeoutsToHclTerraform(struct?: GoogleNetappStoragePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetappStoragePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappStoragePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetappStoragePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool google_netapp_storage_pool}
*/
export declare class GoogleNetappStoragePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_netapp_storage_pool";
    /**
    * Generates CDKTF code for importing a GoogleNetappStoragePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetappStoragePool to import
    * @param importFromId The id of the existing GoogleNetappStoragePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetappStoragePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_storage_pool google_netapp_storage_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetappStoragePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetappStoragePoolConfig);
    private _activeDirectory?;
    get activeDirectory(): string;
    set activeDirectory(value: string);
    resetActiveDirectory(): void;
    get activeDirectoryInput(): string | undefined;
    private _capacityGib?;
    get capacityGib(): string;
    set capacityGib(value: string);
    get capacityGibInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get encryptionType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsConfig?;
    get kmsConfig(): string;
    set kmsConfig(value: string);
    resetKmsConfig(): void;
    get kmsConfigInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _ldapEnabled?;
    get ldapEnabled(): boolean | cdktf.IResolvable;
    set ldapEnabled(value: boolean | cdktf.IResolvable);
    resetLdapEnabled(): void;
    get ldapEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceLevel?;
    get serviceLevel(): string;
    set serviceLevel(value: string);
    get serviceLevelInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get volumeCapacityGib(): string;
    get volumeCount(): number;
    private _timeouts;
    get timeouts(): GoogleNetappStoragePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleNetappStoragePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetappStoragePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
