/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetappVolumeReplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * A destination volume is created as part of replication creation. The destination volume will not became
    * under Terraform management unless you import it manually. If you delete the replication, this volume
    * will remain.
    * Setting this parameter to true will delete the *current* destination volume when destroying the
    * replication. If you reversed the replication direction, this will be your former source volume!
    * For production use, it is recommended to keep this parameter false to avoid accidental volume
    * deletion. Handle with care. Default is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#delete_destination_volume GoogleNetappVolumeReplication#delete_destination_volume}
    */
    readonly deleteDestinationVolume?: boolean | cdktf.IResolvable;
    /**
    * An description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#description GoogleNetappVolumeReplication#description}
    */
    readonly description?: string;
    /**
    * Only replications with mirror_state=MIRRORED can be stopped. A replication in mirror_state=TRANSFERRING
    * currently receives an update and stopping the update might be undesirable. Set this parameter to true
    * to stop anyway. All data transferred to the destination will be discarded and content of destination
    * volume will remain at the state of the last successful update. Default is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#force_stopping GoogleNetappVolumeReplication#force_stopping}
    */
    readonly forceStopping?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#id GoogleNetappVolumeReplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels as key value pairs. Example: '{ "owner": "Bob", "department": "finance", "purpose": "testing" }'
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#labels GoogleNetappVolumeReplication#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of region for this resource. The resource needs to be created in the region of the destination volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#location GoogleNetappVolumeReplication#location}
    */
    readonly location: string;
    /**
    * The name of the replication. Needs to be unique per location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#name GoogleNetappVolumeReplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#project GoogleNetappVolumeReplication#project}
    */
    readonly project?: string;
    /**
    * Set to false to stop/break the mirror. Stopping the mirror makes the destination volume read-write
    * and act independently from the source volume.
    * Set to true to enable/resume the mirror. WARNING: Resuming a mirror overwrites any changes
    * done to the destination volume with the content of the source volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#replication_enabled GoogleNetappVolumeReplication#replication_enabled}
    */
    readonly replicationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the replication interval. Possible values: ["EVERY_10_MINUTES", "HOURLY", "DAILY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#replication_schedule GoogleNetappVolumeReplication#replication_schedule}
    */
    readonly replicationSchedule: string;
    /**
    * The name of the existing source volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#volume_name GoogleNetappVolumeReplication#volume_name}
    */
    readonly volumeName: string;
    /**
    * Replication resource state is independent of mirror_state. With enough data, it can take many hours
    * for mirror_state to reach MIRRORED. If you want Terraform to wait for the mirror to finish on
    * create/stop/resume operations, set this parameter to true. Default is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#wait_for_mirror GoogleNetappVolumeReplication#wait_for_mirror}
    */
    readonly waitForMirror?: boolean | cdktf.IResolvable;
    /**
    * destination_volume_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#destination_volume_parameters GoogleNetappVolumeReplication#destination_volume_parameters}
    */
    readonly destinationVolumeParameters?: GoogleNetappVolumeReplicationDestinationVolumeParameters;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#timeouts GoogleNetappVolumeReplication#timeouts}
    */
    readonly timeouts?: GoogleNetappVolumeReplicationTimeouts;
}
export interface GoogleNetappVolumeReplicationTransferStats {
}
export declare function googleNetappVolumeReplicationTransferStatsToTerraform(struct?: GoogleNetappVolumeReplicationTransferStats): any;
export declare function googleNetappVolumeReplicationTransferStatsToHclTerraform(struct?: GoogleNetappVolumeReplicationTransferStats): any;
export declare class GoogleNetappVolumeReplicationTransferStatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetappVolumeReplicationTransferStats | undefined;
    set internalValue(value: GoogleNetappVolumeReplicationTransferStats | undefined);
    get lagDuration(): string;
    get lastTransferBytes(): string;
    get lastTransferDuration(): string;
    get lastTransferEndTime(): string;
    get lastTransferError(): string;
    get totalTransferDuration(): string;
    get transferBytes(): string;
    get updateTime(): string;
}
export declare class GoogleNetappVolumeReplicationTransferStatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetappVolumeReplicationTransferStatsOutputReference;
}
export interface GoogleNetappVolumeReplicationDestinationVolumeParameters {
    /**
    * Description for the destination volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#description GoogleNetappVolumeReplication#description}
    */
    readonly description?: string;
    /**
    * Share name for destination volume. If not specified, name of source volume's share name will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#share_name GoogleNetappVolumeReplication#share_name}
    */
    readonly shareName?: string;
    /**
    * Name of an existing storage pool for the destination volume with format: 'projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#storage_pool GoogleNetappVolumeReplication#storage_pool}
    */
    readonly storagePool: string;
    /**
    * Name for the destination volume to be created. If not specified, the name of the source volume will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#volume_id GoogleNetappVolumeReplication#volume_id}
    */
    readonly volumeId?: string;
}
export declare function googleNetappVolumeReplicationDestinationVolumeParametersToTerraform(struct?: GoogleNetappVolumeReplicationDestinationVolumeParametersOutputReference | GoogleNetappVolumeReplicationDestinationVolumeParameters): any;
export declare function googleNetappVolumeReplicationDestinationVolumeParametersToHclTerraform(struct?: GoogleNetappVolumeReplicationDestinationVolumeParametersOutputReference | GoogleNetappVolumeReplicationDestinationVolumeParameters): any;
export declare class GoogleNetappVolumeReplicationDestinationVolumeParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeReplicationDestinationVolumeParameters | undefined;
    set internalValue(value: GoogleNetappVolumeReplicationDestinationVolumeParameters | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    resetShareName(): void;
    get shareNameInput(): string | undefined;
    private _storagePool?;
    get storagePool(): string;
    set storagePool(value: string);
    get storagePoolInput(): string | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    resetVolumeId(): void;
    get volumeIdInput(): string | undefined;
}
export interface GoogleNetappVolumeReplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#create GoogleNetappVolumeReplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#delete GoogleNetappVolumeReplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#update GoogleNetappVolumeReplication#update}
    */
    readonly update?: string;
}
export declare function googleNetappVolumeReplicationTimeoutsToTerraform(struct?: GoogleNetappVolumeReplicationTimeouts | cdktf.IResolvable): any;
export declare function googleNetappVolumeReplicationTimeoutsToHclTerraform(struct?: GoogleNetappVolumeReplicationTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetappVolumeReplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeReplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetappVolumeReplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication google_netapp_volume_replication}
*/
export declare class GoogleNetappVolumeReplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_netapp_volume_replication";
    /**
    * Generates CDKTF code for importing a GoogleNetappVolumeReplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetappVolumeReplication to import
    * @param importFromId The id of the existing GoogleNetappVolumeReplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetappVolumeReplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume_replication google_netapp_volume_replication} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetappVolumeReplicationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetappVolumeReplicationConfig);
    get createTime(): string;
    private _deleteDestinationVolume?;
    get deleteDestinationVolume(): boolean | cdktf.IResolvable;
    set deleteDestinationVolume(value: boolean | cdktf.IResolvable);
    resetDeleteDestinationVolume(): void;
    get deleteDestinationVolumeInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get destinationVolume(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _forceStopping?;
    get forceStopping(): boolean | cdktf.IResolvable;
    set forceStopping(value: boolean | cdktf.IResolvable);
    resetForceStopping(): void;
    get forceStoppingInput(): boolean | cdktf.IResolvable | undefined;
    get healthy(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get mirrorState(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _replicationEnabled?;
    get replicationEnabled(): boolean | cdktf.IResolvable;
    set replicationEnabled(value: boolean | cdktf.IResolvable);
    resetReplicationEnabled(): void;
    get replicationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _replicationSchedule?;
    get replicationSchedule(): string;
    set replicationSchedule(value: string);
    get replicationScheduleInput(): string | undefined;
    get role(): string;
    get sourceVolume(): string;
    get state(): string;
    get stateDetails(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _transferStats;
    get transferStats(): GoogleNetappVolumeReplicationTransferStatsList;
    private _volumeName?;
    get volumeName(): string;
    set volumeName(value: string);
    get volumeNameInput(): string | undefined;
    private _waitForMirror?;
    get waitForMirror(): boolean | cdktf.IResolvable;
    set waitForMirror(value: boolean | cdktf.IResolvable);
    resetWaitForMirror(): void;
    get waitForMirrorInput(): boolean | cdktf.IResolvable | undefined;
    private _destinationVolumeParameters;
    get destinationVolumeParameters(): GoogleNetappVolumeReplicationDestinationVolumeParametersOutputReference;
    putDestinationVolumeParameters(value: GoogleNetappVolumeReplicationDestinationVolumeParameters): void;
    resetDestinationVolumeParameters(): void;
    get destinationVolumeParametersInput(): GoogleNetappVolumeReplicationDestinationVolumeParameters | undefined;
    private _timeouts;
    get timeouts(): GoogleNetappVolumeReplicationTimeoutsOutputReference;
    putTimeouts(value: GoogleNetappVolumeReplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetappVolumeReplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
