/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetappVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Capacity of the volume (in GiB).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#capacity_gib GoogleNetappVolume#capacity_gib}
    */
    readonly capacityGib: string;
    /**
    * Policy to determine if the volume should be deleted forcefully.
    * Volumes may have nested snapshot resources. Deleting such a volume will fail.
    * Setting this parameter to FORCE will delete volumes including nested snapshots.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#deletion_policy GoogleNetappVolume#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#description GoogleNetappVolume#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#id GoogleNetappVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Flag indicating if the volume is a kerberos volume or not, export policy rules control kerberos security modes (krb5, krb5i, krb5p).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos_enabled GoogleNetappVolume#kerberos_enabled}
    */
    readonly kerberosEnabled?: boolean | cdktf.IResolvable;
    /**
    * Labels as key value pairs. Example: '{ "owner": "Bob", "department": "finance", "purpose": "testing" }'.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#labels GoogleNetappVolume#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the pool location. Usually a region name, expect for some STANDARD service level pools which require a zone name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#location GoogleNetappVolume#location}
    */
    readonly location: string;
    /**
    * The name of the volume. Needs to be unique per location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#name GoogleNetappVolume#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#project GoogleNetappVolume#project}
    */
    readonly project?: string;
    /**
    * The protocol of the volume. Allowed combinations are '['NFSV3']', '['NFSV4']', '['SMB']', '['NFSV3', 'NFSV4']', '['SMB', 'NFSV3']' and '['SMB', 'NFSV4']'. Possible values: ["NFSV3", "NFSV4", "SMB"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#protocols GoogleNetappVolume#protocols}
    */
    readonly protocols: string[];
    /**
    * List of actions that are restricted on this volume. Possible values: ["DELETE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#restricted_actions GoogleNetappVolume#restricted_actions}
    */
    readonly restrictedActions?: string[];
    /**
    * Security Style of the Volume. Use UNIX to use UNIX or NFSV4 ACLs for file permissions.
    * Use NTFS to use NTFS ACLs for file permissions. Can only be set for volumes which use SMB together with NFS as protocol. Possible values: ["NTFS", "UNIX"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#security_style GoogleNetappVolume#security_style}
    */
    readonly securityStyle?: string;
    /**
    * Share name (SMB) or export path (NFS) of the volume. Needs to be unique per location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#share_name GoogleNetappVolume#share_name}
    */
    readonly shareName: string;
    /**
    * Settings for volumes with SMB access. Possible values: ["ENCRYPT_DATA", "BROWSABLE", "CHANGE_NOTIFY", "NON_BROWSABLE", "OPLOCKS", "SHOW_SNAPSHOT", "SHOW_PREVIOUS_VERSIONS", "ACCESS_BASED_ENUMERATION", "CONTINUOUSLY_AVAILABLE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#smb_settings GoogleNetappVolume#smb_settings}
    */
    readonly smbSettings?: string[];
    /**
    * If enabled, a NFS volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots. Will enable "Previous Versions" support for SMB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#snapshot_directory GoogleNetappVolume#snapshot_directory}
    */
    readonly snapshotDirectory?: boolean | cdktf.IResolvable;
    /**
    * Name of the storage pool to create the volume in. Pool needs enough spare capacity to accomodate the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#storage_pool GoogleNetappVolume#storage_pool}
    */
    readonly storagePool: string;
    /**
    * Unix permission the mount point will be created with. Default is 0770. Applicable for UNIX security style volumes only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#unix_permissions GoogleNetappVolume#unix_permissions}
    */
    readonly unixPermissions?: string;
    /**
    * export_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#export_policy GoogleNetappVolume#export_policy}
    */
    readonly exportPolicy?: GoogleNetappVolumeExportPolicy;
    /**
    * restore_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#restore_parameters GoogleNetappVolume#restore_parameters}
    */
    readonly restoreParameters?: GoogleNetappVolumeRestoreParameters;
    /**
    * snapshot_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#snapshot_policy GoogleNetappVolume#snapshot_policy}
    */
    readonly snapshotPolicy?: GoogleNetappVolumeSnapshotPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#timeouts GoogleNetappVolume#timeouts}
    */
    readonly timeouts?: GoogleNetappVolumeTimeouts;
}
export interface GoogleNetappVolumeMountOptions {
}
export declare function googleNetappVolumeMountOptionsToTerraform(struct?: GoogleNetappVolumeMountOptions): any;
export declare function googleNetappVolumeMountOptionsToHclTerraform(struct?: GoogleNetappVolumeMountOptions): any;
export declare class GoogleNetappVolumeMountOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetappVolumeMountOptions | undefined;
    set internalValue(value: GoogleNetappVolumeMountOptions | undefined);
    get export(): string;
    get exportFull(): string;
    get instructions(): string;
    get protocol(): string;
}
export declare class GoogleNetappVolumeMountOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetappVolumeMountOptionsOutputReference;
}
export interface GoogleNetappVolumeExportPolicyRules {
    /**
    * Defines the access type for clients matching the 'allowedClients' specification. Possible values: ["READ_ONLY", "READ_WRITE", "READ_NONE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#access_type GoogleNetappVolume#access_type}
    */
    readonly accessType?: string;
    /**
    * Defines the client ingress specification (allowed clients) as a comma seperated list with IPv4 CIDRs or IPv4 host addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#allowed_clients GoogleNetappVolume#allowed_clients}
    */
    readonly allowedClients?: string;
    /**
    * If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#has_root_access GoogleNetappVolume#has_root_access}
    */
    readonly hasRootAccess?: string;
    /**
    * If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos5_read_only GoogleNetappVolume#kerberos5_read_only}
    */
    readonly kerberos5ReadOnly?: boolean | cdktf.IResolvable;
    /**
    * If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos5_read_write GoogleNetappVolume#kerberos5_read_write}
    */
    readonly kerberos5ReadWrite?: boolean | cdktf.IResolvable;
    /**
    * If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos5i_read_only GoogleNetappVolume#kerberos5i_read_only}
    */
    readonly kerberos5IReadOnly?: boolean | cdktf.IResolvable;
    /**
    * If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos5i_read_write GoogleNetappVolume#kerberos5i_read_write}
    */
    readonly kerberos5IReadWrite?: boolean | cdktf.IResolvable;
    /**
    * If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos5p_read_only GoogleNetappVolume#kerberos5p_read_only}
    */
    readonly kerberos5PReadOnly?: boolean | cdktf.IResolvable;
    /**
    * If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#kerberos5p_read_write GoogleNetappVolume#kerberos5p_read_write}
    */
    readonly kerberos5PReadWrite?: boolean | cdktf.IResolvable;
    /**
    * Enable to apply the export rule to NFSV3 clients.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#nfsv3 GoogleNetappVolume#nfsv3}
    */
    readonly nfsv3?: boolean | cdktf.IResolvable;
    /**
    * Enable to apply the export rule to NFSV4.1 clients.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#nfsv4 GoogleNetappVolume#nfsv4}
    */
    readonly nfsv4?: boolean | cdktf.IResolvable;
}
export declare function googleNetappVolumeExportPolicyRulesToTerraform(struct?: GoogleNetappVolumeExportPolicyRules | cdktf.IResolvable): any;
export declare function googleNetappVolumeExportPolicyRulesToHclTerraform(struct?: GoogleNetappVolumeExportPolicyRules | cdktf.IResolvable): any;
export declare class GoogleNetappVolumeExportPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetappVolumeExportPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetappVolumeExportPolicyRules | cdktf.IResolvable | undefined);
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    private _allowedClients?;
    get allowedClients(): string;
    set allowedClients(value: string);
    resetAllowedClients(): void;
    get allowedClientsInput(): string | undefined;
    private _hasRootAccess?;
    get hasRootAccess(): string;
    set hasRootAccess(value: string);
    resetHasRootAccess(): void;
    get hasRootAccessInput(): string | undefined;
    private _kerberos5ReadOnly?;
    get kerberos5ReadOnly(): boolean | cdktf.IResolvable;
    set kerberos5ReadOnly(value: boolean | cdktf.IResolvable);
    resetKerberos5ReadOnly(): void;
    get kerberos5ReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5ReadWrite?;
    get kerberos5ReadWrite(): boolean | cdktf.IResolvable;
    set kerberos5ReadWrite(value: boolean | cdktf.IResolvable);
    resetKerberos5ReadWrite(): void;
    get kerberos5ReadWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5IReadOnly?;
    get kerberos5IReadOnly(): boolean | cdktf.IResolvable;
    set kerberos5IReadOnly(value: boolean | cdktf.IResolvable);
    resetKerberos5IReadOnly(): void;
    get kerberos5IReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5IReadWrite?;
    get kerberos5IReadWrite(): boolean | cdktf.IResolvable;
    set kerberos5IReadWrite(value: boolean | cdktf.IResolvable);
    resetKerberos5IReadWrite(): void;
    get kerberos5IReadWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5PReadOnly?;
    get kerberos5PReadOnly(): boolean | cdktf.IResolvable;
    set kerberos5PReadOnly(value: boolean | cdktf.IResolvable);
    resetKerberos5PReadOnly(): void;
    get kerberos5PReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5PReadWrite?;
    get kerberos5PReadWrite(): boolean | cdktf.IResolvable;
    set kerberos5PReadWrite(value: boolean | cdktf.IResolvable);
    resetKerberos5PReadWrite(): void;
    get kerberos5PReadWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _nfsv3?;
    get nfsv3(): boolean | cdktf.IResolvable;
    set nfsv3(value: boolean | cdktf.IResolvable);
    resetNfsv3(): void;
    get nfsv3Input(): boolean | cdktf.IResolvable | undefined;
    private _nfsv4?;
    get nfsv4(): boolean | cdktf.IResolvable;
    set nfsv4(value: boolean | cdktf.IResolvable);
    resetNfsv4(): void;
    get nfsv4Input(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleNetappVolumeExportPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetappVolumeExportPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetappVolumeExportPolicyRulesOutputReference;
}
export interface GoogleNetappVolumeExportPolicy {
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#rules GoogleNetappVolume#rules}
    */
    readonly rules: GoogleNetappVolumeExportPolicyRules[] | cdktf.IResolvable;
}
export declare function googleNetappVolumeExportPolicyToTerraform(struct?: GoogleNetappVolumeExportPolicyOutputReference | GoogleNetappVolumeExportPolicy): any;
export declare function googleNetappVolumeExportPolicyToHclTerraform(struct?: GoogleNetappVolumeExportPolicyOutputReference | GoogleNetappVolumeExportPolicy): any;
export declare class GoogleNetappVolumeExportPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeExportPolicy | undefined;
    set internalValue(value: GoogleNetappVolumeExportPolicy | undefined);
    private _rules;
    get rules(): GoogleNetappVolumeExportPolicyRulesList;
    putRules(value: GoogleNetappVolumeExportPolicyRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleNetappVolumeExportPolicyRules[] | undefined;
}
export interface GoogleNetappVolumeRestoreParameters {
    /**
    * Full name of the snapshot to use for creating this volume.
    * 'source_snapshot' and 'source_backup' cannot be used simultaneously.
    * Format: 'projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#source_backup GoogleNetappVolume#source_backup}
    */
    readonly sourceBackup?: string;
    /**
    * Full name of the snapshot to use for creating this volume.
    * 'source_snapshot' and 'source_backup' cannot be used simultaneously.
    * Format: 'projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#source_snapshot GoogleNetappVolume#source_snapshot}
    */
    readonly sourceSnapshot?: string;
}
export declare function googleNetappVolumeRestoreParametersToTerraform(struct?: GoogleNetappVolumeRestoreParametersOutputReference | GoogleNetappVolumeRestoreParameters): any;
export declare function googleNetappVolumeRestoreParametersToHclTerraform(struct?: GoogleNetappVolumeRestoreParametersOutputReference | GoogleNetappVolumeRestoreParameters): any;
export declare class GoogleNetappVolumeRestoreParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeRestoreParameters | undefined;
    set internalValue(value: GoogleNetappVolumeRestoreParameters | undefined);
    private _sourceBackup?;
    get sourceBackup(): string;
    set sourceBackup(value: string);
    resetSourceBackup(): void;
    get sourceBackupInput(): string | undefined;
    private _sourceSnapshot?;
    get sourceSnapshot(): string;
    set sourceSnapshot(value: string);
    resetSourceSnapshot(): void;
    get sourceSnapshotInput(): string | undefined;
}
export interface GoogleNetappVolumeSnapshotPolicyDailySchedule {
    /**
    * Set the hour to create the snapshot (0-23), defaults to midnight (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#hour GoogleNetappVolume#hour}
    */
    readonly hour?: number;
    /**
    * Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#minute GoogleNetappVolume#minute}
    */
    readonly minute?: number;
    /**
    * The maximum number of snapshots to keep for the daily schedule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#snapshots_to_keep GoogleNetappVolume#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function googleNetappVolumeSnapshotPolicyDailyScheduleToTerraform(struct?: GoogleNetappVolumeSnapshotPolicyDailyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyDailySchedule): any;
export declare function googleNetappVolumeSnapshotPolicyDailyScheduleToHclTerraform(struct?: GoogleNetappVolumeSnapshotPolicyDailyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyDailySchedule): any;
export declare class GoogleNetappVolumeSnapshotPolicyDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeSnapshotPolicyDailySchedule | undefined;
    set internalValue(value: GoogleNetappVolumeSnapshotPolicyDailySchedule | undefined);
    private _hour?;
    get hour(): number;
    set hour(value: number);
    resetHour(): void;
    get hourInput(): number | undefined;
    private _minute?;
    get minute(): number;
    set minute(value: number);
    resetMinute(): void;
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface GoogleNetappVolumeSnapshotPolicyHourlySchedule {
    /**
    * Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#minute GoogleNetappVolume#minute}
    */
    readonly minute?: number;
    /**
    * The maximum number of snapshots to keep for the hourly schedule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#snapshots_to_keep GoogleNetappVolume#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function googleNetappVolumeSnapshotPolicyHourlyScheduleToTerraform(struct?: GoogleNetappVolumeSnapshotPolicyHourlyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyHourlySchedule): any;
export declare function googleNetappVolumeSnapshotPolicyHourlyScheduleToHclTerraform(struct?: GoogleNetappVolumeSnapshotPolicyHourlyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyHourlySchedule): any;
export declare class GoogleNetappVolumeSnapshotPolicyHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeSnapshotPolicyHourlySchedule | undefined;
    set internalValue(value: GoogleNetappVolumeSnapshotPolicyHourlySchedule | undefined);
    private _minute?;
    get minute(): number;
    set minute(value: number);
    resetMinute(): void;
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface GoogleNetappVolumeSnapshotPolicyMonthlySchedule {
    /**
    * Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#days_of_month GoogleNetappVolume#days_of_month}
    */
    readonly daysOfMonth?: string;
    /**
    * Set the hour to create the snapshot (0-23), defaults to midnight (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#hour GoogleNetappVolume#hour}
    */
    readonly hour?: number;
    /**
    * Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#minute GoogleNetappVolume#minute}
    */
    readonly minute?: number;
    /**
    * The maximum number of snapshots to keep for the monthly schedule
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#snapshots_to_keep GoogleNetappVolume#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function googleNetappVolumeSnapshotPolicyMonthlyScheduleToTerraform(struct?: GoogleNetappVolumeSnapshotPolicyMonthlyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyMonthlySchedule): any;
export declare function googleNetappVolumeSnapshotPolicyMonthlyScheduleToHclTerraform(struct?: GoogleNetappVolumeSnapshotPolicyMonthlyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyMonthlySchedule): any;
export declare class GoogleNetappVolumeSnapshotPolicyMonthlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeSnapshotPolicyMonthlySchedule | undefined;
    set internalValue(value: GoogleNetappVolumeSnapshotPolicyMonthlySchedule | undefined);
    private _daysOfMonth?;
    get daysOfMonth(): string;
    set daysOfMonth(value: string);
    resetDaysOfMonth(): void;
    get daysOfMonthInput(): string | undefined;
    private _hour?;
    get hour(): number;
    set hour(value: number);
    resetHour(): void;
    get hourInput(): number | undefined;
    private _minute?;
    get minute(): number;
    set minute(value: number);
    resetMinute(): void;
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface GoogleNetappVolumeSnapshotPolicyWeeklySchedule {
    /**
    * Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#day GoogleNetappVolume#day}
    */
    readonly day?: string;
    /**
    * Set the hour to create the snapshot (0-23), defaults to midnight (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#hour GoogleNetappVolume#hour}
    */
    readonly hour?: number;
    /**
    * Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#minute GoogleNetappVolume#minute}
    */
    readonly minute?: number;
    /**
    * The maximum number of snapshots to keep for the weekly schedule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#snapshots_to_keep GoogleNetappVolume#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function googleNetappVolumeSnapshotPolicyWeeklyScheduleToTerraform(struct?: GoogleNetappVolumeSnapshotPolicyWeeklyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyWeeklySchedule): any;
export declare function googleNetappVolumeSnapshotPolicyWeeklyScheduleToHclTerraform(struct?: GoogleNetappVolumeSnapshotPolicyWeeklyScheduleOutputReference | GoogleNetappVolumeSnapshotPolicyWeeklySchedule): any;
export declare class GoogleNetappVolumeSnapshotPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeSnapshotPolicyWeeklySchedule | undefined;
    set internalValue(value: GoogleNetappVolumeSnapshotPolicyWeeklySchedule | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    resetDay(): void;
    get dayInput(): string | undefined;
    private _hour?;
    get hour(): number;
    set hour(value: number);
    resetHour(): void;
    get hourInput(): number | undefined;
    private _minute?;
    get minute(): number;
    set minute(value: number);
    resetMinute(): void;
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface GoogleNetappVolumeSnapshotPolicy {
    /**
    * Enables automated snapshot creation according to defined schedule. Default is false.
    * To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#enabled GoogleNetappVolume#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * daily_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#daily_schedule GoogleNetappVolume#daily_schedule}
    */
    readonly dailySchedule?: GoogleNetappVolumeSnapshotPolicyDailySchedule;
    /**
    * hourly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#hourly_schedule GoogleNetappVolume#hourly_schedule}
    */
    readonly hourlySchedule?: GoogleNetappVolumeSnapshotPolicyHourlySchedule;
    /**
    * monthly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#monthly_schedule GoogleNetappVolume#monthly_schedule}
    */
    readonly monthlySchedule?: GoogleNetappVolumeSnapshotPolicyMonthlySchedule;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#weekly_schedule GoogleNetappVolume#weekly_schedule}
    */
    readonly weeklySchedule?: GoogleNetappVolumeSnapshotPolicyWeeklySchedule;
}
export declare function googleNetappVolumeSnapshotPolicyToTerraform(struct?: GoogleNetappVolumeSnapshotPolicyOutputReference | GoogleNetappVolumeSnapshotPolicy): any;
export declare function googleNetappVolumeSnapshotPolicyToHclTerraform(struct?: GoogleNetappVolumeSnapshotPolicyOutputReference | GoogleNetappVolumeSnapshotPolicy): any;
export declare class GoogleNetappVolumeSnapshotPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeSnapshotPolicy | undefined;
    set internalValue(value: GoogleNetappVolumeSnapshotPolicy | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dailySchedule;
    get dailySchedule(): GoogleNetappVolumeSnapshotPolicyDailyScheduleOutputReference;
    putDailySchedule(value: GoogleNetappVolumeSnapshotPolicyDailySchedule): void;
    resetDailySchedule(): void;
    get dailyScheduleInput(): GoogleNetappVolumeSnapshotPolicyDailySchedule | undefined;
    private _hourlySchedule;
    get hourlySchedule(): GoogleNetappVolumeSnapshotPolicyHourlyScheduleOutputReference;
    putHourlySchedule(value: GoogleNetappVolumeSnapshotPolicyHourlySchedule): void;
    resetHourlySchedule(): void;
    get hourlyScheduleInput(): GoogleNetappVolumeSnapshotPolicyHourlySchedule | undefined;
    private _monthlySchedule;
    get monthlySchedule(): GoogleNetappVolumeSnapshotPolicyMonthlyScheduleOutputReference;
    putMonthlySchedule(value: GoogleNetappVolumeSnapshotPolicyMonthlySchedule): void;
    resetMonthlySchedule(): void;
    get monthlyScheduleInput(): GoogleNetappVolumeSnapshotPolicyMonthlySchedule | undefined;
    private _weeklySchedule;
    get weeklySchedule(): GoogleNetappVolumeSnapshotPolicyWeeklyScheduleOutputReference;
    putWeeklySchedule(value: GoogleNetappVolumeSnapshotPolicyWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): GoogleNetappVolumeSnapshotPolicyWeeklySchedule | undefined;
}
export interface GoogleNetappVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#create GoogleNetappVolume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#delete GoogleNetappVolume#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#update GoogleNetappVolume#update}
    */
    readonly update?: string;
}
export declare function googleNetappVolumeTimeoutsToTerraform(struct?: GoogleNetappVolumeTimeouts | cdktf.IResolvable): any;
export declare function googleNetappVolumeTimeoutsToHclTerraform(struct?: GoogleNetappVolumeTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetappVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetappVolumeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetappVolumeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume google_netapp_volume}
*/
export declare class GoogleNetappVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_netapp_volume";
    /**
    * Generates CDKTF code for importing a GoogleNetappVolume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetappVolume to import
    * @param importFromId The id of the existing GoogleNetappVolume that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetappVolume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_netapp_volume google_netapp_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetappVolumeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetappVolumeConfig);
    get activeDirectory(): string;
    private _capacityGib?;
    get capacityGib(): string;
    set capacityGib(value: string);
    get capacityGibInput(): string | undefined;
    get createTime(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get encryptionType(): string;
    get hasReplication(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kerberosEnabled?;
    get kerberosEnabled(): boolean | cdktf.IResolvable;
    set kerberosEnabled(value: boolean | cdktf.IResolvable);
    resetKerberosEnabled(): void;
    get kerberosEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get kmsConfig(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get ldapEnabled(): cdktf.IResolvable;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mountOptions;
    get mountOptions(): GoogleNetappVolumeMountOptionsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    get protocolsInput(): string[] | undefined;
    get psaRange(): string;
    private _restrictedActions?;
    get restrictedActions(): string[];
    set restrictedActions(value: string[]);
    resetRestrictedActions(): void;
    get restrictedActionsInput(): string[] | undefined;
    private _securityStyle?;
    get securityStyle(): string;
    set securityStyle(value: string);
    resetSecurityStyle(): void;
    get securityStyleInput(): string | undefined;
    get serviceLevel(): string;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _smbSettings?;
    get smbSettings(): string[];
    set smbSettings(value: string[]);
    resetSmbSettings(): void;
    get smbSettingsInput(): string[] | undefined;
    private _snapshotDirectory?;
    get snapshotDirectory(): boolean | cdktf.IResolvable;
    set snapshotDirectory(value: boolean | cdktf.IResolvable);
    resetSnapshotDirectory(): void;
    get snapshotDirectoryInput(): boolean | cdktf.IResolvable | undefined;
    get state(): string;
    get stateDetails(): string;
    private _storagePool?;
    get storagePool(): string;
    set storagePool(value: string);
    get storagePoolInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _unixPermissions?;
    get unixPermissions(): string;
    set unixPermissions(value: string);
    resetUnixPermissions(): void;
    get unixPermissionsInput(): string | undefined;
    get usedGib(): string;
    private _exportPolicy;
    get exportPolicy(): GoogleNetappVolumeExportPolicyOutputReference;
    putExportPolicy(value: GoogleNetappVolumeExportPolicy): void;
    resetExportPolicy(): void;
    get exportPolicyInput(): GoogleNetappVolumeExportPolicy | undefined;
    private _restoreParameters;
    get restoreParameters(): GoogleNetappVolumeRestoreParametersOutputReference;
    putRestoreParameters(value: GoogleNetappVolumeRestoreParameters): void;
    resetRestoreParameters(): void;
    get restoreParametersInput(): GoogleNetappVolumeRestoreParameters | undefined;
    private _snapshotPolicy;
    get snapshotPolicy(): GoogleNetappVolumeSnapshotPolicyOutputReference;
    putSnapshotPolicy(value: GoogleNetappVolumeSnapshotPolicy): void;
    resetSnapshotPolicy(): void;
    get snapshotPolicyInput(): GoogleNetappVolumeSnapshotPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleNetappVolumeTimeoutsOutputReference;
    putTimeouts(value: GoogleNetappVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetappVolumeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
