/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkConnectivityPolicyBasedRouteConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#description GoogleNetworkConnectivityPolicyBasedRoute#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#id GoogleNetworkConnectivityPolicyBasedRoute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#labels GoogleNetworkConnectivityPolicyBasedRoute#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the policy based route.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#name GoogleNetworkConnectivityPolicyBasedRoute#name}
    */
    readonly name: string;
    /**
    * Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#network GoogleNetworkConnectivityPolicyBasedRoute#network}
    */
    readonly network: string;
    /**
    * The IP address of a global-access-enabled L4 ILB that is the next hop for matching packets.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#next_hop_ilb_ip GoogleNetworkConnectivityPolicyBasedRoute#next_hop_ilb_ip}
    */
    readonly nextHopIlbIp?: string;
    /**
    * Other routes that will be referenced to determine the next hop of the packet. Possible values: ["DEFAULT_ROUTING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#next_hop_other_routes GoogleNetworkConnectivityPolicyBasedRoute#next_hop_other_routes}
    */
    readonly nextHopOtherRoutes?: string;
    /**
    * The priority of this policy-based route. Priority is used to break ties in cases where there are more than one matching policy-based routes found. In cases where multiple policy-based routes are matched, the one with the lowest-numbered priority value wins. The default value is 1000. The priority value must be from 1 to 65535, inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#priority GoogleNetworkConnectivityPolicyBasedRoute#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#project GoogleNetworkConnectivityPolicyBasedRoute#project}
    */
    readonly project?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#filter GoogleNetworkConnectivityPolicyBasedRoute#filter}
    */
    readonly filter: GoogleNetworkConnectivityPolicyBasedRouteFilter;
    /**
    * interconnect_attachment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#interconnect_attachment GoogleNetworkConnectivityPolicyBasedRoute#interconnect_attachment}
    */
    readonly interconnectAttachment?: GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#timeouts GoogleNetworkConnectivityPolicyBasedRoute#timeouts}
    */
    readonly timeouts?: GoogleNetworkConnectivityPolicyBasedRouteTimeouts;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#virtual_machine GoogleNetworkConnectivityPolicyBasedRoute#virtual_machine}
    */
    readonly virtualMachine?: GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine;
}
export interface GoogleNetworkConnectivityPolicyBasedRouteWarnings {
}
export declare function googleNetworkConnectivityPolicyBasedRouteWarningsToTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteWarnings): any;
export declare function googleNetworkConnectivityPolicyBasedRouteWarningsToHclTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteWarnings): any;
export declare class GoogleNetworkConnectivityPolicyBasedRouteWarningsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkConnectivityPolicyBasedRouteWarnings | undefined;
    set internalValue(value: GoogleNetworkConnectivityPolicyBasedRouteWarnings | undefined);
    get code(): string;
    private _data;
    get data(): cdktf.StringMap;
    get warningMessage(): string;
}
export declare class GoogleNetworkConnectivityPolicyBasedRouteWarningsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkConnectivityPolicyBasedRouteWarningsOutputReference;
}
export interface GoogleNetworkConnectivityPolicyBasedRouteFilter {
    /**
    * The destination IP range of outgoing packets that this policy-based route applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#dest_range GoogleNetworkConnectivityPolicyBasedRoute#dest_range}
    */
    readonly destRange?: string;
    /**
    * The IP protocol that this policy-based route applies to. Valid values are 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#ip_protocol GoogleNetworkConnectivityPolicyBasedRoute#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * Internet protocol versions this policy-based route applies to. Possible values: ["IPV4"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#protocol_version GoogleNetworkConnectivityPolicyBasedRoute#protocol_version}
    */
    readonly protocolVersion: string;
    /**
    * The source IP range of outgoing packets that this policy-based route applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#src_range GoogleNetworkConnectivityPolicyBasedRoute#src_range}
    */
    readonly srcRange?: string;
}
export declare function googleNetworkConnectivityPolicyBasedRouteFilterToTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteFilterOutputReference | GoogleNetworkConnectivityPolicyBasedRouteFilter): any;
export declare function googleNetworkConnectivityPolicyBasedRouteFilterToHclTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteFilterOutputReference | GoogleNetworkConnectivityPolicyBasedRouteFilter): any;
export declare class GoogleNetworkConnectivityPolicyBasedRouteFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityPolicyBasedRouteFilter | undefined;
    set internalValue(value: GoogleNetworkConnectivityPolicyBasedRouteFilter | undefined);
    private _destRange?;
    get destRange(): string;
    set destRange(value: string);
    resetDestRange(): void;
    get destRangeInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _protocolVersion?;
    get protocolVersion(): string;
    set protocolVersion(value: string);
    get protocolVersionInput(): string | undefined;
    private _srcRange?;
    get srcRange(): string;
    set srcRange(value: string);
    resetSrcRange(): void;
    get srcRangeInput(): string | undefined;
}
export interface GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment {
    /**
    * Cloud region to install this policy-based route on for Interconnect attachments. Use 'all' to install it on all Interconnect attachments.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#region GoogleNetworkConnectivityPolicyBasedRoute#region}
    */
    readonly region: string;
}
export declare function googleNetworkConnectivityPolicyBasedRouteInterconnectAttachmentToTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachmentOutputReference | GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment): any;
export declare function googleNetworkConnectivityPolicyBasedRouteInterconnectAttachmentToHclTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachmentOutputReference | GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment): any;
export declare class GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment | undefined;
    set internalValue(value: GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment | undefined);
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
}
export interface GoogleNetworkConnectivityPolicyBasedRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#create GoogleNetworkConnectivityPolicyBasedRoute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#delete GoogleNetworkConnectivityPolicyBasedRoute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#update GoogleNetworkConnectivityPolicyBasedRoute#update}
    */
    readonly update?: string;
}
export declare function googleNetworkConnectivityPolicyBasedRouteTimeoutsToTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkConnectivityPolicyBasedRouteTimeoutsToHclTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkConnectivityPolicyBasedRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityPolicyBasedRouteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkConnectivityPolicyBasedRouteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine {
    /**
    * A list of VM instance tags that this policy-based route applies to. VM instances that have ANY of tags specified here will install this PBR.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#tags GoogleNetworkConnectivityPolicyBasedRoute#tags}
    */
    readonly tags: string[];
}
export declare function googleNetworkConnectivityPolicyBasedRouteVirtualMachineToTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteVirtualMachineOutputReference | GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine): any;
export declare function googleNetworkConnectivityPolicyBasedRouteVirtualMachineToHclTerraform(struct?: GoogleNetworkConnectivityPolicyBasedRouteVirtualMachineOutputReference | GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine): any;
export declare class GoogleNetworkConnectivityPolicyBasedRouteVirtualMachineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine | undefined;
    set internalValue(value: GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine | undefined);
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    get tagsInput(): string[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route google_network_connectivity_policy_based_route}
*/
export declare class GoogleNetworkConnectivityPolicyBasedRoute extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_connectivity_policy_based_route";
    /**
    * Generates CDKTF code for importing a GoogleNetworkConnectivityPolicyBasedRoute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkConnectivityPolicyBasedRoute to import
    * @param importFromId The id of the existing GoogleNetworkConnectivityPolicyBasedRoute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkConnectivityPolicyBasedRoute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_policy_based_route google_network_connectivity_policy_based_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkConnectivityPolicyBasedRouteConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkConnectivityPolicyBasedRouteConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _nextHopIlbIp?;
    get nextHopIlbIp(): string;
    set nextHopIlbIp(value: string);
    resetNextHopIlbIp(): void;
    get nextHopIlbIpInput(): string | undefined;
    private _nextHopOtherRoutes?;
    get nextHopOtherRoutes(): string;
    set nextHopOtherRoutes(value: string);
    resetNextHopOtherRoutes(): void;
    get nextHopOtherRoutesInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _warnings;
    get warnings(): GoogleNetworkConnectivityPolicyBasedRouteWarningsList;
    private _filter;
    get filter(): GoogleNetworkConnectivityPolicyBasedRouteFilterOutputReference;
    putFilter(value: GoogleNetworkConnectivityPolicyBasedRouteFilter): void;
    get filterInput(): GoogleNetworkConnectivityPolicyBasedRouteFilter | undefined;
    private _interconnectAttachment;
    get interconnectAttachment(): GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachmentOutputReference;
    putInterconnectAttachment(value: GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment): void;
    resetInterconnectAttachment(): void;
    get interconnectAttachmentInput(): GoogleNetworkConnectivityPolicyBasedRouteInterconnectAttachment | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkConnectivityPolicyBasedRouteTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkConnectivityPolicyBasedRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkConnectivityPolicyBasedRouteTimeouts | undefined;
    private _virtualMachine;
    get virtualMachine(): GoogleNetworkConnectivityPolicyBasedRouteVirtualMachineOutputReference;
    putVirtualMachine(value: GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine): void;
    resetVirtualMachine(): void;
    get virtualMachineInput(): GoogleNetworkConnectivityPolicyBasedRouteVirtualMachine | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
