/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkConnectivityServiceConnectionPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Free-text description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#description GoogleNetworkConnectivityServiceConnectionPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#id GoogleNetworkConnectivityServiceConnectionPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#labels GoogleNetworkConnectivityServiceConnectionPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the ServiceConnectionPolicy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#location GoogleNetworkConnectivityServiceConnectionPolicy#location}
    */
    readonly location: string;
    /**
    * The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#name GoogleNetworkConnectivityServiceConnectionPolicy#name}
    */
    readonly name: string;
    /**
    * The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#network GoogleNetworkConnectivityServiceConnectionPolicy#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#project GoogleNetworkConnectivityServiceConnectionPolicy#project}
    */
    readonly project?: string;
    /**
    * The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
    * It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#service_class GoogleNetworkConnectivityServiceConnectionPolicy#service_class}
    */
    readonly serviceClass: string;
    /**
    * psc_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#psc_config GoogleNetworkConnectivityServiceConnectionPolicy#psc_config}
    */
    readonly pscConfig?: GoogleNetworkConnectivityServiceConnectionPolicyPscConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#timeouts GoogleNetworkConnectivityServiceConnectionPolicy#timeouts}
    */
    readonly timeouts?: GoogleNetworkConnectivityServiceConnectionPolicyTimeouts;
}
export interface GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsError {
}
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorToTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsError): any;
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorToHclTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsError): any;
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsError | undefined;
    set internalValue(value: GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsError | undefined);
    get code(): number;
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
}
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorOutputReference;
}
export interface GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfo {
}
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfoToTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfo): any;
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfoToHclTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfo): any;
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfo | undefined;
    set internalValue(value: GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfo | undefined);
    get domain(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    get reason(): string;
}
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfoOutputReference;
}
export interface GoogleNetworkConnectivityServiceConnectionPolicyPscConnections {
}
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConnectionsToTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConnections): any;
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConnectionsToHclTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConnections): any;
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkConnectivityServiceConnectionPolicyPscConnections | undefined;
    set internalValue(value: GoogleNetworkConnectivityServiceConnectionPolicyPscConnections | undefined);
    get consumerAddress(): string;
    get consumerForwardingRule(): string;
    get consumerTargetProject(): string;
    private _error;
    get error(): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorList;
    private _errorInfo;
    get errorInfo(): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsErrorInfoList;
    get errorType(): string;
    get gceOperation(): string;
    get pscConnectionId(): string;
    get state(): string;
}
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsOutputReference;
}
export interface GoogleNetworkConnectivityServiceConnectionPolicyPscConfig {
    /**
    * Max number of PSC connections for this policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#limit GoogleNetworkConnectivityServiceConnectionPolicy#limit}
    */
    readonly limit?: string;
    /**
    * IDs of the subnetworks or fully qualified identifiers for the subnetworks
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#subnetworks GoogleNetworkConnectivityServiceConnectionPolicy#subnetworks}
    */
    readonly subnetworks: string[];
}
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConfigToTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConfigOutputReference | GoogleNetworkConnectivityServiceConnectionPolicyPscConfig): any;
export declare function googleNetworkConnectivityServiceConnectionPolicyPscConfigToHclTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyPscConfigOutputReference | GoogleNetworkConnectivityServiceConnectionPolicyPscConfig): any;
export declare class GoogleNetworkConnectivityServiceConnectionPolicyPscConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityServiceConnectionPolicyPscConfig | undefined;
    set internalValue(value: GoogleNetworkConnectivityServiceConnectionPolicyPscConfig | undefined);
    private _limit?;
    get limit(): string;
    set limit(value: string);
    resetLimit(): void;
    get limitInput(): string | undefined;
    private _subnetworks?;
    get subnetworks(): string[];
    set subnetworks(value: string[]);
    get subnetworksInput(): string[] | undefined;
}
export interface GoogleNetworkConnectivityServiceConnectionPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#create GoogleNetworkConnectivityServiceConnectionPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#delete GoogleNetworkConnectivityServiceConnectionPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#update GoogleNetworkConnectivityServiceConnectionPolicy#update}
    */
    readonly update?: string;
}
export declare function googleNetworkConnectivityServiceConnectionPolicyTimeoutsToTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkConnectivityServiceConnectionPolicyTimeoutsToHclTerraform(struct?: GoogleNetworkConnectivityServiceConnectionPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkConnectivityServiceConnectionPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityServiceConnectionPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkConnectivityServiceConnectionPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy google_network_connectivity_service_connection_policy}
*/
export declare class GoogleNetworkConnectivityServiceConnectionPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_connectivity_service_connection_policy";
    /**
    * Generates CDKTF code for importing a GoogleNetworkConnectivityServiceConnectionPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkConnectivityServiceConnectionPolicy to import
    * @param importFromId The id of the existing GoogleNetworkConnectivityServiceConnectionPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkConnectivityServiceConnectionPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_connectivity_service_connection_policy google_network_connectivity_service_connection_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkConnectivityServiceConnectionPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkConnectivityServiceConnectionPolicyConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get infrastructure(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pscConnections;
    get pscConnections(): GoogleNetworkConnectivityServiceConnectionPolicyPscConnectionsList;
    private _serviceClass?;
    get serviceClass(): string;
    set serviceClass(value: string);
    get serviceClassInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _pscConfig;
    get pscConfig(): GoogleNetworkConnectivityServiceConnectionPolicyPscConfigOutputReference;
    putPscConfig(value: GoogleNetworkConnectivityServiceConnectionPolicyPscConfig): void;
    resetPscConfig(): void;
    get pscConfigInput(): GoogleNetworkConnectivityServiceConnectionPolicyPscConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkConnectivityServiceConnectionPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkConnectivityServiceConnectionPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkConnectivityServiceConnectionPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
