/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkManagementConnectivityTestConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-supplied description of the Connectivity Test.
    * Maximum of 512 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#description GoogleNetworkManagementConnectivityTest#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#id GoogleNetworkManagementConnectivityTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#labels GoogleNetworkManagementConnectivityTest#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Unique name for the connectivity test.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#name GoogleNetworkManagementConnectivityTest#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#project GoogleNetworkManagementConnectivityTest#project}
    */
    readonly project?: string;
    /**
    * IP Protocol of the test. When not provided, "TCP" is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#protocol GoogleNetworkManagementConnectivityTest#protocol}
    */
    readonly protocol?: string;
    /**
    * Other projects that may be relevant for reachability analysis.
    * This is applicable to scenarios where a test can cross project
    * boundaries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#related_projects GoogleNetworkManagementConnectivityTest#related_projects}
    */
    readonly relatedProjects?: string[];
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#destination GoogleNetworkManagementConnectivityTest#destination}
    */
    readonly destination: GoogleNetworkManagementConnectivityTestDestination;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#source GoogleNetworkManagementConnectivityTest#source}
    */
    readonly source: GoogleNetworkManagementConnectivityTestSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#timeouts GoogleNetworkManagementConnectivityTest#timeouts}
    */
    readonly timeouts?: GoogleNetworkManagementConnectivityTestTimeouts;
}
export interface GoogleNetworkManagementConnectivityTestDestination {
    /**
    * A Compute Engine instance URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#instance GoogleNetworkManagementConnectivityTest#instance}
    */
    readonly instance?: string;
    /**
    * The IP address of the endpoint, which can be an external or
    * internal IP. An IPv6 address is only allowed when the test's
    * destination is a global load balancer VIP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#ip_address GoogleNetworkManagementConnectivityTest#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * A Compute Engine network URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#network GoogleNetworkManagementConnectivityTest#network}
    */
    readonly network?: string;
    /**
    * The IP protocol port of the endpoint. Only applicable when
    * protocol is TCP or UDP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#port GoogleNetworkManagementConnectivityTest#port}
    */
    readonly port?: number;
    /**
    * Project ID where the endpoint is located. The Project ID can be
    * derived from the URI if you provide a VM instance or network URI.
    * The following are two cases where you must provide the project ID:
    * 1. Only the IP address is specified, and the IP address is within
    * a GCP project. 2. When you are using Shared VPC and the IP address
    * that you provide is from the service project. In this case, the
    * network that the IP address resides in is defined in the host
    * project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#project_id GoogleNetworkManagementConnectivityTest#project_id}
    */
    readonly projectId?: string;
}
export declare function googleNetworkManagementConnectivityTestDestinationToTerraform(struct?: GoogleNetworkManagementConnectivityTestDestinationOutputReference | GoogleNetworkManagementConnectivityTestDestination): any;
export declare function googleNetworkManagementConnectivityTestDestinationToHclTerraform(struct?: GoogleNetworkManagementConnectivityTestDestinationOutputReference | GoogleNetworkManagementConnectivityTestDestination): any;
export declare class GoogleNetworkManagementConnectivityTestDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkManagementConnectivityTestDestination | undefined;
    set internalValue(value: GoogleNetworkManagementConnectivityTestDestination | undefined);
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface GoogleNetworkManagementConnectivityTestSource {
    /**
    * A Compute Engine instance URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#instance GoogleNetworkManagementConnectivityTest#instance}
    */
    readonly instance?: string;
    /**
    * The IP address of the endpoint, which can be an external or
    * internal IP. An IPv6 address is only allowed when the test's
    * destination is a global load balancer VIP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#ip_address GoogleNetworkManagementConnectivityTest#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * A Compute Engine network URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#network GoogleNetworkManagementConnectivityTest#network}
    */
    readonly network?: string;
    /**
    * Type of the network where the endpoint is located. Possible values: ["GCP_NETWORK", "NON_GCP_NETWORK"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#network_type GoogleNetworkManagementConnectivityTest#network_type}
    */
    readonly networkType?: string;
    /**
    * The IP protocol port of the endpoint. Only applicable when
    * protocol is TCP or UDP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#port GoogleNetworkManagementConnectivityTest#port}
    */
    readonly port?: number;
    /**
    * Project ID where the endpoint is located. The Project ID can be
    * derived from the URI if you provide a VM instance or network URI.
    * The following are two cases where you must provide the project ID:
    *
    * 1. Only the IP address is specified, and the IP address is
    *    within a GCP project.
    * 2. When you are using Shared VPC and the IP address
    *    that you provide is from the service project. In this case,
    *    the network that the IP address resides in is defined in the
    *    host project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#project_id GoogleNetworkManagementConnectivityTest#project_id}
    */
    readonly projectId?: string;
}
export declare function googleNetworkManagementConnectivityTestSourceToTerraform(struct?: GoogleNetworkManagementConnectivityTestSourceOutputReference | GoogleNetworkManagementConnectivityTestSource): any;
export declare function googleNetworkManagementConnectivityTestSourceToHclTerraform(struct?: GoogleNetworkManagementConnectivityTestSourceOutputReference | GoogleNetworkManagementConnectivityTestSource): any;
export declare class GoogleNetworkManagementConnectivityTestSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkManagementConnectivityTestSource | undefined;
    set internalValue(value: GoogleNetworkManagementConnectivityTestSource | undefined);
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkType?;
    get networkType(): string;
    set networkType(value: string);
    resetNetworkType(): void;
    get networkTypeInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface GoogleNetworkManagementConnectivityTestTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#create GoogleNetworkManagementConnectivityTest#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#delete GoogleNetworkManagementConnectivityTest#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#update GoogleNetworkManagementConnectivityTest#update}
    */
    readonly update?: string;
}
export declare function googleNetworkManagementConnectivityTestTimeoutsToTerraform(struct?: GoogleNetworkManagementConnectivityTestTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkManagementConnectivityTestTimeoutsToHclTerraform(struct?: GoogleNetworkManagementConnectivityTestTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkManagementConnectivityTestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkManagementConnectivityTestTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkManagementConnectivityTestTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test google_network_management_connectivity_test}
*/
export declare class GoogleNetworkManagementConnectivityTest extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_management_connectivity_test";
    /**
    * Generates CDKTF code for importing a GoogleNetworkManagementConnectivityTest resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkManagementConnectivityTest to import
    * @param importFromId The id of the existing GoogleNetworkManagementConnectivityTest that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkManagementConnectivityTest to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_management_connectivity_test google_network_management_connectivity_test} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkManagementConnectivityTestConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkManagementConnectivityTestConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _relatedProjects?;
    get relatedProjects(): string[];
    set relatedProjects(value: string[]);
    resetRelatedProjects(): void;
    get relatedProjectsInput(): string[] | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _destination;
    get destination(): GoogleNetworkManagementConnectivityTestDestinationOutputReference;
    putDestination(value: GoogleNetworkManagementConnectivityTestDestination): void;
    get destinationInput(): GoogleNetworkManagementConnectivityTestDestination | undefined;
    private _source;
    get source(): GoogleNetworkManagementConnectivityTestSourceOutputReference;
    putSource(value: GoogleNetworkManagementConnectivityTestSource): void;
    get sourceInput(): GoogleNetworkManagementConnectivityTestSource | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkManagementConnectivityTestTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkManagementConnectivityTestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkManagementConnectivityTestTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
