/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkSecurityAuthorizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The action to take when a rule match is found. Possible values are "ALLOW" or "DENY". Possible values: ["ALLOW", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#action GoogleNetworkSecurityAuthorizationPolicy#action}
    */
    readonly action: string;
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#description GoogleNetworkSecurityAuthorizationPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#id GoogleNetworkSecurityAuthorizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the AuthorizationPolicy resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#labels GoogleNetworkSecurityAuthorizationPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the authorization policy.
    * The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#location GoogleNetworkSecurityAuthorizationPolicy#location}
    */
    readonly location?: string;
    /**
    * Name of the AuthorizationPolicy resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#name GoogleNetworkSecurityAuthorizationPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#project GoogleNetworkSecurityAuthorizationPolicy#project}
    */
    readonly project?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#rules GoogleNetworkSecurityAuthorizationPolicy#rules}
    */
    readonly rules?: GoogleNetworkSecurityAuthorizationPolicyRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#timeouts GoogleNetworkSecurityAuthorizationPolicy#timeouts}
    */
    readonly timeouts?: GoogleNetworkSecurityAuthorizationPolicyTimeouts;
}
export interface GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch {
    /**
    * The name of the HTTP header to match. For matching against the HTTP request's authority, use a headerMatch with the header name ":authority". For matching a request's method, use the headerName ":method".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#header_name GoogleNetworkSecurityAuthorizationPolicy#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header must match the regular expression specified in regexMatch. For regular expression grammar, please see: en.cppreference.com/w/cpp/regex/ecmascript For matching against a port specified in the HTTP request, use a headerMatch with headerName set to Host and a regular expression that satisfies the RFC2616 Host header's port specifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#regex_match GoogleNetworkSecurityAuthorizationPolicy#regex_match}
    */
    readonly regexMatch: string;
}
export declare function googleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatchToTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatchOutputReference | GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch): any;
export declare function googleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatchToHclTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatchOutputReference | GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch): any;
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch | undefined;
    set internalValue(value: GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    get regexMatchInput(): string | undefined;
}
export interface GoogleNetworkSecurityAuthorizationPolicyRulesDestinations {
    /**
    * List of host names to match. Matched against the ":authority" header in http requests. At least one host should match. Each host can be an exact match, or a prefix match (example "mydomain.*") or a suffix match (example "*.myorg.com") or a presence (any) match "*".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#hosts GoogleNetworkSecurityAuthorizationPolicy#hosts}
    */
    readonly hosts: string[];
    /**
    * A list of HTTP methods to match. At least one method should match. Should not be set for gRPC services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#methods GoogleNetworkSecurityAuthorizationPolicy#methods}
    */
    readonly methods: string[];
    /**
    * List of destination ports to match. At least one port should match.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#ports GoogleNetworkSecurityAuthorizationPolicy#ports}
    */
    readonly ports: number[];
    /**
    * http_header_match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#http_header_match GoogleNetworkSecurityAuthorizationPolicy#http_header_match}
    */
    readonly httpHeaderMatch?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch;
}
export declare function googleNetworkSecurityAuthorizationPolicyRulesDestinationsToTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinations | cdktf.IResolvable): any;
export declare function googleNetworkSecurityAuthorizationPolicyRulesDestinationsToHclTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinations | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecurityAuthorizationPolicyRulesDestinations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityAuthorizationPolicyRulesDestinations | cdktf.IResolvable | undefined);
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _methods?;
    get methods(): string[];
    set methods(value: string[]);
    get methodsInput(): string[] | undefined;
    private _ports?;
    get ports(): number[];
    set ports(value: number[]);
    get portsInput(): number[] | undefined;
    private _httpHeaderMatch;
    get httpHeaderMatch(): GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatchOutputReference;
    putHttpHeaderMatch(value: GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch): void;
    resetHttpHeaderMatch(): void;
    get httpHeaderMatchInput(): GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsHttpHeaderMatch | undefined;
}
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsOutputReference;
}
export interface GoogleNetworkSecurityAuthorizationPolicyRulesSources {
    /**
    * List of CIDR ranges to match based on source IP address. At least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR (e.g., "1.2.3.0/24") are supported. Authorization based on source IP alone should be avoided.
    * The IP addresses of any load balancers or proxies should be considered untrusted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#ip_blocks GoogleNetworkSecurityAuthorizationPolicy#ip_blocks}
    */
    readonly ipBlocks?: string[];
    /**
    * List of peer identities to match for authorization. At least one principal should match. Each peer can be an exact match, or a prefix match (example, "namespace/*") or a suffix match (example, "* /service-account") or a presence match "*".
    * Authorization based on the principal name without certificate validation (configured by ServerTlsPolicy resource) is considered insecure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#principals GoogleNetworkSecurityAuthorizationPolicy#principals}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly principals?: string[];
}
export declare function googleNetworkSecurityAuthorizationPolicyRulesSourcesToTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRulesSources | cdktf.IResolvable): any;
export declare function googleNetworkSecurityAuthorizationPolicyRulesSourcesToHclTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRulesSources | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecurityAuthorizationPolicyRulesSources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityAuthorizationPolicyRulesSources | cdktf.IResolvable | undefined);
    private _ipBlocks?;
    get ipBlocks(): string[];
    set ipBlocks(value: string[]);
    resetIpBlocks(): void;
    get ipBlocksInput(): string[] | undefined;
    private _principals?;
    get principals(): string[];
    set principals(value: string[]);
    resetPrincipals(): void;
    get principalsInput(): string[] | undefined;
}
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecurityAuthorizationPolicyRulesSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecurityAuthorizationPolicyRulesSourcesOutputReference;
}
export interface GoogleNetworkSecurityAuthorizationPolicyRules {
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#destinations GoogleNetworkSecurityAuthorizationPolicy#destinations}
    */
    readonly destinations?: GoogleNetworkSecurityAuthorizationPolicyRulesDestinations[] | cdktf.IResolvable;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#sources GoogleNetworkSecurityAuthorizationPolicy#sources}
    */
    readonly sources?: GoogleNetworkSecurityAuthorizationPolicyRulesSources[] | cdktf.IResolvable;
}
export declare function googleNetworkSecurityAuthorizationPolicyRulesToTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRules | cdktf.IResolvable): any;
export declare function googleNetworkSecurityAuthorizationPolicyRulesToHclTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyRules | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecurityAuthorizationPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityAuthorizationPolicyRules | cdktf.IResolvable | undefined);
    private _destinations;
    get destinations(): GoogleNetworkSecurityAuthorizationPolicyRulesDestinationsList;
    putDestinations(value: GoogleNetworkSecurityAuthorizationPolicyRulesDestinations[] | cdktf.IResolvable): void;
    resetDestinations(): void;
    get destinationsInput(): cdktf.IResolvable | GoogleNetworkSecurityAuthorizationPolicyRulesDestinations[] | undefined;
    private _sources;
    get sources(): GoogleNetworkSecurityAuthorizationPolicyRulesSourcesList;
    putSources(value: GoogleNetworkSecurityAuthorizationPolicyRulesSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | GoogleNetworkSecurityAuthorizationPolicyRulesSources[] | undefined;
}
export declare class GoogleNetworkSecurityAuthorizationPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecurityAuthorizationPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecurityAuthorizationPolicyRulesOutputReference;
}
export interface GoogleNetworkSecurityAuthorizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#create GoogleNetworkSecurityAuthorizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#delete GoogleNetworkSecurityAuthorizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#update GoogleNetworkSecurityAuthorizationPolicy#update}
    */
    readonly update?: string;
}
export declare function googleNetworkSecurityAuthorizationPolicyTimeoutsToTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkSecurityAuthorizationPolicyTimeoutsToHclTerraform(struct?: GoogleNetworkSecurityAuthorizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityAuthorizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityAuthorizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityAuthorizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy google_network_security_authorization_policy}
*/
export declare class GoogleNetworkSecurityAuthorizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_security_authorization_policy";
    /**
    * Generates CDKTF code for importing a GoogleNetworkSecurityAuthorizationPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkSecurityAuthorizationPolicy to import
    * @param importFromId The id of the existing GoogleNetworkSecurityAuthorizationPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkSecurityAuthorizationPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_authorization_policy google_network_security_authorization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkSecurityAuthorizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkSecurityAuthorizationPolicyConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleNetworkSecurityAuthorizationPolicyRulesList;
    putRules(value: GoogleNetworkSecurityAuthorizationPolicyRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | GoogleNetworkSecurityAuthorizationPolicyRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkSecurityAuthorizationPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkSecurityAuthorizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkSecurityAuthorizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
