/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkSecurityClientTlsPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#description GoogleNetworkSecurityClientTlsPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#id GoogleNetworkSecurityClientTlsPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the ClientTlsPolicy resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#labels GoogleNetworkSecurityClientTlsPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the client tls policy.
    * The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#location GoogleNetworkSecurityClientTlsPolicy#location}
    */
    readonly location?: string;
    /**
    * Name of the ClientTlsPolicy resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#name GoogleNetworkSecurityClientTlsPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#project GoogleNetworkSecurityClientTlsPolicy#project}
    */
    readonly project?: string;
    /**
    * Server Name Indication string to present to the server during TLS handshake. E.g: "secure.example.com".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#sni GoogleNetworkSecurityClientTlsPolicy#sni}
    */
    readonly sni?: string;
    /**
    * client_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#client_certificate GoogleNetworkSecurityClientTlsPolicy#client_certificate}
    */
    readonly clientCertificate?: GoogleNetworkSecurityClientTlsPolicyClientCertificate;
    /**
    * server_validation_ca block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#server_validation_ca GoogleNetworkSecurityClientTlsPolicy#server_validation_ca}
    */
    readonly serverValidationCa?: GoogleNetworkSecurityClientTlsPolicyServerValidationCa[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#timeouts GoogleNetworkSecurityClientTlsPolicy#timeouts}
    */
    readonly timeouts?: GoogleNetworkSecurityClientTlsPolicyTimeouts;
}
export interface GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance {
    /**
    * Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#plugin_instance GoogleNetworkSecurityClientTlsPolicy#plugin_instance}
    */
    readonly pluginInstance: string;
}
export declare function googleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstanceToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstanceOutputReference | GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance): any;
export declare function googleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstanceToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstanceOutputReference | GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance): any;
export declare class GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance | undefined);
    private _pluginInstance?;
    get pluginInstance(): string;
    set pluginInstance(value: string);
    get pluginInstanceInput(): string | undefined;
}
export interface GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint {
    /**
    * The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#target_uri GoogleNetworkSecurityClientTlsPolicy#target_uri}
    */
    readonly targetUri: string;
}
export declare function googleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpointToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpointOutputReference | GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint): any;
export declare function googleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpointToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpointOutputReference | GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint): any;
export declare class GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint | undefined);
    private _targetUri?;
    get targetUri(): string;
    set targetUri(value: string);
    get targetUriInput(): string | undefined;
}
export interface GoogleNetworkSecurityClientTlsPolicyClientCertificate {
    /**
    * certificate_provider_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#certificate_provider_instance GoogleNetworkSecurityClientTlsPolicy#certificate_provider_instance}
    */
    readonly certificateProviderInstance?: GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance;
    /**
    * grpc_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#grpc_endpoint GoogleNetworkSecurityClientTlsPolicy#grpc_endpoint}
    */
    readonly grpcEndpoint?: GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint;
}
export declare function googleNetworkSecurityClientTlsPolicyClientCertificateToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyClientCertificateOutputReference | GoogleNetworkSecurityClientTlsPolicyClientCertificate): any;
export declare function googleNetworkSecurityClientTlsPolicyClientCertificateToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyClientCertificateOutputReference | GoogleNetworkSecurityClientTlsPolicyClientCertificate): any;
export declare class GoogleNetworkSecurityClientTlsPolicyClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyClientCertificate | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyClientCertificate | undefined);
    private _certificateProviderInstance;
    get certificateProviderInstance(): GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstanceOutputReference;
    putCertificateProviderInstance(value: GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance): void;
    resetCertificateProviderInstance(): void;
    get certificateProviderInstanceInput(): GoogleNetworkSecurityClientTlsPolicyClientCertificateCertificateProviderInstance | undefined;
    private _grpcEndpoint;
    get grpcEndpoint(): GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpointOutputReference;
    putGrpcEndpoint(value: GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint): void;
    resetGrpcEndpoint(): void;
    get grpcEndpointInput(): GoogleNetworkSecurityClientTlsPolicyClientCertificateGrpcEndpoint | undefined;
}
export interface GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance {
    /**
    * Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#plugin_instance GoogleNetworkSecurityClientTlsPolicy#plugin_instance}
    */
    readonly pluginInstance: string;
}
export declare function googleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstanceToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstanceOutputReference | GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance): any;
export declare function googleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstanceToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstanceOutputReference | GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance): any;
export declare class GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance | undefined);
    private _pluginInstance?;
    get pluginInstance(): string;
    set pluginInstance(value: string);
    get pluginInstanceInput(): string | undefined;
}
export interface GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint {
    /**
    * The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#target_uri GoogleNetworkSecurityClientTlsPolicy#target_uri}
    */
    readonly targetUri: string;
}
export declare function googleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpointToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpointOutputReference | GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint): any;
export declare function googleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpointToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpointOutputReference | GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint): any;
export declare class GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint | undefined);
    private _targetUri?;
    get targetUri(): string;
    set targetUri(value: string);
    get targetUriInput(): string | undefined;
}
export interface GoogleNetworkSecurityClientTlsPolicyServerValidationCa {
    /**
    * certificate_provider_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#certificate_provider_instance GoogleNetworkSecurityClientTlsPolicy#certificate_provider_instance}
    */
    readonly certificateProviderInstance?: GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance;
    /**
    * grpc_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#grpc_endpoint GoogleNetworkSecurityClientTlsPolicy#grpc_endpoint}
    */
    readonly grpcEndpoint?: GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint;
}
export declare function googleNetworkSecurityClientTlsPolicyServerValidationCaToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyServerValidationCa | cdktf.IResolvable): any;
export declare function googleNetworkSecurityClientTlsPolicyServerValidationCaToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyServerValidationCa | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityClientTlsPolicyServerValidationCaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyServerValidationCa | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyServerValidationCa | cdktf.IResolvable | undefined);
    private _certificateProviderInstance;
    get certificateProviderInstance(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstanceOutputReference;
    putCertificateProviderInstance(value: GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance): void;
    resetCertificateProviderInstance(): void;
    get certificateProviderInstanceInput(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaCertificateProviderInstance | undefined;
    private _grpcEndpoint;
    get grpcEndpoint(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpointOutputReference;
    putGrpcEndpoint(value: GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint): void;
    resetGrpcEndpoint(): void;
    get grpcEndpointInput(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaGrpcEndpoint | undefined;
}
export declare class GoogleNetworkSecurityClientTlsPolicyServerValidationCaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecurityClientTlsPolicyServerValidationCa[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecurityClientTlsPolicyServerValidationCaOutputReference;
}
export interface GoogleNetworkSecurityClientTlsPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#create GoogleNetworkSecurityClientTlsPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#delete GoogleNetworkSecurityClientTlsPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#update GoogleNetworkSecurityClientTlsPolicy#update}
    */
    readonly update?: string;
}
export declare function googleNetworkSecurityClientTlsPolicyTimeoutsToTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkSecurityClientTlsPolicyTimeoutsToHclTerraform(struct?: GoogleNetworkSecurityClientTlsPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityClientTlsPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityClientTlsPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityClientTlsPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy google_network_security_client_tls_policy}
*/
export declare class GoogleNetworkSecurityClientTlsPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_security_client_tls_policy";
    /**
    * Generates CDKTF code for importing a GoogleNetworkSecurityClientTlsPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkSecurityClientTlsPolicy to import
    * @param importFromId The id of the existing GoogleNetworkSecurityClientTlsPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkSecurityClientTlsPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_client_tls_policy google_network_security_client_tls_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkSecurityClientTlsPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkSecurityClientTlsPolicyConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sni?;
    get sni(): string;
    set sni(value: string);
    resetSni(): void;
    get sniInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _clientCertificate;
    get clientCertificate(): GoogleNetworkSecurityClientTlsPolicyClientCertificateOutputReference;
    putClientCertificate(value: GoogleNetworkSecurityClientTlsPolicyClientCertificate): void;
    resetClientCertificate(): void;
    get clientCertificateInput(): GoogleNetworkSecurityClientTlsPolicyClientCertificate | undefined;
    private _serverValidationCa;
    get serverValidationCa(): GoogleNetworkSecurityClientTlsPolicyServerValidationCaList;
    putServerValidationCa(value: GoogleNetworkSecurityClientTlsPolicyServerValidationCa[] | cdktf.IResolvable): void;
    resetServerValidationCa(): void;
    get serverValidationCaInput(): cdktf.IResolvable | GoogleNetworkSecurityClientTlsPolicyServerValidationCa[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkSecurityClientTlsPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkSecurityClientTlsPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkSecurityClientTlsPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
