/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkSecurityFirewallEndpointAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URL of the firewall endpoint that is being associated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#firewall_endpoint GoogleNetworkSecurityFirewallEndpointAssociation#firewall_endpoint}
    */
    readonly firewallEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#id GoogleNetworkSecurityFirewallEndpointAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A map of key/value label pairs to assign to the resource.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#labels GoogleNetworkSecurityFirewallEndpointAssociation#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location (zone) of the firewall endpoint association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#location GoogleNetworkSecurityFirewallEndpointAssociation#location}
    */
    readonly location: string;
    /**
    * The name of the firewall endpoint association resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#name GoogleNetworkSecurityFirewallEndpointAssociation#name}
    */
    readonly name: string;
    /**
    * The URL of the network that is being associated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#network GoogleNetworkSecurityFirewallEndpointAssociation#network}
    */
    readonly network: string;
    /**
    * The name of the parent this firewall endpoint association belongs to.
    * Format: projects/{project_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#parent GoogleNetworkSecurityFirewallEndpointAssociation#parent}
    */
    readonly parent?: string;
    /**
    * The URL of the TlsInspectionPolicy that is being associated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#tls_inspection_policy GoogleNetworkSecurityFirewallEndpointAssociation#tls_inspection_policy}
    */
    readonly tlsInspectionPolicy?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#timeouts GoogleNetworkSecurityFirewallEndpointAssociation#timeouts}
    */
    readonly timeouts?: GoogleNetworkSecurityFirewallEndpointAssociationTimeouts;
}
export interface GoogleNetworkSecurityFirewallEndpointAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#create GoogleNetworkSecurityFirewallEndpointAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#delete GoogleNetworkSecurityFirewallEndpointAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#update GoogleNetworkSecurityFirewallEndpointAssociation#update}
    */
    readonly update?: string;
}
export declare function googleNetworkSecurityFirewallEndpointAssociationTimeoutsToTerraform(struct?: GoogleNetworkSecurityFirewallEndpointAssociationTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkSecurityFirewallEndpointAssociationTimeoutsToHclTerraform(struct?: GoogleNetworkSecurityFirewallEndpointAssociationTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityFirewallEndpointAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityFirewallEndpointAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityFirewallEndpointAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association google_network_security_firewall_endpoint_association}
*/
export declare class GoogleNetworkSecurityFirewallEndpointAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_security_firewall_endpoint_association";
    /**
    * Generates CDKTF code for importing a GoogleNetworkSecurityFirewallEndpointAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkSecurityFirewallEndpointAssociation to import
    * @param importFromId The id of the existing GoogleNetworkSecurityFirewallEndpointAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkSecurityFirewallEndpointAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint_association google_network_security_firewall_endpoint_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkSecurityFirewallEndpointAssociationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkSecurityFirewallEndpointAssociationConfig);
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _firewallEndpoint?;
    get firewallEndpoint(): string;
    set firewallEndpoint(value: string);
    get firewallEndpointInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get selfLink(): string;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _tlsInspectionPolicy?;
    get tlsInspectionPolicy(): string;
    set tlsInspectionPolicy(value: string);
    resetTlsInspectionPolicy(): void;
    get tlsInspectionPolicyInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleNetworkSecurityFirewallEndpointAssociationTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkSecurityFirewallEndpointAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkSecurityFirewallEndpointAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
