/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkSecurityFirewallEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#id GoogleNetworkSecurityFirewallEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A map of key/value label pairs to assign to the resource.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#labels GoogleNetworkSecurityFirewallEndpoint#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location (zone) of the firewall endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#location GoogleNetworkSecurityFirewallEndpoint#location}
    */
    readonly location: string;
    /**
    * The name of the firewall endpoint resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#name GoogleNetworkSecurityFirewallEndpoint#name}
    */
    readonly name: string;
    /**
    * The name of the parent this firewall endpoint belongs to.
    * Format: organizations/{organization_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#parent GoogleNetworkSecurityFirewallEndpoint#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#timeouts GoogleNetworkSecurityFirewallEndpoint#timeouts}
    */
    readonly timeouts?: GoogleNetworkSecurityFirewallEndpointTimeouts;
}
export interface GoogleNetworkSecurityFirewallEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#create GoogleNetworkSecurityFirewallEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#delete GoogleNetworkSecurityFirewallEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#update GoogleNetworkSecurityFirewallEndpoint#update}
    */
    readonly update?: string;
}
export declare function googleNetworkSecurityFirewallEndpointTimeoutsToTerraform(struct?: GoogleNetworkSecurityFirewallEndpointTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkSecurityFirewallEndpointTimeoutsToHclTerraform(struct?: GoogleNetworkSecurityFirewallEndpointTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityFirewallEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityFirewallEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityFirewallEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint google_network_security_firewall_endpoint}
*/
export declare class GoogleNetworkSecurityFirewallEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_security_firewall_endpoint";
    /**
    * Generates CDKTF code for importing a GoogleNetworkSecurityFirewallEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkSecurityFirewallEndpoint to import
    * @param importFromId The id of the existing GoogleNetworkSecurityFirewallEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkSecurityFirewallEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_firewall_endpoint google_network_security_firewall_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkSecurityFirewallEndpointConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkSecurityFirewallEndpointConfig);
    get associatedNetworks(): string[];
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get selfLink(): string;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleNetworkSecurityFirewallEndpointTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkSecurityFirewallEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkSecurityFirewallEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
