/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkSecuritySecurityProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of the security profile. The Max length is 512 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#description GoogleNetworkSecuritySecurityProfile#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#id GoogleNetworkSecuritySecurityProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A map of key/value label pairs to assign to the resource.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#labels GoogleNetworkSecuritySecurityProfile#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the security profile.
    * The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#location GoogleNetworkSecuritySecurityProfile#location}
    */
    readonly location?: string;
    /**
    * The name of the security profile resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#name GoogleNetworkSecuritySecurityProfile#name}
    */
    readonly name: string;
    /**
    * The name of the parent this security profile belongs to.
    * Format: organizations/{organization_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#parent GoogleNetworkSecuritySecurityProfile#parent}
    */
    readonly parent?: string;
    /**
    * The type of security profile. Possible values: ["THREAT_PREVENTION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#type GoogleNetworkSecuritySecurityProfile#type}
    */
    readonly type: string;
    /**
    * threat_prevention_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#threat_prevention_profile GoogleNetworkSecuritySecurityProfile#threat_prevention_profile}
    */
    readonly threatPreventionProfile?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#timeouts GoogleNetworkSecuritySecurityProfile#timeouts}
    */
    readonly timeouts?: GoogleNetworkSecuritySecurityProfileTimeouts;
}
export interface GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides {
    /**
    * Threat action override. Possible values: ["ALERT", "ALLOW", "DEFAULT_ACTION", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#action GoogleNetworkSecuritySecurityProfile#action}
    */
    readonly action: string;
    /**
    * Severity level to match. Possible values: ["CRITICAL", "HIGH", "INFORMATIONAL", "LOW", "MEDIUM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#severity GoogleNetworkSecuritySecurityProfile#severity}
    */
    readonly severity: string;
}
export declare function googleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverridesToTerraform(struct?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides | cdktf.IResolvable): any;
export declare function googleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverridesToHclTerraform(struct?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides | cdktf.IResolvable): any;
export declare class GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
}
export declare class GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverridesOutputReference;
}
export interface GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides {
    /**
    * Threat action. Possible values: ["ALERT", "ALLOW", "DEFAULT_ACTION", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#action GoogleNetworkSecuritySecurityProfile#action}
    */
    readonly action: string;
    /**
    * Vendor-specific ID of a threat to override.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#threat_id GoogleNetworkSecuritySecurityProfile#threat_id}
    */
    readonly threatId: string;
}
export declare function googleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverridesToTerraform(struct?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides | cdktf.IResolvable): any;
export declare function googleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverridesToHclTerraform(struct?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides | cdktf.IResolvable): any;
export declare class GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _threatId?;
    get threatId(): string;
    set threatId(value: string);
    get threatIdInput(): string | undefined;
    get type(): string;
}
export declare class GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverridesOutputReference;
}
export interface GoogleNetworkSecuritySecurityProfileThreatPreventionProfile {
    /**
    * severity_overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#severity_overrides GoogleNetworkSecuritySecurityProfile#severity_overrides}
    */
    readonly severityOverrides?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides[] | cdktf.IResolvable;
    /**
    * threat_overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#threat_overrides GoogleNetworkSecuritySecurityProfile#threat_overrides}
    */
    readonly threatOverrides?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides[] | cdktf.IResolvable;
}
export declare function googleNetworkSecuritySecurityProfileThreatPreventionProfileToTerraform(struct?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileOutputReference | GoogleNetworkSecuritySecurityProfileThreatPreventionProfile): any;
export declare function googleNetworkSecuritySecurityProfileThreatPreventionProfileToHclTerraform(struct?: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileOutputReference | GoogleNetworkSecuritySecurityProfileThreatPreventionProfile): any;
export declare class GoogleNetworkSecuritySecurityProfileThreatPreventionProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfile | undefined;
    set internalValue(value: GoogleNetworkSecuritySecurityProfileThreatPreventionProfile | undefined);
    private _severityOverrides;
    get severityOverrides(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverridesList;
    putSeverityOverrides(value: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides[] | cdktf.IResolvable): void;
    resetSeverityOverrides(): void;
    get severityOverridesInput(): cdktf.IResolvable | GoogleNetworkSecuritySecurityProfileThreatPreventionProfileSeverityOverrides[] | undefined;
    private _threatOverrides;
    get threatOverrides(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverridesList;
    putThreatOverrides(value: GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides[] | cdktf.IResolvable): void;
    resetThreatOverrides(): void;
    get threatOverridesInput(): cdktf.IResolvable | GoogleNetworkSecuritySecurityProfileThreatPreventionProfileThreatOverrides[] | undefined;
}
export interface GoogleNetworkSecuritySecurityProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#create GoogleNetworkSecuritySecurityProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#delete GoogleNetworkSecuritySecurityProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#update GoogleNetworkSecuritySecurityProfile#update}
    */
    readonly update?: string;
}
export declare function googleNetworkSecuritySecurityProfileTimeoutsToTerraform(struct?: GoogleNetworkSecuritySecurityProfileTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkSecuritySecurityProfileTimeoutsToHclTerraform(struct?: GoogleNetworkSecuritySecurityProfileTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkSecuritySecurityProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecuritySecurityProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecuritySecurityProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile google_network_security_security_profile}
*/
export declare class GoogleNetworkSecuritySecurityProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_security_security_profile";
    /**
    * Generates CDKTF code for importing a GoogleNetworkSecuritySecurityProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkSecuritySecurityProfile to import
    * @param importFromId The id of the existing GoogleNetworkSecuritySecurityProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkSecuritySecurityProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_security_profile google_network_security_security_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkSecuritySecurityProfileConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkSecuritySecurityProfileConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _threatPreventionProfile;
    get threatPreventionProfile(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfileOutputReference;
    putThreatPreventionProfile(value: GoogleNetworkSecuritySecurityProfileThreatPreventionProfile): void;
    resetThreatPreventionProfile(): void;
    get threatPreventionProfileInput(): GoogleNetworkSecuritySecurityProfileThreatPreventionProfile | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkSecuritySecurityProfileTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkSecuritySecurityProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkSecuritySecurityProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
