/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkSecurityServerTlsPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * This field applies only for Traffic Director policies. It is must be set to false for external HTTPS load balancer policies.
    * Determines if server allows plaintext connections. If set to true, server allows plain text connections. By default, it is set to false. This setting is not exclusive of other encryption modes. For example, if allowOpen and mtlsPolicy are set, server allows both plain text and mTLS connections. See documentation of other encryption modes to confirm compatibility.
    * Consider using it if you wish to upgrade in place your deployment to TLS while having mixed TLS and non-TLS traffic reaching port :80.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#allow_open GoogleNetworkSecurityServerTlsPolicy#allow_open}
    */
    readonly allowOpen?: boolean | cdktf.IResolvable;
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#description GoogleNetworkSecurityServerTlsPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#id GoogleNetworkSecurityServerTlsPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the ServerTlsPolicy resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#labels GoogleNetworkSecurityServerTlsPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the server tls policy.
    * The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#location GoogleNetworkSecurityServerTlsPolicy#location}
    */
    readonly location?: string;
    /**
    * Name of the ServerTlsPolicy resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#name GoogleNetworkSecurityServerTlsPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#project GoogleNetworkSecurityServerTlsPolicy#project}
    */
    readonly project?: string;
    /**
    * mtls_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#mtls_policy GoogleNetworkSecurityServerTlsPolicy#mtls_policy}
    */
    readonly mtlsPolicy?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicy;
    /**
    * server_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#server_certificate GoogleNetworkSecurityServerTlsPolicy#server_certificate}
    */
    readonly serverCertificate?: GoogleNetworkSecurityServerTlsPolicyServerCertificate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#timeouts GoogleNetworkSecurityServerTlsPolicy#timeouts}
    */
    readonly timeouts?: GoogleNetworkSecurityServerTlsPolicyTimeouts;
}
export interface GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance {
    /**
    * Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#plugin_instance GoogleNetworkSecurityServerTlsPolicy#plugin_instance}
    */
    readonly pluginInstance: string;
}
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceOutputReference | GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance): any;
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceOutputReference | GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance): any;
export declare class GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance | undefined);
    private _pluginInstance?;
    get pluginInstance(): string;
    set pluginInstance(value: string);
    get pluginInstanceInput(): string | undefined;
}
export interface GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint {
    /**
    * The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#target_uri GoogleNetworkSecurityServerTlsPolicy#target_uri}
    */
    readonly targetUri: string;
}
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointOutputReference | GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint): any;
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointOutputReference | GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint): any;
export declare class GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint | undefined);
    private _targetUri?;
    get targetUri(): string;
    set targetUri(value: string);
    get targetUriInput(): string | undefined;
}
export interface GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa {
    /**
    * certificate_provider_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#certificate_provider_instance GoogleNetworkSecurityServerTlsPolicy#certificate_provider_instance}
    */
    readonly certificateProviderInstance?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance;
    /**
    * grpc_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#grpc_endpoint GoogleNetworkSecurityServerTlsPolicy#grpc_endpoint}
    */
    readonly grpcEndpoint?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint;
}
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa | cdktf.IResolvable): any;
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa | cdktf.IResolvable | undefined);
    private _certificateProviderInstance;
    get certificateProviderInstance(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstanceOutputReference;
    putCertificateProviderInstance(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance): void;
    resetCertificateProviderInstance(): void;
    get certificateProviderInstanceInput(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaCertificateProviderInstance | undefined;
    private _grpcEndpoint;
    get grpcEndpoint(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpointOutputReference;
    putGrpcEndpoint(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint): void;
    resetGrpcEndpoint(): void;
    get grpcEndpointInput(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaGrpcEndpoint | undefined;
}
export declare class GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaOutputReference;
}
export interface GoogleNetworkSecurityServerTlsPolicyMtlsPolicy {
    /**
    * When the client presents an invalid certificate or no certificate to the load balancer, the clientValidationMode specifies how the client connection is handled.
    * Required if the policy is to be used with the external HTTPS load balancing. For Traffic Director it must be empty. Possible values: ["CLIENT_VALIDATION_MODE_UNSPECIFIED", "ALLOW_INVALID_OR_MISSING_CLIENT_CERT", "REJECT_INVALID"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#client_validation_mode GoogleNetworkSecurityServerTlsPolicy#client_validation_mode}
    */
    readonly clientValidationMode?: string;
    /**
    * Reference to the TrustConfig from certificatemanager.googleapis.com namespace.
    * If specified, the chain validation will be performed against certificates configured in the given TrustConfig.
    * Allowed only if the policy is to be used with external HTTPS load balancers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#client_validation_trust_config GoogleNetworkSecurityServerTlsPolicy#client_validation_trust_config}
    */
    readonly clientValidationTrustConfig?: string;
    /**
    * client_validation_ca block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#client_validation_ca GoogleNetworkSecurityServerTlsPolicy#client_validation_ca}
    */
    readonly clientValidationCa?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa[] | cdktf.IResolvable;
}
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyOutputReference | GoogleNetworkSecurityServerTlsPolicyMtlsPolicy): any;
export declare function googleNetworkSecurityServerTlsPolicyMtlsPolicyToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyOutputReference | GoogleNetworkSecurityServerTlsPolicyMtlsPolicy): any;
export declare class GoogleNetworkSecurityServerTlsPolicyMtlsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicy | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicy | undefined);
    private _clientValidationMode?;
    get clientValidationMode(): string;
    set clientValidationMode(value: string);
    resetClientValidationMode(): void;
    get clientValidationModeInput(): string | undefined;
    private _clientValidationTrustConfig?;
    get clientValidationTrustConfig(): string;
    set clientValidationTrustConfig(value: string);
    resetClientValidationTrustConfig(): void;
    get clientValidationTrustConfigInput(): string | undefined;
    private _clientValidationCa;
    get clientValidationCa(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCaList;
    putClientValidationCa(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa[] | cdktf.IResolvable): void;
    resetClientValidationCa(): void;
    get clientValidationCaInput(): cdktf.IResolvable | GoogleNetworkSecurityServerTlsPolicyMtlsPolicyClientValidationCa[] | undefined;
}
export interface GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance {
    /**
    * Plugin instance name, used to locate and load CertificateProvider instance configuration. Set to "google_cloud_private_spiffe" to use Certificate Authority Service certificate provider instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#plugin_instance GoogleNetworkSecurityServerTlsPolicy#plugin_instance}
    */
    readonly pluginInstance: string;
}
export declare function googleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstanceToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstanceOutputReference | GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance): any;
export declare function googleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstanceToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstanceOutputReference | GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance): any;
export declare class GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance | undefined);
    private _pluginInstance?;
    get pluginInstance(): string;
    set pluginInstance(value: string);
    get pluginInstanceInput(): string | undefined;
}
export interface GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint {
    /**
    * The target URI of the gRPC endpoint. Only UDS path is supported, and should start with "unix:".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#target_uri GoogleNetworkSecurityServerTlsPolicy#target_uri}
    */
    readonly targetUri: string;
}
export declare function googleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpointToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpointOutputReference | GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint): any;
export declare function googleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpointToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpointOutputReference | GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint): any;
export declare class GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint | undefined);
    private _targetUri?;
    get targetUri(): string;
    set targetUri(value: string);
    get targetUriInput(): string | undefined;
}
export interface GoogleNetworkSecurityServerTlsPolicyServerCertificate {
    /**
    * certificate_provider_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#certificate_provider_instance GoogleNetworkSecurityServerTlsPolicy#certificate_provider_instance}
    */
    readonly certificateProviderInstance?: GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance;
    /**
    * grpc_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#grpc_endpoint GoogleNetworkSecurityServerTlsPolicy#grpc_endpoint}
    */
    readonly grpcEndpoint?: GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint;
}
export declare function googleNetworkSecurityServerTlsPolicyServerCertificateToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyServerCertificateOutputReference | GoogleNetworkSecurityServerTlsPolicyServerCertificate): any;
export declare function googleNetworkSecurityServerTlsPolicyServerCertificateToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyServerCertificateOutputReference | GoogleNetworkSecurityServerTlsPolicyServerCertificate): any;
export declare class GoogleNetworkSecurityServerTlsPolicyServerCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyServerCertificate | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyServerCertificate | undefined);
    private _certificateProviderInstance;
    get certificateProviderInstance(): GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstanceOutputReference;
    putCertificateProviderInstance(value: GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance): void;
    resetCertificateProviderInstance(): void;
    get certificateProviderInstanceInput(): GoogleNetworkSecurityServerTlsPolicyServerCertificateCertificateProviderInstance | undefined;
    private _grpcEndpoint;
    get grpcEndpoint(): GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpointOutputReference;
    putGrpcEndpoint(value: GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint): void;
    resetGrpcEndpoint(): void;
    get grpcEndpointInput(): GoogleNetworkSecurityServerTlsPolicyServerCertificateGrpcEndpoint | undefined;
}
export interface GoogleNetworkSecurityServerTlsPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#create GoogleNetworkSecurityServerTlsPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#delete GoogleNetworkSecurityServerTlsPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#update GoogleNetworkSecurityServerTlsPolicy#update}
    */
    readonly update?: string;
}
export declare function googleNetworkSecurityServerTlsPolicyTimeoutsToTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkSecurityServerTlsPolicyTimeoutsToHclTerraform(struct?: GoogleNetworkSecurityServerTlsPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkSecurityServerTlsPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkSecurityServerTlsPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkSecurityServerTlsPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy google_network_security_server_tls_policy}
*/
export declare class GoogleNetworkSecurityServerTlsPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_security_server_tls_policy";
    /**
    * Generates CDKTF code for importing a GoogleNetworkSecurityServerTlsPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkSecurityServerTlsPolicy to import
    * @param importFromId The id of the existing GoogleNetworkSecurityServerTlsPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkSecurityServerTlsPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_security_server_tls_policy google_network_security_server_tls_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkSecurityServerTlsPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkSecurityServerTlsPolicyConfig);
    private _allowOpen?;
    get allowOpen(): boolean | cdktf.IResolvable;
    set allowOpen(value: boolean | cdktf.IResolvable);
    resetAllowOpen(): void;
    get allowOpenInput(): boolean | cdktf.IResolvable | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _mtlsPolicy;
    get mtlsPolicy(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicyOutputReference;
    putMtlsPolicy(value: GoogleNetworkSecurityServerTlsPolicyMtlsPolicy): void;
    resetMtlsPolicy(): void;
    get mtlsPolicyInput(): GoogleNetworkSecurityServerTlsPolicyMtlsPolicy | undefined;
    private _serverCertificate;
    get serverCertificate(): GoogleNetworkSecurityServerTlsPolicyServerCertificateOutputReference;
    putServerCertificate(value: GoogleNetworkSecurityServerTlsPolicyServerCertificate): void;
    resetServerCertificate(): void;
    get serverCertificateInput(): GoogleNetworkSecurityServerTlsPolicyServerCertificate | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkSecurityServerTlsPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkSecurityServerTlsPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkSecurityServerTlsPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
