/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesEdgeCacheKeysetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#description GoogleNetworkServicesEdgeCacheKeyset#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#id GoogleNetworkServicesEdgeCacheKeyset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the EdgeCache resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#labels GoogleNetworkServicesEdgeCacheKeyset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource; provided by the client when the resource is created.
    * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
    * and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#name GoogleNetworkServicesEdgeCacheKeyset#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#project GoogleNetworkServicesEdgeCacheKeyset#project}
    */
    readonly project?: string;
    /**
    * public_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#public_key GoogleNetworkServicesEdgeCacheKeyset#public_key}
    */
    readonly publicKey?: GoogleNetworkServicesEdgeCacheKeysetPublicKey[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#timeouts GoogleNetworkServicesEdgeCacheKeyset#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesEdgeCacheKeysetTimeouts;
    /**
    * validation_shared_keys block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#validation_shared_keys GoogleNetworkServicesEdgeCacheKeyset#validation_shared_keys}
    */
    readonly validationSharedKeys?: GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys[] | cdktf.IResolvable;
}
export interface GoogleNetworkServicesEdgeCacheKeysetPublicKey {
    /**
    * The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
    * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
    * which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#id GoogleNetworkServicesEdgeCacheKeyset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Set to true to have the CDN automatically manage this public key value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#managed GoogleNetworkServicesEdgeCacheKeyset#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
    * The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
    * Representations or encodings of the public key other than this will be rejected with an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#value GoogleNetworkServicesEdgeCacheKeyset#value}
    */
    readonly value?: string;
}
export declare function googleNetworkServicesEdgeCacheKeysetPublicKeyToTerraform(struct?: GoogleNetworkServicesEdgeCacheKeysetPublicKey | cdktf.IResolvable): any;
export declare function googleNetworkServicesEdgeCacheKeysetPublicKeyToHclTerraform(struct?: GoogleNetworkServicesEdgeCacheKeysetPublicKey | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesEdgeCacheKeysetPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesEdgeCacheKeysetPublicKey | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesEdgeCacheKeysetPublicKey | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleNetworkServicesEdgeCacheKeysetPublicKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesEdgeCacheKeysetPublicKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesEdgeCacheKeysetPublicKeyOutputReference;
}
export interface GoogleNetworkServicesEdgeCacheKeysetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#create GoogleNetworkServicesEdgeCacheKeyset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#delete GoogleNetworkServicesEdgeCacheKeyset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#update GoogleNetworkServicesEdgeCacheKeyset#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesEdgeCacheKeysetTimeoutsToTerraform(struct?: GoogleNetworkServicesEdgeCacheKeysetTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesEdgeCacheKeysetTimeoutsToHclTerraform(struct?: GoogleNetworkServicesEdgeCacheKeysetTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesEdgeCacheKeysetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesEdgeCacheKeysetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesEdgeCacheKeysetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys {
    /**
    * The name of the secret version in Secret Manager.
    *
    * The resource name of the secret version must be in the format 'projects/* /secrets/* /versions/*' where the '*' values are replaced by the secrets themselves.
    * The secrets must be at least 16 bytes large.  The recommended secret size depends on the signature algorithm you are using.
    * * If you are using HMAC-SHA1, we suggest 20-byte secrets.
    * * If you are using HMAC-SHA256, we suggest 32-byte secrets.
    * See RFC 2104, Section 3 for more details on these recommendations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#secret_version GoogleNetworkServicesEdgeCacheKeyset#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleNetworkServicesEdgeCacheKeysetValidationSharedKeysToTerraform(struct?: GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys | cdktf.IResolvable): any;
export declare function googleNetworkServicesEdgeCacheKeysetValidationSharedKeysToHclTerraform(struct?: GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys | cdktf.IResolvable | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export declare class GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeysOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset google_network_services_edge_cache_keyset}
*/
export declare class GoogleNetworkServicesEdgeCacheKeyset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_edge_cache_keyset";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesEdgeCacheKeyset resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesEdgeCacheKeyset to import
    * @param importFromId The id of the existing GoogleNetworkServicesEdgeCacheKeyset that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesEdgeCacheKeyset to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_edge_cache_keyset google_network_services_edge_cache_keyset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesEdgeCacheKeysetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesEdgeCacheKeysetConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _publicKey;
    get publicKey(): GoogleNetworkServicesEdgeCacheKeysetPublicKeyList;
    putPublicKey(value: GoogleNetworkServicesEdgeCacheKeysetPublicKey[] | cdktf.IResolvable): void;
    resetPublicKey(): void;
    get publicKeyInput(): cdktf.IResolvable | GoogleNetworkServicesEdgeCacheKeysetPublicKey[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesEdgeCacheKeysetTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesEdgeCacheKeysetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesEdgeCacheKeysetTimeouts | undefined;
    private _validationSharedKeys;
    get validationSharedKeys(): GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeysList;
    putValidationSharedKeys(value: GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys[] | cdktf.IResolvable): void;
    resetValidationSharedKeys(): void;
    get validationSharedKeysInput(): cdktf.IResolvable | GoogleNetworkServicesEdgeCacheKeysetValidationSharedKeys[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
