/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesEndpointPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic at the matched endpoints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#authorization_policy GoogleNetworkServicesEndpointPolicy#authorization_policy}
    */
    readonly authorizationPolicy?: string;
    /**
    * A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from the proxy to the actual endpoints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#client_tls_policy GoogleNetworkServicesEndpointPolicy#client_tls_policy}
    */
    readonly clientTlsPolicy?: string;
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#description GoogleNetworkServicesEndpointPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#id GoogleNetworkServicesEndpointPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the TcpRoute resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#labels GoogleNetworkServicesEndpointPolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the EndpointPolicy resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#name GoogleNetworkServicesEndpointPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#project GoogleNetworkServicesEndpointPolicy#project}
    */
    readonly project?: string;
    /**
    * A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be applied to terminate the inbound traffic at the identified backends.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#server_tls_policy GoogleNetworkServicesEndpointPolicy#server_tls_policy}
    */
    readonly serverTlsPolicy?: string;
    /**
    * The type of endpoint policy. This is primarily used to validate the configuration. Possible values: ["SIDECAR_PROXY", "GRPC_SERVER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#type GoogleNetworkServicesEndpointPolicy#type}
    */
    readonly type: string;
    /**
    * endpoint_matcher block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#endpoint_matcher GoogleNetworkServicesEndpointPolicy#endpoint_matcher}
    */
    readonly endpointMatcher: GoogleNetworkServicesEndpointPolicyEndpointMatcher;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#timeouts GoogleNetworkServicesEndpointPolicy#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesEndpointPolicyTimeouts;
    /**
    * traffic_port_selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#traffic_port_selector GoogleNetworkServicesEndpointPolicy#traffic_port_selector}
    */
    readonly trafficPortSelector?: GoogleNetworkServicesEndpointPolicyTrafficPortSelector;
}
export interface GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels {
    /**
    * Required. Label name presented as key in xDS Node Metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#label_name GoogleNetworkServicesEndpointPolicy#label_name}
    */
    readonly labelName: string;
    /**
    * Required. Label value presented as value corresponding to the above key, in xDS Node Metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#label_value GoogleNetworkServicesEndpointPolicy#label_value}
    */
    readonly labelValue: string;
}
export declare function googleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelsToTerraform(struct?: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels | cdktf.IResolvable): any;
export declare function googleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelsToHclTerraform(struct?: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels | cdktf.IResolvable | undefined);
    private _labelName?;
    get labelName(): string;
    set labelName(value: string);
    get labelNameInput(): string | undefined;
    private _labelValue?;
    get labelValue(): string;
    set labelValue(value: string);
    get labelValueInput(): string | undefined;
}
export declare class GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelsOutputReference;
}
export interface GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher {
    /**
    * Specifies how matching should be done. Possible values: ["MATCH_ANY", "MATCH_ALL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#metadata_label_match_criteria GoogleNetworkServicesEndpointPolicy#metadata_label_match_criteria}
    */
    readonly metadataLabelMatchCriteria: string;
    /**
    * metadata_labels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#metadata_labels GoogleNetworkServicesEndpointPolicy#metadata_labels}
    */
    readonly metadataLabels?: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherToTerraform(struct?: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherOutputReference | GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher): any;
export declare function googleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherToHclTerraform(struct?: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherOutputReference | GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher): any;
export declare class GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher | undefined;
    set internalValue(value: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher | undefined);
    private _metadataLabelMatchCriteria?;
    get metadataLabelMatchCriteria(): string;
    set metadataLabelMatchCriteria(value: string);
    get metadataLabelMatchCriteriaInput(): string | undefined;
    private _metadataLabels;
    get metadataLabels(): GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelsList;
    putMetadataLabels(value: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels[] | cdktf.IResolvable): void;
    resetMetadataLabels(): void;
    get metadataLabelsInput(): cdktf.IResolvable | GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabels[] | undefined;
}
export interface GoogleNetworkServicesEndpointPolicyEndpointMatcher {
    /**
    * metadata_label_matcher block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#metadata_label_matcher GoogleNetworkServicesEndpointPolicy#metadata_label_matcher}
    */
    readonly metadataLabelMatcher: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher;
}
export declare function googleNetworkServicesEndpointPolicyEndpointMatcherToTerraform(struct?: GoogleNetworkServicesEndpointPolicyEndpointMatcherOutputReference | GoogleNetworkServicesEndpointPolicyEndpointMatcher): any;
export declare function googleNetworkServicesEndpointPolicyEndpointMatcherToHclTerraform(struct?: GoogleNetworkServicesEndpointPolicyEndpointMatcherOutputReference | GoogleNetworkServicesEndpointPolicyEndpointMatcher): any;
export declare class GoogleNetworkServicesEndpointPolicyEndpointMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesEndpointPolicyEndpointMatcher | undefined;
    set internalValue(value: GoogleNetworkServicesEndpointPolicyEndpointMatcher | undefined);
    private _metadataLabelMatcher;
    get metadataLabelMatcher(): GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcherOutputReference;
    putMetadataLabelMatcher(value: GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher): void;
    get metadataLabelMatcherInput(): GoogleNetworkServicesEndpointPolicyEndpointMatcherMetadataLabelMatcher | undefined;
}
export interface GoogleNetworkServicesEndpointPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#create GoogleNetworkServicesEndpointPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#delete GoogleNetworkServicesEndpointPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#update GoogleNetworkServicesEndpointPolicy#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesEndpointPolicyTimeoutsToTerraform(struct?: GoogleNetworkServicesEndpointPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesEndpointPolicyTimeoutsToHclTerraform(struct?: GoogleNetworkServicesEndpointPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesEndpointPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesEndpointPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesEndpointPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleNetworkServicesEndpointPolicyTrafficPortSelector {
    /**
    * List of ports. Can be port numbers or port range (example, [80-90] specifies all ports from 80 to 90, including 80 and 90) or named ports or * to specify all ports. If the list is empty, all ports are selected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#ports GoogleNetworkServicesEndpointPolicy#ports}
    */
    readonly ports: string[];
}
export declare function googleNetworkServicesEndpointPolicyTrafficPortSelectorToTerraform(struct?: GoogleNetworkServicesEndpointPolicyTrafficPortSelectorOutputReference | GoogleNetworkServicesEndpointPolicyTrafficPortSelector): any;
export declare function googleNetworkServicesEndpointPolicyTrafficPortSelectorToHclTerraform(struct?: GoogleNetworkServicesEndpointPolicyTrafficPortSelectorOutputReference | GoogleNetworkServicesEndpointPolicyTrafficPortSelector): any;
export declare class GoogleNetworkServicesEndpointPolicyTrafficPortSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesEndpointPolicyTrafficPortSelector | undefined;
    set internalValue(value: GoogleNetworkServicesEndpointPolicyTrafficPortSelector | undefined);
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    get portsInput(): string[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy google_network_services_endpoint_policy}
*/
export declare class GoogleNetworkServicesEndpointPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_endpoint_policy";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesEndpointPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesEndpointPolicy to import
    * @param importFromId The id of the existing GoogleNetworkServicesEndpointPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesEndpointPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_endpoint_policy google_network_services_endpoint_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesEndpointPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesEndpointPolicyConfig);
    private _authorizationPolicy?;
    get authorizationPolicy(): string;
    set authorizationPolicy(value: string);
    resetAuthorizationPolicy(): void;
    get authorizationPolicyInput(): string | undefined;
    private _clientTlsPolicy?;
    get clientTlsPolicy(): string;
    set clientTlsPolicy(value: string);
    resetClientTlsPolicy(): void;
    get clientTlsPolicyInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serverTlsPolicy?;
    get serverTlsPolicy(): string;
    set serverTlsPolicy(value: string);
    resetServerTlsPolicy(): void;
    get serverTlsPolicyInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _endpointMatcher;
    get endpointMatcher(): GoogleNetworkServicesEndpointPolicyEndpointMatcherOutputReference;
    putEndpointMatcher(value: GoogleNetworkServicesEndpointPolicyEndpointMatcher): void;
    get endpointMatcherInput(): GoogleNetworkServicesEndpointPolicyEndpointMatcher | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesEndpointPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesEndpointPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesEndpointPolicyTimeouts | undefined;
    private _trafficPortSelector;
    get trafficPortSelector(): GoogleNetworkServicesEndpointPolicyTrafficPortSelectorOutputReference;
    putTrafficPortSelector(value: GoogleNetworkServicesEndpointPolicyTrafficPortSelector): void;
    resetTrafficPortSelector(): void;
    get trafficPortSelectorInput(): GoogleNetworkServicesEndpointPolicyTrafficPortSelector | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
