/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Zero or one IPv4-address on which the Gateway will receive the traffic. When no address is provided,
    * an IP from the subnetwork is allocated This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
    * Gateways of type 'OPEN_MESH' listen on 0.0.0.0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#addresses GoogleNetworkServicesGateway#addresses}
    */
    readonly addresses?: string[];
    /**
    * A fully-qualified Certificates URL reference. The proxy presents a Certificate (selected based on SNI) when establishing a TLS connection.
    * This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#certificate_urls GoogleNetworkServicesGateway#certificate_urls}
    */
    readonly certificateUrls?: string[];
    /**
    * When deleting a gateway of type 'SECURE_WEB_GATEWAY', this boolean option will also delete auto generated router by the gateway creation.
    * If there is no other gateway of type 'SECURE_WEB_GATEWAY' remaining for that region and network it will be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#delete_swg_autogen_router_on_destroy GoogleNetworkServicesGateway#delete_swg_autogen_router_on_destroy}
    */
    readonly deleteSwgAutogenRouterOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#description GoogleNetworkServicesGateway#description}
    */
    readonly description?: string;
    /**
    * A fully-qualified GatewaySecurityPolicy URL reference. Defines how a server should apply security policy to inbound (VM to Proxy) initiated connections.
    * For example: 'projects/* /locations/* /gatewaySecurityPolicies/swg-policy'.
    * This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#gateway_security_policy GoogleNetworkServicesGateway#gateway_security_policy}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly gatewaySecurityPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#id GoogleNetworkServicesGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the Gateway resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#labels GoogleNetworkServicesGateway#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the gateway.
    * The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#location GoogleNetworkServicesGateway#location}
    */
    readonly location?: string;
    /**
    * Short name of the Gateway resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#name GoogleNetworkServicesGateway#name}
    */
    readonly name: string;
    /**
    * The relative resource name identifying the VPC network that is using this configuration.
    * For example: 'projects/* /global/networks/network-1'.
    * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#network GoogleNetworkServicesGateway#network}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly network?: string;
    /**
    * One or more port numbers (1-65535), on which the Gateway will receive traffic.
    * The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are
    * limited to 1 port. Gateways of type 'OPEN_MESH' listen on 0.0.0.0 and support multiple ports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#ports GoogleNetworkServicesGateway#ports}
    */
    readonly ports: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#project GoogleNetworkServicesGateway#project}
    */
    readonly project?: string;
    /**
    * Immutable. Scope determines how configuration across multiple Gateway instances are merged.
    * The configuration for multiple Gateway instances with the same scope will be merged as presented as
    * a single coniguration to the proxy/load balancer.
    * Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#scope GoogleNetworkServicesGateway#scope}
    */
    readonly scope?: string;
    /**
    * A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated.
    * If empty, TLS termination is disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#server_tls_policy GoogleNetworkServicesGateway#server_tls_policy}
    */
    readonly serverTlsPolicy?: string;
    /**
    * The relative resource name identifying the subnetwork in which this SWG is allocated.
    * For example: 'projects/* /regions/us-central1/subnetworks/network-1'.
    * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#subnetwork GoogleNetworkServicesGateway#subnetwork}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly subnetwork?: string;
    /**
    * Immutable. The type of the customer-managed gateway. Possible values are: * OPEN_MESH * SECURE_WEB_GATEWAY. Possible values: ["TYPE_UNSPECIFIED", "OPEN_MESH", "SECURE_WEB_GATEWAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#type GoogleNetworkServicesGateway#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#timeouts GoogleNetworkServicesGateway#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesGatewayTimeouts;
}
export interface GoogleNetworkServicesGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#create GoogleNetworkServicesGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#delete GoogleNetworkServicesGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#update GoogleNetworkServicesGateway#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesGatewayTimeoutsToTerraform(struct?: GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesGatewayTimeoutsToHclTerraform(struct?: GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway google_network_services_gateway}
*/
export declare class GoogleNetworkServicesGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_gateway";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesGateway to import
    * @param importFromId The id of the existing GoogleNetworkServicesGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_gateway google_network_services_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesGatewayConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesGatewayConfig);
    private _addresses?;
    get addresses(): string[];
    set addresses(value: string[]);
    resetAddresses(): void;
    get addressesInput(): string[] | undefined;
    private _certificateUrls?;
    get certificateUrls(): string[];
    set certificateUrls(value: string[]);
    resetCertificateUrls(): void;
    get certificateUrlsInput(): string[] | undefined;
    get createTime(): string;
    private _deleteSwgAutogenRouterOnDestroy?;
    get deleteSwgAutogenRouterOnDestroy(): boolean | cdktf.IResolvable;
    set deleteSwgAutogenRouterOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeleteSwgAutogenRouterOnDestroy(): void;
    get deleteSwgAutogenRouterOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gatewaySecurityPolicy?;
    get gatewaySecurityPolicy(): string;
    set gatewaySecurityPolicy(value: string);
    resetGatewaySecurityPolicy(): void;
    get gatewaySecurityPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _ports?;
    get ports(): number[];
    set ports(value: number[]);
    get portsInput(): number[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    get selfLink(): string;
    private _serverTlsPolicy?;
    get serverTlsPolicy(): string;
    set serverTlsPolicy(value: string);
    resetServerTlsPolicy(): void;
    get serverTlsPolicyInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesGatewayTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
