/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesGrpcRouteConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#description GoogleNetworkServicesGrpcRoute#description}
    */
    readonly description?: string;
    /**
    * List of gateways this GrpcRoute is attached to, as one of the routing rules to route the requests served by the gateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#gateways GoogleNetworkServicesGrpcRoute#gateways}
    */
    readonly gateways?: string[];
    /**
    * Required. Service hostnames with an optional port for which this route describes traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#hostnames GoogleNetworkServicesGrpcRoute#hostnames}
    */
    readonly hostnames: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#id GoogleNetworkServicesGrpcRoute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the GrpcRoute resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#labels GoogleNetworkServicesGrpcRoute#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * List of meshes this GrpcRoute is attached to, as one of the routing rules to route the requests served by the mesh.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#meshes GoogleNetworkServicesGrpcRoute#meshes}
    */
    readonly meshes?: string[];
    /**
    * Name of the GrpcRoute resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#name GoogleNetworkServicesGrpcRoute#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#project GoogleNetworkServicesGrpcRoute#project}
    */
    readonly project?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#rules GoogleNetworkServicesGrpcRoute#rules}
    */
    readonly rules: GoogleNetworkServicesGrpcRouteRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#timeouts GoogleNetworkServicesGrpcRoute#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesGrpcRouteTimeouts;
}
export interface GoogleNetworkServicesGrpcRouteRulesActionDestinations {
    /**
    * The URL of a BackendService to route traffic to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#service_name GoogleNetworkServicesGrpcRoute#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the proportion of requests forwarded to the backend referenced by the serviceName field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#weight GoogleNetworkServicesGrpcRoute#weight}
    */
    readonly weight?: number;
}
export declare function googleNetworkServicesGrpcRouteRulesActionDestinationsToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare function googleNetworkServicesGrpcRouteRulesActionDestinationsToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGrpcRouteRulesActionDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesActionDestinations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesActionDestinations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export declare class GoogleNetworkServicesGrpcRouteRulesActionDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesGrpcRouteRulesActionDestinations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesGrpcRouteRulesActionDestinationsOutputReference;
}
export interface GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#http_status GoogleNetworkServicesGrpcRoute#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic which will be aborted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#percentage GoogleNetworkServicesGrpcRoute#percentage}
    */
    readonly percentage?: number;
}
export declare function googleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbortOutputReference | GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort): any;
export declare function googleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbortToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbortOutputReference | GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort): any;
export declare class GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay {
    /**
    * Specify a fixed delay before forwarding the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#fixed_delay GoogleNetworkServicesGrpcRoute#fixed_delay}
    */
    readonly fixedDelay?: string;
    /**
    * The percentage of traffic on which delay will be injected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#percentage GoogleNetworkServicesGrpcRoute#percentage}
    */
    readonly percentage?: number;
}
export declare function googleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelayOutputReference | GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay): any;
export declare function googleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelayToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelayOutputReference | GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay): any;
export declare class GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay | undefined);
    private _fixedDelay?;
    get fixedDelay(): string;
    set fixedDelay(value: string);
    resetFixedDelay(): void;
    get fixedDelayInput(): string | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#abort GoogleNetworkServicesGrpcRoute#abort}
    */
    readonly abort?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#delay GoogleNetworkServicesGrpcRoute#delay}
    */
    readonly delay?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay;
}
export declare function googleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyOutputReference | GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy): any;
export declare function googleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyOutputReference | GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy): any;
export declare class GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy {
    /**
    * Specifies the allowed number of retries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#num_retries GoogleNetworkServicesGrpcRoute#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies one or more conditions when this retry policy applies. Possible values: ["connect-failure", "refused-stream", "cancelled", "deadline-exceeded", "resource-exhausted", "unavailable"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#retry_conditions GoogleNetworkServicesGrpcRoute#retry_conditions}
    */
    readonly retryConditions?: string[];
}
export declare function googleNetworkServicesGrpcRouteRulesActionRetryPolicyToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionRetryPolicyOutputReference | GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy): any;
export declare function googleNetworkServicesGrpcRouteRulesActionRetryPolicyToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionRetryPolicyOutputReference | GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy): any;
export declare class GoogleNetworkServicesGrpcRouteRulesActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
}
export interface GoogleNetworkServicesGrpcRouteRulesAction {
    /**
    * Specifies the timeout for selected route.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#timeout GoogleNetworkServicesGrpcRoute#timeout}
    */
    readonly timeout?: string;
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#destinations GoogleNetworkServicesGrpcRoute#destinations}
    */
    readonly destinations?: GoogleNetworkServicesGrpcRouteRulesActionDestinations[] | cdktf.IResolvable;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#fault_injection_policy GoogleNetworkServicesGrpcRoute#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#retry_policy GoogleNetworkServicesGrpcRoute#retry_policy}
    */
    readonly retryPolicy?: GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy;
}
export declare function googleNetworkServicesGrpcRouteRulesActionToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionOutputReference | GoogleNetworkServicesGrpcRouteRulesAction): any;
export declare function googleNetworkServicesGrpcRouteRulesActionToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesActionOutputReference | GoogleNetworkServicesGrpcRouteRulesAction): any;
export declare class GoogleNetworkServicesGrpcRouteRulesActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesAction | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesAction | undefined);
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _destinations;
    get destinations(): GoogleNetworkServicesGrpcRouteRulesActionDestinationsList;
    putDestinations(value: GoogleNetworkServicesGrpcRouteRulesActionDestinations[] | cdktf.IResolvable): void;
    resetDestinations(): void;
    get destinationsInput(): cdktf.IResolvable | GoogleNetworkServicesGrpcRouteRulesActionDestinations[] | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleNetworkServicesGrpcRouteRulesActionFaultInjectionPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleNetworkServicesGrpcRouteRulesActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleNetworkServicesGrpcRouteRulesActionRetryPolicy | undefined;
}
export interface GoogleNetworkServicesGrpcRouteRulesMatchesHeaders {
    /**
    * Required. The key of the header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#key GoogleNetworkServicesGrpcRoute#key}
    */
    readonly key: string;
    /**
    * The type of match. Default value: "EXACT" Possible values: ["TYPE_UNSPECIFIED", "EXACT", "REGULAR_EXPRESSION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#type GoogleNetworkServicesGrpcRoute#type}
    */
    readonly type?: string;
    /**
    * Required. The value of the header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#value GoogleNetworkServicesGrpcRoute#value}
    */
    readonly value: string;
}
export declare function googleNetworkServicesGrpcRouteRulesMatchesHeadersToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesMatchesHeaders | cdktf.IResolvable): any;
export declare function googleNetworkServicesGrpcRouteRulesMatchesHeadersToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesMatchesHeaders | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGrpcRouteRulesMatchesHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesMatchesHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesMatchesHeaders | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleNetworkServicesGrpcRouteRulesMatchesHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesGrpcRouteRulesMatchesHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesGrpcRouteRulesMatchesHeadersOutputReference;
}
export interface GoogleNetworkServicesGrpcRouteRulesMatchesMethod {
    /**
    * Specifies that matches are case sensitive. The default value is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#case_sensitive GoogleNetworkServicesGrpcRoute#case_sensitive}
    */
    readonly caseSensitive?: boolean | cdktf.IResolvable;
    /**
    * Required. Name of the method to match against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#grpc_method GoogleNetworkServicesGrpcRoute#grpc_method}
    */
    readonly grpcMethod: string;
    /**
    * Required. Name of the service to match against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#grpc_service GoogleNetworkServicesGrpcRoute#grpc_service}
    */
    readonly grpcService: string;
}
export declare function googleNetworkServicesGrpcRouteRulesMatchesMethodToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesMatchesMethodOutputReference | GoogleNetworkServicesGrpcRouteRulesMatchesMethod): any;
export declare function googleNetworkServicesGrpcRouteRulesMatchesMethodToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesMatchesMethodOutputReference | GoogleNetworkServicesGrpcRouteRulesMatchesMethod): any;
export declare class GoogleNetworkServicesGrpcRouteRulesMatchesMethodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesMatchesMethod | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesMatchesMethod | undefined);
    private _caseSensitive?;
    get caseSensitive(): boolean | cdktf.IResolvable;
    set caseSensitive(value: boolean | cdktf.IResolvable);
    resetCaseSensitive(): void;
    get caseSensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _grpcMethod?;
    get grpcMethod(): string;
    set grpcMethod(value: string);
    get grpcMethodInput(): string | undefined;
    private _grpcService?;
    get grpcService(): string;
    set grpcService(value: string);
    get grpcServiceInput(): string | undefined;
}
export interface GoogleNetworkServicesGrpcRouteRulesMatches {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#headers GoogleNetworkServicesGrpcRoute#headers}
    */
    readonly headers?: GoogleNetworkServicesGrpcRouteRulesMatchesHeaders[] | cdktf.IResolvable;
    /**
    * method block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#method GoogleNetworkServicesGrpcRoute#method}
    */
    readonly method?: GoogleNetworkServicesGrpcRouteRulesMatchesMethod;
}
export declare function googleNetworkServicesGrpcRouteRulesMatchesToTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesMatches | cdktf.IResolvable): any;
export declare function googleNetworkServicesGrpcRouteRulesMatchesToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRulesMatches | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGrpcRouteRulesMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesGrpcRouteRulesMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRulesMatches | cdktf.IResolvable | undefined);
    private _headers;
    get headers(): GoogleNetworkServicesGrpcRouteRulesMatchesHeadersList;
    putHeaders(value: GoogleNetworkServicesGrpcRouteRulesMatchesHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | GoogleNetworkServicesGrpcRouteRulesMatchesHeaders[] | undefined;
    private _method;
    get method(): GoogleNetworkServicesGrpcRouteRulesMatchesMethodOutputReference;
    putMethod(value: GoogleNetworkServicesGrpcRouteRulesMatchesMethod): void;
    resetMethod(): void;
    get methodInput(): GoogleNetworkServicesGrpcRouteRulesMatchesMethod | undefined;
}
export declare class GoogleNetworkServicesGrpcRouteRulesMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesGrpcRouteRulesMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesGrpcRouteRulesMatchesOutputReference;
}
export interface GoogleNetworkServicesGrpcRouteRules {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#action GoogleNetworkServicesGrpcRoute#action}
    */
    readonly action?: GoogleNetworkServicesGrpcRouteRulesAction;
    /**
    * matches block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#matches GoogleNetworkServicesGrpcRoute#matches}
    */
    readonly matches?: GoogleNetworkServicesGrpcRouteRulesMatches[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesGrpcRouteRulesToTerraform(struct?: GoogleNetworkServicesGrpcRouteRules | cdktf.IResolvable): any;
export declare function googleNetworkServicesGrpcRouteRulesToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteRules | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGrpcRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesGrpcRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteRules | cdktf.IResolvable | undefined);
    private _action;
    get action(): GoogleNetworkServicesGrpcRouteRulesActionOutputReference;
    putAction(value: GoogleNetworkServicesGrpcRouteRulesAction): void;
    resetAction(): void;
    get actionInput(): GoogleNetworkServicesGrpcRouteRulesAction | undefined;
    private _matches;
    get matches(): GoogleNetworkServicesGrpcRouteRulesMatchesList;
    putMatches(value: GoogleNetworkServicesGrpcRouteRulesMatches[] | cdktf.IResolvable): void;
    resetMatches(): void;
    get matchesInput(): cdktf.IResolvable | GoogleNetworkServicesGrpcRouteRulesMatches[] | undefined;
}
export declare class GoogleNetworkServicesGrpcRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesGrpcRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesGrpcRouteRulesOutputReference;
}
export interface GoogleNetworkServicesGrpcRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#create GoogleNetworkServicesGrpcRoute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#delete GoogleNetworkServicesGrpcRoute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#update GoogleNetworkServicesGrpcRoute#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesGrpcRouteTimeoutsToTerraform(struct?: GoogleNetworkServicesGrpcRouteTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesGrpcRouteTimeoutsToHclTerraform(struct?: GoogleNetworkServicesGrpcRouteTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGrpcRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGrpcRouteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGrpcRouteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route google_network_services_grpc_route}
*/
export declare class GoogleNetworkServicesGrpcRoute extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_grpc_route";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesGrpcRoute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesGrpcRoute to import
    * @param importFromId The id of the existing GoogleNetworkServicesGrpcRoute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesGrpcRoute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_grpc_route google_network_services_grpc_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesGrpcRouteConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesGrpcRouteConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gateways?;
    get gateways(): string[];
    set gateways(value: string[]);
    resetGateways(): void;
    get gatewaysInput(): string[] | undefined;
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    get hostnamesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _meshes?;
    get meshes(): string[];
    set meshes(value: string[]);
    resetMeshes(): void;
    get meshesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleNetworkServicesGrpcRouteRulesList;
    putRules(value: GoogleNetworkServicesGrpcRouteRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleNetworkServicesGrpcRouteRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesGrpcRouteTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesGrpcRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesGrpcRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
