/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesHttpRouteConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#description GoogleNetworkServicesHttpRoute#description}
    */
    readonly description?: string;
    /**
    * Gateways defines a list of gateways this HttpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
    * Each gateway reference should match the pattern: projects/* /locations/global/gateways/<gateway_name>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#gateways GoogleNetworkServicesHttpRoute#gateways}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly gateways?: string[];
    /**
    * Set of hosts that should match against the HTTP host header to select a HttpRoute to process the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#hostnames GoogleNetworkServicesHttpRoute#hostnames}
    */
    readonly hostnames: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#id GoogleNetworkServicesHttpRoute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the HttpRoute resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#labels GoogleNetworkServicesHttpRoute#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Meshes defines a list of meshes this HttpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
    * Each mesh reference should match the pattern: projects/* /locations/global/meshes/<mesh_name>.
    * The attached Mesh should be of a type SIDECAR.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#meshes GoogleNetworkServicesHttpRoute#meshes}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly meshes?: string[];
    /**
    * Name of the HttpRoute resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#name GoogleNetworkServicesHttpRoute#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#project GoogleNetworkServicesHttpRoute#project}
    */
    readonly project?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#rules GoogleNetworkServicesHttpRoute#rules}
    */
    readonly rules: GoogleNetworkServicesHttpRouteRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#timeouts GoogleNetworkServicesHttpRoute#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesHttpRouteTimeouts;
}
export interface GoogleNetworkServicesHttpRouteRulesActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#allow_credentials GoogleNetworkServicesHttpRoute#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#allow_headers GoogleNetworkServicesHttpRoute#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#allow_methods GoogleNetworkServicesHttpRoute#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#allow_origin_regexes GoogleNetworkServicesHttpRoute#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#allow_origins GoogleNetworkServicesHttpRoute#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#disabled GoogleNetworkServicesHttpRoute#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#expose_headers GoogleNetworkServicesHttpRoute#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long result of a preflight request can be cached in seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#max_age GoogleNetworkServicesHttpRoute#max_age}
    */
    readonly maxAge?: string;
}
export declare function googleNetworkServicesHttpRouteRulesActionCorsPolicyToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionCorsPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionCorsPolicy): any;
export declare function googleNetworkServicesHttpRouteRulesActionCorsPolicyToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionCorsPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionCorsPolicy): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionCorsPolicy | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): string;
    set maxAge(value: string);
    resetMaxAge(): void;
    get maxAgeInput(): string | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionDestinations {
    /**
    * The URL of a BackendService to route traffic to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#service_name GoogleNetworkServicesHttpRoute#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
    * If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
    * If weights are specified for any one service name, they need to be specified for all of them.
    * If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#weight GoogleNetworkServicesHttpRoute#weight}
    */
    readonly weight?: number;
}
export declare function googleNetworkServicesHttpRouteRulesActionDestinationsToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare function googleNetworkServicesHttpRouteRulesActionDestinationsToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionDestinations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionDestinations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export declare class GoogleNetworkServicesHttpRouteRulesActionDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesHttpRouteRulesActionDestinations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesHttpRouteRulesActionDestinationsOutputReference;
}
export interface GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#http_status GoogleNetworkServicesHttpRoute#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic which will be aborted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#percentage GoogleNetworkServicesHttpRoute#percentage}
    */
    readonly percentage?: number;
}
export declare function googleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbortOutputReference | GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort): any;
export declare function googleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbortToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbortOutputReference | GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay {
    /**
    * Specify a fixed delay before forwarding the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#fixed_delay GoogleNetworkServicesHttpRoute#fixed_delay}
    */
    readonly fixedDelay?: string;
    /**
    * The percentage of traffic on which delay will be injected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#percentage GoogleNetworkServicesHttpRoute#percentage}
    */
    readonly percentage?: number;
}
export declare function googleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelayOutputReference | GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay): any;
export declare function googleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelayToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelayOutputReference | GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay | undefined);
    private _fixedDelay?;
    get fixedDelay(): string;
    set fixedDelay(value: string);
    resetFixedDelay(): void;
    get fixedDelayInput(): string | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#abort GoogleNetworkServicesHttpRoute#abort}
    */
    readonly abort?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#delay GoogleNetworkServicesHttpRoute#delay}
    */
    readonly delay?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay;
}
export declare function googleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy): any;
export declare function googleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was supplied in the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#host_redirect GoogleNetworkServicesHttpRoute#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#https_redirect GoogleNetworkServicesHttpRoute#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was supplied in the request. pathRedirect can not be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#path_redirect GoogleNetworkServicesHttpRoute#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The port that will be used in the redirected request instead of the one that was supplied in the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#port_redirect GoogleNetworkServicesHttpRoute#port_redirect}
    */
    readonly portRedirect?: number;
    /**
    * Indicates that during redirection, the matched prefix (or path) should be swapped with this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#prefix_rewrite GoogleNetworkServicesHttpRoute#prefix_rewrite}
    */
    readonly prefixRewrite?: string;
    /**
    * The HTTP Status code to use for the redirect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#response_code GoogleNetworkServicesHttpRoute#response_code}
    */
    readonly responseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#strip_query GoogleNetworkServicesHttpRoute#strip_query}
    */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function googleNetworkServicesHttpRouteRulesActionRedirectToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRedirectOutputReference | GoogleNetworkServicesHttpRouteRulesActionRedirect): any;
export declare function googleNetworkServicesHttpRouteRulesActionRedirectToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRedirectOutputReference | GoogleNetworkServicesHttpRouteRulesActionRedirect): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionRedirect | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _portRedirect?;
    get portRedirect(): number;
    set portRedirect(value: number);
    resetPortRedirect(): void;
    get portRedirectInput(): number | undefined;
    private _prefixRewrite?;
    get prefixRewrite(): string;
    set prefixRewrite(value: string);
    resetPrefixRewrite(): void;
    get prefixRewriteInput(): string | undefined;
    private _responseCode?;
    get responseCode(): string;
    set responseCode(value: string);
    resetResponseCode(): void;
    get responseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier {
    /**
    * Add the headers with given map where key is the name of the header, value is the value of the header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#add GoogleNetworkServicesHttpRoute#add}
    */
    readonly add?: {
        [key: string]: string;
    };
    /**
    * Remove headers (matching by header names) specified in the list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#remove GoogleNetworkServicesHttpRoute#remove}
    */
    readonly remove?: string[];
    /**
    * Completely overwrite/replace the headers with given map where key is the name of the header, value is the value of the header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#set GoogleNetworkServicesHttpRoute#set}
    */
    readonly set?: {
        [key: string]: string;
    };
}
export declare function googleNetworkServicesHttpRouteRulesActionRequestHeaderModifierToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifierOutputReference | GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier): any;
export declare function googleNetworkServicesHttpRouteRulesActionRequestHeaderModifierToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifierOutputReference | GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier | undefined);
    private _add?;
    get add(): {
        [key: string]: string;
    };
    set add(value: {
        [key: string]: string;
    });
    resetAdd(): void;
    get addInput(): {
        [key: string]: string;
    } | undefined;
    private _remove?;
    get remove(): string[];
    set remove(value: string[]);
    resetRemove(): void;
    get removeInput(): string[] | undefined;
    private _set?;
    get set(): {
        [key: string]: string;
    };
    set set(value: {
        [key: string]: string;
    });
    resetSet(): void;
    get setInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination {
    /**
    * The URL of a BackendService to route traffic to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#service_name GoogleNetworkServicesHttpRoute#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
    * If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
    * If weights are specified for any one service name, they need to be specified for all of them.
    * If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#weight GoogleNetworkServicesHttpRoute#weight}
    */
    readonly weight?: number;
}
export declare function googleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestinationToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestinationOutputReference | GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination): any;
export declare function googleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestinationToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestinationOutputReference | GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy {
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#destination GoogleNetworkServicesHttpRoute#destination}
    */
    readonly destination?: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination;
}
export declare function googleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy): any;
export declare function googleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy | undefined);
    private _destination;
    get destination(): GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestinationOutputReference;
    putDestination(value: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination): void;
    resetDestination(): void;
    get destinationInput(): GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyDestination | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier {
    /**
    * Add the headers with given map where key is the name of the header, value is the value of the header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#add GoogleNetworkServicesHttpRoute#add}
    */
    readonly add?: {
        [key: string]: string;
    };
    /**
    * Remove headers (matching by header names) specified in the list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#remove GoogleNetworkServicesHttpRoute#remove}
    */
    readonly remove?: string[];
    /**
    * Completely overwrite/replace the headers with given map where key is the name of the header, value is the value of the header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#set GoogleNetworkServicesHttpRoute#set}
    */
    readonly set?: {
        [key: string]: string;
    };
}
export declare function googleNetworkServicesHttpRouteRulesActionResponseHeaderModifierToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifierOutputReference | GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier): any;
export declare function googleNetworkServicesHttpRouteRulesActionResponseHeaderModifierToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifierOutputReference | GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier | undefined);
    private _add?;
    get add(): {
        [key: string]: string;
    };
    set add(value: {
        [key: string]: string;
    });
    resetAdd(): void;
    get addInput(): {
        [key: string]: string;
    } | undefined;
    private _remove?;
    get remove(): string[];
    set remove(value: string[]);
    resetRemove(): void;
    get removeInput(): string[] | undefined;
    private _set?;
    get set(): {
        [key: string]: string;
    };
    set set(value: {
        [key: string]: string;
    });
    resetSet(): void;
    get setInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionRetryPolicy {
    /**
    * Specifies the allowed number of retries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#num_retries GoogleNetworkServicesHttpRoute#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies a non-zero timeout per retry attempt. A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#per_try_timeout GoogleNetworkServicesHttpRoute#per_try_timeout}
    */
    readonly perTryTimeout?: string;
    /**
    * Specifies one or more conditions when this retry policy applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#retry_conditions GoogleNetworkServicesHttpRoute#retry_conditions}
    */
    readonly retryConditions?: string[];
}
export declare function googleNetworkServicesHttpRouteRulesActionRetryPolicyToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRetryPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionRetryPolicy): any;
export declare function googleNetworkServicesHttpRouteRulesActionRetryPolicyToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionRetryPolicyOutputReference | GoogleNetworkServicesHttpRouteRulesActionRetryPolicy): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionRetryPolicy | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _perTryTimeout?;
    get perTryTimeout(): string;
    set perTryTimeout(value: string);
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): string | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected destination, the requests host header is replaced by this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#host_rewrite GoogleNetworkServicesHttpRoute#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected destination, the matching portion of the requests path is replaced by this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#path_prefix_rewrite GoogleNetworkServicesHttpRoute#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleNetworkServicesHttpRouteRulesActionUrlRewriteToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionUrlRewriteOutputReference | GoogleNetworkServicesHttpRouteRulesActionUrlRewrite): any;
export declare function googleNetworkServicesHttpRouteRulesActionUrlRewriteToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionUrlRewriteOutputReference | GoogleNetworkServicesHttpRouteRulesActionUrlRewrite): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesActionUrlRewrite | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesAction {
    /**
    * Specifies the timeout for selected route.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#timeout GoogleNetworkServicesHttpRoute#timeout}
    */
    readonly timeout?: string;
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#cors_policy GoogleNetworkServicesHttpRoute#cors_policy}
    */
    readonly corsPolicy?: GoogleNetworkServicesHttpRouteRulesActionCorsPolicy;
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#destinations GoogleNetworkServicesHttpRoute#destinations}
    */
    readonly destinations?: GoogleNetworkServicesHttpRouteRulesActionDestinations[] | cdktf.IResolvable;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#fault_injection_policy GoogleNetworkServicesHttpRoute#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy;
    /**
    * redirect block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#redirect GoogleNetworkServicesHttpRoute#redirect}
    */
    readonly redirect?: GoogleNetworkServicesHttpRouteRulesActionRedirect;
    /**
    * request_header_modifier block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#request_header_modifier GoogleNetworkServicesHttpRoute#request_header_modifier}
    */
    readonly requestHeaderModifier?: GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#request_mirror_policy GoogleNetworkServicesHttpRoute#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy;
    /**
    * response_header_modifier block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#response_header_modifier GoogleNetworkServicesHttpRoute#response_header_modifier}
    */
    readonly responseHeaderModifier?: GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#retry_policy GoogleNetworkServicesHttpRoute#retry_policy}
    */
    readonly retryPolicy?: GoogleNetworkServicesHttpRouteRulesActionRetryPolicy;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#url_rewrite GoogleNetworkServicesHttpRoute#url_rewrite}
    */
    readonly urlRewrite?: GoogleNetworkServicesHttpRouteRulesActionUrlRewrite;
}
export declare function googleNetworkServicesHttpRouteRulesActionToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionOutputReference | GoogleNetworkServicesHttpRouteRulesAction): any;
export declare function googleNetworkServicesHttpRouteRulesActionToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesActionOutputReference | GoogleNetworkServicesHttpRouteRulesAction): any;
export declare class GoogleNetworkServicesHttpRouteRulesActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesAction | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesAction | undefined);
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _corsPolicy;
    get corsPolicy(): GoogleNetworkServicesHttpRouteRulesActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleNetworkServicesHttpRouteRulesActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleNetworkServicesHttpRouteRulesActionCorsPolicy | undefined;
    private _destinations;
    get destinations(): GoogleNetworkServicesHttpRouteRulesActionDestinationsList;
    putDestinations(value: GoogleNetworkServicesHttpRouteRulesActionDestinations[] | cdktf.IResolvable): void;
    resetDestinations(): void;
    get destinationsInput(): cdktf.IResolvable | GoogleNetworkServicesHttpRouteRulesActionDestinations[] | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleNetworkServicesHttpRouteRulesActionFaultInjectionPolicy | undefined;
    private _redirect;
    get redirect(): GoogleNetworkServicesHttpRouteRulesActionRedirectOutputReference;
    putRedirect(value: GoogleNetworkServicesHttpRouteRulesActionRedirect): void;
    resetRedirect(): void;
    get redirectInput(): GoogleNetworkServicesHttpRouteRulesActionRedirect | undefined;
    private _requestHeaderModifier;
    get requestHeaderModifier(): GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifierOutputReference;
    putRequestHeaderModifier(value: GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier): void;
    resetRequestHeaderModifier(): void;
    get requestHeaderModifierInput(): GoogleNetworkServicesHttpRouteRulesActionRequestHeaderModifier | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleNetworkServicesHttpRouteRulesActionRequestMirrorPolicy | undefined;
    private _responseHeaderModifier;
    get responseHeaderModifier(): GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifierOutputReference;
    putResponseHeaderModifier(value: GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier): void;
    resetResponseHeaderModifier(): void;
    get responseHeaderModifierInput(): GoogleNetworkServicesHttpRouteRulesActionResponseHeaderModifier | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleNetworkServicesHttpRouteRulesActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleNetworkServicesHttpRouteRulesActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleNetworkServicesHttpRouteRulesActionRetryPolicy | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleNetworkServicesHttpRouteRulesActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleNetworkServicesHttpRouteRulesActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleNetworkServicesHttpRouteRulesActionUrlRewrite | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch {
    /**
    * End of the range (exclusive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#end GoogleNetworkServicesHttpRoute#end}
    */
    readonly end: number;
    /**
    * Start of the range (inclusive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#start GoogleNetworkServicesHttpRoute#start}
    */
    readonly start: number;
}
export declare function googleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatchToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatchOutputReference | GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch): any;
export declare function googleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatchToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatchOutputReference | GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch): any;
export declare class GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch | undefined);
    private _end?;
    get end(): number;
    set end(value: number);
    get endInput(): number | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    get startInput(): number | undefined;
}
export interface GoogleNetworkServicesHttpRouteRulesMatchesHeaders {
    /**
    * The value of the header should match exactly the content of exactMatch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#exact_match GoogleNetworkServicesHttpRoute#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the HTTP header to match against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#header GoogleNetworkServicesHttpRoute#header}
    */
    readonly header?: string;
    /**
    * If specified, the match result will be inverted before checking. Default value is set to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#invert_match GoogleNetworkServicesHttpRoute#invert_match}
    */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must start with the contents of prefixMatch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#prefix_match GoogleNetworkServicesHttpRoute#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * A header with headerName must exist. The match takes place whether or not the header has a value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#present_match GoogleNetworkServicesHttpRoute#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must match the regular expression specified in regexMatch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#regex_match GoogleNetworkServicesHttpRoute#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * The value of the header must end with the contents of suffixMatch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#suffix_match GoogleNetworkServicesHttpRoute#suffix_match}
    */
    readonly suffixMatch?: string;
    /**
    * range_match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#range_match GoogleNetworkServicesHttpRoute#range_match}
    */
    readonly rangeMatch?: GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch;
}
export declare function googleNetworkServicesHttpRouteRulesMatchesHeadersToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatchesHeaders | cdktf.IResolvable): any;
export declare function googleNetworkServicesHttpRouteRulesMatchesHeadersToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatchesHeaders | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesHttpRouteRulesMatchesHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesMatchesHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesMatchesHeaders | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _header?;
    get header(): string;
    set header(value: string);
    resetHeader(): void;
    get headerInput(): string | undefined;
    private _invertMatch?;
    get invertMatch(): boolean | cdktf.IResolvable;
    set invertMatch(value: boolean | cdktf.IResolvable);
    resetInvertMatch(): void;
    get invertMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _suffixMatch?;
    get suffixMatch(): string;
    set suffixMatch(value: string);
    resetSuffixMatch(): void;
    get suffixMatchInput(): string | undefined;
    private _rangeMatch;
    get rangeMatch(): GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatchOutputReference;
    putRangeMatch(value: GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch): void;
    resetRangeMatch(): void;
    get rangeMatchInput(): GoogleNetworkServicesHttpRouteRulesMatchesHeadersRangeMatch | undefined;
}
export declare class GoogleNetworkServicesHttpRouteRulesMatchesHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesHttpRouteRulesMatchesHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesHttpRouteRulesMatchesHeadersOutputReference;
}
export interface GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters {
    /**
    * The value of the query parameter must exactly match the contents of exactMatch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#exact_match GoogleNetworkServicesHttpRoute#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * Specifies that the QueryParameterMatcher matches if request contains query parameter, irrespective of whether the parameter has a value or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#present_match GoogleNetworkServicesHttpRoute#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The name of the query parameter to match.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#query_parameter GoogleNetworkServicesHttpRoute#query_parameter}
    */
    readonly queryParameter?: string;
    /**
    * The value of the query parameter must match the regular expression specified by regexMatch.For regular expression grammar, please see https://github.com/google/re2/wiki/Syntax
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#regex_match GoogleNetworkServicesHttpRoute#regex_match}
    */
    readonly regexMatch?: string;
}
export declare function googleNetworkServicesHttpRouteRulesMatchesQueryParametersToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters | cdktf.IResolvable): any;
export declare function googleNetworkServicesHttpRouteRulesMatchesQueryParametersToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesHttpRouteRulesMatchesQueryParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _queryParameter?;
    get queryParameter(): string;
    set queryParameter(value: string);
    resetQueryParameter(): void;
    get queryParameterInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
}
export declare class GoogleNetworkServicesHttpRouteRulesMatchesQueryParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesHttpRouteRulesMatchesQueryParametersOutputReference;
}
export interface GoogleNetworkServicesHttpRouteRulesMatches {
    /**
    * The HTTP request path value should exactly match this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#full_path_match GoogleNetworkServicesHttpRoute#full_path_match}
    */
    readonly fullPathMatch?: string;
    /**
    * Specifies if prefixMatch and fullPathMatch matches are case sensitive. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#ignore_case GoogleNetworkServicesHttpRoute#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * The HTTP request path value must begin with specified prefixMatch. prefixMatch must begin with a /.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#prefix_match GoogleNetworkServicesHttpRoute#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * The HTTP request path value must satisfy the regular expression specified by regexMatch after removing any query parameters and anchor supplied with the original URL. For regular expression grammar, please see https://github.com/google/re2/wiki/Syntax
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#regex_match GoogleNetworkServicesHttpRoute#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#headers GoogleNetworkServicesHttpRoute#headers}
    */
    readonly headers?: GoogleNetworkServicesHttpRouteRulesMatchesHeaders[] | cdktf.IResolvable;
    /**
    * query_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#query_parameters GoogleNetworkServicesHttpRoute#query_parameters}
    */
    readonly queryParameters?: GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesHttpRouteRulesMatchesToTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatches | cdktf.IResolvable): any;
export declare function googleNetworkServicesHttpRouteRulesMatchesToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRulesMatches | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesHttpRouteRulesMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesHttpRouteRulesMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRulesMatches | cdktf.IResolvable | undefined);
    private _fullPathMatch?;
    get fullPathMatch(): string;
    set fullPathMatch(value: string);
    resetFullPathMatch(): void;
    get fullPathMatchInput(): string | undefined;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _headers;
    get headers(): GoogleNetworkServicesHttpRouteRulesMatchesHeadersList;
    putHeaders(value: GoogleNetworkServicesHttpRouteRulesMatchesHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | GoogleNetworkServicesHttpRouteRulesMatchesHeaders[] | undefined;
    private _queryParameters;
    get queryParameters(): GoogleNetworkServicesHttpRouteRulesMatchesQueryParametersList;
    putQueryParameters(value: GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters[] | cdktf.IResolvable): void;
    resetQueryParameters(): void;
    get queryParametersInput(): cdktf.IResolvable | GoogleNetworkServicesHttpRouteRulesMatchesQueryParameters[] | undefined;
}
export declare class GoogleNetworkServicesHttpRouteRulesMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesHttpRouteRulesMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesHttpRouteRulesMatchesOutputReference;
}
export interface GoogleNetworkServicesHttpRouteRules {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#action GoogleNetworkServicesHttpRoute#action}
    */
    readonly action?: GoogleNetworkServicesHttpRouteRulesAction;
    /**
    * matches block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#matches GoogleNetworkServicesHttpRoute#matches}
    */
    readonly matches?: GoogleNetworkServicesHttpRouteRulesMatches[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesHttpRouteRulesToTerraform(struct?: GoogleNetworkServicesHttpRouteRules | cdktf.IResolvable): any;
export declare function googleNetworkServicesHttpRouteRulesToHclTerraform(struct?: GoogleNetworkServicesHttpRouteRules | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesHttpRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesHttpRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteRules | cdktf.IResolvable | undefined);
    private _action;
    get action(): GoogleNetworkServicesHttpRouteRulesActionOutputReference;
    putAction(value: GoogleNetworkServicesHttpRouteRulesAction): void;
    resetAction(): void;
    get actionInput(): GoogleNetworkServicesHttpRouteRulesAction | undefined;
    private _matches;
    get matches(): GoogleNetworkServicesHttpRouteRulesMatchesList;
    putMatches(value: GoogleNetworkServicesHttpRouteRulesMatches[] | cdktf.IResolvable): void;
    resetMatches(): void;
    get matchesInput(): cdktf.IResolvable | GoogleNetworkServicesHttpRouteRulesMatches[] | undefined;
}
export declare class GoogleNetworkServicesHttpRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesHttpRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesHttpRouteRulesOutputReference;
}
export interface GoogleNetworkServicesHttpRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#create GoogleNetworkServicesHttpRoute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#delete GoogleNetworkServicesHttpRoute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#update GoogleNetworkServicesHttpRoute#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesHttpRouteTimeoutsToTerraform(struct?: GoogleNetworkServicesHttpRouteTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesHttpRouteTimeoutsToHclTerraform(struct?: GoogleNetworkServicesHttpRouteTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesHttpRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesHttpRouteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesHttpRouteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route google_network_services_http_route}
*/
export declare class GoogleNetworkServicesHttpRoute extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_http_route";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesHttpRoute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesHttpRoute to import
    * @param importFromId The id of the existing GoogleNetworkServicesHttpRoute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesHttpRoute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_http_route google_network_services_http_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesHttpRouteConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesHttpRouteConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gateways?;
    get gateways(): string[];
    set gateways(value: string[]);
    resetGateways(): void;
    get gatewaysInput(): string[] | undefined;
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    get hostnamesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _meshes?;
    get meshes(): string[];
    set meshes(value: string[]);
    resetMeshes(): void;
    get meshesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleNetworkServicesHttpRouteRulesList;
    putRules(value: GoogleNetworkServicesHttpRouteRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleNetworkServicesHttpRouteRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesHttpRouteTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesHttpRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesHttpRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
