/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesTcpRouteConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#description GoogleNetworkServicesTcpRoute#description}
    */
    readonly description?: string;
    /**
    * Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests served by the gateway.
    * Each gateway reference should match the pattern: projects/* /locations/global/gateways/<gateway_name>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#gateways GoogleNetworkServicesTcpRoute#gateways}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly gateways?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#id GoogleNetworkServicesTcpRoute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the TcpRoute resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#labels GoogleNetworkServicesTcpRoute#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served by the mesh.
    * Each mesh reference should match the pattern: projects/* /locations/global/meshes/<mesh_name>
    * The attached Mesh should be of a type SIDECAR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#meshes GoogleNetworkServicesTcpRoute#meshes}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly meshes?: string[];
    /**
    * Name of the TcpRoute resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#name GoogleNetworkServicesTcpRoute#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#project GoogleNetworkServicesTcpRoute#project}
    */
    readonly project?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#rules GoogleNetworkServicesTcpRoute#rules}
    */
    readonly rules: GoogleNetworkServicesTcpRouteRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#timeouts GoogleNetworkServicesTcpRoute#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesTcpRouteTimeouts;
}
export interface GoogleNetworkServicesTcpRouteRulesActionDestinations {
    /**
    * The URL of a BackendService to route traffic to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#service_name GoogleNetworkServicesTcpRoute#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
    * If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
    * If weights are specified for any one service name, they need to be specified for all of them.
    * If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#weight GoogleNetworkServicesTcpRoute#weight}
    */
    readonly weight?: number;
}
export declare function googleNetworkServicesTcpRouteRulesActionDestinationsToTerraform(struct?: GoogleNetworkServicesTcpRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare function googleNetworkServicesTcpRouteRulesActionDestinationsToHclTerraform(struct?: GoogleNetworkServicesTcpRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTcpRouteRulesActionDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesTcpRouteRulesActionDestinations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTcpRouteRulesActionDestinations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export declare class GoogleNetworkServicesTcpRouteRulesActionDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesTcpRouteRulesActionDestinations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesTcpRouteRulesActionDestinationsOutputReference;
}
export interface GoogleNetworkServicesTcpRouteRulesAction {
    /**
    * If true, Router will use the destination IP and port of the original connection as the destination of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#original_destination GoogleNetworkServicesTcpRoute#original_destination}
    */
    readonly originalDestination?: boolean | cdktf.IResolvable;
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#destinations GoogleNetworkServicesTcpRoute#destinations}
    */
    readonly destinations?: GoogleNetworkServicesTcpRouteRulesActionDestinations[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesTcpRouteRulesActionToTerraform(struct?: GoogleNetworkServicesTcpRouteRulesActionOutputReference | GoogleNetworkServicesTcpRouteRulesAction): any;
export declare function googleNetworkServicesTcpRouteRulesActionToHclTerraform(struct?: GoogleNetworkServicesTcpRouteRulesActionOutputReference | GoogleNetworkServicesTcpRouteRulesAction): any;
export declare class GoogleNetworkServicesTcpRouteRulesActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesTcpRouteRulesAction | undefined;
    set internalValue(value: GoogleNetworkServicesTcpRouteRulesAction | undefined);
    private _originalDestination?;
    get originalDestination(): boolean | cdktf.IResolvable;
    set originalDestination(value: boolean | cdktf.IResolvable);
    resetOriginalDestination(): void;
    get originalDestinationInput(): boolean | cdktf.IResolvable | undefined;
    private _destinations;
    get destinations(): GoogleNetworkServicesTcpRouteRulesActionDestinationsList;
    putDestinations(value: GoogleNetworkServicesTcpRouteRulesActionDestinations[] | cdktf.IResolvable): void;
    resetDestinations(): void;
    get destinationsInput(): cdktf.IResolvable | GoogleNetworkServicesTcpRouteRulesActionDestinations[] | undefined;
}
export interface GoogleNetworkServicesTcpRouteRulesMatches {
    /**
    * Must be specified in the CIDR range format. A CIDR range consists of an IP Address and a prefix length to construct the subnet mask.
    * By default, the prefix length is 32 (i.e. matches a single IP address). Only IPV4 addresses are supported. Examples: "10.0.0.1" - matches against this exact IP address. "10.0.0.0/8" - matches against any IP address within the 10.0.0.0 subnet and 255.255.255.0 mask. "0.0.0.0/0" - matches against any IP address'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#address GoogleNetworkServicesTcpRoute#address}
    */
    readonly address: string;
    /**
    * Specifies the destination port to match against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#port GoogleNetworkServicesTcpRoute#port}
    */
    readonly port: string;
}
export declare function googleNetworkServicesTcpRouteRulesMatchesToTerraform(struct?: GoogleNetworkServicesTcpRouteRulesMatches | cdktf.IResolvable): any;
export declare function googleNetworkServicesTcpRouteRulesMatchesToHclTerraform(struct?: GoogleNetworkServicesTcpRouteRulesMatches | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTcpRouteRulesMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesTcpRouteRulesMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTcpRouteRulesMatches | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class GoogleNetworkServicesTcpRouteRulesMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesTcpRouteRulesMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesTcpRouteRulesMatchesOutputReference;
}
export interface GoogleNetworkServicesTcpRouteRules {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#action GoogleNetworkServicesTcpRoute#action}
    */
    readonly action: GoogleNetworkServicesTcpRouteRulesAction;
    /**
    * matches block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#matches GoogleNetworkServicesTcpRoute#matches}
    */
    readonly matches?: GoogleNetworkServicesTcpRouteRulesMatches[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesTcpRouteRulesToTerraform(struct?: GoogleNetworkServicesTcpRouteRules | cdktf.IResolvable): any;
export declare function googleNetworkServicesTcpRouteRulesToHclTerraform(struct?: GoogleNetworkServicesTcpRouteRules | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTcpRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesTcpRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTcpRouteRules | cdktf.IResolvable | undefined);
    private _action;
    get action(): GoogleNetworkServicesTcpRouteRulesActionOutputReference;
    putAction(value: GoogleNetworkServicesTcpRouteRulesAction): void;
    get actionInput(): GoogleNetworkServicesTcpRouteRulesAction | undefined;
    private _matches;
    get matches(): GoogleNetworkServicesTcpRouteRulesMatchesList;
    putMatches(value: GoogleNetworkServicesTcpRouteRulesMatches[] | cdktf.IResolvable): void;
    resetMatches(): void;
    get matchesInput(): cdktf.IResolvable | GoogleNetworkServicesTcpRouteRulesMatches[] | undefined;
}
export declare class GoogleNetworkServicesTcpRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesTcpRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesTcpRouteRulesOutputReference;
}
export interface GoogleNetworkServicesTcpRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#create GoogleNetworkServicesTcpRoute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#delete GoogleNetworkServicesTcpRoute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#update GoogleNetworkServicesTcpRoute#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesTcpRouteTimeoutsToTerraform(struct?: GoogleNetworkServicesTcpRouteTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesTcpRouteTimeoutsToHclTerraform(struct?: GoogleNetworkServicesTcpRouteTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTcpRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesTcpRouteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTcpRouteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route google_network_services_tcp_route}
*/
export declare class GoogleNetworkServicesTcpRoute extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_tcp_route";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesTcpRoute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesTcpRoute to import
    * @param importFromId The id of the existing GoogleNetworkServicesTcpRoute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesTcpRoute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tcp_route google_network_services_tcp_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesTcpRouteConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesTcpRouteConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gateways?;
    get gateways(): string[];
    set gateways(value: string[]);
    resetGateways(): void;
    get gatewaysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _meshes?;
    get meshes(): string[];
    set meshes(value: string[]);
    resetMeshes(): void;
    get meshesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleNetworkServicesTcpRouteRulesList;
    putRules(value: GoogleNetworkServicesTcpRouteRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleNetworkServicesTcpRouteRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesTcpRouteTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesTcpRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesTcpRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
