/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesTlsRouteConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#description GoogleNetworkServicesTlsRoute#description}
    */
    readonly description?: string;
    /**
    * Gateways defines a list of gateways this TlsRoute is attached to, as one of the routing rules to route the requests served by the gateway.
    * Each gateway reference should match the pattern: projects/* /locations/global/gateways/<gateway_name>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#gateways GoogleNetworkServicesTlsRoute#gateways}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly gateways?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#id GoogleNetworkServicesTlsRoute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Meshes defines a list of meshes this TlsRoute is attached to, as one of the routing rules to route the requests served by the mesh.
    * Each mesh reference should match the pattern: projects/* /locations/global/meshes/<mesh_name>
    * The attached Mesh should be of a type SIDECAR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#meshes GoogleNetworkServicesTlsRoute#meshes}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly meshes?: string[];
    /**
    * Name of the TlsRoute resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#name GoogleNetworkServicesTlsRoute#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#project GoogleNetworkServicesTlsRoute#project}
    */
    readonly project?: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#rules GoogleNetworkServicesTlsRoute#rules}
    */
    readonly rules: GoogleNetworkServicesTlsRouteRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#timeouts GoogleNetworkServicesTlsRoute#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesTlsRouteTimeouts;
}
export interface GoogleNetworkServicesTlsRouteRulesActionDestinations {
    /**
    * The URL of a BackendService to route traffic to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#service_name GoogleNetworkServicesTlsRoute#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the proportion of requests forwarded to the backend referenced by the serviceName field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#weight GoogleNetworkServicesTlsRoute#weight}
    */
    readonly weight?: number;
}
export declare function googleNetworkServicesTlsRouteRulesActionDestinationsToTerraform(struct?: GoogleNetworkServicesTlsRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare function googleNetworkServicesTlsRouteRulesActionDestinationsToHclTerraform(struct?: GoogleNetworkServicesTlsRouteRulesActionDestinations | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTlsRouteRulesActionDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesTlsRouteRulesActionDestinations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTlsRouteRulesActionDestinations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export declare class GoogleNetworkServicesTlsRouteRulesActionDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesTlsRouteRulesActionDestinations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesTlsRouteRulesActionDestinationsOutputReference;
}
export interface GoogleNetworkServicesTlsRouteRulesAction {
    /**
    * destinations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#destinations GoogleNetworkServicesTlsRoute#destinations}
    */
    readonly destinations?: GoogleNetworkServicesTlsRouteRulesActionDestinations[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesTlsRouteRulesActionToTerraform(struct?: GoogleNetworkServicesTlsRouteRulesActionOutputReference | GoogleNetworkServicesTlsRouteRulesAction): any;
export declare function googleNetworkServicesTlsRouteRulesActionToHclTerraform(struct?: GoogleNetworkServicesTlsRouteRulesActionOutputReference | GoogleNetworkServicesTlsRouteRulesAction): any;
export declare class GoogleNetworkServicesTlsRouteRulesActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesTlsRouteRulesAction | undefined;
    set internalValue(value: GoogleNetworkServicesTlsRouteRulesAction | undefined);
    private _destinations;
    get destinations(): GoogleNetworkServicesTlsRouteRulesActionDestinationsList;
    putDestinations(value: GoogleNetworkServicesTlsRouteRulesActionDestinations[] | cdktf.IResolvable): void;
    resetDestinations(): void;
    get destinationsInput(): cdktf.IResolvable | GoogleNetworkServicesTlsRouteRulesActionDestinations[] | undefined;
}
export interface GoogleNetworkServicesTlsRouteRulesMatches {
    /**
    * ALPN (Application-Layer Protocol Negotiation) to match against. Examples: "http/1.1", "h2". At least one of sniHost and alpn is required. Up to 5 alpns across all matches can be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#alpn GoogleNetworkServicesTlsRoute#alpn}
    */
    readonly alpn?: string[];
    /**
    * SNI (server name indicator) to match against. SNI will be matched against all wildcard domains, i.e. www.example.com will be first matched against www.example.com, then *.example.com, then *.com.
    * Partial wildcards are not supported, and values like *w.example.com are invalid. At least one of sniHost and alpn is required. Up to 5 sni hosts across all matches can be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#sni_host GoogleNetworkServicesTlsRoute#sni_host}
    */
    readonly sniHost?: string[];
}
export declare function googleNetworkServicesTlsRouteRulesMatchesToTerraform(struct?: GoogleNetworkServicesTlsRouteRulesMatches | cdktf.IResolvable): any;
export declare function googleNetworkServicesTlsRouteRulesMatchesToHclTerraform(struct?: GoogleNetworkServicesTlsRouteRulesMatches | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTlsRouteRulesMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesTlsRouteRulesMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTlsRouteRulesMatches | cdktf.IResolvable | undefined);
    private _alpn?;
    get alpn(): string[];
    set alpn(value: string[]);
    resetAlpn(): void;
    get alpnInput(): string[] | undefined;
    private _sniHost?;
    get sniHost(): string[];
    set sniHost(value: string[]);
    resetSniHost(): void;
    get sniHostInput(): string[] | undefined;
}
export declare class GoogleNetworkServicesTlsRouteRulesMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesTlsRouteRulesMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesTlsRouteRulesMatchesOutputReference;
}
export interface GoogleNetworkServicesTlsRouteRules {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#action GoogleNetworkServicesTlsRoute#action}
    */
    readonly action: GoogleNetworkServicesTlsRouteRulesAction;
    /**
    * matches block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#matches GoogleNetworkServicesTlsRoute#matches}
    */
    readonly matches: GoogleNetworkServicesTlsRouteRulesMatches[] | cdktf.IResolvable;
}
export declare function googleNetworkServicesTlsRouteRulesToTerraform(struct?: GoogleNetworkServicesTlsRouteRules | cdktf.IResolvable): any;
export declare function googleNetworkServicesTlsRouteRulesToHclTerraform(struct?: GoogleNetworkServicesTlsRouteRules | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTlsRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkServicesTlsRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTlsRouteRules | cdktf.IResolvable | undefined);
    private _action;
    get action(): GoogleNetworkServicesTlsRouteRulesActionOutputReference;
    putAction(value: GoogleNetworkServicesTlsRouteRulesAction): void;
    get actionInput(): GoogleNetworkServicesTlsRouteRulesAction | undefined;
    private _matches;
    get matches(): GoogleNetworkServicesTlsRouteRulesMatchesList;
    putMatches(value: GoogleNetworkServicesTlsRouteRulesMatches[] | cdktf.IResolvable): void;
    get matchesInput(): cdktf.IResolvable | GoogleNetworkServicesTlsRouteRulesMatches[] | undefined;
}
export declare class GoogleNetworkServicesTlsRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkServicesTlsRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkServicesTlsRouteRulesOutputReference;
}
export interface GoogleNetworkServicesTlsRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#create GoogleNetworkServicesTlsRoute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#delete GoogleNetworkServicesTlsRoute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#update GoogleNetworkServicesTlsRoute#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesTlsRouteTimeoutsToTerraform(struct?: GoogleNetworkServicesTlsRouteTimeouts | cdktf.IResolvable): any;
export declare function googleNetworkServicesTlsRouteTimeoutsToHclTerraform(struct?: GoogleNetworkServicesTlsRouteTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesTlsRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesTlsRouteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesTlsRouteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route google_network_services_tls_route}
*/
export declare class GoogleNetworkServicesTlsRoute extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_tls_route";
    /**
    * Generates CDKTF code for importing a GoogleNetworkServicesTlsRoute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNetworkServicesTlsRoute to import
    * @param importFromId The id of the existing GoogleNetworkServicesTlsRoute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNetworkServicesTlsRoute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_network_services_tls_route google_network_services_tls_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesTlsRouteConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesTlsRouteConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gateways?;
    get gateways(): string[];
    set gateways(value: string[]);
    resetGateways(): void;
    get gatewaysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meshes?;
    get meshes(): string[];
    set meshes(value: string[]);
    resetMeshes(): void;
    get meshesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleNetworkServicesTlsRouteRulesList;
    putRules(value: GoogleNetworkServicesTlsRouteRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleNetworkServicesTlsRouteRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesTlsRouteTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesTlsRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesTlsRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
