/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNotebooksEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * A brief description of this environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#description GoogleNotebooksEnvironment#description}
    */
    readonly description?: string;
    /**
    * Display name of this environment for the UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#display_name GoogleNotebooksEnvironment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#id GoogleNotebooksEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A reference to the zone where the machine resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#location GoogleNotebooksEnvironment#location}
    */
    readonly location: string;
    /**
    * The name specified for the Environment instance.
    * Format: projects/{project_id}/locations/{location}/environments/{environmentId}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#name GoogleNotebooksEnvironment#name}
    */
    readonly name: string;
    /**
    * Path to a Bash script that automatically runs after a notebook instance fully boots up.
    * The path must be a URL or Cloud Storage path. Example: "gs://path-to-file/file-name"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#post_startup_script GoogleNotebooksEnvironment#post_startup_script}
    */
    readonly postStartupScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#project GoogleNotebooksEnvironment#project}
    */
    readonly project?: string;
    /**
    * container_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#container_image GoogleNotebooksEnvironment#container_image}
    */
    readonly containerImage?: GoogleNotebooksEnvironmentContainerImage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#timeouts GoogleNotebooksEnvironment#timeouts}
    */
    readonly timeouts?: GoogleNotebooksEnvironmentTimeouts;
    /**
    * vm_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#vm_image GoogleNotebooksEnvironment#vm_image}
    */
    readonly vmImage?: GoogleNotebooksEnvironmentVmImage;
}
export interface GoogleNotebooksEnvironmentContainerImage {
    /**
    * The path to the container image repository.
    * For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#repository GoogleNotebooksEnvironment#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#tag GoogleNotebooksEnvironment#tag}
    */
    readonly tag?: string;
}
export declare function googleNotebooksEnvironmentContainerImageToTerraform(struct?: GoogleNotebooksEnvironmentContainerImageOutputReference | GoogleNotebooksEnvironmentContainerImage): any;
export declare function googleNotebooksEnvironmentContainerImageToHclTerraform(struct?: GoogleNotebooksEnvironmentContainerImageOutputReference | GoogleNotebooksEnvironmentContainerImage): any;
export declare class GoogleNotebooksEnvironmentContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksEnvironmentContainerImage | undefined;
    set internalValue(value: GoogleNotebooksEnvironmentContainerImage | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface GoogleNotebooksEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#create GoogleNotebooksEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#delete GoogleNotebooksEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#update GoogleNotebooksEnvironment#update}
    */
    readonly update?: string;
}
export declare function googleNotebooksEnvironmentTimeoutsToTerraform(struct?: GoogleNotebooksEnvironmentTimeouts | cdktf.IResolvable): any;
export declare function googleNotebooksEnvironmentTimeoutsToHclTerraform(struct?: GoogleNotebooksEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleNotebooksEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNotebooksEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleNotebooksEnvironmentVmImage {
    /**
    * Use this VM image family to find the image; the newest image in this family will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#image_family GoogleNotebooksEnvironment#image_family}
    */
    readonly imageFamily?: string;
    /**
    * Use VM image name to find the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#image_name GoogleNotebooksEnvironment#image_name}
    */
    readonly imageName?: string;
    /**
    * The name of the Google Cloud project that this VM image belongs to.
    * Format: projects/{project_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#project GoogleNotebooksEnvironment#project}
    */
    readonly project: string;
}
export declare function googleNotebooksEnvironmentVmImageToTerraform(struct?: GoogleNotebooksEnvironmentVmImageOutputReference | GoogleNotebooksEnvironmentVmImage): any;
export declare function googleNotebooksEnvironmentVmImageToHclTerraform(struct?: GoogleNotebooksEnvironmentVmImageOutputReference | GoogleNotebooksEnvironmentVmImage): any;
export declare class GoogleNotebooksEnvironmentVmImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksEnvironmentVmImage | undefined;
    set internalValue(value: GoogleNotebooksEnvironmentVmImage | undefined);
    private _imageFamily?;
    get imageFamily(): string;
    set imageFamily(value: string);
    resetImageFamily(): void;
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment google_notebooks_environment}
*/
export declare class GoogleNotebooksEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_environment";
    /**
    * Generates CDKTF code for importing a GoogleNotebooksEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNotebooksEnvironment to import
    * @param importFromId The id of the existing GoogleNotebooksEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNotebooksEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_environment google_notebooks_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNotebooksEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNotebooksEnvironmentConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _postStartupScript?;
    get postStartupScript(): string;
    set postStartupScript(value: string);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _containerImage;
    get containerImage(): GoogleNotebooksEnvironmentContainerImageOutputReference;
    putContainerImage(value: GoogleNotebooksEnvironmentContainerImage): void;
    resetContainerImage(): void;
    get containerImageInput(): GoogleNotebooksEnvironmentContainerImage | undefined;
    private _timeouts;
    get timeouts(): GoogleNotebooksEnvironmentTimeoutsOutputReference;
    putTimeouts(value: GoogleNotebooksEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNotebooksEnvironmentTimeouts | undefined;
    private _vmImage;
    get vmImage(): GoogleNotebooksEnvironmentVmImageOutputReference;
    putVmImage(value: GoogleNotebooksEnvironmentVmImage): void;
    resetVmImage(): void;
    get vmImageInput(): GoogleNotebooksEnvironmentVmImage | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
