/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNotebooksRuntimeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#id GoogleNotebooksRuntime#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels to associate with this runtime. Label **keys** must
    * contain 1 to 63 characters, and must conform to [RFC 1035]
    * (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
    * empty, but, if present, must contain 1 to 63 characters, and must
    * conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
    * more than 32 labels can be associated with a cluster.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#labels GoogleNotebooksRuntime#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A reference to the zone where the machine resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#location GoogleNotebooksRuntime#location}
    */
    readonly location: string;
    /**
    * The name specified for the Notebook runtime.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#name GoogleNotebooksRuntime#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#project GoogleNotebooksRuntime#project}
    */
    readonly project?: string;
    /**
    * access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#access_config GoogleNotebooksRuntime#access_config}
    */
    readonly accessConfig?: GoogleNotebooksRuntimeAccessConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#software_config GoogleNotebooksRuntime#software_config}
    */
    readonly softwareConfig?: GoogleNotebooksRuntimeSoftwareConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#timeouts GoogleNotebooksRuntime#timeouts}
    */
    readonly timeouts?: GoogleNotebooksRuntimeTimeouts;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#virtual_machine GoogleNotebooksRuntime#virtual_machine}
    */
    readonly virtualMachine?: GoogleNotebooksRuntimeVirtualMachine;
}
export interface GoogleNotebooksRuntimeMetrics {
}
export declare function googleNotebooksRuntimeMetricsToTerraform(struct?: GoogleNotebooksRuntimeMetrics): any;
export declare function googleNotebooksRuntimeMetricsToHclTerraform(struct?: GoogleNotebooksRuntimeMetrics): any;
export declare class GoogleNotebooksRuntimeMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNotebooksRuntimeMetrics | undefined;
    set internalValue(value: GoogleNotebooksRuntimeMetrics | undefined);
    private _systemMetrics;
    get systemMetrics(): cdktf.StringMap;
}
export declare class GoogleNotebooksRuntimeMetricsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNotebooksRuntimeMetricsOutputReference;
}
export interface GoogleNotebooksRuntimeAccessConfig {
    /**
    * The type of access mode this instance. For valid values, see
    * 'https://cloud.google.com/vertex-ai/docs/workbench/reference/
    * rest/v1/projects.locations.runtimes#RuntimeAccessType'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#access_type GoogleNotebooksRuntime#access_type}
    */
    readonly accessType?: string;
    /**
    * The owner of this runtime after creation. Format: 'alias@example.com'.
    * Currently supports one owner only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#runtime_owner GoogleNotebooksRuntime#runtime_owner}
    */
    readonly runtimeOwner?: string;
}
export declare function googleNotebooksRuntimeAccessConfigToTerraform(struct?: GoogleNotebooksRuntimeAccessConfigOutputReference | GoogleNotebooksRuntimeAccessConfig): any;
export declare function googleNotebooksRuntimeAccessConfigToHclTerraform(struct?: GoogleNotebooksRuntimeAccessConfigOutputReference | GoogleNotebooksRuntimeAccessConfig): any;
export declare class GoogleNotebooksRuntimeAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeAccessConfig | undefined;
    set internalValue(value: GoogleNotebooksRuntimeAccessConfig | undefined);
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    get proxyUri(): string;
    private _runtimeOwner?;
    get runtimeOwner(): string;
    set runtimeOwner(value: string);
    resetRuntimeOwner(): void;
    get runtimeOwnerInput(): string | undefined;
}
export interface GoogleNotebooksRuntimeSoftwareConfigKernels {
    /**
    * The path to the container image repository.
    * For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#repository GoogleNotebooksRuntime#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#tag GoogleNotebooksRuntime#tag}
    */
    readonly tag?: string;
}
export declare function googleNotebooksRuntimeSoftwareConfigKernelsToTerraform(struct?: GoogleNotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable): any;
export declare function googleNotebooksRuntimeSoftwareConfigKernelsToHclTerraform(struct?: GoogleNotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable): any;
export declare class GoogleNotebooksRuntimeSoftwareConfigKernelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class GoogleNotebooksRuntimeSoftwareConfigKernelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNotebooksRuntimeSoftwareConfigKernels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNotebooksRuntimeSoftwareConfigKernelsOutputReference;
}
export interface GoogleNotebooksRuntimeSoftwareConfig {
    /**
    * Specify a custom Cloud Storage path where the GPU driver is stored.
    * If not specified, we'll automatically choose from official GPU drivers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#custom_gpu_driver_path GoogleNotebooksRuntime#custom_gpu_driver_path}
    */
    readonly customGpuDriverPath?: string;
    /**
    * Verifies core internal services are running. Default: True.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#enable_health_monitoring GoogleNotebooksRuntime#enable_health_monitoring}
    */
    readonly enableHealthMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Runtime will automatically shutdown after idle_shutdown_time.
    * Default: True
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#idle_shutdown GoogleNotebooksRuntime#idle_shutdown}
    */
    readonly idleShutdown?: boolean | cdktf.IResolvable;
    /**
    * Time in minutes to wait before shuting down runtime.
    * Default: 180 minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#idle_shutdown_timeout GoogleNotebooksRuntime#idle_shutdown_timeout}
    */
    readonly idleShutdownTimeout?: number;
    /**
    * Install Nvidia Driver automatically.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#install_gpu_driver GoogleNotebooksRuntime#install_gpu_driver}
    */
    readonly installGpuDriver?: boolean | cdktf.IResolvable;
    /**
    * Cron expression in UTC timezone for schedule instance auto upgrade.
    * Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#notebook_upgrade_schedule GoogleNotebooksRuntime#notebook_upgrade_schedule}
    */
    readonly notebookUpgradeSchedule?: string;
    /**
    * Path to a Bash script that automatically runs after a notebook instance
    * fully boots up. The path must be a URL or
    * Cloud Storage path (gs://path-to-file/file-name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#post_startup_script GoogleNotebooksRuntime#post_startup_script}
    */
    readonly postStartupScript?: string;
    /**
    * Behavior for the post startup script. Possible values: ["POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED", "RUN_EVERY_START", "DOWNLOAD_AND_RUN_EVERY_START"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#post_startup_script_behavior GoogleNotebooksRuntime#post_startup_script_behavior}
    */
    readonly postStartupScriptBehavior?: string;
    /**
    * kernels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#kernels GoogleNotebooksRuntime#kernels}
    */
    readonly kernels?: GoogleNotebooksRuntimeSoftwareConfigKernels[] | cdktf.IResolvable;
}
export declare function googleNotebooksRuntimeSoftwareConfigToTerraform(struct?: GoogleNotebooksRuntimeSoftwareConfigOutputReference | GoogleNotebooksRuntimeSoftwareConfig): any;
export declare function googleNotebooksRuntimeSoftwareConfigToHclTerraform(struct?: GoogleNotebooksRuntimeSoftwareConfigOutputReference | GoogleNotebooksRuntimeSoftwareConfig): any;
export declare class GoogleNotebooksRuntimeSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeSoftwareConfig | undefined;
    set internalValue(value: GoogleNotebooksRuntimeSoftwareConfig | undefined);
    private _customGpuDriverPath?;
    get customGpuDriverPath(): string;
    set customGpuDriverPath(value: string);
    resetCustomGpuDriverPath(): void;
    get customGpuDriverPathInput(): string | undefined;
    private _enableHealthMonitoring?;
    get enableHealthMonitoring(): boolean | cdktf.IResolvable;
    set enableHealthMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableHealthMonitoring(): void;
    get enableHealthMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _idleShutdown?;
    get idleShutdown(): boolean | cdktf.IResolvable;
    set idleShutdown(value: boolean | cdktf.IResolvable);
    resetIdleShutdown(): void;
    get idleShutdownInput(): boolean | cdktf.IResolvable | undefined;
    private _idleShutdownTimeout?;
    get idleShutdownTimeout(): number;
    set idleShutdownTimeout(value: number);
    resetIdleShutdownTimeout(): void;
    get idleShutdownTimeoutInput(): number | undefined;
    private _installGpuDriver?;
    get installGpuDriver(): boolean | cdktf.IResolvable;
    set installGpuDriver(value: boolean | cdktf.IResolvable);
    resetInstallGpuDriver(): void;
    get installGpuDriverInput(): boolean | cdktf.IResolvable | undefined;
    private _notebookUpgradeSchedule?;
    get notebookUpgradeSchedule(): string;
    set notebookUpgradeSchedule(value: string);
    resetNotebookUpgradeSchedule(): void;
    get notebookUpgradeScheduleInput(): string | undefined;
    private _postStartupScript?;
    get postStartupScript(): string;
    set postStartupScript(value: string);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _postStartupScriptBehavior?;
    get postStartupScriptBehavior(): string;
    set postStartupScriptBehavior(value: string);
    resetPostStartupScriptBehavior(): void;
    get postStartupScriptBehaviorInput(): string | undefined;
    get upgradeable(): cdktf.IResolvable;
    private _kernels;
    get kernels(): GoogleNotebooksRuntimeSoftwareConfigKernelsList;
    putKernels(value: GoogleNotebooksRuntimeSoftwareConfigKernels[] | cdktf.IResolvable): void;
    resetKernels(): void;
    get kernelsInput(): cdktf.IResolvable | GoogleNotebooksRuntimeSoftwareConfigKernels[] | undefined;
}
export interface GoogleNotebooksRuntimeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#create GoogleNotebooksRuntime#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#delete GoogleNotebooksRuntime#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#update GoogleNotebooksRuntime#update}
    */
    readonly update?: string;
}
export declare function googleNotebooksRuntimeTimeoutsToTerraform(struct?: GoogleNotebooksRuntimeTimeouts | cdktf.IResolvable): any;
export declare function googleNotebooksRuntimeTimeoutsToHclTerraform(struct?: GoogleNotebooksRuntimeTimeouts | cdktf.IResolvable): any;
export declare class GoogleNotebooksRuntimeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNotebooksRuntimeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig {
    /**
    * Count of cores of this accelerator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#core_count GoogleNotebooksRuntime#core_count}
    */
    readonly coreCount?: number;
    /**
    * Accelerator model. For valid values, see
    * 'https://cloud.google.com/vertex-ai/docs/workbench/reference/
    * rest/v1/projects.locations.runtimes#AcceleratorType'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#type GoogleNotebooksRuntime#type}
    */
    readonly type?: string;
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig | undefined);
    private _coreCount?;
    get coreCount(): number;
    set coreCount(value: number);
    resetCoreCount(): void;
    get coreCountInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages {
    /**
    * The path to the container image repository.
    * For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#repository GoogleNotebooksRuntime#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#tag GoogleNotebooksRuntime#tag}
    */
    readonly tag?: string;
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesOutputReference;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams {
    /**
    * Provide this property when creating the disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#description GoogleNotebooksRuntime#description}
    */
    readonly description?: string;
    /**
    * Specifies the disk name. If not specified, the default is
    * to use the name of the instance. If the disk with the
    * instance name exists already in the given zone/region, a
    * new name will be automatically generated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#disk_name GoogleNotebooksRuntime#disk_name}
    */
    readonly diskName?: string;
    /**
    * Specifies the size of the disk in base-2 GB. If not
    * specified, the disk will be the same size as the image
    * (usually 10GB). If specified, the size must be equal to
    * or larger than 10GB. Default 100 GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#disk_size_gb GoogleNotebooksRuntime#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * The type of the boot disk attached to this runtime,
    * defaults to standard persistent disk. For valid values,
    * see 'https://cloud.google.com/vertex-ai/docs/workbench/
    * reference/rest/v1/projects.locations.runtimes#disktype'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#disk_type GoogleNotebooksRuntime#disk_type}
    */
    readonly diskType?: string;
    /**
    * Labels to apply to this disk. These can be later modified
    * by the disks.setLabels method. This field is only
    * applicable for persistent disks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#labels GoogleNotebooksRuntime#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    resetDiskName(): void;
    get diskNameInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk {
    /**
    * "Specifies the disk interface to use for attaching this disk,
    * which is either SCSI or NVME. The default is SCSI. Persistent
    * disks must always use SCSI and the request will fail if you attempt
    * to attach a persistent disk in any other format than SCSI. Local SSDs
    * can use either NVME or SCSI. For performance characteristics of SCSI
    * over NVMe, see Local SSD performance. Valid values: * NVME * SCSI".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#interface GoogleNotebooksRuntime#interface}
    */
    readonly interface?: string;
    /**
    * The mode in which to attach this disk, either READ_WRITE
    * or READ_ONLY. If not specified, the default is to attach
    * the disk in READ_WRITE mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#mode GoogleNotebooksRuntime#mode}
    */
    readonly mode?: string;
    /**
    * Specifies a valid partial or full URL to an existing
    * Persistent Disk resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#source GoogleNotebooksRuntime#source}
    */
    readonly source?: string;
    /**
    * Specifies the type of the disk, either SCRATCH or PERSISTENT.
    * If not specified, the default is PERSISTENT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#type GoogleNotebooksRuntime#type}
    */
    readonly type?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#initialize_params GoogleNotebooksRuntime#initialize_params}
    */
    readonly initializeParams?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams;
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk | undefined);
    get autoDelete(): cdktf.IResolvable;
    get boot(): cdktf.IResolvable;
    get deviceName(): string;
    get guestOsFeatures(): string[];
    get index(): number;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    get kind(): string;
    get licenses(): string[];
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference;
    putInitializeParams(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig {
    /**
    * The Cloud KMS resource identifier of the customer-managed
    * encryption key used to protect a resource, such as a disks.
    * It has the following format:
    * 'projects/{PROJECT_ID}/locations/{REGION}/keyRings/
    * {KEY_RING_NAME}/cryptoKeys/{KEY_NAME}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#kms_key GoogleNotebooksRuntime#kms_key}
    */
    readonly kmsKey?: string;
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    * Enables monitoring and attestation of the boot integrity of
    * the instance. The attestation is performed against the
    * integrity policy baseline. This baseline is initially derived
    * from the implicitly trusted boot image when the instance is
    * created. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#enable_integrity_monitoring GoogleNotebooksRuntime#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.Secure
    * Boot helps ensure that the system only runs authentic software
    * by verifying the digital signature of all boot components, and
    * halting the boot process if signature verification fails.
    * Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#enable_secure_boot GoogleNotebooksRuntime#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has the vTPM enabled. Enabled by
    * default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#enable_vtpm GoogleNotebooksRuntime#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig {
    /**
    * If true, runtime will only have internal IP addresses. By default,
    * runtimes are not restricted to internal IP addresses, and will
    * have ephemeral external IP addresses assigned to each vm. This
    * 'internal_ip_only' restriction can only be enabled for subnetwork
    * enabled networks, and all dependencies must be configured to be
    * accessible without external IP addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#internal_ip_only GoogleNotebooksRuntime#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * The labels to associate with this runtime. Label **keys** must
    * contain 1 to 63 characters, and must conform to [RFC 1035]
    * (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
    * empty, but, if present, must contain 1 to 63 characters, and must
    * conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
    * more than 32 labels can be associated with a cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#labels GoogleNotebooksRuntime#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Compute Engine machine type used for runtimes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#machine_type GoogleNotebooksRuntime#machine_type}
    */
    readonly machineType: string;
    /**
    * The Compute Engine metadata entries to add to virtual machine.
    * (see [Project and instance metadata](https://cloud.google.com
    * /compute/docs/storing-retrieving-metadata#project_and_instance
    * _metadata)).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#metadata GoogleNotebooksRuntime#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The Compute Engine network to be used for machine communications.
    * Cannot be specified with subnetwork. If neither 'network' nor
    * 'subnet' is specified, the "default" network of the project is
    * used, if it exists. A full URL or partial URI. Examples:
    *   * 'https://www.googleapis.com/compute/v1/projects/[project_id]/
    *   regions/global/default'
    *   * 'projects/[project_id]/regions/global/default'
    * Runtimes are managed resources inside Google Infrastructure.
    * Runtimes support the following network configurations:
    *   * Google Managed Network (Network & subnet are empty)
    *   * Consumer Project VPC (network & subnet are required). Requires
    *   configuring Private Service Access.
    *   * Shared VPC (network & subnet are required). Requires
    *   configuring Private Service Access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#network GoogleNotebooksRuntime#network}
    */
    readonly network?: string;
    /**
    * The type of vNIC to be used on this interface. This may be gVNIC
    * or VirtioNet. Possible values: ["UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#nic_type GoogleNotebooksRuntime#nic_type}
    */
    readonly nicType?: string;
    /**
    * Reserved IP Range name is used for VPC Peering. The
    * subnetwork allocation will use the range *name* if it's assigned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#reserved_ip_range GoogleNotebooksRuntime#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
    /**
    * The Compute Engine subnetwork to be used for machine
    * communications. Cannot be specified with network. A full URL or
    * partial URI are valid. Examples:
    *   * 'https://www.googleapis.com/compute/v1/projects/[project_id]/
    *   regions/us-east1/subnetworks/sub0'
    *   * 'projects/[project_id]/regions/us-east1/subnetworks/sub0'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#subnet GoogleNotebooksRuntime#subnet}
    */
    readonly subnet?: string;
    /**
    * The Compute Engine tags to add to runtime (see [Tagging instances]
    * (https://cloud.google.com/compute/docs/
    * label-or-tag-resources#tags)).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#tags GoogleNotebooksRuntime#tags}
    */
    readonly tags?: string[];
    /**
    * accelerator_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#accelerator_config GoogleNotebooksRuntime#accelerator_config}
    */
    readonly acceleratorConfig?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig;
    /**
    * container_images block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#container_images GoogleNotebooksRuntime#container_images}
    */
    readonly containerImages?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | cdktf.IResolvable;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#data_disk GoogleNotebooksRuntime#data_disk}
    */
    readonly dataDisk: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#encryption_config GoogleNotebooksRuntime#encryption_config}
    */
    readonly encryptionConfig?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#shielded_instance_config GoogleNotebooksRuntime#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig;
}
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig): any;
export declare function googleNotebooksRuntimeVirtualMachineVirtualMachineConfigToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig): any;
export declare class GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig | undefined);
    private _guestAttributes;
    get guestAttributes(): cdktf.StringMap;
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    resetReservedIpRange(): void;
    get reservedIpRangeInput(): string | undefined;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get zone(): string;
    private _acceleratorConfig;
    get acceleratorConfig(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference;
    putAcceleratorConfig(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig): void;
    resetAcceleratorConfig(): void;
    get acceleratorConfigInput(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig | undefined;
    private _containerImages;
    get containerImages(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesList;
    putContainerImages(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | cdktf.IResolvable): void;
    resetContainerImages(): void;
    get containerImagesInput(): cdktf.IResolvable | GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | undefined;
    private _dataDisk;
    get dataDisk(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference;
    putDataDisk(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk): void;
    get dataDiskInput(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig | undefined;
}
export interface GoogleNotebooksRuntimeVirtualMachine {
    /**
    * virtual_machine_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#virtual_machine_config GoogleNotebooksRuntime#virtual_machine_config}
    */
    readonly virtualMachineConfig?: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig;
}
export declare function googleNotebooksRuntimeVirtualMachineToTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineOutputReference | GoogleNotebooksRuntimeVirtualMachine): any;
export declare function googleNotebooksRuntimeVirtualMachineToHclTerraform(struct?: GoogleNotebooksRuntimeVirtualMachineOutputReference | GoogleNotebooksRuntimeVirtualMachine): any;
export declare class GoogleNotebooksRuntimeVirtualMachineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeVirtualMachine | undefined;
    set internalValue(value: GoogleNotebooksRuntimeVirtualMachine | undefined);
    get instanceId(): string;
    get instanceName(): string;
    private _virtualMachineConfig;
    get virtualMachineConfig(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference;
    putVirtualMachineConfig(value: GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig): void;
    resetVirtualMachineConfig(): void;
    get virtualMachineConfigInput(): GoogleNotebooksRuntimeVirtualMachineVirtualMachineConfig | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime google_notebooks_runtime}
*/
export declare class GoogleNotebooksRuntime extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_runtime";
    /**
    * Generates CDKTF code for importing a GoogleNotebooksRuntime resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleNotebooksRuntime to import
    * @param importFromId The id of the existing GoogleNotebooksRuntime that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleNotebooksRuntime to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_notebooks_runtime google_notebooks_runtime} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNotebooksRuntimeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNotebooksRuntimeConfig);
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get healthState(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metrics;
    get metrics(): GoogleNotebooksRuntimeMetricsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _accessConfig;
    get accessConfig(): GoogleNotebooksRuntimeAccessConfigOutputReference;
    putAccessConfig(value: GoogleNotebooksRuntimeAccessConfig): void;
    resetAccessConfig(): void;
    get accessConfigInput(): GoogleNotebooksRuntimeAccessConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): GoogleNotebooksRuntimeSoftwareConfigOutputReference;
    putSoftwareConfig(value: GoogleNotebooksRuntimeSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): GoogleNotebooksRuntimeSoftwareConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleNotebooksRuntimeTimeoutsOutputReference;
    putTimeouts(value: GoogleNotebooksRuntimeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNotebooksRuntimeTimeouts | undefined;
    private _virtualMachine;
    get virtualMachine(): GoogleNotebooksRuntimeVirtualMachineOutputReference;
    putVirtualMachine(value: GoogleNotebooksRuntimeVirtualMachine): void;
    resetVirtualMachine(): void;
    get virtualMachineInput(): GoogleNotebooksRuntimeVirtualMachine | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
