/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleOrgPolicyPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#id GoogleOrgPolicyPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Immutable. The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#name GoogleOrgPolicyPolicy#name}
    */
    readonly name: string;
    /**
    * The parent of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#parent GoogleOrgPolicyPolicy#parent}
    */
    readonly parent: string;
    /**
    * dry_run_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#dry_run_spec GoogleOrgPolicyPolicy#dry_run_spec}
    */
    readonly dryRunSpec?: GoogleOrgPolicyPolicyDryRunSpec;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#spec GoogleOrgPolicyPolicy#spec}
    */
    readonly spec?: GoogleOrgPolicyPolicySpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#timeouts GoogleOrgPolicyPolicy#timeouts}
    */
    readonly timeouts?: GoogleOrgPolicyPolicyTimeouts;
}
export interface GoogleOrgPolicyPolicyDryRunSpecRulesCondition {
    /**
    * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#description GoogleOrgPolicyPolicy#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#expression GoogleOrgPolicyPolicy#expression}
    */
    readonly expression?: string;
    /**
    * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#location GoogleOrgPolicyPolicy#location}
    */
    readonly location?: string;
    /**
    * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#title GoogleOrgPolicyPolicy#title}
    */
    readonly title?: string;
}
export declare function googleOrgPolicyPolicyDryRunSpecRulesConditionToTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecRulesConditionOutputReference | GoogleOrgPolicyPolicyDryRunSpecRulesCondition): any;
export declare function googleOrgPolicyPolicyDryRunSpecRulesConditionToHclTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecRulesConditionOutputReference | GoogleOrgPolicyPolicyDryRunSpecRulesCondition): any;
export declare class GoogleOrgPolicyPolicyDryRunSpecRulesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicyDryRunSpecRulesCondition | undefined;
    set internalValue(value: GoogleOrgPolicyPolicyDryRunSpecRulesCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleOrgPolicyPolicyDryRunSpecRulesValues {
    /**
    * List of values allowed at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#allowed_values GoogleOrgPolicyPolicy#allowed_values}
    */
    readonly allowedValues?: string[];
    /**
    * List of values denied at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#denied_values GoogleOrgPolicyPolicy#denied_values}
    */
    readonly deniedValues?: string[];
}
export declare function googleOrgPolicyPolicyDryRunSpecRulesValuesToTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecRulesValuesOutputReference | GoogleOrgPolicyPolicyDryRunSpecRulesValues): any;
export declare function googleOrgPolicyPolicyDryRunSpecRulesValuesToHclTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecRulesValuesOutputReference | GoogleOrgPolicyPolicyDryRunSpecRulesValues): any;
export declare class GoogleOrgPolicyPolicyDryRunSpecRulesValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicyDryRunSpecRulesValues | undefined;
    set internalValue(value: GoogleOrgPolicyPolicyDryRunSpecRulesValues | undefined);
    private _allowedValues?;
    get allowedValues(): string[];
    set allowedValues(value: string[]);
    resetAllowedValues(): void;
    get allowedValuesInput(): string[] | undefined;
    private _deniedValues?;
    get deniedValues(): string[];
    set deniedValues(value: string[]);
    resetDeniedValues(): void;
    get deniedValuesInput(): string[] | undefined;
}
export interface GoogleOrgPolicyPolicyDryRunSpecRules {
    /**
    * Setting this to `"TRUE"` means that all values are allowed. This field can be set only in policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#allow_all GoogleOrgPolicyPolicy#allow_all}
    */
    readonly allowAll?: string;
    /**
    * Setting this to `"TRUE"` means that all values are denied. This field can be set only in policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#deny_all GoogleOrgPolicyPolicy#deny_all}
    */
    readonly denyAll?: string;
    /**
    * If `"TRUE"`, then the policy is enforced. If `"FALSE"`, then any configuration is acceptable. This field can be set only in policies for boolean constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#enforce GoogleOrgPolicyPolicy#enforce}
    */
    readonly enforce?: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#condition GoogleOrgPolicyPolicy#condition}
    */
    readonly condition?: GoogleOrgPolicyPolicyDryRunSpecRulesCondition;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#values GoogleOrgPolicyPolicy#values}
    */
    readonly values?: GoogleOrgPolicyPolicyDryRunSpecRulesValues;
}
export declare function googleOrgPolicyPolicyDryRunSpecRulesToTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecRules | cdktf.IResolvable): any;
export declare function googleOrgPolicyPolicyDryRunSpecRulesToHclTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecRules | cdktf.IResolvable): any;
export declare class GoogleOrgPolicyPolicyDryRunSpecRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOrgPolicyPolicyDryRunSpecRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOrgPolicyPolicyDryRunSpecRules | cdktf.IResolvable | undefined);
    private _allowAll?;
    get allowAll(): string;
    set allowAll(value: string);
    resetAllowAll(): void;
    get allowAllInput(): string | undefined;
    private _denyAll?;
    get denyAll(): string;
    set denyAll(value: string);
    resetDenyAll(): void;
    get denyAllInput(): string | undefined;
    private _enforce?;
    get enforce(): string;
    set enforce(value: string);
    resetEnforce(): void;
    get enforceInput(): string | undefined;
    private _condition;
    get condition(): GoogleOrgPolicyPolicyDryRunSpecRulesConditionOutputReference;
    putCondition(value: GoogleOrgPolicyPolicyDryRunSpecRulesCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleOrgPolicyPolicyDryRunSpecRulesCondition | undefined;
    private _values;
    get values(): GoogleOrgPolicyPolicyDryRunSpecRulesValuesOutputReference;
    putValues(value: GoogleOrgPolicyPolicyDryRunSpecRulesValues): void;
    resetValues(): void;
    get valuesInput(): GoogleOrgPolicyPolicyDryRunSpecRulesValues | undefined;
}
export declare class GoogleOrgPolicyPolicyDryRunSpecRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOrgPolicyPolicyDryRunSpecRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOrgPolicyPolicyDryRunSpecRulesOutputReference;
}
export interface GoogleOrgPolicyPolicyDryRunSpec {
    /**
    * Determines the inheritance behavior for this policy. If `inherit_from_parent` is true, policy rules set higher up in the hierarchy (up to the closest root) are inherited and present in the effective policy. If it is false, then no rules are inherited, and this policy becomes the new root for evaluation. This field can be set only for policies which configure list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#inherit_from_parent GoogleOrgPolicyPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * Ignores policies set above this resource and restores the `constraint_default` enforcement behavior of the specific constraint at this resource. This field can be set in policies for either list or boolean constraints. If set, `rules` must be empty and `inherit_from_parent` must be set to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#reset GoogleOrgPolicyPolicy#reset}
    */
    readonly reset?: boolean | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#rules GoogleOrgPolicyPolicy#rules}
    */
    readonly rules?: GoogleOrgPolicyPolicyDryRunSpecRules[] | cdktf.IResolvable;
}
export declare function googleOrgPolicyPolicyDryRunSpecToTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecOutputReference | GoogleOrgPolicyPolicyDryRunSpec): any;
export declare function googleOrgPolicyPolicyDryRunSpecToHclTerraform(struct?: GoogleOrgPolicyPolicyDryRunSpecOutputReference | GoogleOrgPolicyPolicyDryRunSpec): any;
export declare class GoogleOrgPolicyPolicyDryRunSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicyDryRunSpec | undefined;
    set internalValue(value: GoogleOrgPolicyPolicyDryRunSpec | undefined);
    get etag(): string;
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _reset?;
    get reset(): boolean | cdktf.IResolvable;
    set reset(value: boolean | cdktf.IResolvable);
    resetReset(): void;
    get resetInput(): boolean | cdktf.IResolvable | undefined;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleOrgPolicyPolicyDryRunSpecRulesList;
    putRules(value: GoogleOrgPolicyPolicyDryRunSpecRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | GoogleOrgPolicyPolicyDryRunSpecRules[] | undefined;
}
export interface GoogleOrgPolicyPolicySpecRulesCondition {
    /**
    * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#description GoogleOrgPolicyPolicy#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#expression GoogleOrgPolicyPolicy#expression}
    */
    readonly expression?: string;
    /**
    * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#location GoogleOrgPolicyPolicy#location}
    */
    readonly location?: string;
    /**
    * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#title GoogleOrgPolicyPolicy#title}
    */
    readonly title?: string;
}
export declare function googleOrgPolicyPolicySpecRulesConditionToTerraform(struct?: GoogleOrgPolicyPolicySpecRulesConditionOutputReference | GoogleOrgPolicyPolicySpecRulesCondition): any;
export declare function googleOrgPolicyPolicySpecRulesConditionToHclTerraform(struct?: GoogleOrgPolicyPolicySpecRulesConditionOutputReference | GoogleOrgPolicyPolicySpecRulesCondition): any;
export declare class GoogleOrgPolicyPolicySpecRulesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicySpecRulesCondition | undefined;
    set internalValue(value: GoogleOrgPolicyPolicySpecRulesCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleOrgPolicyPolicySpecRulesValues {
    /**
    * List of values allowed at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#allowed_values GoogleOrgPolicyPolicy#allowed_values}
    */
    readonly allowedValues?: string[];
    /**
    * List of values denied at this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#denied_values GoogleOrgPolicyPolicy#denied_values}
    */
    readonly deniedValues?: string[];
}
export declare function googleOrgPolicyPolicySpecRulesValuesToTerraform(struct?: GoogleOrgPolicyPolicySpecRulesValuesOutputReference | GoogleOrgPolicyPolicySpecRulesValues): any;
export declare function googleOrgPolicyPolicySpecRulesValuesToHclTerraform(struct?: GoogleOrgPolicyPolicySpecRulesValuesOutputReference | GoogleOrgPolicyPolicySpecRulesValues): any;
export declare class GoogleOrgPolicyPolicySpecRulesValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicySpecRulesValues | undefined;
    set internalValue(value: GoogleOrgPolicyPolicySpecRulesValues | undefined);
    private _allowedValues?;
    get allowedValues(): string[];
    set allowedValues(value: string[]);
    resetAllowedValues(): void;
    get allowedValuesInput(): string[] | undefined;
    private _deniedValues?;
    get deniedValues(): string[];
    set deniedValues(value: string[]);
    resetDeniedValues(): void;
    get deniedValuesInput(): string[] | undefined;
}
export interface GoogleOrgPolicyPolicySpecRules {
    /**
    * Setting this to `"TRUE"` means that all values are allowed. This field can be set only in Policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#allow_all GoogleOrgPolicyPolicy#allow_all}
    */
    readonly allowAll?: string;
    /**
    * Setting this to `"TRUE"` means that all values are denied. This field can be set only in Policies for list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#deny_all GoogleOrgPolicyPolicy#deny_all}
    */
    readonly denyAll?: string;
    /**
    * If `"TRUE"`, then the `Policy` is enforced. If `"FALSE"`, then any configuration is acceptable. This field can be set only in Policies for boolean constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#enforce GoogleOrgPolicyPolicy#enforce}
    */
    readonly enforce?: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#condition GoogleOrgPolicyPolicy#condition}
    */
    readonly condition?: GoogleOrgPolicyPolicySpecRulesCondition;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#values GoogleOrgPolicyPolicy#values}
    */
    readonly values?: GoogleOrgPolicyPolicySpecRulesValues;
}
export declare function googleOrgPolicyPolicySpecRulesToTerraform(struct?: GoogleOrgPolicyPolicySpecRules | cdktf.IResolvable): any;
export declare function googleOrgPolicyPolicySpecRulesToHclTerraform(struct?: GoogleOrgPolicyPolicySpecRules | cdktf.IResolvable): any;
export declare class GoogleOrgPolicyPolicySpecRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOrgPolicyPolicySpecRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOrgPolicyPolicySpecRules | cdktf.IResolvable | undefined);
    private _allowAll?;
    get allowAll(): string;
    set allowAll(value: string);
    resetAllowAll(): void;
    get allowAllInput(): string | undefined;
    private _denyAll?;
    get denyAll(): string;
    set denyAll(value: string);
    resetDenyAll(): void;
    get denyAllInput(): string | undefined;
    private _enforce?;
    get enforce(): string;
    set enforce(value: string);
    resetEnforce(): void;
    get enforceInput(): string | undefined;
    private _condition;
    get condition(): GoogleOrgPolicyPolicySpecRulesConditionOutputReference;
    putCondition(value: GoogleOrgPolicyPolicySpecRulesCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleOrgPolicyPolicySpecRulesCondition | undefined;
    private _values;
    get values(): GoogleOrgPolicyPolicySpecRulesValuesOutputReference;
    putValues(value: GoogleOrgPolicyPolicySpecRulesValues): void;
    resetValues(): void;
    get valuesInput(): GoogleOrgPolicyPolicySpecRulesValues | undefined;
}
export declare class GoogleOrgPolicyPolicySpecRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOrgPolicyPolicySpecRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOrgPolicyPolicySpecRulesOutputReference;
}
export interface GoogleOrgPolicyPolicySpec {
    /**
    * Determines the inheritance behavior for this `Policy`. If `inherit_from_parent` is true, PolicyRules set higher up in the hierarchy (up to the closest root) are inherited and present in the effective policy. If it is false, then no rules are inherited, and this Policy becomes the new root for evaluation. This field can be set only for Policies which configure list constraints.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#inherit_from_parent GoogleOrgPolicyPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * Ignores policies set above this resource and restores the `constraint_default` enforcement behavior of the specific `Constraint` at this resource. This field can be set in policies for either list or boolean constraints. If set, `rules` must be empty and `inherit_from_parent` must be set to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#reset GoogleOrgPolicyPolicy#reset}
    */
    readonly reset?: boolean | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#rules GoogleOrgPolicyPolicy#rules}
    */
    readonly rules?: GoogleOrgPolicyPolicySpecRules[] | cdktf.IResolvable;
}
export declare function googleOrgPolicyPolicySpecToTerraform(struct?: GoogleOrgPolicyPolicySpecOutputReference | GoogleOrgPolicyPolicySpec): any;
export declare function googleOrgPolicyPolicySpecToHclTerraform(struct?: GoogleOrgPolicyPolicySpecOutputReference | GoogleOrgPolicyPolicySpec): any;
export declare class GoogleOrgPolicyPolicySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicySpec | undefined;
    set internalValue(value: GoogleOrgPolicyPolicySpec | undefined);
    get etag(): string;
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _reset?;
    get reset(): boolean | cdktf.IResolvable;
    set reset(value: boolean | cdktf.IResolvable);
    resetReset(): void;
    get resetInput(): boolean | cdktf.IResolvable | undefined;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleOrgPolicyPolicySpecRulesList;
    putRules(value: GoogleOrgPolicyPolicySpecRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | GoogleOrgPolicyPolicySpecRules[] | undefined;
}
export interface GoogleOrgPolicyPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#create GoogleOrgPolicyPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#delete GoogleOrgPolicyPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#update GoogleOrgPolicyPolicy#update}
    */
    readonly update?: string;
}
export declare function googleOrgPolicyPolicyTimeoutsToTerraform(struct?: GoogleOrgPolicyPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleOrgPolicyPolicyTimeoutsToHclTerraform(struct?: GoogleOrgPolicyPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleOrgPolicyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrgPolicyPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOrgPolicyPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy google_org_policy_policy}
*/
export declare class GoogleOrgPolicyPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_org_policy_policy";
    /**
    * Generates CDKTF code for importing a GoogleOrgPolicyPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleOrgPolicyPolicy to import
    * @param importFromId The id of the existing GoogleOrgPolicyPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleOrgPolicyPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_org_policy_policy google_org_policy_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleOrgPolicyPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleOrgPolicyPolicyConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _dryRunSpec;
    get dryRunSpec(): GoogleOrgPolicyPolicyDryRunSpecOutputReference;
    putDryRunSpec(value: GoogleOrgPolicyPolicyDryRunSpec): void;
    resetDryRunSpec(): void;
    get dryRunSpecInput(): GoogleOrgPolicyPolicyDryRunSpec | undefined;
    private _spec;
    get spec(): GoogleOrgPolicyPolicySpecOutputReference;
    putSpec(value: GoogleOrgPolicyPolicySpec): void;
    resetSpec(): void;
    get specInput(): GoogleOrgPolicyPolicySpec | undefined;
    private _timeouts;
    get timeouts(): GoogleOrgPolicyPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleOrgPolicyPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleOrgPolicyPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
