/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#constraint GoogleOrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#id GoogleOrganizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#org_id GoogleOrganizationPolicy#org_id}
    */
    readonly orgId: string;
    /**
    * Version of the Policy. Default version is 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#version GoogleOrganizationPolicy#version}
    */
    readonly version?: number;
    /**
    * boolean_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#boolean_policy GoogleOrganizationPolicy#boolean_policy}
    */
    readonly booleanPolicy?: GoogleOrganizationPolicyBooleanPolicy;
    /**
    * list_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#list_policy GoogleOrganizationPolicy#list_policy}
    */
    readonly listPolicy?: GoogleOrganizationPolicyListPolicy;
    /**
    * restore_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#restore_policy GoogleOrganizationPolicy#restore_policy}
    */
    readonly restorePolicy?: GoogleOrganizationPolicyRestorePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#timeouts GoogleOrganizationPolicy#timeouts}
    */
    readonly timeouts?: GoogleOrganizationPolicyTimeouts;
}
export interface GoogleOrganizationPolicyBooleanPolicy {
    /**
    * If true, then the Policy is enforced. If false, then any configuration is acceptable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#enforced GoogleOrganizationPolicy#enforced}
    */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function googleOrganizationPolicyBooleanPolicyToTerraform(struct?: GoogleOrganizationPolicyBooleanPolicyOutputReference | GoogleOrganizationPolicyBooleanPolicy): any;
export declare function googleOrganizationPolicyBooleanPolicyToHclTerraform(struct?: GoogleOrganizationPolicyBooleanPolicyOutputReference | GoogleOrganizationPolicyBooleanPolicy): any;
export declare class GoogleOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: GoogleOrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleOrganizationPolicyListPolicyAllow {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#all GoogleOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#values GoogleOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function googleOrganizationPolicyListPolicyAllowToTerraform(struct?: GoogleOrganizationPolicyListPolicyAllowOutputReference | GoogleOrganizationPolicyListPolicyAllow): any;
export declare function googleOrganizationPolicyListPolicyAllowToHclTerraform(struct?: GoogleOrganizationPolicyListPolicyAllowOutputReference | GoogleOrganizationPolicyListPolicyAllow): any;
export declare class GoogleOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: GoogleOrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleOrganizationPolicyListPolicyDeny {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#all GoogleOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#values GoogleOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function googleOrganizationPolicyListPolicyDenyToTerraform(struct?: GoogleOrganizationPolicyListPolicyDenyOutputReference | GoogleOrganizationPolicyListPolicyDeny): any;
export declare function googleOrganizationPolicyListPolicyDenyToHclTerraform(struct?: GoogleOrganizationPolicyListPolicyDenyOutputReference | GoogleOrganizationPolicyListPolicyDeny): any;
export declare class GoogleOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: GoogleOrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleOrganizationPolicyListPolicy {
    /**
    * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#inherit_from_parent GoogleOrganizationPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#suggested_value GoogleOrganizationPolicy#suggested_value}
    */
    readonly suggestedValue?: string;
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#allow GoogleOrganizationPolicy#allow}
    */
    readonly allow?: GoogleOrganizationPolicyListPolicyAllow;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#deny GoogleOrganizationPolicy#deny}
    */
    readonly deny?: GoogleOrganizationPolicyListPolicyDeny;
}
export declare function googleOrganizationPolicyListPolicyToTerraform(struct?: GoogleOrganizationPolicyListPolicyOutputReference | GoogleOrganizationPolicyListPolicy): any;
export declare function googleOrganizationPolicyListPolicyToHclTerraform(struct?: GoogleOrganizationPolicyListPolicyOutputReference | GoogleOrganizationPolicyListPolicy): any;
export declare class GoogleOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationPolicyListPolicy | undefined;
    set internalValue(value: GoogleOrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string;
    set suggestedValue(value: string);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow;
    get allow(): GoogleOrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: GoogleOrganizationPolicyListPolicyAllow): void;
    resetAllow(): void;
    get allowInput(): GoogleOrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    get deny(): GoogleOrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: GoogleOrganizationPolicyListPolicyDeny): void;
    resetDeny(): void;
    get denyInput(): GoogleOrganizationPolicyListPolicyDeny | undefined;
}
export interface GoogleOrganizationPolicyRestorePolicy {
    /**
    * May only be set to true. If set, then the default Policy is restored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#default GoogleOrganizationPolicy#default}
    */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function googleOrganizationPolicyRestorePolicyToTerraform(struct?: GoogleOrganizationPolicyRestorePolicyOutputReference | GoogleOrganizationPolicyRestorePolicy): any;
export declare function googleOrganizationPolicyRestorePolicyToHclTerraform(struct?: GoogleOrganizationPolicyRestorePolicyOutputReference | GoogleOrganizationPolicyRestorePolicy): any;
export declare class GoogleOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: GoogleOrganizationPolicyRestorePolicy | undefined);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleOrganizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#create GoogleOrganizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#delete GoogleOrganizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#read GoogleOrganizationPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#update GoogleOrganizationPolicy#update}
    */
    readonly update?: string;
}
export declare function googleOrganizationPolicyTimeoutsToTerraform(struct?: GoogleOrganizationPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleOrganizationPolicyTimeoutsToHclTerraform(struct?: GoogleOrganizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOrganizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy google_organization_policy}
*/
export declare class GoogleOrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_organization_policy";
    /**
    * Generates CDKTF code for importing a GoogleOrganizationPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleOrganizationPolicy to import
    * @param importFromId The id of the existing GoogleOrganizationPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleOrganizationPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_organization_policy google_organization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleOrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleOrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy;
    get booleanPolicy(): GoogleOrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: GoogleOrganizationPolicyBooleanPolicy): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): GoogleOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    get listPolicy(): GoogleOrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: GoogleOrganizationPolicyListPolicy): void;
    resetListPolicy(): void;
    get listPolicyInput(): GoogleOrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    get restorePolicy(): GoogleOrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: GoogleOrganizationPolicyRestorePolicy): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): GoogleOrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleOrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleOrganizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleOrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
