/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleOsConfigPatchDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the patch deployment. Length of the description is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#description GoogleOsConfigPatchDeployment#description}
    */
    readonly description?: string;
    /**
    * Duration of the patch. After the duration ends, the patch times out.
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#duration GoogleOsConfigPatchDeployment#duration}
    */
    readonly duration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#id GoogleOsConfigPatchDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A name for the patch deployment in the project. When creating a name the following rules apply:
    * * Must contain only lowercase letters, numbers, and hyphens.
    * * Must start with a letter.
    * * Must be between 1-63 characters.
    * * Must end with a number or a letter.
    * * Must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#patch_deployment_id GoogleOsConfigPatchDeployment#patch_deployment_id}
    */
    readonly patchDeploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#project GoogleOsConfigPatchDeployment#project}
    */
    readonly project?: string;
    /**
    * instance_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#instance_filter GoogleOsConfigPatchDeployment#instance_filter}
    */
    readonly instanceFilter: GoogleOsConfigPatchDeploymentInstanceFilter;
    /**
    * one_time_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#one_time_schedule GoogleOsConfigPatchDeployment#one_time_schedule}
    */
    readonly oneTimeSchedule?: GoogleOsConfigPatchDeploymentOneTimeSchedule;
    /**
    * patch_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#patch_config GoogleOsConfigPatchDeployment#patch_config}
    */
    readonly patchConfig?: GoogleOsConfigPatchDeploymentPatchConfig;
    /**
    * recurring_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#recurring_schedule GoogleOsConfigPatchDeployment#recurring_schedule}
    */
    readonly recurringSchedule?: GoogleOsConfigPatchDeploymentRecurringSchedule;
    /**
    * rollout block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#rollout GoogleOsConfigPatchDeployment#rollout}
    */
    readonly rollout?: GoogleOsConfigPatchDeploymentRollout;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#timeouts GoogleOsConfigPatchDeployment#timeouts}
    */
    readonly timeouts?: GoogleOsConfigPatchDeploymentTimeouts;
}
export interface GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels {
    /**
    * Compute Engine instance labels that must be present for a VM instance to be targeted by this filter
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#labels GoogleOsConfigPatchDeployment#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
}
export declare function googleOsConfigPatchDeploymentInstanceFilterGroupLabelsToTerraform(struct?: GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels | cdktf.IResolvable): any;
export declare function googleOsConfigPatchDeploymentInstanceFilterGroupLabelsToHclTerraform(struct?: GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels | cdktf.IResolvable): any;
export declare class GoogleOsConfigPatchDeploymentInstanceFilterGroupLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class GoogleOsConfigPatchDeploymentInstanceFilterGroupLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigPatchDeploymentInstanceFilterGroupLabelsOutputReference;
}
export interface GoogleOsConfigPatchDeploymentInstanceFilter {
    /**
    * Target all VM instances in the project. If true, no other criteria is permitted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#all GoogleOsConfigPatchDeployment#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
    * VMs when targeting configs, for example prefix="prod-".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#instance_name_prefixes GoogleOsConfigPatchDeployment#instance_name_prefixes}
    */
    readonly instanceNamePrefixes?: string[];
    /**
    * Targets any of the VM instances specified. Instances are specified by their URI in the 'form zones/{{zone}}/instances/{{instance_name}}',
    * 'projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}', or
    * 'https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#instances GoogleOsConfigPatchDeployment#instances}
    */
    readonly instances?: string[];
    /**
    * Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#zones GoogleOsConfigPatchDeployment#zones}
    */
    readonly zones?: string[];
    /**
    * group_labels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#group_labels GoogleOsConfigPatchDeployment#group_labels}
    */
    readonly groupLabels?: GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels[] | cdktf.IResolvable;
}
export declare function googleOsConfigPatchDeploymentInstanceFilterToTerraform(struct?: GoogleOsConfigPatchDeploymentInstanceFilterOutputReference | GoogleOsConfigPatchDeploymentInstanceFilter): any;
export declare function googleOsConfigPatchDeploymentInstanceFilterToHclTerraform(struct?: GoogleOsConfigPatchDeploymentInstanceFilterOutputReference | GoogleOsConfigPatchDeploymentInstanceFilter): any;
export declare class GoogleOsConfigPatchDeploymentInstanceFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentInstanceFilter | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentInstanceFilter | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceNamePrefixes?;
    get instanceNamePrefixes(): string[];
    set instanceNamePrefixes(value: string[]);
    resetInstanceNamePrefixes(): void;
    get instanceNamePrefixesInput(): string[] | undefined;
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _groupLabels;
    get groupLabels(): GoogleOsConfigPatchDeploymentInstanceFilterGroupLabelsList;
    putGroupLabels(value: GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels[] | cdktf.IResolvable): void;
    resetGroupLabels(): void;
    get groupLabelsInput(): cdktf.IResolvable | GoogleOsConfigPatchDeploymentInstanceFilterGroupLabels[] | undefined;
}
export interface GoogleOsConfigPatchDeploymentOneTimeSchedule {
    /**
    * The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
    * accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#execute_time GoogleOsConfigPatchDeployment#execute_time}
    */
    readonly executeTime: string;
}
export declare function googleOsConfigPatchDeploymentOneTimeScheduleToTerraform(struct?: GoogleOsConfigPatchDeploymentOneTimeScheduleOutputReference | GoogleOsConfigPatchDeploymentOneTimeSchedule): any;
export declare function googleOsConfigPatchDeploymentOneTimeScheduleToHclTerraform(struct?: GoogleOsConfigPatchDeploymentOneTimeScheduleOutputReference | GoogleOsConfigPatchDeploymentOneTimeSchedule): any;
export declare class GoogleOsConfigPatchDeploymentOneTimeScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentOneTimeSchedule | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentOneTimeSchedule | undefined);
    private _executeTime?;
    get executeTime(): string;
    set executeTime(value: string);
    get executeTimeInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigApt {
    /**
    * List of packages to exclude from update. These packages will be excluded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#excludes GoogleOsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of packages to be updated. These are the only packages that will be updated.
    * If these packages are not installed, they will be ignored. This field cannot be specified with
    * any other patch configuration fields.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#exclusive_packages GoogleOsConfigPatchDeployment#exclusive_packages}
    */
    readonly exclusivePackages?: string[];
    /**
    * By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead. Possible values: ["DIST", "UPGRADE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#type GoogleOsConfigPatchDeployment#type}
    */
    readonly type?: string;
}
export declare function googleOsConfigPatchDeploymentPatchConfigAptToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigAptOutputReference | GoogleOsConfigPatchDeploymentPatchConfigApt): any;
export declare function googleOsConfigPatchDeploymentPatchConfigAptToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigAptOutputReference | GoogleOsConfigPatchDeploymentPatchConfigApt): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigAptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigApt | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigApt | undefined);
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    get exclusivePackages(): string[];
    set exclusivePackages(value: string[]);
    resetExclusivePackages(): void;
    get exclusivePackagesInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigGoo {
    /**
    * goo update settings. Use this setting to override the default goo patch rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#enabled GoogleOsConfigPatchDeployment#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleOsConfigPatchDeploymentPatchConfigGooToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigGooOutputReference | GoogleOsConfigPatchDeploymentPatchConfigGoo): any;
export declare function googleOsConfigPatchDeploymentPatchConfigGooToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigGooOutputReference | GoogleOsConfigPatchDeploymentPatchConfigGoo): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigGooOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigGoo | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigGoo | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#bucket GoogleOsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#generation_number GoogleOsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#object GoogleOsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#allowed_success_codes GoogleOsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
    * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#interpreter GoogleOsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#local_path GoogleOsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#gcs_object GoogleOsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#bucket GoogleOsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#generation_number GoogleOsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#object GoogleOsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#allowed_success_codes GoogleOsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
    * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#interpreter GoogleOsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#local_path GoogleOsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#gcs_object GoogleOsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPostStep {
    /**
    * linux_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#linux_exec_step_config GoogleOsConfigPatchDeployment#linux_exec_step_config}
    */
    readonly linuxExecStepConfig?: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig;
    /**
    * windows_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#windows_exec_step_config GoogleOsConfigPatchDeployment#windows_exec_step_config}
    */
    readonly windowsExecStepConfig?: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStep): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPostStepToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPostStepOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPostStep): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPostStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPostStep | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPostStep | undefined);
    private _linuxExecStepConfig;
    get linuxExecStepConfig(): GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference;
    putLinuxExecStepConfig(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): void;
    resetLinuxExecStepConfig(): void;
    get linuxExecStepConfigInput(): GoogleOsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig;
    get windowsExecStepConfig(): GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference;
    putWindowsExecStepConfig(value: GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): void;
    resetWindowsExecStepConfig(): void;
    get windowsExecStepConfigInput(): GoogleOsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#bucket GoogleOsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#generation_number GoogleOsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#object GoogleOsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#allowed_success_codes GoogleOsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
    * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#interpreter GoogleOsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#local_path GoogleOsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#gcs_object GoogleOsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#bucket GoogleOsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#generation_number GoogleOsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#object GoogleOsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#allowed_success_codes GoogleOsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
    * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#interpreter GoogleOsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#local_path GoogleOsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#gcs_object GoogleOsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigPreStep {
    /**
    * linux_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#linux_exec_step_config GoogleOsConfigPatchDeployment#linux_exec_step_config}
    */
    readonly linuxExecStepConfig?: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig;
    /**
    * windows_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#windows_exec_step_config GoogleOsConfigPatchDeployment#windows_exec_step_config}
    */
    readonly windowsExecStepConfig?: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig;
}
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStep): any;
export declare function googleOsConfigPatchDeploymentPatchConfigPreStepToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigPreStepOutputReference | GoogleOsConfigPatchDeploymentPatchConfigPreStep): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigPreStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigPreStep | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigPreStep | undefined);
    private _linuxExecStepConfig;
    get linuxExecStepConfig(): GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference;
    putLinuxExecStepConfig(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): void;
    resetLinuxExecStepConfig(): void;
    get linuxExecStepConfigInput(): GoogleOsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig;
    get windowsExecStepConfig(): GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference;
    putWindowsExecStepConfig(value: GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): void;
    resetWindowsExecStepConfig(): void;
    get windowsExecStepConfigInput(): GoogleOsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate {
    /**
    * Only apply updates of these windows update classifications. If empty, all updates are applied. Possible values: ["CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#classifications GoogleOsConfigPatchDeployment#classifications}
    */
    readonly classifications?: string[];
    /**
    * List of KBs to exclude from update.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#excludes GoogleOsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of kbs to be updated. These are the only patches that will be updated.
    * This field must not be used with other patch configurations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#exclusive_patches GoogleOsConfigPatchDeployment#exclusive_patches}
    */
    readonly exclusivePatches?: string[];
}
export declare function googleOsConfigPatchDeploymentPatchConfigWindowsUpdateToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference | GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate): any;
export declare function googleOsConfigPatchDeploymentPatchConfigWindowsUpdateToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference | GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined);
    private _classifications?;
    get classifications(): string[];
    set classifications(value: string[]);
    resetClassifications(): void;
    get classificationsInput(): string[] | undefined;
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    get exclusivePatches(): string[];
    set exclusivePatches(value: string[]);
    resetExclusivePatches(): void;
    get exclusivePatchesInput(): string[] | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigYum {
    /**
    * List of packages to exclude from update. These packages will be excluded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#excludes GoogleOsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of packages to be updated. These are the only packages that will be updated.
    * If these packages are not installed, they will be ignored. This field cannot be specified with
    * any other patch configuration fields.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#exclusive_packages GoogleOsConfigPatchDeployment#exclusive_packages}
    */
    readonly exclusivePackages?: string[];
    /**
    * Will cause patch to run yum update-minimal instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#minimal GoogleOsConfigPatchDeployment#minimal}
    */
    readonly minimal?: boolean | cdktf.IResolvable;
    /**
    * Adds the --security flag to yum update. Not supported on all platforms.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#security GoogleOsConfigPatchDeployment#security}
    */
    readonly security?: boolean | cdktf.IResolvable;
}
export declare function googleOsConfigPatchDeploymentPatchConfigYumToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigYumOutputReference | GoogleOsConfigPatchDeploymentPatchConfigYum): any;
export declare function googleOsConfigPatchDeploymentPatchConfigYumToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigYumOutputReference | GoogleOsConfigPatchDeploymentPatchConfigYum): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigYumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigYum | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigYum | undefined);
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    get exclusivePackages(): string[];
    set exclusivePackages(value: string[]);
    resetExclusivePackages(): void;
    get exclusivePackagesInput(): string[] | undefined;
    private _minimal?;
    get minimal(): boolean | cdktf.IResolvable;
    set minimal(value: boolean | cdktf.IResolvable);
    resetMinimal(): void;
    get minimalInput(): boolean | cdktf.IResolvable | undefined;
    private _security?;
    get security(): boolean | cdktf.IResolvable;
    set security(value: boolean | cdktf.IResolvable);
    resetSecurity(): void;
    get securityInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfigZypper {
    /**
    * Install only patches with these categories. Common categories include security, recommended, and feature.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#categories GoogleOsConfigPatchDeployment#categories}
    */
    readonly categories?: string[];
    /**
    * List of packages to exclude from update.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#excludes GoogleOsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command.
    * This field must not be used with any other patch configuration fields.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#exclusive_patches GoogleOsConfigPatchDeployment#exclusive_patches}
    */
    readonly exclusivePatches?: string[];
    /**
    * Install only patches with these severities. Common severities include critical, important, moderate, and low.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#severities GoogleOsConfigPatchDeployment#severities}
    */
    readonly severities?: string[];
    /**
    * Adds the --with-optional flag to zypper patch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#with_optional GoogleOsConfigPatchDeployment#with_optional}
    */
    readonly withOptional?: boolean | cdktf.IResolvable;
    /**
    * Adds the --with-update flag, to zypper patch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#with_update GoogleOsConfigPatchDeployment#with_update}
    */
    readonly withUpdate?: boolean | cdktf.IResolvable;
}
export declare function googleOsConfigPatchDeploymentPatchConfigZypperToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigZypperOutputReference | GoogleOsConfigPatchDeploymentPatchConfigZypper): any;
export declare function googleOsConfigPatchDeploymentPatchConfigZypperToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigZypperOutputReference | GoogleOsConfigPatchDeploymentPatchConfigZypper): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigZypperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfigZypper | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfigZypper | undefined);
    private _categories?;
    get categories(): string[];
    set categories(value: string[]);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    get exclusivePatches(): string[];
    set exclusivePatches(value: string[]);
    resetExclusivePatches(): void;
    get exclusivePatchesInput(): string[] | undefined;
    private _severities?;
    get severities(): string[];
    set severities(value: string[]);
    resetSeverities(): void;
    get severitiesInput(): string[] | undefined;
    private _withOptional?;
    get withOptional(): boolean | cdktf.IResolvable;
    set withOptional(value: boolean | cdktf.IResolvable);
    resetWithOptional(): void;
    get withOptionalInput(): boolean | cdktf.IResolvable | undefined;
    private _withUpdate?;
    get withUpdate(): boolean | cdktf.IResolvable;
    set withUpdate(value: boolean | cdktf.IResolvable);
    resetWithUpdate(): void;
    get withUpdateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleOsConfigPatchDeploymentPatchConfig {
    /**
    * Allows the patch job to run on Managed instance groups (MIGs).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#mig_instances_allowed GoogleOsConfigPatchDeployment#mig_instances_allowed}
    */
    readonly migInstancesAllowed?: boolean | cdktf.IResolvable;
    /**
    * Post-patch reboot settings. Possible values: ["DEFAULT", "ALWAYS", "NEVER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#reboot_config GoogleOsConfigPatchDeployment#reboot_config}
    */
    readonly rebootConfig?: string;
    /**
    * apt block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#apt GoogleOsConfigPatchDeployment#apt}
    */
    readonly apt?: GoogleOsConfigPatchDeploymentPatchConfigApt;
    /**
    * goo block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#goo GoogleOsConfigPatchDeployment#goo}
    */
    readonly goo?: GoogleOsConfigPatchDeploymentPatchConfigGoo;
    /**
    * post_step block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#post_step GoogleOsConfigPatchDeployment#post_step}
    */
    readonly postStep?: GoogleOsConfigPatchDeploymentPatchConfigPostStep;
    /**
    * pre_step block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#pre_step GoogleOsConfigPatchDeployment#pre_step}
    */
    readonly preStep?: GoogleOsConfigPatchDeploymentPatchConfigPreStep;
    /**
    * windows_update block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#windows_update GoogleOsConfigPatchDeployment#windows_update}
    */
    readonly windowsUpdate?: GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate;
    /**
    * yum block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#yum GoogleOsConfigPatchDeployment#yum}
    */
    readonly yum?: GoogleOsConfigPatchDeploymentPatchConfigYum;
    /**
    * zypper block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#zypper GoogleOsConfigPatchDeployment#zypper}
    */
    readonly zypper?: GoogleOsConfigPatchDeploymentPatchConfigZypper;
}
export declare function googleOsConfigPatchDeploymentPatchConfigToTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfig): any;
export declare function googleOsConfigPatchDeploymentPatchConfigToHclTerraform(struct?: GoogleOsConfigPatchDeploymentPatchConfigOutputReference | GoogleOsConfigPatchDeploymentPatchConfig): any;
export declare class GoogleOsConfigPatchDeploymentPatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentPatchConfig | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentPatchConfig | undefined);
    private _migInstancesAllowed?;
    get migInstancesAllowed(): boolean | cdktf.IResolvable;
    set migInstancesAllowed(value: boolean | cdktf.IResolvable);
    resetMigInstancesAllowed(): void;
    get migInstancesAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _rebootConfig?;
    get rebootConfig(): string;
    set rebootConfig(value: string);
    resetRebootConfig(): void;
    get rebootConfigInput(): string | undefined;
    private _apt;
    get apt(): GoogleOsConfigPatchDeploymentPatchConfigAptOutputReference;
    putApt(value: GoogleOsConfigPatchDeploymentPatchConfigApt): void;
    resetApt(): void;
    get aptInput(): GoogleOsConfigPatchDeploymentPatchConfigApt | undefined;
    private _goo;
    get goo(): GoogleOsConfigPatchDeploymentPatchConfigGooOutputReference;
    putGoo(value: GoogleOsConfigPatchDeploymentPatchConfigGoo): void;
    resetGoo(): void;
    get gooInput(): GoogleOsConfigPatchDeploymentPatchConfigGoo | undefined;
    private _postStep;
    get postStep(): GoogleOsConfigPatchDeploymentPatchConfigPostStepOutputReference;
    putPostStep(value: GoogleOsConfigPatchDeploymentPatchConfigPostStep): void;
    resetPostStep(): void;
    get postStepInput(): GoogleOsConfigPatchDeploymentPatchConfigPostStep | undefined;
    private _preStep;
    get preStep(): GoogleOsConfigPatchDeploymentPatchConfigPreStepOutputReference;
    putPreStep(value: GoogleOsConfigPatchDeploymentPatchConfigPreStep): void;
    resetPreStep(): void;
    get preStepInput(): GoogleOsConfigPatchDeploymentPatchConfigPreStep | undefined;
    private _windowsUpdate;
    get windowsUpdate(): GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference;
    putWindowsUpdate(value: GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate): void;
    resetWindowsUpdate(): void;
    get windowsUpdateInput(): GoogleOsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    private _yum;
    get yum(): GoogleOsConfigPatchDeploymentPatchConfigYumOutputReference;
    putYum(value: GoogleOsConfigPatchDeploymentPatchConfigYum): void;
    resetYum(): void;
    get yumInput(): GoogleOsConfigPatchDeploymentPatchConfigYum | undefined;
    private _zypper;
    get zypper(): GoogleOsConfigPatchDeploymentPatchConfigZypperOutputReference;
    putZypper(value: GoogleOsConfigPatchDeploymentPatchConfigZypper): void;
    resetZypper(): void;
    get zypperInput(): GoogleOsConfigPatchDeploymentPatchConfigZypper | undefined;
}
export interface GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth {
    /**
    * A day of the week. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#day_of_week GoogleOsConfigPatchDeployment#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Represents the number of days before or after the given week day of month that the patch deployment is scheduled for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#day_offset GoogleOsConfigPatchDeployment#day_offset}
    */
    readonly dayOffset?: number;
    /**
    * Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#week_ordinal GoogleOsConfigPatchDeployment#week_ordinal}
    */
    readonly weekOrdinal: number;
}
export declare function googleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthToTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): any;
export declare function googleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): any;
export declare class GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _dayOffset?;
    get dayOffset(): number;
    set dayOffset(value: number);
    resetDayOffset(): void;
    get dayOffsetInput(): number | undefined;
    private _weekOrdinal?;
    get weekOrdinal(): number;
    set weekOrdinal(value: number);
    get weekOrdinalInput(): number | undefined;
}
export interface GoogleOsConfigPatchDeploymentRecurringScheduleMonthly {
    /**
    * One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
    * Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
    * will not run in February, April, June, etc.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#month_day GoogleOsConfigPatchDeployment#month_day}
    */
    readonly monthDay?: number;
    /**
    * week_day_of_month block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#week_day_of_month GoogleOsConfigPatchDeployment#week_day_of_month}
    */
    readonly weekDayOfMonth?: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth;
}
export declare function googleOsConfigPatchDeploymentRecurringScheduleMonthlyToTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleMonthly): any;
export declare function googleOsConfigPatchDeploymentRecurringScheduleMonthlyToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleMonthly): any;
export declare class GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRecurringScheduleMonthly | undefined);
    private _monthDay?;
    get monthDay(): number;
    set monthDay(value: number);
    resetMonthDay(): void;
    get monthDayInput(): number | undefined;
    private _weekDayOfMonth;
    get weekDayOfMonth(): GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference;
    putWeekDayOfMonth(value: GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): void;
    resetWeekDayOfMonth(): void;
    get weekDayOfMonthInput(): GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
}
export interface GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
    * An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#hours GoogleOsConfigPatchDeployment#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#minutes GoogleOsConfigPatchDeployment#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#nanos GoogleOsConfigPatchDeployment#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#seconds GoogleOsConfigPatchDeployment#seconds}
    */
    readonly seconds?: number;
}
export declare function googleOsConfigPatchDeploymentRecurringScheduleTimeOfDayToTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay): any;
export declare function googleOsConfigPatchDeploymentRecurringScheduleTimeOfDayToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay): any;
export declare class GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone {
    /**
    * IANA Time Zone Database time zone, e.g. "America/New_York".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#id GoogleOsConfigPatchDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * IANA Time Zone Database version number, e.g. "2019a".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#version GoogleOsConfigPatchDeployment#version}
    */
    readonly version?: string;
}
export declare function googleOsConfigPatchDeploymentRecurringScheduleTimeZoneToTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone): any;
export declare function googleOsConfigPatchDeploymentRecurringScheduleTimeZoneToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone): any;
export declare class GoogleOsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentRecurringScheduleWeekly {
    /**
    * IANA Time Zone Database time zone, e.g. "America/New_York". Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#day_of_week GoogleOsConfigPatchDeployment#day_of_week}
    */
    readonly dayOfWeek: string;
}
export declare function googleOsConfigPatchDeploymentRecurringScheduleWeeklyToTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleWeekly): any;
export declare function googleOsConfigPatchDeploymentRecurringScheduleWeeklyToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference | GoogleOsConfigPatchDeploymentRecurringScheduleWeekly): any;
export declare class GoogleOsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRecurringScheduleWeekly | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
}
export interface GoogleOsConfigPatchDeploymentRecurringSchedule {
    /**
    * The end time at which a recurring patch deployment schedule is no longer active.
    * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#end_time GoogleOsConfigPatchDeployment#end_time}
    */
    readonly endTime?: string;
    /**
    * The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
    * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#start_time GoogleOsConfigPatchDeployment#start_time}
    */
    readonly startTime?: string;
    /**
    * monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#monthly GoogleOsConfigPatchDeployment#monthly}
    */
    readonly monthly?: GoogleOsConfigPatchDeploymentRecurringScheduleMonthly;
    /**
    * time_of_day block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#time_of_day GoogleOsConfigPatchDeployment#time_of_day}
    */
    readonly timeOfDay: GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay;
    /**
    * time_zone block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#time_zone GoogleOsConfigPatchDeployment#time_zone}
    */
    readonly timeZone: GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone;
    /**
    * weekly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#weekly GoogleOsConfigPatchDeployment#weekly}
    */
    readonly weekly?: GoogleOsConfigPatchDeploymentRecurringScheduleWeekly;
}
export declare function googleOsConfigPatchDeploymentRecurringScheduleToTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleOutputReference | GoogleOsConfigPatchDeploymentRecurringSchedule): any;
export declare function googleOsConfigPatchDeploymentRecurringScheduleToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRecurringScheduleOutputReference | GoogleOsConfigPatchDeploymentRecurringSchedule): any;
export declare class GoogleOsConfigPatchDeploymentRecurringScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRecurringSchedule | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRecurringSchedule | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    get lastExecuteTime(): string;
    get nextExecuteTime(): string;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _monthly;
    get monthly(): GoogleOsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference;
    putMonthly(value: GoogleOsConfigPatchDeploymentRecurringScheduleMonthly): void;
    resetMonthly(): void;
    get monthlyInput(): GoogleOsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    private _timeOfDay;
    get timeOfDay(): GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference;
    putTimeOfDay(value: GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay): void;
    get timeOfDayInput(): GoogleOsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    private _timeZone;
    get timeZone(): GoogleOsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference;
    putTimeZone(value: GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone): void;
    get timeZoneInput(): GoogleOsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    private _weekly;
    get weekly(): GoogleOsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference;
    putWeekly(value: GoogleOsConfigPatchDeploymentRecurringScheduleWeekly): void;
    resetWeekly(): void;
    get weeklyInput(): GoogleOsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
}
export interface GoogleOsConfigPatchDeploymentRolloutDisruptionBudget {
    /**
    * Specifies a fixed value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#fixed GoogleOsConfigPatchDeployment#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#percentage GoogleOsConfigPatchDeployment#percentage}
    */
    readonly percentage?: number;
}
export declare function googleOsConfigPatchDeploymentRolloutDisruptionBudgetToTerraform(struct?: GoogleOsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference | GoogleOsConfigPatchDeploymentRolloutDisruptionBudget): any;
export declare function googleOsConfigPatchDeploymentRolloutDisruptionBudgetToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference | GoogleOsConfigPatchDeploymentRolloutDisruptionBudget): any;
export declare class GoogleOsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRolloutDisruptionBudget | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleOsConfigPatchDeploymentRollout {
    /**
    * Mode of the patch rollout. Possible values: ["ZONE_BY_ZONE", "CONCURRENT_ZONES"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#mode GoogleOsConfigPatchDeployment#mode}
    */
    readonly mode: string;
    /**
    * disruption_budget block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#disruption_budget GoogleOsConfigPatchDeployment#disruption_budget}
    */
    readonly disruptionBudget: GoogleOsConfigPatchDeploymentRolloutDisruptionBudget;
}
export declare function googleOsConfigPatchDeploymentRolloutToTerraform(struct?: GoogleOsConfigPatchDeploymentRolloutOutputReference | GoogleOsConfigPatchDeploymentRollout): any;
export declare function googleOsConfigPatchDeploymentRolloutToHclTerraform(struct?: GoogleOsConfigPatchDeploymentRolloutOutputReference | GoogleOsConfigPatchDeploymentRollout): any;
export declare class GoogleOsConfigPatchDeploymentRolloutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentRollout | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentRollout | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _disruptionBudget;
    get disruptionBudget(): GoogleOsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference;
    putDisruptionBudget(value: GoogleOsConfigPatchDeploymentRolloutDisruptionBudget): void;
    get disruptionBudgetInput(): GoogleOsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
}
export interface GoogleOsConfigPatchDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#create GoogleOsConfigPatchDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#delete GoogleOsConfigPatchDeployment#delete}
    */
    readonly delete?: string;
}
export declare function googleOsConfigPatchDeploymentTimeoutsToTerraform(struct?: GoogleOsConfigPatchDeploymentTimeouts | cdktf.IResolvable): any;
export declare function googleOsConfigPatchDeploymentTimeoutsToHclTerraform(struct?: GoogleOsConfigPatchDeploymentTimeouts | cdktf.IResolvable): any;
export declare class GoogleOsConfigPatchDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigPatchDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigPatchDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment google_os_config_patch_deployment}
*/
export declare class GoogleOsConfigPatchDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_os_config_patch_deployment";
    /**
    * Generates CDKTF code for importing a GoogleOsConfigPatchDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleOsConfigPatchDeployment to import
    * @param importFromId The id of the existing GoogleOsConfigPatchDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleOsConfigPatchDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_os_config_patch_deployment google_os_config_patch_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleOsConfigPatchDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleOsConfigPatchDeploymentConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastExecuteTime(): string;
    get name(): string;
    private _patchDeploymentId?;
    get patchDeploymentId(): string;
    set patchDeploymentId(value: string);
    get patchDeploymentIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _instanceFilter;
    get instanceFilter(): GoogleOsConfigPatchDeploymentInstanceFilterOutputReference;
    putInstanceFilter(value: GoogleOsConfigPatchDeploymentInstanceFilter): void;
    get instanceFilterInput(): GoogleOsConfigPatchDeploymentInstanceFilter | undefined;
    private _oneTimeSchedule;
    get oneTimeSchedule(): GoogleOsConfigPatchDeploymentOneTimeScheduleOutputReference;
    putOneTimeSchedule(value: GoogleOsConfigPatchDeploymentOneTimeSchedule): void;
    resetOneTimeSchedule(): void;
    get oneTimeScheduleInput(): GoogleOsConfigPatchDeploymentOneTimeSchedule | undefined;
    private _patchConfig;
    get patchConfig(): GoogleOsConfigPatchDeploymentPatchConfigOutputReference;
    putPatchConfig(value: GoogleOsConfigPatchDeploymentPatchConfig): void;
    resetPatchConfig(): void;
    get patchConfigInput(): GoogleOsConfigPatchDeploymentPatchConfig | undefined;
    private _recurringSchedule;
    get recurringSchedule(): GoogleOsConfigPatchDeploymentRecurringScheduleOutputReference;
    putRecurringSchedule(value: GoogleOsConfigPatchDeploymentRecurringSchedule): void;
    resetRecurringSchedule(): void;
    get recurringScheduleInput(): GoogleOsConfigPatchDeploymentRecurringSchedule | undefined;
    private _rollout;
    get rollout(): GoogleOsConfigPatchDeploymentRolloutOutputReference;
    putRollout(value: GoogleOsConfigPatchDeploymentRollout): void;
    resetRollout(): void;
    get rolloutInput(): GoogleOsConfigPatchDeploymentRollout | undefined;
    private _timeouts;
    get timeouts(): GoogleOsConfigPatchDeploymentTimeoutsOutputReference;
    putTimeouts(value: GoogleOsConfigPatchDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleOsConfigPatchDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
