/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePrivatecaCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
    * a Certificate Authority with resource name 'projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca',
    * argument 'pool' should be set to 'projects/my-project/locations/us-central1/caPools/my-pool', argument 'certificate_authority'
    * should be set to 'my-ca'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#certificate_authority GooglePrivatecaCertificate#certificate_authority}
    */
    readonly certificateAuthority?: string;
    /**
    * The resource name for a CertificateTemplate used to issue this certificate,
    * in the format 'projects/* /locations/* /certificateTemplates/*'. If this is specified,
    * the caller must have the necessary permission to use this template. If this is
    * omitted, no template will be used. This template must be in the same location
    * as the Certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#certificate_template GooglePrivatecaCertificate#certificate_template}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly certificateTemplate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#id GooglePrivatecaCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels with user-defined metadata to apply to this resource.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#labels GooglePrivatecaCertificate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
    * "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
    * fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#lifetime GooglePrivatecaCertificate#lifetime}
    */
    readonly lifetime?: string;
    /**
    * Location of the Certificate. A full list of valid locations can be found by
    * running 'gcloud privateca locations list'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#location GooglePrivatecaCertificate#location}
    */
    readonly location: string;
    /**
    * The name for this Certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#name GooglePrivatecaCertificate#name}
    */
    readonly name: string;
    /**
    * Immutable. A pem-encoded X.509 certificate signing request (CSR).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#pem_csr GooglePrivatecaCertificate#pem_csr}
    */
    readonly pemCsr?: string;
    /**
    * The name of the CaPool this Certificate belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#pool GooglePrivatecaCertificate#pool}
    */
    readonly pool: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#project GooglePrivatecaCertificate#project}
    */
    readonly project?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#config GooglePrivatecaCertificate#config}
    */
    readonly config?: GooglePrivatecaCertificateConfigA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#timeouts GooglePrivatecaCertificate#timeouts}
    */
    readonly timeouts?: GooglePrivatecaCertificateTimeouts;
}
export interface GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyId {
}
export declare function googlePrivatecaCertificateCertificateDescriptionAuthorityKeyIdToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyId): any;
export declare function googlePrivatecaCertificateCertificateDescriptionAuthorityKeyIdToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyId): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyId | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyId | undefined);
    get keyId(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyIdOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionCertFingerprint {
}
export declare function googlePrivatecaCertificateCertificateDescriptionCertFingerprintToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionCertFingerprint): any;
export declare function googlePrivatecaCertificateCertificateDescriptionCertFingerprintToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionCertFingerprint): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionCertFingerprintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionCertFingerprint | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionCertFingerprint | undefined);
    get sha256Hash(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionCertFingerprintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionCertFingerprintOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionPublicKey {
}
export declare function googlePrivatecaCertificateCertificateDescriptionPublicKeyToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionPublicKey): any;
export declare function googlePrivatecaCertificateCertificateDescriptionPublicKeyToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionPublicKey): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionPublicKey | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionPublicKey | undefined);
    get format(): string;
    get key(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionPublicKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionPublicKeyOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject {
}
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject): any;
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject | undefined);
    get commonName(): string;
    get countryCode(): string;
    get locality(): string;
    get organization(): string;
    get organizationalUnit(): string;
    get postalCode(): string;
    get province(): string;
    get streetAddress(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId {
}
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId): any;
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId | undefined);
    get objectIdPath(): number[];
}
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans {
}
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans): any;
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans | undefined);
    get critical(): cdktf.IResolvable;
    private _obectId;
    get obectId(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdList;
    get value(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName {
}
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName): any;
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName | undefined);
    private _customSans;
    get customSans(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansList;
    get dnsNames(): string[];
    get emailAddresses(): string[];
    get ipAddresses(): string[];
    get uris(): string[];
}
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionSubjectDescription {
}
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescription): any;
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectDescriptionToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectDescription): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescription | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionSubjectDescription | undefined);
    get hexSerialNumber(): string;
    get lifetime(): string;
    get notAfterTime(): string;
    get notBeforeTime(): string;
    private _subject;
    get subject(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectList;
    private _subjectAltName;
    get subjectAltName(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameList;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionSubjectKeyId {
}
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectKeyIdToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectKeyId): any;
export declare function googlePrivatecaCertificateCertificateDescriptionSubjectKeyIdToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionSubjectKeyId): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectKeyIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionSubjectKeyId | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionSubjectKeyId | undefined);
    get keyId(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionSubjectKeyIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionSubjectKeyIdOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId | undefined);
    get objectIdPath(): number[];
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions | undefined);
    get critical(): cdktf.IResolvable;
    private _objectId;
    get objectId(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdList;
    get value(): string;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions | undefined);
    get isCa(): cdktf.IResolvable;
    get maxIssuerPathLength(): number;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage | undefined);
    get certSign(): cdktf.IResolvable;
    get contentCommitment(): cdktf.IResolvable;
    get crlSign(): cdktf.IResolvable;
    get dataEncipherment(): cdktf.IResolvable;
    get decipherOnly(): cdktf.IResolvable;
    get digitalSignature(): cdktf.IResolvable;
    get encipherOnly(): cdktf.IResolvable;
    get keyAgreement(): cdktf.IResolvable;
    get keyEncipherment(): cdktf.IResolvable;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage | undefined);
    get clientAuth(): cdktf.IResolvable;
    get codeSigning(): cdktf.IResolvable;
    get emailProtection(): cdktf.IResolvable;
    get ocspSigning(): cdktf.IResolvable;
    get serverAuth(): cdktf.IResolvable;
    get timeStamping(): cdktf.IResolvable;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages | undefined);
    get objectIdPath(): number[];
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageList;
    private _extendedKeyUsage;
    get extendedKeyUsage(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageList;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesList;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraints {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraintsToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraints): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraintsToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraints): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraints | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraints | undefined);
    get critical(): cdktf.IResolvable;
    get excludedDnsNames(): string[];
    get excludedEmailAddresses(): string[];
    get excludedIpRanges(): string[];
    get excludedUris(): string[];
    get permittedDnsNames(): string[];
    get permittedEmailAddresses(): string[];
    get permittedIpRanges(): string[];
    get permittedUris(): string[];
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraintsOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds | undefined);
    get objectIdPath(): number[];
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescriptionX509Description {
}
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionToTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509Description): any;
export declare function googlePrivatecaCertificateCertificateDescriptionX509DescriptionToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescriptionX509Description): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescriptionX509Description | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescriptionX509Description | undefined);
    private _additionalExtensions;
    get additionalExtensions(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsList;
    get aiaOcspServers(): string[];
    private _caOptions;
    get caOptions(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsList;
    private _keyUsage;
    get keyUsage(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageList;
    private _nameConstraints;
    get nameConstraints(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionNameConstraintsList;
    private _policyIds;
    get policyIds(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsList;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionX509DescriptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionOutputReference;
}
export interface GooglePrivatecaCertificateCertificateDescription {
}
export declare function googlePrivatecaCertificateCertificateDescriptionToTerraform(struct?: GooglePrivatecaCertificateCertificateDescription): any;
export declare function googlePrivatecaCertificateCertificateDescriptionToHclTerraform(struct?: GooglePrivatecaCertificateCertificateDescription): any;
export declare class GooglePrivatecaCertificateCertificateDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateCertificateDescription | undefined;
    set internalValue(value: GooglePrivatecaCertificateCertificateDescription | undefined);
    get aiaIssuingCertificateUrls(): string[];
    private _authorityKeyId;
    get authorityKeyId(): GooglePrivatecaCertificateCertificateDescriptionAuthorityKeyIdList;
    private _certFingerprint;
    get certFingerprint(): GooglePrivatecaCertificateCertificateDescriptionCertFingerprintList;
    get crlDistributionPoints(): string[];
    private _publicKey;
    get publicKey(): GooglePrivatecaCertificateCertificateDescriptionPublicKeyList;
    private _subjectDescription;
    get subjectDescription(): GooglePrivatecaCertificateCertificateDescriptionSubjectDescriptionList;
    private _subjectKeyId;
    get subjectKeyId(): GooglePrivatecaCertificateCertificateDescriptionSubjectKeyIdList;
    private _x509Description;
    get x509Description(): GooglePrivatecaCertificateCertificateDescriptionX509DescriptionList;
}
export declare class GooglePrivatecaCertificateCertificateDescriptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateCertificateDescriptionOutputReference;
}
export interface GooglePrivatecaCertificateRevocationDetails {
}
export declare function googlePrivatecaCertificateRevocationDetailsToTerraform(struct?: GooglePrivatecaCertificateRevocationDetails): any;
export declare function googlePrivatecaCertificateRevocationDetailsToHclTerraform(struct?: GooglePrivatecaCertificateRevocationDetails): any;
export declare class GooglePrivatecaCertificateRevocationDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateRevocationDetails | undefined;
    set internalValue(value: GooglePrivatecaCertificateRevocationDetails | undefined);
    get revocationState(): string;
    get revocationTime(): string;
}
export declare class GooglePrivatecaCertificateRevocationDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateRevocationDetailsOutputReference;
}
export interface GooglePrivatecaCertificateConfigPublicKey {
    /**
    * The format of the public key. Currently, only PEM format is supported. Possible values: ["KEY_TYPE_UNSPECIFIED", "PEM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#format GooglePrivatecaCertificate#format}
    */
    readonly format: string;
    /**
    * Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#key GooglePrivatecaCertificate#key}
    */
    readonly key?: string;
}
export declare function googlePrivatecaCertificateConfigPublicKeyToTerraform(struct?: GooglePrivatecaCertificateConfigPublicKeyOutputReference | GooglePrivatecaCertificateConfigPublicKey): any;
export declare function googlePrivatecaCertificateConfigPublicKeyToHclTerraform(struct?: GooglePrivatecaCertificateConfigPublicKeyOutputReference | GooglePrivatecaCertificateConfigPublicKey): any;
export declare class GooglePrivatecaCertificateConfigPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigPublicKey | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigPublicKey | undefined);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
}
export interface GooglePrivatecaCertificateConfigSubjectConfigSubject {
    /**
    * The common name of the distinguished name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#common_name GooglePrivatecaCertificate#common_name}
    */
    readonly commonName: string;
    /**
    * The country code of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#country_code GooglePrivatecaCertificate#country_code}
    */
    readonly countryCode?: string;
    /**
    * The locality or city of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#locality GooglePrivatecaCertificate#locality}
    */
    readonly locality?: string;
    /**
    * The organization of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#organization GooglePrivatecaCertificate#organization}
    */
    readonly organization: string;
    /**
    * The organizational unit of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#organizational_unit GooglePrivatecaCertificate#organizational_unit}
    */
    readonly organizationalUnit?: string;
    /**
    * The postal code of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#postal_code GooglePrivatecaCertificate#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The province, territory, or regional state of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#province GooglePrivatecaCertificate#province}
    */
    readonly province?: string;
    /**
    * The street address of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#street_address GooglePrivatecaCertificate#street_address}
    */
    readonly streetAddress?: string;
}
export declare function googlePrivatecaCertificateConfigSubjectConfigSubjectToTerraform(struct?: GooglePrivatecaCertificateConfigSubjectConfigSubjectOutputReference | GooglePrivatecaCertificateConfigSubjectConfigSubject): any;
export declare function googlePrivatecaCertificateConfigSubjectConfigSubjectToHclTerraform(struct?: GooglePrivatecaCertificateConfigSubjectConfigSubjectOutputReference | GooglePrivatecaCertificateConfigSubjectConfigSubject): any;
export declare class GooglePrivatecaCertificateConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigSubjectConfigSubject | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigSubjectConfigSubject | undefined);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    get organizationalUnit(): string;
    set organizationalUnit(value: string);
    resetOrganizationalUnit(): void;
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _province?;
    get province(): string;
    set province(value: string);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
}
export interface GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName {
    /**
    * Contains only valid, fully-qualified host names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#dns_names GooglePrivatecaCertificate#dns_names}
    */
    readonly dnsNames?: string[];
    /**
    * Contains only valid RFC 2822 E-mail addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#email_addresses GooglePrivatecaCertificate#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#ip_addresses GooglePrivatecaCertificate#ip_addresses}
    */
    readonly ipAddresses?: string[];
    /**
    * Contains only valid RFC 3986 URIs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#uris GooglePrivatecaCertificate#uris}
    */
    readonly uris?: string[];
}
export declare function googlePrivatecaCertificateConfigSubjectConfigSubjectAltNameToTerraform(struct?: GooglePrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference | GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName): any;
export declare function googlePrivatecaCertificateConfigSubjectConfigSubjectAltNameToHclTerraform(struct?: GooglePrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference | GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName): any;
export declare class GooglePrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined);
    private _dnsNames?;
    get dnsNames(): string[];
    set dnsNames(value: string[]);
    resetDnsNames(): void;
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    resetUris(): void;
    get urisInput(): string[] | undefined;
}
export interface GooglePrivatecaCertificateConfigSubjectConfig {
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#subject GooglePrivatecaCertificate#subject}
    */
    readonly subject: GooglePrivatecaCertificateConfigSubjectConfigSubject;
    /**
    * subject_alt_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#subject_alt_name GooglePrivatecaCertificate#subject_alt_name}
    */
    readonly subjectAltName?: GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName;
}
export declare function googlePrivatecaCertificateConfigSubjectConfigToTerraform(struct?: GooglePrivatecaCertificateConfigSubjectConfigOutputReference | GooglePrivatecaCertificateConfigSubjectConfig): any;
export declare function googlePrivatecaCertificateConfigSubjectConfigToHclTerraform(struct?: GooglePrivatecaCertificateConfigSubjectConfigOutputReference | GooglePrivatecaCertificateConfigSubjectConfig): any;
export declare class GooglePrivatecaCertificateConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigSubjectConfig | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigSubjectConfig | undefined);
    private _subject;
    get subject(): GooglePrivatecaCertificateConfigSubjectConfigSubjectOutputReference;
    putSubject(value: GooglePrivatecaCertificateConfigSubjectConfigSubject): void;
    get subjectInput(): GooglePrivatecaCertificateConfigSubjectConfigSubject | undefined;
    private _subjectAltName;
    get subjectAltName(): GooglePrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference;
    putSubjectAltName(value: GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName): void;
    resetSubjectAltName(): void;
    get subjectAltNameInput(): GooglePrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#object_id_path GooglePrivatecaCertificate#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdOutputReference | GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId): any;
export declare function googlePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdOutputReference | GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions {
    /**
    * Indicates whether or not this extension is critical (i.e., if the client does not know how to
    * handle this extension, the client should consider this to be an error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#critical GooglePrivatecaCertificate#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * The value of this X.509 extension. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#value GooglePrivatecaCertificate#value}
    */
    readonly value: string;
    /**
    * object_id block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#object_id GooglePrivatecaCertificate#object_id}
    */
    readonly objectId: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId;
}
export declare function googlePrivatecaCertificateConfigX509ConfigAdditionalExtensionsToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions | cdktf.IResolvable): any;
export declare function googlePrivatecaCertificateConfigX509ConfigAdditionalExtensionsToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions | cdktf.IResolvable | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _objectId;
    get objectId(): GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdOutputReference;
    putObjectId(value: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId): void;
    get objectIdInput(): GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId | undefined;
}
export declare class GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsOutputReference;
}
export interface GooglePrivatecaCertificateConfigX509ConfigCaOptions {
    /**
    * When true, the "CA" in Basic Constraints extension will be set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#is_ca GooglePrivatecaCertificate#is_ca}
    */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
    * Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
    * subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#max_issuer_path_length GooglePrivatecaCertificate#max_issuer_path_length}
    */
    readonly maxIssuerPathLength?: number;
    /**
    * When true, the "CA" in Basic Constraints extension will be set to false.
    * If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#non_ca GooglePrivatecaCertificate#non_ca}
    */
    readonly nonCa?: boolean | cdktf.IResolvable;
    /**
    * When true, the "path length constraint" in Basic Constraints extension will be set to 0.
    * if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
    * the max path length will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#zero_max_issuer_path_length GooglePrivatecaCertificate#zero_max_issuer_path_length}
    */
    readonly zeroMaxIssuerPathLength?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateConfigX509ConfigCaOptionsToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigCaOptionsOutputReference | GooglePrivatecaCertificateConfigX509ConfigCaOptions): any;
export declare function googlePrivatecaCertificateConfigX509ConfigCaOptionsToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigCaOptionsOutputReference | GooglePrivatecaCertificateConfigX509ConfigCaOptions): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigCaOptions | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigCaOptions | undefined);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable;
    set isCa(value: boolean | cdktf.IResolvable);
    resetIsCa(): void;
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number;
    set maxIssuerPathLength(value: number);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
    private _nonCa?;
    get nonCa(): boolean | cdktf.IResolvable;
    set nonCa(value: boolean | cdktf.IResolvable);
    resetNonCa(): void;
    get nonCaInput(): boolean | cdktf.IResolvable | undefined;
    private _zeroMaxIssuerPathLength?;
    get zeroMaxIssuerPathLength(): boolean | cdktf.IResolvable;
    set zeroMaxIssuerPathLength(value: boolean | cdktf.IResolvable);
    resetZeroMaxIssuerPathLength(): void;
    get zeroMaxIssuerPathLengthInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
    * The key may be used to sign certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#cert_sign GooglePrivatecaCertificate#cert_sign}
    */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#content_commitment GooglePrivatecaCertificate#content_commitment}
    */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used sign certificate revocation lists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#crl_sign GooglePrivatecaCertificate#crl_sign}
    */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#data_encipherment GooglePrivatecaCertificate#data_encipherment}
    */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to decipher only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#decipher_only GooglePrivatecaCertificate#decipher_only}
    */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for digital signatures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#digital_signature GooglePrivatecaCertificate#digital_signature}
    */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#encipher_only GooglePrivatecaCertificate#encipher_only}
    */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used in a key agreement protocol.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#key_agreement GooglePrivatecaCertificate#key_agreement}
    */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher other keys.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#key_encipherment GooglePrivatecaCertificate#key_encipherment}
    */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference | GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage): any;
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference | GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable;
    set certSign(value: boolean | cdktf.IResolvable);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable;
    set contentCommitment(value: boolean | cdktf.IResolvable);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable;
    set crlSign(value: boolean | cdktf.IResolvable);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable;
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable;
    set decipherOnly(value: boolean | cdktf.IResolvable);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable;
    set digitalSignature(value: boolean | cdktf.IResolvable);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable;
    set encipherOnly(value: boolean | cdktf.IResolvable);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable;
    set keyAgreement(value: boolean | cdktf.IResolvable);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable;
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#client_auth GooglePrivatecaCertificate#client_auth}
    */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#code_signing GooglePrivatecaCertificate#code_signing}
    */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#email_protection GooglePrivatecaCertificate#email_protection}
    */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#ocsp_signing GooglePrivatecaCertificate#ocsp_signing}
    */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#server_auth GooglePrivatecaCertificate#server_auth}
    */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#time_stamping GooglePrivatecaCertificate#time_stamping}
    */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference | GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage): any;
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference | GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable;
    set clientAuth(value: boolean | cdktf.IResolvable);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable;
    set codeSigning(value: boolean | cdktf.IResolvable);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable;
    set emailProtection(value: boolean | cdktf.IResolvable);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable;
    set ocspSigning(value: boolean | cdktf.IResolvable);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable;
    set serverAuth(value: boolean | cdktf.IResolvable);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable;
    set timeStamping(value: boolean | cdktf.IResolvable);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#object_id_path GooglePrivatecaCertificate#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface GooglePrivatecaCertificateConfigX509ConfigKeyUsage {
    /**
    * base_key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#base_key_usage GooglePrivatecaCertificate#base_key_usage}
    */
    readonly baseKeyUsage: GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
    * extended_key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#extended_key_usage GooglePrivatecaCertificate#extended_key_usage}
    */
    readonly extendedKeyUsage: GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
    * unknown_extended_key_usages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#unknown_extended_key_usages GooglePrivatecaCertificate#unknown_extended_key_usages}
    */
    readonly unknownExtendedKeyUsages?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageOutputReference | GooglePrivatecaCertificateConfigX509ConfigKeyUsage): any;
export declare function googlePrivatecaCertificateConfigX509ConfigKeyUsageToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigKeyUsageOutputReference | GooglePrivatecaCertificateConfigX509ConfigKeyUsage): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    get extendedKeyUsage(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList;
    putUnknownExtendedKeyUsages(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable): void;
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): cdktf.IResolvable | GooglePrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigNameConstraints {
    /**
    * Indicates whether or not the name constraints are marked critical.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#critical GooglePrivatecaCertificate#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * Contains excluded DNS names. Any DNS name that can be
    * constructed by simply adding zero or more labels to
    * the left-hand side of the name satisfies the name constraint.
    * For example, 'example.com', 'www.example.com', 'www.sub.example.com'
    * would satisfy 'example.com' while 'example1.com' does not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#excluded_dns_names GooglePrivatecaCertificate#excluded_dns_names}
    */
    readonly excludedDnsNames?: string[];
    /**
    * Contains the excluded email addresses. The value can be a particular
    * email address, a hostname to indicate all email addresses on that host or
    * a domain with a leading period (e.g. '.example.com') to indicate
    * all email addresses in that domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#excluded_email_addresses GooglePrivatecaCertificate#excluded_email_addresses}
    */
    readonly excludedEmailAddresses?: string[];
    /**
    * Contains the excluded IP ranges. For IPv4 addresses, the ranges
    * are expressed using CIDR notation as specified in RFC 4632.
    * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
    * addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#excluded_ip_ranges GooglePrivatecaCertificate#excluded_ip_ranges}
    */
    readonly excludedIpRanges?: string[];
    /**
    * Contains the excluded URIs that apply to the host part of the name.
    * The value can be a hostname or a domain with a
    * leading period (like '.example.com')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#excluded_uris GooglePrivatecaCertificate#excluded_uris}
    */
    readonly excludedUris?: string[];
    /**
    * Contains permitted DNS names. Any DNS name that can be
    * constructed by simply adding zero or more labels to
    * the left-hand side of the name satisfies the name constraint.
    * For example, 'example.com', 'www.example.com', 'www.sub.example.com'
    * would satisfy 'example.com' while 'example1.com' does not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#permitted_dns_names GooglePrivatecaCertificate#permitted_dns_names}
    */
    readonly permittedDnsNames?: string[];
    /**
    * Contains the permitted email addresses. The value can be a particular
    * email address, a hostname to indicate all email addresses on that host or
    * a domain with a leading period (e.g. '.example.com') to indicate
    * all email addresses in that domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#permitted_email_addresses GooglePrivatecaCertificate#permitted_email_addresses}
    */
    readonly permittedEmailAddresses?: string[];
    /**
    * Contains the permitted IP ranges. For IPv4 addresses, the ranges
    * are expressed using CIDR notation as specified in RFC 4632.
    * For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
    * addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#permitted_ip_ranges GooglePrivatecaCertificate#permitted_ip_ranges}
    */
    readonly permittedIpRanges?: string[];
    /**
    * Contains the permitted URIs that apply to the host part of the name.
    * The value can be a hostname or a domain with a
    * leading period (like '.example.com')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#permitted_uris GooglePrivatecaCertificate#permitted_uris}
    */
    readonly permittedUris?: string[];
}
export declare function googlePrivatecaCertificateConfigX509ConfigNameConstraintsToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigNameConstraintsOutputReference | GooglePrivatecaCertificateConfigX509ConfigNameConstraints): any;
export declare function googlePrivatecaCertificateConfigX509ConfigNameConstraintsToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigNameConstraintsOutputReference | GooglePrivatecaCertificateConfigX509ConfigNameConstraints): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigNameConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigNameConstraints | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigNameConstraints | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedDnsNames?;
    get excludedDnsNames(): string[];
    set excludedDnsNames(value: string[]);
    resetExcludedDnsNames(): void;
    get excludedDnsNamesInput(): string[] | undefined;
    private _excludedEmailAddresses?;
    get excludedEmailAddresses(): string[];
    set excludedEmailAddresses(value: string[]);
    resetExcludedEmailAddresses(): void;
    get excludedEmailAddressesInput(): string[] | undefined;
    private _excludedIpRanges?;
    get excludedIpRanges(): string[];
    set excludedIpRanges(value: string[]);
    resetExcludedIpRanges(): void;
    get excludedIpRangesInput(): string[] | undefined;
    private _excludedUris?;
    get excludedUris(): string[];
    set excludedUris(value: string[]);
    resetExcludedUris(): void;
    get excludedUrisInput(): string[] | undefined;
    private _permittedDnsNames?;
    get permittedDnsNames(): string[];
    set permittedDnsNames(value: string[]);
    resetPermittedDnsNames(): void;
    get permittedDnsNamesInput(): string[] | undefined;
    private _permittedEmailAddresses?;
    get permittedEmailAddresses(): string[];
    set permittedEmailAddresses(value: string[]);
    resetPermittedEmailAddresses(): void;
    get permittedEmailAddressesInput(): string[] | undefined;
    private _permittedIpRanges?;
    get permittedIpRanges(): string[];
    set permittedIpRanges(value: string[]);
    resetPermittedIpRanges(): void;
    get permittedIpRangesInput(): string[] | undefined;
    private _permittedUris?;
    get permittedUris(): string[];
    set permittedUris(value: string[]);
    resetPermittedUris(): void;
    get permittedUrisInput(): string[] | undefined;
}
export interface GooglePrivatecaCertificateConfigX509ConfigPolicyIds {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#object_id_path GooglePrivatecaCertificate#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCertificateConfigX509ConfigPolicyIdsToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigPolicyIds | cdktf.IResolvable): any;
export declare function googlePrivatecaCertificateConfigX509ConfigPolicyIdsToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigPolicyIds | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateConfigX509ConfigPolicyIds | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509ConfigPolicyIds | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class GooglePrivatecaCertificateConfigX509ConfigPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCertificateConfigX509ConfigPolicyIds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateConfigX509ConfigPolicyIdsOutputReference;
}
export interface GooglePrivatecaCertificateConfigX509Config {
    /**
    * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
    * "Authority Information Access" extension in the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#aia_ocsp_servers GooglePrivatecaCertificate#aia_ocsp_servers}
    */
    readonly aiaOcspServers?: string[];
    /**
    * additional_extensions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#additional_extensions GooglePrivatecaCertificate#additional_extensions}
    */
    readonly additionalExtensions?: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * ca_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#ca_options GooglePrivatecaCertificate#ca_options}
    */
    readonly caOptions?: GooglePrivatecaCertificateConfigX509ConfigCaOptions;
    /**
    * key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#key_usage GooglePrivatecaCertificate#key_usage}
    */
    readonly keyUsage: GooglePrivatecaCertificateConfigX509ConfigKeyUsage;
    /**
    * name_constraints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#name_constraints GooglePrivatecaCertificate#name_constraints}
    */
    readonly nameConstraints?: GooglePrivatecaCertificateConfigX509ConfigNameConstraints;
    /**
    * policy_ids block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#policy_ids GooglePrivatecaCertificate#policy_ids}
    */
    readonly policyIds?: GooglePrivatecaCertificateConfigX509ConfigPolicyIds[] | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateConfigX509ConfigToTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigOutputReference | GooglePrivatecaCertificateConfigX509Config): any;
export declare function googlePrivatecaCertificateConfigX509ConfigToHclTerraform(struct?: GooglePrivatecaCertificateConfigX509ConfigOutputReference | GooglePrivatecaCertificateConfigX509Config): any;
export declare class GooglePrivatecaCertificateConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigX509Config | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigX509Config | undefined);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[];
    set aiaOcspServers(value: string[]);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions;
    get additionalExtensions(): GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensionsList;
    putAdditionalExtensions(value: GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable): void;
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): cdktf.IResolvable | GooglePrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions;
    get caOptions(): GooglePrivatecaCertificateConfigX509ConfigCaOptionsOutputReference;
    putCaOptions(value: GooglePrivatecaCertificateConfigX509ConfigCaOptions): void;
    resetCaOptions(): void;
    get caOptionsInput(): GooglePrivatecaCertificateConfigX509ConfigCaOptions | undefined;
    private _keyUsage;
    get keyUsage(): GooglePrivatecaCertificateConfigX509ConfigKeyUsageOutputReference;
    putKeyUsage(value: GooglePrivatecaCertificateConfigX509ConfigKeyUsage): void;
    get keyUsageInput(): GooglePrivatecaCertificateConfigX509ConfigKeyUsage | undefined;
    private _nameConstraints;
    get nameConstraints(): GooglePrivatecaCertificateConfigX509ConfigNameConstraintsOutputReference;
    putNameConstraints(value: GooglePrivatecaCertificateConfigX509ConfigNameConstraints): void;
    resetNameConstraints(): void;
    get nameConstraintsInput(): GooglePrivatecaCertificateConfigX509ConfigNameConstraints | undefined;
    private _policyIds;
    get policyIds(): GooglePrivatecaCertificateConfigX509ConfigPolicyIdsList;
    putPolicyIds(value: GooglePrivatecaCertificateConfigX509ConfigPolicyIds[] | cdktf.IResolvable): void;
    resetPolicyIds(): void;
    get policyIdsInput(): cdktf.IResolvable | GooglePrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined;
}
export interface GooglePrivatecaCertificateConfigA {
    /**
    * public_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#public_key GooglePrivatecaCertificate#public_key}
    */
    readonly publicKey: GooglePrivatecaCertificateConfigPublicKey;
    /**
    * subject_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#subject_config GooglePrivatecaCertificate#subject_config}
    */
    readonly subjectConfig: GooglePrivatecaCertificateConfigSubjectConfig;
    /**
    * x509_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#x509_config GooglePrivatecaCertificate#x509_config}
    */
    readonly x509Config: GooglePrivatecaCertificateConfigX509Config;
}
export declare function googlePrivatecaCertificateConfigAToTerraform(struct?: GooglePrivatecaCertificateConfigAOutputReference | GooglePrivatecaCertificateConfigA): any;
export declare function googlePrivatecaCertificateConfigAToHclTerraform(struct?: GooglePrivatecaCertificateConfigAOutputReference | GooglePrivatecaCertificateConfigA): any;
export declare class GooglePrivatecaCertificateConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateConfigA | undefined;
    set internalValue(value: GooglePrivatecaCertificateConfigA | undefined);
    private _publicKey;
    get publicKey(): GooglePrivatecaCertificateConfigPublicKeyOutputReference;
    putPublicKey(value: GooglePrivatecaCertificateConfigPublicKey): void;
    get publicKeyInput(): GooglePrivatecaCertificateConfigPublicKey | undefined;
    private _subjectConfig;
    get subjectConfig(): GooglePrivatecaCertificateConfigSubjectConfigOutputReference;
    putSubjectConfig(value: GooglePrivatecaCertificateConfigSubjectConfig): void;
    get subjectConfigInput(): GooglePrivatecaCertificateConfigSubjectConfig | undefined;
    private _x509Config;
    get x509Config(): GooglePrivatecaCertificateConfigX509ConfigOutputReference;
    putX509Config(value: GooglePrivatecaCertificateConfigX509Config): void;
    get x509ConfigInput(): GooglePrivatecaCertificateConfigX509Config | undefined;
}
export interface GooglePrivatecaCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#create GooglePrivatecaCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#delete GooglePrivatecaCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#update GooglePrivatecaCertificate#update}
    */
    readonly update?: string;
}
export declare function googlePrivatecaCertificateTimeoutsToTerraform(struct?: GooglePrivatecaCertificateTimeouts | cdktf.IResolvable): any;
export declare function googlePrivatecaCertificateTimeoutsToHclTerraform(struct?: GooglePrivatecaCertificateTimeouts | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate google_privateca_certificate}
*/
export declare class GooglePrivatecaCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_certificate";
    /**
    * Generates CDKTF code for importing a GooglePrivatecaCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GooglePrivatecaCertificate to import
    * @param importFromId The id of the existing GooglePrivatecaCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GooglePrivatecaCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_privateca_certificate google_privateca_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePrivatecaCertificateConfig
    */
    constructor(scope: Construct, id: string, config: GooglePrivatecaCertificateConfig);
    private _certificateAuthority?;
    get certificateAuthority(): string;
    set certificateAuthority(value: string);
    resetCertificateAuthority(): void;
    get certificateAuthorityInput(): string | undefined;
    private _certificateDescription;
    get certificateDescription(): GooglePrivatecaCertificateCertificateDescriptionList;
    private _certificateTemplate?;
    get certificateTemplate(): string;
    set certificateTemplate(value: string);
    resetCertificateTemplate(): void;
    get certificateTemplateInput(): string | undefined;
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuerCertificateAuthority(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): string;
    set lifetime(value: string);
    resetLifetime(): void;
    get lifetimeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pemCertificate(): string;
    get pemCertificateChain(): string[];
    private _pemCsr?;
    get pemCsr(): string;
    set pemCsr(value: string);
    resetPemCsr(): void;
    get pemCsrInput(): string | undefined;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _revocationDetails;
    get revocationDetails(): GooglePrivatecaCertificateRevocationDetailsList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _config;
    get config(): GooglePrivatecaCertificateConfigAOutputReference;
    putConfig(value: GooglePrivatecaCertificateConfigA): void;
    resetConfig(): void;
    get configInput(): GooglePrivatecaCertificateConfigA | undefined;
    private _timeouts;
    get timeouts(): GooglePrivatecaCertificateTimeoutsOutputReference;
    putTimeouts(value: GooglePrivatecaCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePrivatecaCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
