/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectDefaultServiceAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The action to be performed in the default service accounts. Valid values are: DEPRIVILEGE, DELETE, DISABLE.
    * 				Note that DEPRIVILEGE action will ignore the REVERT configuration in the restore_policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#action GoogleProjectDefaultServiceAccounts#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#id GoogleProjectDefaultServiceAccounts#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project ID where service accounts are created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#project GoogleProjectDefaultServiceAccounts#project}
    */
    readonly project: string;
    /**
    * The action to be performed in the default service accounts on the resource destroy.
    * 				Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#restore_policy GoogleProjectDefaultServiceAccounts#restore_policy}
    */
    readonly restorePolicy?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#timeouts GoogleProjectDefaultServiceAccounts#timeouts}
    */
    readonly timeouts?: GoogleProjectDefaultServiceAccountsTimeouts;
}
export interface GoogleProjectDefaultServiceAccountsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#create GoogleProjectDefaultServiceAccounts#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#delete GoogleProjectDefaultServiceAccounts#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#read GoogleProjectDefaultServiceAccounts#read}
    */
    readonly read?: string;
}
export declare function googleProjectDefaultServiceAccountsTimeoutsToTerraform(struct?: GoogleProjectDefaultServiceAccountsTimeouts | cdktf.IResolvable): any;
export declare function googleProjectDefaultServiceAccountsTimeoutsToHclTerraform(struct?: GoogleProjectDefaultServiceAccountsTimeouts | cdktf.IResolvable): any;
export declare class GoogleProjectDefaultServiceAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectDefaultServiceAccountsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectDefaultServiceAccountsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts google_project_default_service_accounts}
*/
export declare class GoogleProjectDefaultServiceAccounts extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_default_service_accounts";
    /**
    * Generates CDKTF code for importing a GoogleProjectDefaultServiceAccounts resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleProjectDefaultServiceAccounts to import
    * @param importFromId The id of the existing GoogleProjectDefaultServiceAccounts that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleProjectDefaultServiceAccounts to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_default_service_accounts google_project_default_service_accounts} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectDefaultServiceAccountsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectDefaultServiceAccountsConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _restorePolicy?;
    get restorePolicy(): string;
    set restorePolicy(value: string);
    resetRestorePolicy(): void;
    get restorePolicyInput(): string | undefined;
    private _serviceAccounts;
    get serviceAccounts(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): GoogleProjectDefaultServiceAccountsTimeoutsOutputReference;
    putTimeouts(value: GoogleProjectDefaultServiceAccountsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleProjectDefaultServiceAccountsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
