/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectServiceIdentityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#id GoogleProjectServiceIdentity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#project GoogleProjectServiceIdentity#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#service GoogleProjectServiceIdentity#service}
    */
    readonly service: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#timeouts GoogleProjectServiceIdentity#timeouts}
    */
    readonly timeouts?: GoogleProjectServiceIdentityTimeouts;
}
export interface GoogleProjectServiceIdentityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#create GoogleProjectServiceIdentity#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#delete GoogleProjectServiceIdentity#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#read GoogleProjectServiceIdentity#read}
    */
    readonly read?: string;
}
export declare function googleProjectServiceIdentityTimeoutsToTerraform(struct?: GoogleProjectServiceIdentityTimeouts | cdktf.IResolvable): any;
export declare function googleProjectServiceIdentityTimeoutsToHclTerraform(struct?: GoogleProjectServiceIdentityTimeouts | cdktf.IResolvable): any;
export declare class GoogleProjectServiceIdentityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectServiceIdentityTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectServiceIdentityTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity google_project_service_identity}
*/
export declare class GoogleProjectServiceIdentity extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_service_identity";
    /**
    * Generates CDKTF code for importing a GoogleProjectServiceIdentity resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleProjectServiceIdentity to import
    * @param importFromId The id of the existing GoogleProjectServiceIdentity that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleProjectServiceIdentity to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_project_service_identity google_project_service_identity} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectServiceIdentityConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectServiceIdentityConfig);
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleProjectServiceIdentityTimeoutsOutputReference;
    putTimeouts(value: GoogleProjectServiceIdentityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleProjectServiceIdentityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
