/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePublicCaExternalAccountKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#id GooglePublicCaExternalAccountKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Location for the externalAccountKey. Currently only 'global' is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#location GooglePublicCaExternalAccountKey#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#project GooglePublicCaExternalAccountKey#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#timeouts GooglePublicCaExternalAccountKey#timeouts}
    */
    readonly timeouts?: GooglePublicCaExternalAccountKeyTimeouts;
}
export interface GooglePublicCaExternalAccountKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#create GooglePublicCaExternalAccountKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#delete GooglePublicCaExternalAccountKey#delete}
    */
    readonly delete?: string;
}
export declare function googlePublicCaExternalAccountKeyTimeoutsToTerraform(struct?: GooglePublicCaExternalAccountKeyTimeouts | cdktf.IResolvable): any;
export declare function googlePublicCaExternalAccountKeyTimeoutsToHclTerraform(struct?: GooglePublicCaExternalAccountKeyTimeouts | cdktf.IResolvable): any;
export declare class GooglePublicCaExternalAccountKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePublicCaExternalAccountKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePublicCaExternalAccountKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key google_public_ca_external_account_key}
*/
export declare class GooglePublicCaExternalAccountKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_public_ca_external_account_key";
    /**
    * Generates CDKTF code for importing a GooglePublicCaExternalAccountKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GooglePublicCaExternalAccountKey to import
    * @param importFromId The id of the existing GooglePublicCaExternalAccountKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GooglePublicCaExternalAccountKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_public_ca_external_account_key google_public_ca_external_account_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePublicCaExternalAccountKeyConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GooglePublicCaExternalAccountKeyConfig);
    get b64MacKey(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyId(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GooglePublicCaExternalAccountKeyTimeoutsOutputReference;
    putTimeouts(value: GooglePublicCaExternalAccountKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePublicCaExternalAccountKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
