/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubLiteTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#id GooglePubsubLiteTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#name GooglePubsubLiteTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#project GooglePubsubLiteTopic#project}
    */
    readonly project?: string;
    /**
    * The region of the pubsub lite topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#region GooglePubsubLiteTopic#region}
    */
    readonly region?: string;
    /**
    * The zone of the pubsub lite topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#zone GooglePubsubLiteTopic#zone}
    */
    readonly zone?: string;
    /**
    * partition_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#partition_config GooglePubsubLiteTopic#partition_config}
    */
    readonly partitionConfig?: GooglePubsubLiteTopicPartitionConfig;
    /**
    * reservation_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#reservation_config GooglePubsubLiteTopic#reservation_config}
    */
    readonly reservationConfig?: GooglePubsubLiteTopicReservationConfig;
    /**
    * retention_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#retention_config GooglePubsubLiteTopic#retention_config}
    */
    readonly retentionConfig?: GooglePubsubLiteTopicRetentionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#timeouts GooglePubsubLiteTopic#timeouts}
    */
    readonly timeouts?: GooglePubsubLiteTopicTimeouts;
}
export interface GooglePubsubLiteTopicPartitionConfigCapacity {
    /**
    * Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#publish_mib_per_sec GooglePubsubLiteTopic#publish_mib_per_sec}
    */
    readonly publishMibPerSec: number;
    /**
    * Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#subscribe_mib_per_sec GooglePubsubLiteTopic#subscribe_mib_per_sec}
    */
    readonly subscribeMibPerSec: number;
}
export declare function googlePubsubLiteTopicPartitionConfigCapacityToTerraform(struct?: GooglePubsubLiteTopicPartitionConfigCapacityOutputReference | GooglePubsubLiteTopicPartitionConfigCapacity): any;
export declare function googlePubsubLiteTopicPartitionConfigCapacityToHclTerraform(struct?: GooglePubsubLiteTopicPartitionConfigCapacityOutputReference | GooglePubsubLiteTopicPartitionConfigCapacity): any;
export declare class GooglePubsubLiteTopicPartitionConfigCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteTopicPartitionConfigCapacity | undefined;
    set internalValue(value: GooglePubsubLiteTopicPartitionConfigCapacity | undefined);
    private _publishMibPerSec?;
    get publishMibPerSec(): number;
    set publishMibPerSec(value: number);
    get publishMibPerSecInput(): number | undefined;
    private _subscribeMibPerSec?;
    get subscribeMibPerSec(): number;
    set subscribeMibPerSec(value: number);
    get subscribeMibPerSecInput(): number | undefined;
}
export interface GooglePubsubLiteTopicPartitionConfig {
    /**
    * The number of partitions in the topic. Must be at least 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#count GooglePubsubLiteTopic#count}
    */
    readonly count: number;
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#capacity GooglePubsubLiteTopic#capacity}
    */
    readonly capacity?: GooglePubsubLiteTopicPartitionConfigCapacity;
}
export declare function googlePubsubLiteTopicPartitionConfigToTerraform(struct?: GooglePubsubLiteTopicPartitionConfigOutputReference | GooglePubsubLiteTopicPartitionConfig): any;
export declare function googlePubsubLiteTopicPartitionConfigToHclTerraform(struct?: GooglePubsubLiteTopicPartitionConfigOutputReference | GooglePubsubLiteTopicPartitionConfig): any;
export declare class GooglePubsubLiteTopicPartitionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteTopicPartitionConfig | undefined;
    set internalValue(value: GooglePubsubLiteTopicPartitionConfig | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _capacity;
    get capacity(): GooglePubsubLiteTopicPartitionConfigCapacityOutputReference;
    putCapacity(value: GooglePubsubLiteTopicPartitionConfigCapacity): void;
    resetCapacity(): void;
    get capacityInput(): GooglePubsubLiteTopicPartitionConfigCapacity | undefined;
}
export interface GooglePubsubLiteTopicReservationConfig {
    /**
    * The Reservation to use for this topic's throughput capacity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#throughput_reservation GooglePubsubLiteTopic#throughput_reservation}
    */
    readonly throughputReservation?: string;
}
export declare function googlePubsubLiteTopicReservationConfigToTerraform(struct?: GooglePubsubLiteTopicReservationConfigOutputReference | GooglePubsubLiteTopicReservationConfig): any;
export declare function googlePubsubLiteTopicReservationConfigToHclTerraform(struct?: GooglePubsubLiteTopicReservationConfigOutputReference | GooglePubsubLiteTopicReservationConfig): any;
export declare class GooglePubsubLiteTopicReservationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteTopicReservationConfig | undefined;
    set internalValue(value: GooglePubsubLiteTopicReservationConfig | undefined);
    private _throughputReservation?;
    get throughputReservation(): string;
    set throughputReservation(value: string);
    resetThroughputReservation(): void;
    get throughputReservationInput(): string | undefined;
}
export interface GooglePubsubLiteTopicRetentionConfig {
    /**
    * The provisioned storage, in bytes, per partition. If the number of bytes stored
    * in any of the topic's partitions grows beyond this value, older messages will be
    * dropped to make room for newer ones, regardless of the value of period.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#per_partition_bytes GooglePubsubLiteTopic#per_partition_bytes}
    */
    readonly perPartitionBytes: string;
    /**
    * How long a published message is retained. If unset, messages will be retained as
    * long as the bytes retained for each partition is below perPartitionBytes. A
    * duration in seconds with up to nine fractional digits, terminated by 's'.
    * Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#period GooglePubsubLiteTopic#period}
    */
    readonly period?: string;
}
export declare function googlePubsubLiteTopicRetentionConfigToTerraform(struct?: GooglePubsubLiteTopicRetentionConfigOutputReference | GooglePubsubLiteTopicRetentionConfig): any;
export declare function googlePubsubLiteTopicRetentionConfigToHclTerraform(struct?: GooglePubsubLiteTopicRetentionConfigOutputReference | GooglePubsubLiteTopicRetentionConfig): any;
export declare class GooglePubsubLiteTopicRetentionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteTopicRetentionConfig | undefined;
    set internalValue(value: GooglePubsubLiteTopicRetentionConfig | undefined);
    private _perPartitionBytes?;
    get perPartitionBytes(): string;
    set perPartitionBytes(value: string);
    get perPartitionBytesInput(): string | undefined;
    private _period?;
    get period(): string;
    set period(value: string);
    resetPeriod(): void;
    get periodInput(): string | undefined;
}
export interface GooglePubsubLiteTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#create GooglePubsubLiteTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#delete GooglePubsubLiteTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#update GooglePubsubLiteTopic#update}
    */
    readonly update?: string;
}
export declare function googlePubsubLiteTopicTimeoutsToTerraform(struct?: GooglePubsubLiteTopicTimeouts | cdktf.IResolvable): any;
export declare function googlePubsubLiteTopicTimeoutsToHclTerraform(struct?: GooglePubsubLiteTopicTimeouts | cdktf.IResolvable): any;
export declare class GooglePubsubLiteTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePubsubLiteTopicTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic google_pubsub_lite_topic}
*/
export declare class GooglePubsubLiteTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_lite_topic";
    /**
    * Generates CDKTF code for importing a GooglePubsubLiteTopic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GooglePubsubLiteTopic to import
    * @param importFromId The id of the existing GooglePubsubLiteTopic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GooglePubsubLiteTopic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_lite_topic google_pubsub_lite_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubLiteTopicConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubLiteTopicConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _partitionConfig;
    get partitionConfig(): GooglePubsubLiteTopicPartitionConfigOutputReference;
    putPartitionConfig(value: GooglePubsubLiteTopicPartitionConfig): void;
    resetPartitionConfig(): void;
    get partitionConfigInput(): GooglePubsubLiteTopicPartitionConfig | undefined;
    private _reservationConfig;
    get reservationConfig(): GooglePubsubLiteTopicReservationConfigOutputReference;
    putReservationConfig(value: GooglePubsubLiteTopicReservationConfig): void;
    resetReservationConfig(): void;
    get reservationConfigInput(): GooglePubsubLiteTopicReservationConfig | undefined;
    private _retentionConfig;
    get retentionConfig(): GooglePubsubLiteTopicRetentionConfigOutputReference;
    putRetentionConfig(value: GooglePubsubLiteTopicRetentionConfig): void;
    resetRetentionConfig(): void;
    get retentionConfigInput(): GooglePubsubLiteTopicRetentionConfig | undefined;
    private _timeouts;
    get timeouts(): GooglePubsubLiteTopicTimeoutsOutputReference;
    putTimeouts(value: GooglePubsubLiteTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePubsubLiteTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
