/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * This value is the maximum time after a subscriber receives a message
    * before the subscriber should acknowledge the message. After message
    * delivery but before the ack deadline expires and before the message is
    * acknowledged, it is an outstanding message and will not be delivered
    * again during that time (on a best-effort basis).
    *
    * For pull subscriptions, this value is used as the initial value for
    * the ack deadline. To override this value for a given message, call
    * subscriptions.modifyAckDeadline with the corresponding ackId if using
    * pull. The minimum custom deadline you can specify is 10 seconds. The
    * maximum custom deadline you can specify is 600 seconds (10 minutes).
    * If this parameter is 0, a default value of 10 seconds is used.
    *
    * For push delivery, this value is also used to set the request timeout
    * for the call to the push endpoint.
    *
    * If the subscriber never acknowledges the message, the Pub/Sub system
    * will eventually redeliver the message.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#ack_deadline_seconds GooglePubsubSubscription#ack_deadline_seconds}
    */
    readonly ackDeadlineSeconds?: number;
    /**
    * If 'true', Pub/Sub provides the following guarantees for the delivery
    * of a message with a given value of messageId on this Subscriptions':
    *
    * - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
    *
    * - An acknowledged message will not be resent to a subscriber.
    *
    * Note that subscribers may still receive multiple copies of a message when 'enable_exactly_once_delivery'
    * is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#enable_exactly_once_delivery GooglePubsubSubscription#enable_exactly_once_delivery}
    */
    readonly enableExactlyOnceDelivery?: boolean | cdktf.IResolvable;
    /**
    * If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to
    * the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
    * may be delivered in any order.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#enable_message_ordering GooglePubsubSubscription#enable_message_ordering}
    */
    readonly enableMessageOrdering?: boolean | cdktf.IResolvable;
    /**
    * The subscription only delivers the messages that match the filter.
    * Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
    * by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
    * you can't modify the filter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#filter GooglePubsubSubscription#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#id GooglePubsubSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this Subscription.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#labels GooglePubsubSubscription#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * How long to retain unacknowledged messages in the subscription's
    * backlog, from the moment a message is published. If
    * retain_acked_messages is true, then this also configures the retention
    * of acknowledged messages, and thus configures how far back in time a
    * subscriptions.seek can be done. Defaults to 7 days. Cannot be more
    * than 7 days ('"604800s"') or less than 10 minutes ('"600s"').
    *
    * A duration in seconds with up to nine fractional digits, terminated
    * by 's'. Example: '"600.5s"'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#message_retention_duration GooglePubsubSubscription#message_retention_duration}
    */
    readonly messageRetentionDuration?: string;
    /**
    * Name of the subscription.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#name GooglePubsubSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#project GooglePubsubSubscription#project}
    */
    readonly project?: string;
    /**
    * Indicates whether to retain acknowledged messages. If 'true', then
    * messages are not expunged from the subscription's backlog, even if
    * they are acknowledged, until they fall out of the
    * messageRetentionDuration window.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#retain_acked_messages GooglePubsubSubscription#retain_acked_messages}
    */
    readonly retainAckedMessages?: boolean | cdktf.IResolvable;
    /**
    * A reference to a Topic resource, of the form projects/{project}/topics/{{name}}
    * (as in the id property of a google_pubsub_topic), or just a topic name if
    * the topic is in the same project as the subscription.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#topic GooglePubsubSubscription#topic}
    */
    readonly topic: string;
    /**
    * bigquery_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#bigquery_config GooglePubsubSubscription#bigquery_config}
    */
    readonly bigqueryConfig?: GooglePubsubSubscriptionBigqueryConfig;
    /**
    * cloud_storage_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#cloud_storage_config GooglePubsubSubscription#cloud_storage_config}
    */
    readonly cloudStorageConfig?: GooglePubsubSubscriptionCloudStorageConfig;
    /**
    * dead_letter_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#dead_letter_policy GooglePubsubSubscription#dead_letter_policy}
    */
    readonly deadLetterPolicy?: GooglePubsubSubscriptionDeadLetterPolicy;
    /**
    * expiration_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#expiration_policy GooglePubsubSubscription#expiration_policy}
    */
    readonly expirationPolicy?: GooglePubsubSubscriptionExpirationPolicy;
    /**
    * push_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#push_config GooglePubsubSubscription#push_config}
    */
    readonly pushConfig?: GooglePubsubSubscriptionPushConfig;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#retry_policy GooglePubsubSubscription#retry_policy}
    */
    readonly retryPolicy?: GooglePubsubSubscriptionRetryPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#timeouts GooglePubsubSubscription#timeouts}
    */
    readonly timeouts?: GooglePubsubSubscriptionTimeouts;
}
export interface GooglePubsubSubscriptionBigqueryConfig {
    /**
    * When true and use_topic_schema or use_table_schema is true, any fields that are a part of the topic schema or message schema that
    * are not part of the BigQuery table schema are dropped when writing to BigQuery. Otherwise, the schemas must be kept in sync
    * and any messages with extra fields are not written and remain in the subscription's backlog.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#drop_unknown_fields GooglePubsubSubscription#drop_unknown_fields}
    */
    readonly dropUnknownFields?: boolean | cdktf.IResolvable;
    /**
    * The name of the table to which to write data, of the form {projectId}:{datasetId}.{tableId}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#table GooglePubsubSubscription#table}
    */
    readonly table: string;
    /**
    * When true, use the BigQuery table's schema as the columns to write to in BigQuery. Messages
    * must be published in JSON format. Only one of use_topic_schema and use_table_schema can be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#use_table_schema GooglePubsubSubscription#use_table_schema}
    */
    readonly useTableSchema?: boolean | cdktf.IResolvable;
    /**
    * When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
    * Only one of use_topic_schema and use_table_schema can be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#use_topic_schema GooglePubsubSubscription#use_topic_schema}
    */
    readonly useTopicSchema?: boolean | cdktf.IResolvable;
    /**
    * When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
    * The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#write_metadata GooglePubsubSubscription#write_metadata}
    */
    readonly writeMetadata?: boolean | cdktf.IResolvable;
}
export declare function googlePubsubSubscriptionBigqueryConfigToTerraform(struct?: GooglePubsubSubscriptionBigqueryConfigOutputReference | GooglePubsubSubscriptionBigqueryConfig): any;
export declare function googlePubsubSubscriptionBigqueryConfigToHclTerraform(struct?: GooglePubsubSubscriptionBigqueryConfigOutputReference | GooglePubsubSubscriptionBigqueryConfig): any;
export declare class GooglePubsubSubscriptionBigqueryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionBigqueryConfig | undefined;
    set internalValue(value: GooglePubsubSubscriptionBigqueryConfig | undefined);
    private _dropUnknownFields?;
    get dropUnknownFields(): boolean | cdktf.IResolvable;
    set dropUnknownFields(value: boolean | cdktf.IResolvable);
    resetDropUnknownFields(): void;
    get dropUnknownFieldsInput(): boolean | cdktf.IResolvable | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _useTableSchema?;
    get useTableSchema(): boolean | cdktf.IResolvable;
    set useTableSchema(value: boolean | cdktf.IResolvable);
    resetUseTableSchema(): void;
    get useTableSchemaInput(): boolean | cdktf.IResolvable | undefined;
    private _useTopicSchema?;
    get useTopicSchema(): boolean | cdktf.IResolvable;
    set useTopicSchema(value: boolean | cdktf.IResolvable);
    resetUseTopicSchema(): void;
    get useTopicSchemaInput(): boolean | cdktf.IResolvable | undefined;
    private _writeMetadata?;
    get writeMetadata(): boolean | cdktf.IResolvable;
    set writeMetadata(value: boolean | cdktf.IResolvable);
    resetWriteMetadata(): void;
    get writeMetadataInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePubsubSubscriptionCloudStorageConfigAvroConfig {
    /**
    * When true, write the subscription name, messageId, publishTime, attributes, and orderingKey as additional fields in the output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#write_metadata GooglePubsubSubscription#write_metadata}
    */
    readonly writeMetadata?: boolean | cdktf.IResolvable;
}
export declare function googlePubsubSubscriptionCloudStorageConfigAvroConfigToTerraform(struct?: GooglePubsubSubscriptionCloudStorageConfigAvroConfigOutputReference | GooglePubsubSubscriptionCloudStorageConfigAvroConfig): any;
export declare function googlePubsubSubscriptionCloudStorageConfigAvroConfigToHclTerraform(struct?: GooglePubsubSubscriptionCloudStorageConfigAvroConfigOutputReference | GooglePubsubSubscriptionCloudStorageConfigAvroConfig): any;
export declare class GooglePubsubSubscriptionCloudStorageConfigAvroConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionCloudStorageConfigAvroConfig | undefined;
    set internalValue(value: GooglePubsubSubscriptionCloudStorageConfigAvroConfig | undefined);
    private _writeMetadata?;
    get writeMetadata(): boolean | cdktf.IResolvable;
    set writeMetadata(value: boolean | cdktf.IResolvable);
    resetWriteMetadata(): void;
    get writeMetadataInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePubsubSubscriptionCloudStorageConfig {
    /**
    * User-provided name for the Cloud Storage bucket. The bucket must be created by the user. The bucket name must be without any prefix like "gs://".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#bucket GooglePubsubSubscription#bucket}
    */
    readonly bucket: string;
    /**
    * User-provided prefix for Cloud Storage filename.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#filename_prefix GooglePubsubSubscription#filename_prefix}
    */
    readonly filenamePrefix?: string;
    /**
    * User-provided suffix for Cloud Storage filename. Must not end in "/".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#filename_suffix GooglePubsubSubscription#filename_suffix}
    */
    readonly filenameSuffix?: string;
    /**
    * The maximum bytes that can be written to a Cloud Storage file before a new file is created. Min 1 KB, max 10 GiB.
    * The maxBytes limit may be exceeded in cases where messages are larger than the limit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#max_bytes GooglePubsubSubscription#max_bytes}
    */
    readonly maxBytes?: number;
    /**
    * The maximum duration that can elapse before a new Cloud Storage file is created. Min 1 minute, max 10 minutes, default 5 minutes.
    * May not exceed the subscription's acknowledgement deadline.
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#max_duration GooglePubsubSubscription#max_duration}
    */
    readonly maxDuration?: string;
    /**
    * avro_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#avro_config GooglePubsubSubscription#avro_config}
    */
    readonly avroConfig?: GooglePubsubSubscriptionCloudStorageConfigAvroConfig;
}
export declare function googlePubsubSubscriptionCloudStorageConfigToTerraform(struct?: GooglePubsubSubscriptionCloudStorageConfigOutputReference | GooglePubsubSubscriptionCloudStorageConfig): any;
export declare function googlePubsubSubscriptionCloudStorageConfigToHclTerraform(struct?: GooglePubsubSubscriptionCloudStorageConfigOutputReference | GooglePubsubSubscriptionCloudStorageConfig): any;
export declare class GooglePubsubSubscriptionCloudStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionCloudStorageConfig | undefined;
    set internalValue(value: GooglePubsubSubscriptionCloudStorageConfig | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _filenamePrefix?;
    get filenamePrefix(): string;
    set filenamePrefix(value: string);
    resetFilenamePrefix(): void;
    get filenamePrefixInput(): string | undefined;
    private _filenameSuffix?;
    get filenameSuffix(): string;
    set filenameSuffix(value: string);
    resetFilenameSuffix(): void;
    get filenameSuffixInput(): string | undefined;
    private _maxBytes?;
    get maxBytes(): number;
    set maxBytes(value: number);
    resetMaxBytes(): void;
    get maxBytesInput(): number | undefined;
    private _maxDuration?;
    get maxDuration(): string;
    set maxDuration(value: string);
    resetMaxDuration(): void;
    get maxDurationInput(): string | undefined;
    get state(): string;
    private _avroConfig;
    get avroConfig(): GooglePubsubSubscriptionCloudStorageConfigAvroConfigOutputReference;
    putAvroConfig(value: GooglePubsubSubscriptionCloudStorageConfigAvroConfig): void;
    resetAvroConfig(): void;
    get avroConfigInput(): GooglePubsubSubscriptionCloudStorageConfigAvroConfig | undefined;
}
export interface GooglePubsubSubscriptionDeadLetterPolicy {
    /**
    * The name of the topic to which dead letter messages should be published.
    * Format is 'projects/{project}/topics/{topic}'.
    *
    * The Cloud Pub/Sub service account associated with the enclosing subscription's
    * parent project (i.e.,
    * service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
    * permission to Publish() to this topic.
    *
    * The operation will fail if the topic does not exist.
    * Users should ensure that there is a subscription attached to this topic
    * since messages published to a topic with no subscriptions are lost.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#dead_letter_topic GooglePubsubSubscription#dead_letter_topic}
    */
    readonly deadLetterTopic?: string;
    /**
    * The maximum number of delivery attempts for any message. The value must be
    * between 5 and 100.
    *
    * The number of delivery attempts is defined as 1 + (the sum of number of
    * NACKs and number of times the acknowledgement deadline has been exceeded for the message).
    *
    * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
    * client libraries may automatically extend ack_deadlines.
    *
    * This field will be honored on a best effort basis.
    *
    * If this parameter is 0, a default value of 5 is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#max_delivery_attempts GooglePubsubSubscription#max_delivery_attempts}
    */
    readonly maxDeliveryAttempts?: number;
}
export declare function googlePubsubSubscriptionDeadLetterPolicyToTerraform(struct?: GooglePubsubSubscriptionDeadLetterPolicyOutputReference | GooglePubsubSubscriptionDeadLetterPolicy): any;
export declare function googlePubsubSubscriptionDeadLetterPolicyToHclTerraform(struct?: GooglePubsubSubscriptionDeadLetterPolicyOutputReference | GooglePubsubSubscriptionDeadLetterPolicy): any;
export declare class GooglePubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionDeadLetterPolicy | undefined;
    set internalValue(value: GooglePubsubSubscriptionDeadLetterPolicy | undefined);
    private _deadLetterTopic?;
    get deadLetterTopic(): string;
    set deadLetterTopic(value: string);
    resetDeadLetterTopic(): void;
    get deadLetterTopicInput(): string | undefined;
    private _maxDeliveryAttempts?;
    get maxDeliveryAttempts(): number;
    set maxDeliveryAttempts(value: number);
    resetMaxDeliveryAttempts(): void;
    get maxDeliveryAttemptsInput(): number | undefined;
}
export interface GooglePubsubSubscriptionExpirationPolicy {
    /**
    * Specifies the "time-to-live" duration for an associated resource. The
    * resource expires if it is not active for a period of ttl.
    * If ttl is set to "", the associated resource never expires.
    * A duration in seconds with up to nine fractional digits, terminated by 's'.
    * Example - "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#ttl GooglePubsubSubscription#ttl}
    */
    readonly ttl: string;
}
export declare function googlePubsubSubscriptionExpirationPolicyToTerraform(struct?: GooglePubsubSubscriptionExpirationPolicyOutputReference | GooglePubsubSubscriptionExpirationPolicy): any;
export declare function googlePubsubSubscriptionExpirationPolicyToHclTerraform(struct?: GooglePubsubSubscriptionExpirationPolicyOutputReference | GooglePubsubSubscriptionExpirationPolicy): any;
export declare class GooglePubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionExpirationPolicy | undefined;
    set internalValue(value: GooglePubsubSubscriptionExpirationPolicy | undefined);
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    get ttlInput(): string | undefined;
}
export interface GooglePubsubSubscriptionPushConfigNoWrapper {
    /**
    * When true, writes the Pub/Sub message metadata to
    * 'x-goog-pubsub-<KEY>:<VAL>' headers of the HTTP request. Writes the
    * Pub/Sub message attributes to '<KEY>:<VAL>' headers of the HTTP request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#write_metadata GooglePubsubSubscription#write_metadata}
    */
    readonly writeMetadata: boolean | cdktf.IResolvable;
}
export declare function googlePubsubSubscriptionPushConfigNoWrapperToTerraform(struct?: GooglePubsubSubscriptionPushConfigNoWrapperOutputReference | GooglePubsubSubscriptionPushConfigNoWrapper): any;
export declare function googlePubsubSubscriptionPushConfigNoWrapperToHclTerraform(struct?: GooglePubsubSubscriptionPushConfigNoWrapperOutputReference | GooglePubsubSubscriptionPushConfigNoWrapper): any;
export declare class GooglePubsubSubscriptionPushConfigNoWrapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionPushConfigNoWrapper | undefined;
    set internalValue(value: GooglePubsubSubscriptionPushConfigNoWrapper | undefined);
    private _writeMetadata?;
    get writeMetadata(): boolean | cdktf.IResolvable;
    set writeMetadata(value: boolean | cdktf.IResolvable);
    get writeMetadataInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePubsubSubscriptionPushConfigOidcToken {
    /**
    * Audience to be used when generating OIDC token. The audience claim
    * identifies the recipients that the JWT is intended for. The audience
    * value is a single case-sensitive string. Having multiple values (array)
    * for the audience field is not supported. More info about the OIDC JWT
    * token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
    * Note: if not specified, the Push endpoint URL will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#audience GooglePubsubSubscription#audience}
    */
    readonly audience?: string;
    /**
    * Service account email to be used for generating the OIDC token.
    * The caller (for subscriptions.create, subscriptions.patch, and
    * subscriptions.modifyPushConfig RPCs) must have the
    * iam.serviceAccounts.actAs permission for the service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#service_account_email GooglePubsubSubscription#service_account_email}
    */
    readonly serviceAccountEmail: string;
}
export declare function googlePubsubSubscriptionPushConfigOidcTokenToTerraform(struct?: GooglePubsubSubscriptionPushConfigOidcTokenOutputReference | GooglePubsubSubscriptionPushConfigOidcToken): any;
export declare function googlePubsubSubscriptionPushConfigOidcTokenToHclTerraform(struct?: GooglePubsubSubscriptionPushConfigOidcTokenOutputReference | GooglePubsubSubscriptionPushConfigOidcToken): any;
export declare class GooglePubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionPushConfigOidcToken | undefined;
    set internalValue(value: GooglePubsubSubscriptionPushConfigOidcToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
}
export interface GooglePubsubSubscriptionPushConfig {
    /**
    * Endpoint configuration attributes.
    *
    * Every endpoint has a set of API supported attributes that can
    * be used to control different aspects of the message delivery.
    *
    * The currently supported attribute is x-goog-version, which you
    * can use to change the format of the pushed message. This
    * attribute indicates the version of the data expected by
    * the endpoint. This controls the shape of the pushed message
    * (i.e., its fields and metadata). The endpoint version is
    * based on the version of the Pub/Sub API.
    *
    * If not present during the subscriptions.create call,
    * it will default to the version of the API used to make
    * such call. If not present during a subscriptions.modifyPushConfig
    * call, its value will not be changed. subscriptions.get
    * calls will always return a valid version, even if the
    * subscription was created without this attribute.
    *
    * The possible values for this attribute are:
    *
    * - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
    * - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#attributes GooglePubsubSubscription#attributes}
    */
    readonly attributes?: {
        [key: string]: string;
    };
    /**
    * A URL locating the endpoint to which messages should be pushed.
    * For example, a Webhook endpoint might use
    * "https://example.com/push".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#push_endpoint GooglePubsubSubscription#push_endpoint}
    */
    readonly pushEndpoint: string;
    /**
    * no_wrapper block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#no_wrapper GooglePubsubSubscription#no_wrapper}
    */
    readonly noWrapper?: GooglePubsubSubscriptionPushConfigNoWrapper;
    /**
    * oidc_token block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#oidc_token GooglePubsubSubscription#oidc_token}
    */
    readonly oidcToken?: GooglePubsubSubscriptionPushConfigOidcToken;
}
export declare function googlePubsubSubscriptionPushConfigToTerraform(struct?: GooglePubsubSubscriptionPushConfigOutputReference | GooglePubsubSubscriptionPushConfig): any;
export declare function googlePubsubSubscriptionPushConfigToHclTerraform(struct?: GooglePubsubSubscriptionPushConfigOutputReference | GooglePubsubSubscriptionPushConfig): any;
export declare class GooglePubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionPushConfig | undefined;
    set internalValue(value: GooglePubsubSubscriptionPushConfig | undefined);
    private _attributes?;
    get attributes(): {
        [key: string]: string;
    };
    set attributes(value: {
        [key: string]: string;
    });
    resetAttributes(): void;
    get attributesInput(): {
        [key: string]: string;
    } | undefined;
    private _pushEndpoint?;
    get pushEndpoint(): string;
    set pushEndpoint(value: string);
    get pushEndpointInput(): string | undefined;
    private _noWrapper;
    get noWrapper(): GooglePubsubSubscriptionPushConfigNoWrapperOutputReference;
    putNoWrapper(value: GooglePubsubSubscriptionPushConfigNoWrapper): void;
    resetNoWrapper(): void;
    get noWrapperInput(): GooglePubsubSubscriptionPushConfigNoWrapper | undefined;
    private _oidcToken;
    get oidcToken(): GooglePubsubSubscriptionPushConfigOidcTokenOutputReference;
    putOidcToken(value: GooglePubsubSubscriptionPushConfigOidcToken): void;
    resetOidcToken(): void;
    get oidcTokenInput(): GooglePubsubSubscriptionPushConfigOidcToken | undefined;
}
export interface GooglePubsubSubscriptionRetryPolicy {
    /**
    * The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#maximum_backoff GooglePubsubSubscription#maximum_backoff}
    */
    readonly maximumBackoff?: string;
    /**
    * The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#minimum_backoff GooglePubsubSubscription#minimum_backoff}
    */
    readonly minimumBackoff?: string;
}
export declare function googlePubsubSubscriptionRetryPolicyToTerraform(struct?: GooglePubsubSubscriptionRetryPolicyOutputReference | GooglePubsubSubscriptionRetryPolicy): any;
export declare function googlePubsubSubscriptionRetryPolicyToHclTerraform(struct?: GooglePubsubSubscriptionRetryPolicyOutputReference | GooglePubsubSubscriptionRetryPolicy): any;
export declare class GooglePubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionRetryPolicy | undefined;
    set internalValue(value: GooglePubsubSubscriptionRetryPolicy | undefined);
    private _maximumBackoff?;
    get maximumBackoff(): string;
    set maximumBackoff(value: string);
    resetMaximumBackoff(): void;
    get maximumBackoffInput(): string | undefined;
    private _minimumBackoff?;
    get minimumBackoff(): string;
    set minimumBackoff(value: string);
    resetMinimumBackoff(): void;
    get minimumBackoffInput(): string | undefined;
}
export interface GooglePubsubSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#create GooglePubsubSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#delete GooglePubsubSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#update GooglePubsubSubscription#update}
    */
    readonly update?: string;
}
export declare function googlePubsubSubscriptionTimeoutsToTerraform(struct?: GooglePubsubSubscriptionTimeouts | cdktf.IResolvable): any;
export declare function googlePubsubSubscriptionTimeoutsToHclTerraform(struct?: GooglePubsubSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class GooglePubsubSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePubsubSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription google_pubsub_subscription}
*/
export declare class GooglePubsubSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_subscription";
    /**
    * Generates CDKTF code for importing a GooglePubsubSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GooglePubsubSubscription to import
    * @param importFromId The id of the existing GooglePubsubSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GooglePubsubSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_subscription google_pubsub_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubSubscriptionConfig);
    private _ackDeadlineSeconds?;
    get ackDeadlineSeconds(): number;
    set ackDeadlineSeconds(value: number);
    resetAckDeadlineSeconds(): void;
    get ackDeadlineSecondsInput(): number | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableExactlyOnceDelivery?;
    get enableExactlyOnceDelivery(): boolean | cdktf.IResolvable;
    set enableExactlyOnceDelivery(value: boolean | cdktf.IResolvable);
    resetEnableExactlyOnceDelivery(): void;
    get enableExactlyOnceDeliveryInput(): boolean | cdktf.IResolvable | undefined;
    private _enableMessageOrdering?;
    get enableMessageOrdering(): boolean | cdktf.IResolvable;
    set enableMessageOrdering(value: boolean | cdktf.IResolvable);
    resetEnableMessageOrdering(): void;
    get enableMessageOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _messageRetentionDuration?;
    get messageRetentionDuration(): string;
    set messageRetentionDuration(value: string);
    resetMessageRetentionDuration(): void;
    get messageRetentionDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _retainAckedMessages?;
    get retainAckedMessages(): boolean | cdktf.IResolvable;
    set retainAckedMessages(value: boolean | cdktf.IResolvable);
    resetRetainAckedMessages(): void;
    get retainAckedMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    private _bigqueryConfig;
    get bigqueryConfig(): GooglePubsubSubscriptionBigqueryConfigOutputReference;
    putBigqueryConfig(value: GooglePubsubSubscriptionBigqueryConfig): void;
    resetBigqueryConfig(): void;
    get bigqueryConfigInput(): GooglePubsubSubscriptionBigqueryConfig | undefined;
    private _cloudStorageConfig;
    get cloudStorageConfig(): GooglePubsubSubscriptionCloudStorageConfigOutputReference;
    putCloudStorageConfig(value: GooglePubsubSubscriptionCloudStorageConfig): void;
    resetCloudStorageConfig(): void;
    get cloudStorageConfigInput(): GooglePubsubSubscriptionCloudStorageConfig | undefined;
    private _deadLetterPolicy;
    get deadLetterPolicy(): GooglePubsubSubscriptionDeadLetterPolicyOutputReference;
    putDeadLetterPolicy(value: GooglePubsubSubscriptionDeadLetterPolicy): void;
    resetDeadLetterPolicy(): void;
    get deadLetterPolicyInput(): GooglePubsubSubscriptionDeadLetterPolicy | undefined;
    private _expirationPolicy;
    get expirationPolicy(): GooglePubsubSubscriptionExpirationPolicyOutputReference;
    putExpirationPolicy(value: GooglePubsubSubscriptionExpirationPolicy): void;
    resetExpirationPolicy(): void;
    get expirationPolicyInput(): GooglePubsubSubscriptionExpirationPolicy | undefined;
    private _pushConfig;
    get pushConfig(): GooglePubsubSubscriptionPushConfigOutputReference;
    putPushConfig(value: GooglePubsubSubscriptionPushConfig): void;
    resetPushConfig(): void;
    get pushConfigInput(): GooglePubsubSubscriptionPushConfig | undefined;
    private _retryPolicy;
    get retryPolicy(): GooglePubsubSubscriptionRetryPolicyOutputReference;
    putRetryPolicy(value: GooglePubsubSubscriptionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GooglePubsubSubscriptionRetryPolicy | undefined;
    private _timeouts;
    get timeouts(): GooglePubsubSubscriptionTimeoutsOutputReference;
    putTimeouts(value: GooglePubsubSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePubsubSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
