/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#id GooglePubsubTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the Cloud KMS CryptoKey to be used to protect access
    * to messages published on this topic. Your project's PubSub service account
    * ('service-{{PROJECT_NUMBER}}@gcp-sa-pubsub.iam.gserviceaccount.com') must have
    * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
    * The expected format is 'projects/* /locations/* /keyRings/* /cryptoKeys/*'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#kms_key_name GooglePubsubTopic#kms_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKeyName?: string;
    /**
    * A set of key/value label pairs to assign to this Topic.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#labels GooglePubsubTopic#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Indicates the minimum duration to retain a message after it is published
    * to the topic. If this field is set, messages published to the topic in
    * the last messageRetentionDuration are always available to subscribers.
    * For instance, it allows any attached subscription to seek to a timestamp
    * that is up to messageRetentionDuration in the past. If this field is not
    * set, message retention is controlled by settings on individual subscriptions.
    * The rotation period has the format of a decimal number, followed by the
    * letter 's' (seconds). Cannot be more than 31 days or less than 10 minutes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#message_retention_duration GooglePubsubTopic#message_retention_duration}
    */
    readonly messageRetentionDuration?: string;
    /**
    * Name of the topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#name GooglePubsubTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#project GooglePubsubTopic#project}
    */
    readonly project?: string;
    /**
    * message_storage_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#message_storage_policy GooglePubsubTopic#message_storage_policy}
    */
    readonly messageStoragePolicy?: GooglePubsubTopicMessageStoragePolicy;
    /**
    * schema_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#schema_settings GooglePubsubTopic#schema_settings}
    */
    readonly schemaSettings?: GooglePubsubTopicSchemaSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#timeouts GooglePubsubTopic#timeouts}
    */
    readonly timeouts?: GooglePubsubTopicTimeouts;
}
export interface GooglePubsubTopicMessageStoragePolicy {
    /**
    * A list of IDs of GCP regions where messages that are published to
    * the topic may be persisted in storage. Messages published by
    * publishers running in non-allowed GCP regions (or running outside
    * of GCP altogether) will be routed for storage in one of the
    * allowed regions. An empty list means that no regions are allowed,
    * and is not a valid configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#allowed_persistence_regions GooglePubsubTopic#allowed_persistence_regions}
    */
    readonly allowedPersistenceRegions: string[];
}
export declare function googlePubsubTopicMessageStoragePolicyToTerraform(struct?: GooglePubsubTopicMessageStoragePolicyOutputReference | GooglePubsubTopicMessageStoragePolicy): any;
export declare function googlePubsubTopicMessageStoragePolicyToHclTerraform(struct?: GooglePubsubTopicMessageStoragePolicyOutputReference | GooglePubsubTopicMessageStoragePolicy): any;
export declare class GooglePubsubTopicMessageStoragePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubTopicMessageStoragePolicy | undefined;
    set internalValue(value: GooglePubsubTopicMessageStoragePolicy | undefined);
    private _allowedPersistenceRegions?;
    get allowedPersistenceRegions(): string[];
    set allowedPersistenceRegions(value: string[]);
    get allowedPersistenceRegionsInput(): string[] | undefined;
}
export interface GooglePubsubTopicSchemaSettings {
    /**
    * The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#encoding GooglePubsubTopic#encoding}
    */
    readonly encoding?: string;
    /**
    * The name of the schema that messages published should be
    * validated against. Format is projects/{project}/schemas/{schema}.
    * The value of this field will be _deleted-schema_
    * if the schema has been deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#schema GooglePubsubTopic#schema}
    */
    readonly schema: string;
}
export declare function googlePubsubTopicSchemaSettingsToTerraform(struct?: GooglePubsubTopicSchemaSettingsOutputReference | GooglePubsubTopicSchemaSettings): any;
export declare function googlePubsubTopicSchemaSettingsToHclTerraform(struct?: GooglePubsubTopicSchemaSettingsOutputReference | GooglePubsubTopicSchemaSettings): any;
export declare class GooglePubsubTopicSchemaSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubTopicSchemaSettings | undefined;
    set internalValue(value: GooglePubsubTopicSchemaSettings | undefined);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
}
export interface GooglePubsubTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#create GooglePubsubTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#delete GooglePubsubTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#update GooglePubsubTopic#update}
    */
    readonly update?: string;
}
export declare function googlePubsubTopicTimeoutsToTerraform(struct?: GooglePubsubTopicTimeouts | cdktf.IResolvable): any;
export declare function googlePubsubTopicTimeoutsToHclTerraform(struct?: GooglePubsubTopicTimeouts | cdktf.IResolvable): any;
export declare class GooglePubsubTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePubsubTopicTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic google_pubsub_topic}
*/
export declare class GooglePubsubTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_topic";
    /**
    * Generates CDKTF code for importing a GooglePubsubTopic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GooglePubsubTopic to import
    * @param importFromId The id of the existing GooglePubsubTopic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GooglePubsubTopic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_pubsub_topic google_pubsub_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubTopicConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubTopicConfig);
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _messageRetentionDuration?;
    get messageRetentionDuration(): string;
    set messageRetentionDuration(value: string);
    resetMessageRetentionDuration(): void;
    get messageRetentionDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _messageStoragePolicy;
    get messageStoragePolicy(): GooglePubsubTopicMessageStoragePolicyOutputReference;
    putMessageStoragePolicy(value: GooglePubsubTopicMessageStoragePolicy): void;
    resetMessageStoragePolicy(): void;
    get messageStoragePolicyInput(): GooglePubsubTopicMessageStoragePolicy | undefined;
    private _schemaSettings;
    get schemaSettings(): GooglePubsubTopicSchemaSettingsOutputReference;
    putSchemaSettings(value: GooglePubsubTopicSchemaSettings): void;
    resetSchemaSettings(): void;
    get schemaSettingsInput(): GooglePubsubTopicSchemaSettings | undefined;
    private _timeouts;
    get timeouts(): GooglePubsubTopicTimeoutsOutputReference;
    putTimeouts(value: GooglePubsubTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePubsubTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
