/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleRedisClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. The authorization mode of the Redis cluster. If not provided, auth feature is disabled for the cluster. Default value: "AUTH_MODE_DISABLED" Possible values: ["AUTH_MODE_UNSPECIFIED", "AUTH_MODE_IAM_AUTH", "AUTH_MODE_DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#authorization_mode GoogleRedisCluster#authorization_mode}
    */
    readonly authorizationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#id GoogleRedisCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name of the resource in this scope including project and location using the form:
    * projects/{projectId}/locations/{locationId}/clusters/{clusterId}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#name GoogleRedisCluster#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#project GoogleRedisCluster#project}
    */
    readonly project?: string;
    /**
    * The name of the region of the Redis cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#region GoogleRedisCluster#region}
    */
    readonly region?: string;
    /**
    * Optional. The number of replica nodes per shard.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#replica_count GoogleRedisCluster#replica_count}
    */
    readonly replicaCount?: number;
    /**
    * Required. Number of shards for the Redis cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#shard_count GoogleRedisCluster#shard_count}
    */
    readonly shardCount: number;
    /**
    * Optional. The in-transit encryption for the Redis cluster.
    * If not provided, encryption is disabled for the cluster. Default value: "TRANSIT_ENCRYPTION_MODE_DISABLED" Possible values: ["TRANSIT_ENCRYPTION_MODE_UNSPECIFIED", "TRANSIT_ENCRYPTION_MODE_DISABLED", "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#transit_encryption_mode GoogleRedisCluster#transit_encryption_mode}
    */
    readonly transitEncryptionMode?: string;
    /**
    * psc_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#psc_configs GoogleRedisCluster#psc_configs}
    */
    readonly pscConfigs: GoogleRedisClusterPscConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#timeouts GoogleRedisCluster#timeouts}
    */
    readonly timeouts?: GoogleRedisClusterTimeouts;
}
export interface GoogleRedisClusterDiscoveryEndpointsPscConfig {
}
export declare function googleRedisClusterDiscoveryEndpointsPscConfigToTerraform(struct?: GoogleRedisClusterDiscoveryEndpointsPscConfig): any;
export declare function googleRedisClusterDiscoveryEndpointsPscConfigToHclTerraform(struct?: GoogleRedisClusterDiscoveryEndpointsPscConfig): any;
export declare class GoogleRedisClusterDiscoveryEndpointsPscConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisClusterDiscoveryEndpointsPscConfig | undefined;
    set internalValue(value: GoogleRedisClusterDiscoveryEndpointsPscConfig | undefined);
    get network(): string;
}
export declare class GoogleRedisClusterDiscoveryEndpointsPscConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisClusterDiscoveryEndpointsPscConfigOutputReference;
}
export interface GoogleRedisClusterDiscoveryEndpoints {
}
export declare function googleRedisClusterDiscoveryEndpointsToTerraform(struct?: GoogleRedisClusterDiscoveryEndpoints): any;
export declare function googleRedisClusterDiscoveryEndpointsToHclTerraform(struct?: GoogleRedisClusterDiscoveryEndpoints): any;
export declare class GoogleRedisClusterDiscoveryEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisClusterDiscoveryEndpoints | undefined;
    set internalValue(value: GoogleRedisClusterDiscoveryEndpoints | undefined);
    get address(): string;
    get port(): number;
    private _pscConfig;
    get pscConfig(): GoogleRedisClusterDiscoveryEndpointsPscConfigList;
}
export declare class GoogleRedisClusterDiscoveryEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisClusterDiscoveryEndpointsOutputReference;
}
export interface GoogleRedisClusterPscConnections {
}
export declare function googleRedisClusterPscConnectionsToTerraform(struct?: GoogleRedisClusterPscConnections): any;
export declare function googleRedisClusterPscConnectionsToHclTerraform(struct?: GoogleRedisClusterPscConnections): any;
export declare class GoogleRedisClusterPscConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisClusterPscConnections | undefined;
    set internalValue(value: GoogleRedisClusterPscConnections | undefined);
    get address(): string;
    get forwardingRule(): string;
    get network(): string;
    get projectId(): string;
    get pscConnectionId(): string;
}
export declare class GoogleRedisClusterPscConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisClusterPscConnectionsOutputReference;
}
export interface GoogleRedisClusterStateInfoUpdateInfo {
}
export declare function googleRedisClusterStateInfoUpdateInfoToTerraform(struct?: GoogleRedisClusterStateInfoUpdateInfo): any;
export declare function googleRedisClusterStateInfoUpdateInfoToHclTerraform(struct?: GoogleRedisClusterStateInfoUpdateInfo): any;
export declare class GoogleRedisClusterStateInfoUpdateInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisClusterStateInfoUpdateInfo | undefined;
    set internalValue(value: GoogleRedisClusterStateInfoUpdateInfo | undefined);
    get targetReplicaCount(): number;
    get targetShardCount(): number;
}
export declare class GoogleRedisClusterStateInfoUpdateInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisClusterStateInfoUpdateInfoOutputReference;
}
export interface GoogleRedisClusterStateInfo {
}
export declare function googleRedisClusterStateInfoToTerraform(struct?: GoogleRedisClusterStateInfo): any;
export declare function googleRedisClusterStateInfoToHclTerraform(struct?: GoogleRedisClusterStateInfo): any;
export declare class GoogleRedisClusterStateInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisClusterStateInfo | undefined;
    set internalValue(value: GoogleRedisClusterStateInfo | undefined);
    private _updateInfo;
    get updateInfo(): GoogleRedisClusterStateInfoUpdateInfoList;
}
export declare class GoogleRedisClusterStateInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisClusterStateInfoOutputReference;
}
export interface GoogleRedisClusterPscConfigs {
    /**
    * Required. The consumer network where the network address of
    * the discovery endpoint will be reserved, in the form of
    * projects/{network_project_id_or_number}/global/networks/{network_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#network GoogleRedisCluster#network}
    */
    readonly network: string;
}
export declare function googleRedisClusterPscConfigsToTerraform(struct?: GoogleRedisClusterPscConfigs | cdktf.IResolvable): any;
export declare function googleRedisClusterPscConfigsToHclTerraform(struct?: GoogleRedisClusterPscConfigs | cdktf.IResolvable): any;
export declare class GoogleRedisClusterPscConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisClusterPscConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleRedisClusterPscConfigs | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
}
export declare class GoogleRedisClusterPscConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleRedisClusterPscConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisClusterPscConfigsOutputReference;
}
export interface GoogleRedisClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#create GoogleRedisCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#delete GoogleRedisCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#update GoogleRedisCluster#update}
    */
    readonly update?: string;
}
export declare function googleRedisClusterTimeoutsToTerraform(struct?: GoogleRedisClusterTimeouts | cdktf.IResolvable): any;
export declare function googleRedisClusterTimeoutsToHclTerraform(struct?: GoogleRedisClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleRedisClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRedisClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleRedisClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster google_redis_cluster}
*/
export declare class GoogleRedisCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_redis_cluster";
    /**
    * Generates CDKTF code for importing a GoogleRedisCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleRedisCluster to import
    * @param importFromId The id of the existing GoogleRedisCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleRedisCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_cluster google_redis_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleRedisClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleRedisClusterConfig);
    private _authorizationMode?;
    get authorizationMode(): string;
    set authorizationMode(value: string);
    resetAuthorizationMode(): void;
    get authorizationModeInput(): string | undefined;
    get createTime(): string;
    private _discoveryEndpoints;
    get discoveryEndpoints(): GoogleRedisClusterDiscoveryEndpointsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pscConnections;
    get pscConnections(): GoogleRedisClusterPscConnectionsList;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaCount?;
    get replicaCount(): number;
    set replicaCount(value: number);
    resetReplicaCount(): void;
    get replicaCountInput(): number | undefined;
    private _shardCount?;
    get shardCount(): number;
    set shardCount(value: number);
    get shardCountInput(): number | undefined;
    get sizeGb(): number;
    get state(): string;
    private _stateInfo;
    get stateInfo(): GoogleRedisClusterStateInfoList;
    private _transitEncryptionMode?;
    get transitEncryptionMode(): string;
    set transitEncryptionMode(value: string);
    resetTransitEncryptionMode(): void;
    get transitEncryptionModeInput(): string | undefined;
    get uid(): string;
    private _pscConfigs;
    get pscConfigs(): GoogleRedisClusterPscConfigsList;
    putPscConfigs(value: GoogleRedisClusterPscConfigs[] | cdktf.IResolvable): void;
    get pscConfigsInput(): cdktf.IResolvable | GoogleRedisClusterPscConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleRedisClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleRedisClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleRedisClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
