/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleRedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Only applicable to STANDARD_HA tier which protects the instance
    * against zonal failures by provisioning it across two zones.
    * If provided, it must be a different zone from the one provided in
    * [locationId].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#alternative_location_id GoogleRedisInstance#alternative_location_id}
    */
    readonly alternativeLocationId?: string;
    /**
    * Optional. Indicates whether OSS Redis AUTH is enabled for the
    * instance. If set to "true" AUTH is enabled on the instance.
    * Default value is "false" meaning AUTH is disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#auth_enabled GoogleRedisInstance#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The full name of the Google Compute Engine network to which the
    * instance is connected. If left unspecified, the default network
    * will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#authorized_network GoogleRedisInstance#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * The connection mode of the Redis instance. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#connect_mode GoogleRedisInstance#connect_mode}
    */
    readonly connectMode?: string;
    /**
    * Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
    * instance. If this is provided, CMEK is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#customer_managed_key GoogleRedisInstance#customer_managed_key}
    */
    readonly customerManagedKey?: string;
    /**
    * An arbitrary and optional user-provided name for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#display_name GoogleRedisInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#id GoogleRedisInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#labels GoogleRedisInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The zone where the instance will be provisioned. If not provided,
    * the service will choose a zone for the instance. For STANDARD_HA tier,
    * instances will be created across two zones for protection against
    * zonal failures. If [alternativeLocationId] is also provided, it must
    * be different from [locationId].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#location_id GoogleRedisInstance#location_id}
    */
    readonly locationId?: string;
    /**
    * Redis memory size in GiB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#memory_size_gb GoogleRedisInstance#memory_size_gb}
    */
    readonly memorySizeGb: number;
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#name GoogleRedisInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#project GoogleRedisInstance#project}
    */
    readonly project?: string;
    /**
    * Optional. Read replica mode. Can only be specified when trying to create the instance.
    * If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
    * - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
    * instance cannot scale up or down the number of replicas.
    * - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
    * can scale up and down the number of replicas. Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#read_replicas_mode GoogleRedisInstance#read_replicas_mode}
    */
    readonly readReplicasMode?: string;
    /**
    * Redis configuration parameters, according to http://redis.io/topics/config.
    * Please check Memorystore documentation for the list of supported parameters:
    * https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#redis_configs GoogleRedisInstance#redis_configs}
    */
    readonly redisConfigs?: {
        [key: string]: string;
    };
    /**
    * The version of Redis software. If not provided, latest supported
    * version will be used. Please check the API documentation linked
    * at the top for the latest valid values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#redis_version GoogleRedisInstance#redis_version}
    */
    readonly redisVersion?: string;
    /**
    * The name of the Redis region of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#region GoogleRedisInstance#region}
    */
    readonly region?: string;
    /**
    * Optional. The number of replica nodes. The valid range for the Standard Tier with
    * read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
    * for a Standard Tier instance, the only valid value is 1 and the default is 1.
    * The valid value for basic tier is 0 and the default is also 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#replica_count GoogleRedisInstance#replica_count}
    */
    readonly replicaCount?: number;
    /**
    * The CIDR range of internal addresses that are reserved for this
    * instance. If not provided, the service will choose an unused /29
    * block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
    * unique and non-overlapping with existing subnets in an authorized
    * network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#reserved_ip_range GoogleRedisInstance#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
    /**
    * Optional. Additional IP range for node placement. Required when enabling read replicas on
    * an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
    * "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
    * range associated with the private service access connection, or "auto".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#secondary_ip_range GoogleRedisInstance#secondary_ip_range}
    */
    readonly secondaryIpRange?: string;
    /**
    * The service tier of the instance. Must be one of these values:
    *
    * - BASIC: standalone instance
    * - STANDARD_HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD_HA"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#tier GoogleRedisInstance#tier}
    */
    readonly tier?: string;
    /**
    * The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
    *
    * - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication Default value: "DISABLED" Possible values: ["SERVER_AUTHENTICATION", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#transit_encryption_mode GoogleRedisInstance#transit_encryption_mode}
    */
    readonly transitEncryptionMode?: string;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#maintenance_policy GoogleRedisInstance#maintenance_policy}
    */
    readonly maintenancePolicy?: GoogleRedisInstanceMaintenancePolicy;
    /**
    * persistence_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#persistence_config GoogleRedisInstance#persistence_config}
    */
    readonly persistenceConfig?: GoogleRedisInstancePersistenceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#timeouts GoogleRedisInstance#timeouts}
    */
    readonly timeouts?: GoogleRedisInstanceTimeouts;
}
export interface GoogleRedisInstanceMaintenanceSchedule {
}
export declare function googleRedisInstanceMaintenanceScheduleToTerraform(struct?: GoogleRedisInstanceMaintenanceSchedule): any;
export declare function googleRedisInstanceMaintenanceScheduleToHclTerraform(struct?: GoogleRedisInstanceMaintenanceSchedule): any;
export declare class GoogleRedisInstanceMaintenanceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisInstanceMaintenanceSchedule | undefined;
    set internalValue(value: GoogleRedisInstanceMaintenanceSchedule | undefined);
    get endTime(): string;
    get scheduleDeadlineTime(): string;
    get startTime(): string;
}
export declare class GoogleRedisInstanceMaintenanceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisInstanceMaintenanceScheduleOutputReference;
}
export interface GoogleRedisInstanceNodes {
}
export declare function googleRedisInstanceNodesToTerraform(struct?: GoogleRedisInstanceNodes): any;
export declare function googleRedisInstanceNodesToHclTerraform(struct?: GoogleRedisInstanceNodes): any;
export declare class GoogleRedisInstanceNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisInstanceNodes | undefined;
    set internalValue(value: GoogleRedisInstanceNodes | undefined);
    get id(): string;
    get zone(): string;
}
export declare class GoogleRedisInstanceNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisInstanceNodesOutputReference;
}
export interface GoogleRedisInstanceServerCaCerts {
}
export declare function googleRedisInstanceServerCaCertsToTerraform(struct?: GoogleRedisInstanceServerCaCerts): any;
export declare function googleRedisInstanceServerCaCertsToHclTerraform(struct?: GoogleRedisInstanceServerCaCerts): any;
export declare class GoogleRedisInstanceServerCaCertsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisInstanceServerCaCerts | undefined;
    set internalValue(value: GoogleRedisInstanceServerCaCerts | undefined);
    get cert(): string;
    get createTime(): string;
    get expireTime(): string;
    get serialNumber(): string;
    get sha1Fingerprint(): string;
}
export declare class GoogleRedisInstanceServerCaCertsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisInstanceServerCaCertsOutputReference;
}
export interface GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
    * An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#hours GoogleRedisInstance#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#minutes GoogleRedisInstance#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#nanos GoogleRedisInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
    * An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#seconds GoogleRedisInstance#seconds}
    */
    readonly seconds?: number;
}
export declare function googleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeToTerraform(struct?: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference | GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): any;
export declare function googleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeToHclTerraform(struct?: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference | GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): any;
export declare class GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined;
    set internalValue(value: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow {
    /**
    * Required. The day of week that maintenance updates occur.
    *
    * - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
    * - MONDAY: Monday
    * - TUESDAY: Tuesday
    * - WEDNESDAY: Wednesday
    * - THURSDAY: Thursday
    * - FRIDAY: Friday
    * - SATURDAY: Saturday
    * - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#day GoogleRedisInstance#day}
    */
    readonly day: string;
    /**
    * start_time block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#start_time GoogleRedisInstance#start_time}
    */
    readonly startTime: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime;
}
export declare function googleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowToTerraform(struct?: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable): any;
export declare function googleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowToHclTerraform(struct?: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable): any;
export declare class GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    get duration(): string;
    private _startTime;
    get startTime(): GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference;
    putStartTime(value: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): void;
    get startTimeInput(): GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined;
}
export declare class GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowOutputReference;
}
export interface GoogleRedisInstanceMaintenancePolicy {
    /**
    * Optional. Description of what this policy is for.
    * Create/Update methods return INVALID_ARGUMENT if the
    * length is greater than 512.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#description GoogleRedisInstance#description}
    */
    readonly description?: string;
    /**
    * weekly_maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#weekly_maintenance_window GoogleRedisInstance#weekly_maintenance_window}
    */
    readonly weeklyMaintenanceWindow?: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable;
}
export declare function googleRedisInstanceMaintenancePolicyToTerraform(struct?: GoogleRedisInstanceMaintenancePolicyOutputReference | GoogleRedisInstanceMaintenancePolicy): any;
export declare function googleRedisInstanceMaintenancePolicyToHclTerraform(struct?: GoogleRedisInstanceMaintenancePolicyOutputReference | GoogleRedisInstanceMaintenancePolicy): any;
export declare class GoogleRedisInstanceMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRedisInstanceMaintenancePolicy | undefined;
    set internalValue(value: GoogleRedisInstanceMaintenancePolicy | undefined);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get updateTime(): string;
    private _weeklyMaintenanceWindow;
    get weeklyMaintenanceWindow(): GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindowList;
    putWeeklyMaintenanceWindow(value: GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable): void;
    resetWeeklyMaintenanceWindow(): void;
    get weeklyMaintenanceWindowInput(): cdktf.IResolvable | GoogleRedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | undefined;
}
export interface GoogleRedisInstancePersistenceConfig {
    /**
    * Optional. Controls whether Persistence features are enabled. If not provided, the existing value will be used.
    *
    * - DISABLED: 	Persistence is disabled for the instance, and any existing snapshots are deleted.
    * - RDB: RDB based Persistence is enabled. Possible values: ["DISABLED", "RDB"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#persistence_mode GoogleRedisInstance#persistence_mode}
    */
    readonly persistenceMode?: string;
    /**
    * Optional. Available snapshot periods for scheduling.
    *
    * - ONE_HOUR:	Snapshot every 1 hour.
    * - SIX_HOURS:	Snapshot every 6 hours.
    * - TWELVE_HOURS:	Snapshot every 12 hours.
    * - TWENTY_FOUR_HOURS:	Snapshot every 24 hours. Possible values: ["ONE_HOUR", "SIX_HOURS", "TWELVE_HOURS", "TWENTY_FOUR_HOURS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#rdb_snapshot_period GoogleRedisInstance#rdb_snapshot_period}
    */
    readonly rdbSnapshotPeriod?: string;
    /**
    * Optional. Date and time that the first snapshot was/will be attempted,
    * and to which future snapshots will be aligned. If not provided,
    * the current time will be used.
    * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution
    * and up to nine fractional digits.
    * Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#rdb_snapshot_start_time GoogleRedisInstance#rdb_snapshot_start_time}
    */
    readonly rdbSnapshotStartTime?: string;
}
export declare function googleRedisInstancePersistenceConfigToTerraform(struct?: GoogleRedisInstancePersistenceConfigOutputReference | GoogleRedisInstancePersistenceConfig): any;
export declare function googleRedisInstancePersistenceConfigToHclTerraform(struct?: GoogleRedisInstancePersistenceConfigOutputReference | GoogleRedisInstancePersistenceConfig): any;
export declare class GoogleRedisInstancePersistenceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRedisInstancePersistenceConfig | undefined;
    set internalValue(value: GoogleRedisInstancePersistenceConfig | undefined);
    private _persistenceMode?;
    get persistenceMode(): string;
    set persistenceMode(value: string);
    resetPersistenceMode(): void;
    get persistenceModeInput(): string | undefined;
    get rdbNextSnapshotTime(): string;
    private _rdbSnapshotPeriod?;
    get rdbSnapshotPeriod(): string;
    set rdbSnapshotPeriod(value: string);
    resetRdbSnapshotPeriod(): void;
    get rdbSnapshotPeriodInput(): string | undefined;
    private _rdbSnapshotStartTime?;
    get rdbSnapshotStartTime(): string;
    set rdbSnapshotStartTime(value: string);
    resetRdbSnapshotStartTime(): void;
    get rdbSnapshotStartTimeInput(): string | undefined;
}
export interface GoogleRedisInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#create GoogleRedisInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#delete GoogleRedisInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#update GoogleRedisInstance#update}
    */
    readonly update?: string;
}
export declare function googleRedisInstanceTimeoutsToTerraform(struct?: GoogleRedisInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleRedisInstanceTimeoutsToHclTerraform(struct?: GoogleRedisInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleRedisInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRedisInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleRedisInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance google_redis_instance}
*/
export declare class GoogleRedisInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_redis_instance";
    /**
    * Generates CDKTF code for importing a GoogleRedisInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleRedisInstance to import
    * @param importFromId The id of the existing GoogleRedisInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleRedisInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_redis_instance google_redis_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleRedisInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleRedisInstanceConfig);
    private _alternativeLocationId?;
    get alternativeLocationId(): string;
    set alternativeLocationId(value: string);
    resetAlternativeLocationId(): void;
    get alternativeLocationIdInput(): string | undefined;
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get authString(): string;
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    private _connectMode?;
    get connectMode(): string;
    set connectMode(value: string);
    resetConnectMode(): void;
    get connectModeInput(): string | undefined;
    get createTime(): string;
    get currentLocationId(): string;
    private _customerManagedKey?;
    get customerManagedKey(): string;
    set customerManagedKey(value: string);
    resetCustomerManagedKey(): void;
    get customerManagedKeyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    resetLocationId(): void;
    get locationIdInput(): string | undefined;
    private _maintenanceSchedule;
    get maintenanceSchedule(): GoogleRedisInstanceMaintenanceScheduleList;
    private _memorySizeGb?;
    get memorySizeGb(): number;
    set memorySizeGb(value: number);
    get memorySizeGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodes;
    get nodes(): GoogleRedisInstanceNodesList;
    get persistenceIamIdentity(): string;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get readEndpoint(): string;
    get readEndpointPort(): number;
    private _readReplicasMode?;
    get readReplicasMode(): string;
    set readReplicasMode(value: string);
    resetReadReplicasMode(): void;
    get readReplicasModeInput(): string | undefined;
    private _redisConfigs?;
    get redisConfigs(): {
        [key: string]: string;
    };
    set redisConfigs(value: {
        [key: string]: string;
    });
    resetRedisConfigs(): void;
    get redisConfigsInput(): {
        [key: string]: string;
    } | undefined;
    private _redisVersion?;
    get redisVersion(): string;
    set redisVersion(value: string);
    resetRedisVersion(): void;
    get redisVersionInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaCount?;
    get replicaCount(): number;
    set replicaCount(value: number);
    resetReplicaCount(): void;
    get replicaCountInput(): number | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    resetReservedIpRange(): void;
    get reservedIpRangeInput(): string | undefined;
    private _secondaryIpRange?;
    get secondaryIpRange(): string;
    set secondaryIpRange(value: string);
    resetSecondaryIpRange(): void;
    get secondaryIpRangeInput(): string | undefined;
    private _serverCaCerts;
    get serverCaCerts(): GoogleRedisInstanceServerCaCertsList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _transitEncryptionMode?;
    get transitEncryptionMode(): string;
    set transitEncryptionMode(value: string);
    resetTransitEncryptionMode(): void;
    get transitEncryptionModeInput(): string | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): GoogleRedisInstanceMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: GoogleRedisInstanceMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): GoogleRedisInstanceMaintenancePolicy | undefined;
    private _persistenceConfig;
    get persistenceConfig(): GoogleRedisInstancePersistenceConfigOutputReference;
    putPersistenceConfig(value: GoogleRedisInstancePersistenceConfig): void;
    resetPersistenceConfig(): void;
    get persistenceConfigInput(): GoogleRedisInstancePersistenceConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleRedisInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleRedisInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleRedisInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
