/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSccFolderCustomModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the Security Health Analytics custom module. This
    * display name becomes the finding category for all findings that are
    * returned by this custom module. The display name must be between 1 and
    * 128 characters, start with a lowercase letter, and contain alphanumeric
    * characters or underscores only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#display_name GoogleSccFolderCustomModule#display_name}
    */
    readonly displayName: string;
    /**
    * The enablement state of the custom module. Possible values: ["ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#enablement_state GoogleSccFolderCustomModule#enablement_state}
    */
    readonly enablementState: string;
    /**
    * Numerical ID of the parent folder.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#folder GoogleSccFolderCustomModule#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#id GoogleSccFolderCustomModule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * custom_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#custom_config GoogleSccFolderCustomModule#custom_config}
    */
    readonly customConfig: GoogleSccFolderCustomModuleCustomConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#timeouts GoogleSccFolderCustomModule#timeouts}
    */
    readonly timeouts?: GoogleSccFolderCustomModuleTimeouts;
}
export interface GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression {
    /**
    * Description of the expression. This is a longer text which describes the
    * expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#description GoogleSccFolderCustomModule#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#expression GoogleSccFolderCustomModule#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a
    * file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#location GoogleSccFolderCustomModule#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can
    * be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#title GoogleSccFolderCustomModule#title}
    */
    readonly title?: string;
}
export declare function googleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpressionToTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression): any;
export declare function googleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpressionToHclTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression): any;
export declare class GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties {
    /**
    * Name of the property for the custom output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#name GoogleSccFolderCustomModule#name}
    */
    readonly name?: string;
    /**
    * value_expression block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#value_expression GoogleSccFolderCustomModule#value_expression}
    */
    readonly valueExpression?: GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression;
}
export declare function googleSccFolderCustomModuleCustomConfigCustomOutputPropertiesToTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare function googleSccFolderCustomModuleCustomConfigCustomOutputPropertiesToHclTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare class GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _valueExpression;
    get valueExpression(): GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference;
    putValueExpression(value: GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression): void;
    resetValueExpression(): void;
    get valueExpressionInput(): GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined;
}
export declare class GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesOutputReference;
}
export interface GoogleSccFolderCustomModuleCustomConfigCustomOutput {
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#properties GoogleSccFolderCustomModule#properties}
    */
    readonly properties?: GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable;
}
export declare function googleSccFolderCustomModuleCustomConfigCustomOutputToTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigCustomOutputOutputReference | GoogleSccFolderCustomModuleCustomConfigCustomOutput): any;
export declare function googleSccFolderCustomModuleCustomConfigCustomOutputToHclTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigCustomOutputOutputReference | GoogleSccFolderCustomModuleCustomConfigCustomOutput): any;
export declare class GoogleSccFolderCustomModuleCustomConfigCustomOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccFolderCustomModuleCustomConfigCustomOutput | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleCustomConfigCustomOutput | undefined);
    private _properties;
    get properties(): GoogleSccFolderCustomModuleCustomConfigCustomOutputPropertiesList;
    putProperties(value: GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | GoogleSccFolderCustomModuleCustomConfigCustomOutputProperties[] | undefined;
}
export interface GoogleSccFolderCustomModuleCustomConfigPredicate {
    /**
    * Description of the expression. This is a longer text which describes the
    * expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#description GoogleSccFolderCustomModule#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#expression GoogleSccFolderCustomModule#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a
    * file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#location GoogleSccFolderCustomModule#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can
    * be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#title GoogleSccFolderCustomModule#title}
    */
    readonly title?: string;
}
export declare function googleSccFolderCustomModuleCustomConfigPredicateToTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigPredicateOutputReference | GoogleSccFolderCustomModuleCustomConfigPredicate): any;
export declare function googleSccFolderCustomModuleCustomConfigPredicateToHclTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigPredicateOutputReference | GoogleSccFolderCustomModuleCustomConfigPredicate): any;
export declare class GoogleSccFolderCustomModuleCustomConfigPredicateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccFolderCustomModuleCustomConfigPredicate | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleCustomConfigPredicate | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSccFolderCustomModuleCustomConfigResourceSelector {
    /**
    * The resource types to run the detector on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#resource_types GoogleSccFolderCustomModule#resource_types}
    */
    readonly resourceTypes: string[];
}
export declare function googleSccFolderCustomModuleCustomConfigResourceSelectorToTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigResourceSelectorOutputReference | GoogleSccFolderCustomModuleCustomConfigResourceSelector): any;
export declare function googleSccFolderCustomModuleCustomConfigResourceSelectorToHclTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigResourceSelectorOutputReference | GoogleSccFolderCustomModuleCustomConfigResourceSelector): any;
export declare class GoogleSccFolderCustomModuleCustomConfigResourceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccFolderCustomModuleCustomConfigResourceSelector | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleCustomConfigResourceSelector | undefined);
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    get resourceTypesInput(): string[] | undefined;
}
export interface GoogleSccFolderCustomModuleCustomConfig {
    /**
    * Text that describes the vulnerability or misconfiguration that the custom
    * module detects. This explanation is returned with each finding instance to
    * help investigators understand the detected issue. The text must be enclosed in quotation marks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#description GoogleSccFolderCustomModule#description}
    */
    readonly description?: string;
    /**
    * An explanation of the recommended steps that security teams can take to resolve
    * the detected issue. This explanation is returned with each finding generated by
    * this module in the nextSteps property of the finding JSON.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#recommendation GoogleSccFolderCustomModule#recommendation}
    */
    readonly recommendation: string;
    /**
    * The severity to assign to findings generated by the module. Possible values: ["CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#severity GoogleSccFolderCustomModule#severity}
    */
    readonly severity: string;
    /**
    * custom_output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#custom_output GoogleSccFolderCustomModule#custom_output}
    */
    readonly customOutput?: GoogleSccFolderCustomModuleCustomConfigCustomOutput;
    /**
    * predicate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#predicate GoogleSccFolderCustomModule#predicate}
    */
    readonly predicate: GoogleSccFolderCustomModuleCustomConfigPredicate;
    /**
    * resource_selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#resource_selector GoogleSccFolderCustomModule#resource_selector}
    */
    readonly resourceSelector: GoogleSccFolderCustomModuleCustomConfigResourceSelector;
}
export declare function googleSccFolderCustomModuleCustomConfigToTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigOutputReference | GoogleSccFolderCustomModuleCustomConfig): any;
export declare function googleSccFolderCustomModuleCustomConfigToHclTerraform(struct?: GoogleSccFolderCustomModuleCustomConfigOutputReference | GoogleSccFolderCustomModuleCustomConfig): any;
export declare class GoogleSccFolderCustomModuleCustomConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccFolderCustomModuleCustomConfig | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleCustomConfig | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _recommendation?;
    get recommendation(): string;
    set recommendation(value: string);
    get recommendationInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _customOutput;
    get customOutput(): GoogleSccFolderCustomModuleCustomConfigCustomOutputOutputReference;
    putCustomOutput(value: GoogleSccFolderCustomModuleCustomConfigCustomOutput): void;
    resetCustomOutput(): void;
    get customOutputInput(): GoogleSccFolderCustomModuleCustomConfigCustomOutput | undefined;
    private _predicate;
    get predicate(): GoogleSccFolderCustomModuleCustomConfigPredicateOutputReference;
    putPredicate(value: GoogleSccFolderCustomModuleCustomConfigPredicate): void;
    get predicateInput(): GoogleSccFolderCustomModuleCustomConfigPredicate | undefined;
    private _resourceSelector;
    get resourceSelector(): GoogleSccFolderCustomModuleCustomConfigResourceSelectorOutputReference;
    putResourceSelector(value: GoogleSccFolderCustomModuleCustomConfigResourceSelector): void;
    get resourceSelectorInput(): GoogleSccFolderCustomModuleCustomConfigResourceSelector | undefined;
}
export interface GoogleSccFolderCustomModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#create GoogleSccFolderCustomModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#delete GoogleSccFolderCustomModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#update GoogleSccFolderCustomModule#update}
    */
    readonly update?: string;
}
export declare function googleSccFolderCustomModuleTimeoutsToTerraform(struct?: GoogleSccFolderCustomModuleTimeouts | cdktf.IResolvable): any;
export declare function googleSccFolderCustomModuleTimeoutsToHclTerraform(struct?: GoogleSccFolderCustomModuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleSccFolderCustomModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccFolderCustomModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccFolderCustomModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module google_scc_folder_custom_module}
*/
export declare class GoogleSccFolderCustomModule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_folder_custom_module";
    /**
    * Generates CDKTF code for importing a GoogleSccFolderCustomModule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSccFolderCustomModule to import
    * @param importFromId The id of the existing GoogleSccFolderCustomModule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSccFolderCustomModule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_folder_custom_module google_scc_folder_custom_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSccFolderCustomModuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSccFolderCustomModuleConfig);
    get ancestorModule(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enablementState?;
    get enablementState(): string;
    set enablementState(value: string);
    get enablementStateInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastEditor(): string;
    get name(): string;
    get updateTime(): string;
    private _customConfig;
    get customConfig(): GoogleSccFolderCustomModuleCustomConfigOutputReference;
    putCustomConfig(value: GoogleSccFolderCustomModuleCustomConfig): void;
    get customConfigInput(): GoogleSccFolderCustomModuleCustomConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSccFolderCustomModuleTimeoutsOutputReference;
    putTimeouts(value: GoogleSccFolderCustomModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSccFolderCustomModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
