/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSccMuteConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the mute config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#description GoogleSccMuteConfig#description}
    */
    readonly description?: string;
    /**
    * An expression that defines the filter to apply across create/update
    * events of findings. While creating a filter string, be mindful of
    * the scope in which the mute configuration is being created. E.g.,
    * If a filter contains project = X but is created under the
    * project = Y scope, it might not match any findings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#filter GoogleSccMuteConfig#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#id GoogleSccMuteConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique identifier provided by the client within the parent scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#mute_config_id GoogleSccMuteConfig#mute_config_id}
    */
    readonly muteConfigId: string;
    /**
    * Resource name of the new mute configs's parent. Its format is
    * "organizations/[organization_id]", "folders/[folder_id]", or
    * "projects/[project_id]".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#parent GoogleSccMuteConfig#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#timeouts GoogleSccMuteConfig#timeouts}
    */
    readonly timeouts?: GoogleSccMuteConfigTimeouts;
}
export interface GoogleSccMuteConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#create GoogleSccMuteConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#delete GoogleSccMuteConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#update GoogleSccMuteConfig#update}
    */
    readonly update?: string;
}
export declare function googleSccMuteConfigTimeoutsToTerraform(struct?: GoogleSccMuteConfigTimeouts | cdktf.IResolvable): any;
export declare function googleSccMuteConfigTimeoutsToHclTerraform(struct?: GoogleSccMuteConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleSccMuteConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccMuteConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccMuteConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config google_scc_mute_config}
*/
export declare class GoogleSccMuteConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_mute_config";
    /**
    * Generates CDKTF code for importing a GoogleSccMuteConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSccMuteConfig to import
    * @param importFromId The id of the existing GoogleSccMuteConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSccMuteConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_mute_config google_scc_mute_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSccMuteConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSccMuteConfigConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mostRecentEditor(): string;
    private _muteConfigId?;
    get muteConfigId(): string;
    set muteConfigId(value: string);
    get muteConfigIdInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleSccMuteConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleSccMuteConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSccMuteConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
