/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSccOrganizationCustomModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the Security Health Analytics custom module. This
    * display name becomes the finding category for all findings that are
    * returned by this custom module. The display name must be between 1 and
    * 128 characters, start with a lowercase letter, and contain alphanumeric
    * characters or underscores only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#display_name GoogleSccOrganizationCustomModule#display_name}
    */
    readonly displayName: string;
    /**
    * The enablement state of the custom module. Possible values: ["ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#enablement_state GoogleSccOrganizationCustomModule#enablement_state}
    */
    readonly enablementState: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#id GoogleSccOrganizationCustomModule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Numerical ID of the parent organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#organization GoogleSccOrganizationCustomModule#organization}
    */
    readonly organization: string;
    /**
    * custom_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#custom_config GoogleSccOrganizationCustomModule#custom_config}
    */
    readonly customConfig: GoogleSccOrganizationCustomModuleCustomConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#timeouts GoogleSccOrganizationCustomModule#timeouts}
    */
    readonly timeouts?: GoogleSccOrganizationCustomModuleTimeouts;
}
export interface GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression {
    /**
    * Description of the expression. This is a longer text which describes the
    * expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#description GoogleSccOrganizationCustomModule#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#expression GoogleSccOrganizationCustomModule#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a
    * file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#location GoogleSccOrganizationCustomModule#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can
    * be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#title GoogleSccOrganizationCustomModule#title}
    */
    readonly title?: string;
}
export declare function googleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpressionToTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression): any;
export declare function googleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpressionToHclTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression): any;
export declare class GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties {
    /**
    * Name of the property for the custom output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#name GoogleSccOrganizationCustomModule#name}
    */
    readonly name?: string;
    /**
    * value_expression block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#value_expression GoogleSccOrganizationCustomModule#value_expression}
    */
    readonly valueExpression?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression;
}
export declare function googleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesToTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare function googleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesToHclTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare class GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _valueExpression;
    get valueExpression(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference;
    putValueExpression(value: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression): void;
    resetValueExpression(): void;
    get valueExpressionInput(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined;
}
export declare class GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesOutputReference;
}
export interface GoogleSccOrganizationCustomModuleCustomConfigCustomOutput {
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#properties GoogleSccOrganizationCustomModule#properties}
    */
    readonly properties?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable;
}
export declare function googleSccOrganizationCustomModuleCustomConfigCustomOutputToTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputOutputReference | GoogleSccOrganizationCustomModuleCustomConfigCustomOutput): any;
export declare function googleSccOrganizationCustomModuleCustomConfigCustomOutputToHclTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputOutputReference | GoogleSccOrganizationCustomModuleCustomConfigCustomOutput): any;
export declare class GoogleSccOrganizationCustomModuleCustomConfigCustomOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutput | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleCustomConfigCustomOutput | undefined);
    private _properties;
    get properties(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputPropertiesList;
    putProperties(value: GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | GoogleSccOrganizationCustomModuleCustomConfigCustomOutputProperties[] | undefined;
}
export interface GoogleSccOrganizationCustomModuleCustomConfigPredicate {
    /**
    * Description of the expression. This is a longer text which describes the
    * expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#description GoogleSccOrganizationCustomModule#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#expression GoogleSccOrganizationCustomModule#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a
    * file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#location GoogleSccOrganizationCustomModule#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can
    * be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#title GoogleSccOrganizationCustomModule#title}
    */
    readonly title?: string;
}
export declare function googleSccOrganizationCustomModuleCustomConfigPredicateToTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigPredicateOutputReference | GoogleSccOrganizationCustomModuleCustomConfigPredicate): any;
export declare function googleSccOrganizationCustomModuleCustomConfigPredicateToHclTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigPredicateOutputReference | GoogleSccOrganizationCustomModuleCustomConfigPredicate): any;
export declare class GoogleSccOrganizationCustomModuleCustomConfigPredicateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccOrganizationCustomModuleCustomConfigPredicate | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleCustomConfigPredicate | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSccOrganizationCustomModuleCustomConfigResourceSelector {
    /**
    * The resource types to run the detector on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#resource_types GoogleSccOrganizationCustomModule#resource_types}
    */
    readonly resourceTypes: string[];
}
export declare function googleSccOrganizationCustomModuleCustomConfigResourceSelectorToTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigResourceSelectorOutputReference | GoogleSccOrganizationCustomModuleCustomConfigResourceSelector): any;
export declare function googleSccOrganizationCustomModuleCustomConfigResourceSelectorToHclTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigResourceSelectorOutputReference | GoogleSccOrganizationCustomModuleCustomConfigResourceSelector): any;
export declare class GoogleSccOrganizationCustomModuleCustomConfigResourceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccOrganizationCustomModuleCustomConfigResourceSelector | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleCustomConfigResourceSelector | undefined);
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    get resourceTypesInput(): string[] | undefined;
}
export interface GoogleSccOrganizationCustomModuleCustomConfig {
    /**
    * Text that describes the vulnerability or misconfiguration that the custom
    * module detects. This explanation is returned with each finding instance to
    * help investigators understand the detected issue. The text must be enclosed in quotation marks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#description GoogleSccOrganizationCustomModule#description}
    */
    readonly description?: string;
    /**
    * An explanation of the recommended steps that security teams can take to resolve
    * the detected issue. This explanation is returned with each finding generated by
    * this module in the nextSteps property of the finding JSON.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#recommendation GoogleSccOrganizationCustomModule#recommendation}
    */
    readonly recommendation: string;
    /**
    * The severity to assign to findings generated by the module. Possible values: ["CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#severity GoogleSccOrganizationCustomModule#severity}
    */
    readonly severity: string;
    /**
    * custom_output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#custom_output GoogleSccOrganizationCustomModule#custom_output}
    */
    readonly customOutput?: GoogleSccOrganizationCustomModuleCustomConfigCustomOutput;
    /**
    * predicate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#predicate GoogleSccOrganizationCustomModule#predicate}
    */
    readonly predicate: GoogleSccOrganizationCustomModuleCustomConfigPredicate;
    /**
    * resource_selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#resource_selector GoogleSccOrganizationCustomModule#resource_selector}
    */
    readonly resourceSelector: GoogleSccOrganizationCustomModuleCustomConfigResourceSelector;
}
export declare function googleSccOrganizationCustomModuleCustomConfigToTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigOutputReference | GoogleSccOrganizationCustomModuleCustomConfig): any;
export declare function googleSccOrganizationCustomModuleCustomConfigToHclTerraform(struct?: GoogleSccOrganizationCustomModuleCustomConfigOutputReference | GoogleSccOrganizationCustomModuleCustomConfig): any;
export declare class GoogleSccOrganizationCustomModuleCustomConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccOrganizationCustomModuleCustomConfig | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleCustomConfig | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _recommendation?;
    get recommendation(): string;
    set recommendation(value: string);
    get recommendationInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _customOutput;
    get customOutput(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutputOutputReference;
    putCustomOutput(value: GoogleSccOrganizationCustomModuleCustomConfigCustomOutput): void;
    resetCustomOutput(): void;
    get customOutputInput(): GoogleSccOrganizationCustomModuleCustomConfigCustomOutput | undefined;
    private _predicate;
    get predicate(): GoogleSccOrganizationCustomModuleCustomConfigPredicateOutputReference;
    putPredicate(value: GoogleSccOrganizationCustomModuleCustomConfigPredicate): void;
    get predicateInput(): GoogleSccOrganizationCustomModuleCustomConfigPredicate | undefined;
    private _resourceSelector;
    get resourceSelector(): GoogleSccOrganizationCustomModuleCustomConfigResourceSelectorOutputReference;
    putResourceSelector(value: GoogleSccOrganizationCustomModuleCustomConfigResourceSelector): void;
    get resourceSelectorInput(): GoogleSccOrganizationCustomModuleCustomConfigResourceSelector | undefined;
}
export interface GoogleSccOrganizationCustomModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#create GoogleSccOrganizationCustomModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#delete GoogleSccOrganizationCustomModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#update GoogleSccOrganizationCustomModule#update}
    */
    readonly update?: string;
}
export declare function googleSccOrganizationCustomModuleTimeoutsToTerraform(struct?: GoogleSccOrganizationCustomModuleTimeouts | cdktf.IResolvable): any;
export declare function googleSccOrganizationCustomModuleTimeoutsToHclTerraform(struct?: GoogleSccOrganizationCustomModuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleSccOrganizationCustomModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccOrganizationCustomModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccOrganizationCustomModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module google_scc_organization_custom_module}
*/
export declare class GoogleSccOrganizationCustomModule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_organization_custom_module";
    /**
    * Generates CDKTF code for importing a GoogleSccOrganizationCustomModule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSccOrganizationCustomModule to import
    * @param importFromId The id of the existing GoogleSccOrganizationCustomModule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSccOrganizationCustomModule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_organization_custom_module google_scc_organization_custom_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSccOrganizationCustomModuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSccOrganizationCustomModuleConfig);
    get ancestorModule(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enablementState?;
    get enablementState(): string;
    set enablementState(value: string);
    get enablementStateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastEditor(): string;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    get updateTime(): string;
    private _customConfig;
    get customConfig(): GoogleSccOrganizationCustomModuleCustomConfigOutputReference;
    putCustomConfig(value: GoogleSccOrganizationCustomModuleCustomConfig): void;
    get customConfigInput(): GoogleSccOrganizationCustomModuleCustomConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSccOrganizationCustomModuleTimeoutsOutputReference;
    putTimeouts(value: GoogleSccOrganizationCustomModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSccOrganizationCustomModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
