/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSccProjectCustomModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the Security Health Analytics custom module. This
    * display name becomes the finding category for all findings that are
    * returned by this custom module. The display name must be between 1 and
    * 128 characters, start with a lowercase letter, and contain alphanumeric
    * characters or underscores only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#display_name GoogleSccProjectCustomModule#display_name}
    */
    readonly displayName: string;
    /**
    * The enablement state of the custom module. Possible values: ["ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#enablement_state GoogleSccProjectCustomModule#enablement_state}
    */
    readonly enablementState: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#id GoogleSccProjectCustomModule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#project GoogleSccProjectCustomModule#project}
    */
    readonly project?: string;
    /**
    * custom_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#custom_config GoogleSccProjectCustomModule#custom_config}
    */
    readonly customConfig: GoogleSccProjectCustomModuleCustomConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#timeouts GoogleSccProjectCustomModule#timeouts}
    */
    readonly timeouts?: GoogleSccProjectCustomModuleTimeouts;
}
export interface GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression {
    /**
    * Description of the expression. This is a longer text which describes the
    * expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#description GoogleSccProjectCustomModule#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#expression GoogleSccProjectCustomModule#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a
    * file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#location GoogleSccProjectCustomModule#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can
    * be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#title GoogleSccProjectCustomModule#title}
    */
    readonly title?: string;
}
export declare function googleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpressionToTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression): any;
export declare function googleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpressionToHclTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference | GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression): any;
export declare class GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties {
    /**
    * Name of the property for the custom output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#name GoogleSccProjectCustomModule#name}
    */
    readonly name?: string;
    /**
    * value_expression block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#value_expression GoogleSccProjectCustomModule#value_expression}
    */
    readonly valueExpression?: GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression;
}
export declare function googleSccProjectCustomModuleCustomConfigCustomOutputPropertiesToTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare function googleSccProjectCustomModuleCustomConfigCustomOutputPropertiesToHclTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable): any;
export declare class GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _valueExpression;
    get valueExpression(): GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpressionOutputReference;
    putValueExpression(value: GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression): void;
    resetValueExpression(): void;
    get valueExpressionInput(): GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesValueExpression | undefined;
}
export declare class GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesOutputReference;
}
export interface GoogleSccProjectCustomModuleCustomConfigCustomOutput {
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#properties GoogleSccProjectCustomModule#properties}
    */
    readonly properties?: GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable;
}
export declare function googleSccProjectCustomModuleCustomConfigCustomOutputToTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigCustomOutputOutputReference | GoogleSccProjectCustomModuleCustomConfigCustomOutput): any;
export declare function googleSccProjectCustomModuleCustomConfigCustomOutputToHclTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigCustomOutputOutputReference | GoogleSccProjectCustomModuleCustomConfigCustomOutput): any;
export declare class GoogleSccProjectCustomModuleCustomConfigCustomOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccProjectCustomModuleCustomConfigCustomOutput | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleCustomConfigCustomOutput | undefined);
    private _properties;
    get properties(): GoogleSccProjectCustomModuleCustomConfigCustomOutputPropertiesList;
    putProperties(value: GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | GoogleSccProjectCustomModuleCustomConfigCustomOutputProperties[] | undefined;
}
export interface GoogleSccProjectCustomModuleCustomConfigPredicate {
    /**
    * Description of the expression. This is a longer text which describes the
    * expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#description GoogleSccProjectCustomModule#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#expression GoogleSccProjectCustomModule#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a
    * file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#location GoogleSccProjectCustomModule#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can
    * be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#title GoogleSccProjectCustomModule#title}
    */
    readonly title?: string;
}
export declare function googleSccProjectCustomModuleCustomConfigPredicateToTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigPredicateOutputReference | GoogleSccProjectCustomModuleCustomConfigPredicate): any;
export declare function googleSccProjectCustomModuleCustomConfigPredicateToHclTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigPredicateOutputReference | GoogleSccProjectCustomModuleCustomConfigPredicate): any;
export declare class GoogleSccProjectCustomModuleCustomConfigPredicateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccProjectCustomModuleCustomConfigPredicate | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleCustomConfigPredicate | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleSccProjectCustomModuleCustomConfigResourceSelector {
    /**
    * The resource types to run the detector on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#resource_types GoogleSccProjectCustomModule#resource_types}
    */
    readonly resourceTypes: string[];
}
export declare function googleSccProjectCustomModuleCustomConfigResourceSelectorToTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigResourceSelectorOutputReference | GoogleSccProjectCustomModuleCustomConfigResourceSelector): any;
export declare function googleSccProjectCustomModuleCustomConfigResourceSelectorToHclTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigResourceSelectorOutputReference | GoogleSccProjectCustomModuleCustomConfigResourceSelector): any;
export declare class GoogleSccProjectCustomModuleCustomConfigResourceSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccProjectCustomModuleCustomConfigResourceSelector | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleCustomConfigResourceSelector | undefined);
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    get resourceTypesInput(): string[] | undefined;
}
export interface GoogleSccProjectCustomModuleCustomConfig {
    /**
    * Text that describes the vulnerability or misconfiguration that the custom
    * module detects. This explanation is returned with each finding instance to
    * help investigators understand the detected issue. The text must be enclosed in quotation marks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#description GoogleSccProjectCustomModule#description}
    */
    readonly description?: string;
    /**
    * An explanation of the recommended steps that security teams can take to resolve
    * the detected issue. This explanation is returned with each finding generated by
    * this module in the nextSteps property of the finding JSON.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#recommendation GoogleSccProjectCustomModule#recommendation}
    */
    readonly recommendation: string;
    /**
    * The severity to assign to findings generated by the module. Possible values: ["CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#severity GoogleSccProjectCustomModule#severity}
    */
    readonly severity: string;
    /**
    * custom_output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#custom_output GoogleSccProjectCustomModule#custom_output}
    */
    readonly customOutput?: GoogleSccProjectCustomModuleCustomConfigCustomOutput;
    /**
    * predicate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#predicate GoogleSccProjectCustomModule#predicate}
    */
    readonly predicate: GoogleSccProjectCustomModuleCustomConfigPredicate;
    /**
    * resource_selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#resource_selector GoogleSccProjectCustomModule#resource_selector}
    */
    readonly resourceSelector: GoogleSccProjectCustomModuleCustomConfigResourceSelector;
}
export declare function googleSccProjectCustomModuleCustomConfigToTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigOutputReference | GoogleSccProjectCustomModuleCustomConfig): any;
export declare function googleSccProjectCustomModuleCustomConfigToHclTerraform(struct?: GoogleSccProjectCustomModuleCustomConfigOutputReference | GoogleSccProjectCustomModuleCustomConfig): any;
export declare class GoogleSccProjectCustomModuleCustomConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccProjectCustomModuleCustomConfig | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleCustomConfig | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _recommendation?;
    get recommendation(): string;
    set recommendation(value: string);
    get recommendationInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _customOutput;
    get customOutput(): GoogleSccProjectCustomModuleCustomConfigCustomOutputOutputReference;
    putCustomOutput(value: GoogleSccProjectCustomModuleCustomConfigCustomOutput): void;
    resetCustomOutput(): void;
    get customOutputInput(): GoogleSccProjectCustomModuleCustomConfigCustomOutput | undefined;
    private _predicate;
    get predicate(): GoogleSccProjectCustomModuleCustomConfigPredicateOutputReference;
    putPredicate(value: GoogleSccProjectCustomModuleCustomConfigPredicate): void;
    get predicateInput(): GoogleSccProjectCustomModuleCustomConfigPredicate | undefined;
    private _resourceSelector;
    get resourceSelector(): GoogleSccProjectCustomModuleCustomConfigResourceSelectorOutputReference;
    putResourceSelector(value: GoogleSccProjectCustomModuleCustomConfigResourceSelector): void;
    get resourceSelectorInput(): GoogleSccProjectCustomModuleCustomConfigResourceSelector | undefined;
}
export interface GoogleSccProjectCustomModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#create GoogleSccProjectCustomModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#delete GoogleSccProjectCustomModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#update GoogleSccProjectCustomModule#update}
    */
    readonly update?: string;
}
export declare function googleSccProjectCustomModuleTimeoutsToTerraform(struct?: GoogleSccProjectCustomModuleTimeouts | cdktf.IResolvable): any;
export declare function googleSccProjectCustomModuleTimeoutsToHclTerraform(struct?: GoogleSccProjectCustomModuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleSccProjectCustomModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccProjectCustomModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccProjectCustomModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module google_scc_project_custom_module}
*/
export declare class GoogleSccProjectCustomModule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_project_custom_module";
    /**
    * Generates CDKTF code for importing a GoogleSccProjectCustomModule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSccProjectCustomModule to import
    * @param importFromId The id of the existing GoogleSccProjectCustomModule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSccProjectCustomModule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_scc_project_custom_module google_scc_project_custom_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSccProjectCustomModuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSccProjectCustomModuleConfig);
    get ancestorModule(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enablementState?;
    get enablementState(): string;
    set enablementState(value: string);
    get enablementStateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastEditor(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _customConfig;
    get customConfig(): GoogleSccProjectCustomModuleCustomConfigOutputReference;
    putCustomConfig(value: GoogleSccProjectCustomModuleCustomConfig): void;
    get customConfigInput(): GoogleSccProjectCustomModuleCustomConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSccProjectCustomModuleTimeoutsOutputReference;
    putTimeouts(value: GoogleSccProjectCustomModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSccProjectCustomModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
