/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecretManagerSecretVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The deletion policy for the secret version. Setting 'ABANDON' allows the resource
    * to be abandoned rather than deleted. Setting 'DISABLE' allows the resource to be
    * disabled rather than deleted. Default is 'DELETE'. Possible values are:
    *   * DELETE
    *   * DISABLE
    *   * ABANDON
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#deletion_policy GoogleSecretManagerSecretVersion#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The current state of the SecretVersion.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#enabled GoogleSecretManagerSecretVersion#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#id GoogleSecretManagerSecretVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If set to 'true', the secret data is expected to be base64-encoded string and would be sent as is.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#is_secret_data_base64 GoogleSecretManagerSecretVersion#is_secret_data_base64}
    */
    readonly isSecretDataBase64?: boolean | cdktf.IResolvable;
    /**
    * Secret Manager secret resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#secret GoogleSecretManagerSecretVersion#secret}
    */
    readonly secret: string;
    /**
    * The secret data. Must be no larger than 64KiB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#secret_data GoogleSecretManagerSecretVersion#secret_data}
    */
    readonly secretData: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#timeouts GoogleSecretManagerSecretVersion#timeouts}
    */
    readonly timeouts?: GoogleSecretManagerSecretVersionTimeouts;
}
export interface GoogleSecretManagerSecretVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#create GoogleSecretManagerSecretVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#delete GoogleSecretManagerSecretVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#update GoogleSecretManagerSecretVersion#update}
    */
    readonly update?: string;
}
export declare function googleSecretManagerSecretVersionTimeoutsToTerraform(struct?: GoogleSecretManagerSecretVersionTimeouts | cdktf.IResolvable): any;
export declare function googleSecretManagerSecretVersionTimeoutsToHclTerraform(struct?: GoogleSecretManagerSecretVersionTimeouts | cdktf.IResolvable): any;
export declare class GoogleSecretManagerSecretVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecretManagerSecretVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version google_secret_manager_secret_version}
*/
export declare class GoogleSecretManagerSecretVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_secret_manager_secret_version";
    /**
    * Generates CDKTF code for importing a GoogleSecretManagerSecretVersion resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSecretManagerSecretVersion to import
    * @param importFromId The id of the existing GoogleSecretManagerSecretVersion that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSecretManagerSecretVersion to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret_version google_secret_manager_secret_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecretManagerSecretVersionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecretManagerSecretVersionConfig);
    get createTime(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    get destroyTime(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSecretDataBase64?;
    get isSecretDataBase64(): boolean | cdktf.IResolvable;
    set isSecretDataBase64(value: boolean | cdktf.IResolvable);
    resetIsSecretDataBase64(): void;
    get isSecretDataBase64Input(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _secretData?;
    get secretData(): string;
    set secretData(value: string);
    get secretDataInput(): string | undefined;
    get version(): string;
    private _timeouts;
    get timeouts(): GoogleSecretManagerSecretVersionTimeoutsOutputReference;
    putTimeouts(value: GoogleSecretManagerSecretVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSecretManagerSecretVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
