/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom metadata about the secret.
    *
    * Annotations are distinct from various forms of labels. Annotations exist to allow
    * client tools to store their own state information without requiring a database.
    *
    * Annotation keys must be between 1 and 63 characters long, have a UTF-8 encoding of
    * maximum 128 bytes, begin and end with an alphanumeric character ([a-z0-9A-Z]), and
    * may have dashes (-), underscores (_), dots (.), and alphanumerics in between these
    * symbols.
    *
    * The total size of annotation keys and values must be less than 16KiB.
    *
    * An object containing a list of "key": value pairs. Example:
    * { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#annotations GoogleSecretManagerSecret#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Timestamp in UTC when the Secret is scheduled to expire. This is always provided on output, regardless of what was sent on input.
    * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    * Only one of 'expire_time' or 'ttl' can be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#expire_time GoogleSecretManagerSecret#expire_time}
    */
    readonly expireTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#id GoogleSecretManagerSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels assigned to this Secret.
    *
    * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
    * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
    *
    * Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
    * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
    *
    * No more than 64 labels can be assigned to a given resource.
    *
    * An object containing a list of "key": value pairs. Example:
    * { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#labels GoogleSecretManagerSecret#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#project GoogleSecretManagerSecret#project}
    */
    readonly project?: string;
    /**
    * This must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#secret_id GoogleSecretManagerSecret#secret_id}
    */
    readonly secretId: string;
    /**
    * The TTL for the Secret.
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    * Only one of 'ttl' or 'expire_time' can be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#ttl GoogleSecretManagerSecret#ttl}
    */
    readonly ttl?: string;
    /**
    * Mapping from version alias to version name.
    *
    * A version alias is a string with a maximum length of 63 characters and can contain
    * uppercase and lowercase letters, numerals, and the hyphen (-) and underscore ('_')
    * characters. An alias string must start with a letter and cannot be the string
    * 'latest' or 'NEW'. No more than 50 aliases can be assigned to a given secret.
    *
    * An object containing a list of "key": value pairs. Example:
    * { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#version_aliases GoogleSecretManagerSecret#version_aliases}
    */
    readonly versionAliases?: {
        [key: string]: string;
    };
    /**
    * replication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#replication GoogleSecretManagerSecret#replication}
    */
    readonly replication: GoogleSecretManagerSecretReplication;
    /**
    * rotation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#rotation GoogleSecretManagerSecret#rotation}
    */
    readonly rotation?: GoogleSecretManagerSecretRotation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#timeouts GoogleSecretManagerSecret#timeouts}
    */
    readonly timeouts?: GoogleSecretManagerSecretTimeouts;
    /**
    * topics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#topics GoogleSecretManagerSecret#topics}
    */
    readonly topics?: GoogleSecretManagerSecretTopics[] | cdktf.IResolvable;
}
export interface GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption {
    /**
    * The resource name of the Cloud KMS CryptoKey used to encrypt secret payloads.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#kms_key_name GoogleSecretManagerSecret#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleSecretManagerSecretReplicationAutoCustomerManagedEncryptionToTerraform(struct?: GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionOutputReference | GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption): any;
export declare function googleSecretManagerSecretReplicationAutoCustomerManagedEncryptionToHclTerraform(struct?: GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionOutputReference | GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption): any;
export declare class GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption | undefined;
    set internalValue(value: GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleSecretManagerSecretReplicationAuto {
    /**
    * customer_managed_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#customer_managed_encryption GoogleSecretManagerSecret#customer_managed_encryption}
    */
    readonly customerManagedEncryption?: GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption;
}
export declare function googleSecretManagerSecretReplicationAutoToTerraform(struct?: GoogleSecretManagerSecretReplicationAutoOutputReference | GoogleSecretManagerSecretReplicationAuto): any;
export declare function googleSecretManagerSecretReplicationAutoToHclTerraform(struct?: GoogleSecretManagerSecretReplicationAutoOutputReference | GoogleSecretManagerSecretReplicationAuto): any;
export declare class GoogleSecretManagerSecretReplicationAutoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretReplicationAuto | undefined;
    set internalValue(value: GoogleSecretManagerSecretReplicationAuto | undefined);
    private _customerManagedEncryption;
    get customerManagedEncryption(): GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryptionOutputReference;
    putCustomerManagedEncryption(value: GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption): void;
    resetCustomerManagedEncryption(): void;
    get customerManagedEncryptionInput(): GoogleSecretManagerSecretReplicationAutoCustomerManagedEncryption | undefined;
}
export interface GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
    /**
    * Describes the Cloud KMS encryption key that will be used to protect destination secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#kms_key_name GoogleSecretManagerSecret#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToTerraform(struct?: GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference | GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare function googleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToHclTerraform(struct?: GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference | GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare class GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
    set internalValue(value: GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleSecretManagerSecretReplicationUserManagedReplicas {
    /**
    * The canonical IDs of the location to replicate data. For example: "us-east1".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#location GoogleSecretManagerSecret#location}
    */
    readonly location: string;
    /**
    * customer_managed_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#customer_managed_encryption GoogleSecretManagerSecret#customer_managed_encryption}
    */
    readonly customerManagedEncryption?: GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption;
}
export declare function googleSecretManagerSecretReplicationUserManagedReplicasToTerraform(struct?: GoogleSecretManagerSecretReplicationUserManagedReplicas | cdktf.IResolvable): any;
export declare function googleSecretManagerSecretReplicationUserManagedReplicasToHclTerraform(struct?: GoogleSecretManagerSecretReplicationUserManagedReplicas | cdktf.IResolvable): any;
export declare class GoogleSecretManagerSecretReplicationUserManagedReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecretManagerSecretReplicationUserManagedReplicas | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecretManagerSecretReplicationUserManagedReplicas | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _customerManagedEncryption;
    get customerManagedEncryption(): GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference;
    putCustomerManagedEncryption(value: GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): void;
    resetCustomerManagedEncryption(): void;
    get customerManagedEncryptionInput(): GoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
}
export declare class GoogleSecretManagerSecretReplicationUserManagedReplicasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecretManagerSecretReplicationUserManagedReplicas[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecretManagerSecretReplicationUserManagedReplicasOutputReference;
}
export interface GoogleSecretManagerSecretReplicationUserManaged {
    /**
    * replicas block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#replicas GoogleSecretManagerSecret#replicas}
    */
    readonly replicas: GoogleSecretManagerSecretReplicationUserManagedReplicas[] | cdktf.IResolvable;
}
export declare function googleSecretManagerSecretReplicationUserManagedToTerraform(struct?: GoogleSecretManagerSecretReplicationUserManagedOutputReference | GoogleSecretManagerSecretReplicationUserManaged): any;
export declare function googleSecretManagerSecretReplicationUserManagedToHclTerraform(struct?: GoogleSecretManagerSecretReplicationUserManagedOutputReference | GoogleSecretManagerSecretReplicationUserManaged): any;
export declare class GoogleSecretManagerSecretReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretReplicationUserManaged | undefined;
    set internalValue(value: GoogleSecretManagerSecretReplicationUserManaged | undefined);
    private _replicas;
    get replicas(): GoogleSecretManagerSecretReplicationUserManagedReplicasList;
    putReplicas(value: GoogleSecretManagerSecretReplicationUserManagedReplicas[] | cdktf.IResolvable): void;
    get replicasInput(): cdktf.IResolvable | GoogleSecretManagerSecretReplicationUserManagedReplicas[] | undefined;
}
export interface GoogleSecretManagerSecretReplication {
    /**
    * auto block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#auto GoogleSecretManagerSecret#auto}
    */
    readonly auto?: GoogleSecretManagerSecretReplicationAuto;
    /**
    * user_managed block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#user_managed GoogleSecretManagerSecret#user_managed}
    */
    readonly userManaged?: GoogleSecretManagerSecretReplicationUserManaged;
}
export declare function googleSecretManagerSecretReplicationToTerraform(struct?: GoogleSecretManagerSecretReplicationOutputReference | GoogleSecretManagerSecretReplication): any;
export declare function googleSecretManagerSecretReplicationToHclTerraform(struct?: GoogleSecretManagerSecretReplicationOutputReference | GoogleSecretManagerSecretReplication): any;
export declare class GoogleSecretManagerSecretReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretReplication | undefined;
    set internalValue(value: GoogleSecretManagerSecretReplication | undefined);
    private _auto;
    get auto(): GoogleSecretManagerSecretReplicationAutoOutputReference;
    putAuto(value: GoogleSecretManagerSecretReplicationAuto): void;
    resetAuto(): void;
    get autoInput(): GoogleSecretManagerSecretReplicationAuto | undefined;
    private _userManaged;
    get userManaged(): GoogleSecretManagerSecretReplicationUserManagedOutputReference;
    putUserManaged(value: GoogleSecretManagerSecretReplicationUserManaged): void;
    resetUserManaged(): void;
    get userManagedInput(): GoogleSecretManagerSecretReplicationUserManaged | undefined;
}
export interface GoogleSecretManagerSecretRotation {
    /**
    * Timestamp in UTC at which the Secret is scheduled to rotate.
    * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#next_rotation_time GoogleSecretManagerSecret#next_rotation_time}
    */
    readonly nextRotationTime?: string;
    /**
    * The Duration between rotation notifications. Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
    * If rotationPeriod is set, 'next_rotation_time' must be set. 'next_rotation_time' will be advanced by this period when the service automatically sends rotation notifications.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#rotation_period GoogleSecretManagerSecret#rotation_period}
    */
    readonly rotationPeriod?: string;
}
export declare function googleSecretManagerSecretRotationToTerraform(struct?: GoogleSecretManagerSecretRotationOutputReference | GoogleSecretManagerSecretRotation): any;
export declare function googleSecretManagerSecretRotationToHclTerraform(struct?: GoogleSecretManagerSecretRotationOutputReference | GoogleSecretManagerSecretRotation): any;
export declare class GoogleSecretManagerSecretRotationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretRotation | undefined;
    set internalValue(value: GoogleSecretManagerSecretRotation | undefined);
    private _nextRotationTime?;
    get nextRotationTime(): string;
    set nextRotationTime(value: string);
    resetNextRotationTime(): void;
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string;
    set rotationPeriod(value: string);
    resetRotationPeriod(): void;
    get rotationPeriodInput(): string | undefined;
}
export interface GoogleSecretManagerSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#create GoogleSecretManagerSecret#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#delete GoogleSecretManagerSecret#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#update GoogleSecretManagerSecret#update}
    */
    readonly update?: string;
}
export declare function googleSecretManagerSecretTimeoutsToTerraform(struct?: GoogleSecretManagerSecretTimeouts | cdktf.IResolvable): any;
export declare function googleSecretManagerSecretTimeoutsToHclTerraform(struct?: GoogleSecretManagerSecretTimeouts | cdktf.IResolvable): any;
export declare class GoogleSecretManagerSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecretManagerSecretTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleSecretManagerSecretTopics {
    /**
    * The resource name of the Pub/Sub topic that will be published to, in the following format: projects/* /topics/*.
    * For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#name GoogleSecretManagerSecret#name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly name: string;
}
export declare function googleSecretManagerSecretTopicsToTerraform(struct?: GoogleSecretManagerSecretTopics | cdktf.IResolvable): any;
export declare function googleSecretManagerSecretTopicsToHclTerraform(struct?: GoogleSecretManagerSecretTopics | cdktf.IResolvable): any;
export declare class GoogleSecretManagerSecretTopicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSecretManagerSecretTopics | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecretManagerSecretTopics | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleSecretManagerSecretTopicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleSecretManagerSecretTopics[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSecretManagerSecretTopicsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret google_secret_manager_secret}
*/
export declare class GoogleSecretManagerSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_secret_manager_secret";
    /**
    * Generates CDKTF code for importing a GoogleSecretManagerSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleSecretManagerSecret to import
    * @param importFromId The id of the existing GoogleSecretManagerSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleSecretManagerSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_secret_manager_secret google_secret_manager_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecretManagerSecretConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecretManagerSecretConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _expireTime?;
    get expireTime(): string;
    set expireTime(value: string);
    resetExpireTime(): void;
    get expireTimeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _versionAliases?;
    get versionAliases(): {
        [key: string]: string;
    };
    set versionAliases(value: {
        [key: string]: string;
    });
    resetVersionAliases(): void;
    get versionAliasesInput(): {
        [key: string]: string;
    } | undefined;
    private _replication;
    get replication(): GoogleSecretManagerSecretReplicationOutputReference;
    putReplication(value: GoogleSecretManagerSecretReplication): void;
    get replicationInput(): GoogleSecretManagerSecretReplication | undefined;
    private _rotation;
    get rotation(): GoogleSecretManagerSecretRotationOutputReference;
    putRotation(value: GoogleSecretManagerSecretRotation): void;
    resetRotation(): void;
    get rotationInput(): GoogleSecretManagerSecretRotation | undefined;
    private _timeouts;
    get timeouts(): GoogleSecretManagerSecretTimeoutsOutputReference;
    putTimeouts(value: GoogleSecretManagerSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSecretManagerSecretTimeouts | undefined;
    private _topics;
    get topics(): GoogleSecretManagerSecretTopicsList;
    putTopics(value: GoogleSecretManagerSecretTopics[] | cdktf.IResolvable): void;
    resetTopics(): void;
    get topicsInput(): cdktf.IResolvable | GoogleSecretManagerSecretTopics[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
